/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.Stripe;
import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.PaymentSource;
import com.stripe.model.StripeCollectionAPIResource;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.Map;

public class PaymentSourceCollection
extends StripeCollectionAPIResource<PaymentSource> {
    public PaymentSourceCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.all(params, null);
    }

    public PaymentSourceCollection all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String url = String.format("%s%s", Stripe.getApiBase(), this.getURL());
        return PaymentSourceCollection.request(APIResource.RequestMethod.GET, url, params, PaymentSourceCollection.class, options);
    }

    public PaymentSource retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.retrieve(id, null);
    }

    public PaymentSource retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String url = String.format("%s%s/%s", Stripe.getApiBase(), this.getURL(), id);
        return PaymentSourceCollection.request(APIResource.RequestMethod.GET, url, null, PaymentSource.class, options);
    }

    public PaymentSource create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.create(params, null);
    }

    public PaymentSource create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String url = String.format("%s%s", Stripe.getApiBase(), this.getURL());
        return PaymentSourceCollection.request(APIResource.RequestMethod.POST, url, params, PaymentSource.class, options);
    }
}

