/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Customer;
import com.stripe.model.Discount;
import com.stripe.model.MetadataStore;
import com.stripe.model.Plan;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.Map;

public class Subscription
extends APIResource
implements MetadataStore<Subscription> {
    String id;
    Long currentPeriodEnd;
    Long currentPeriodStart;
    Boolean cancelAtPeriodEnd;
    String customer;
    Long start;
    String status;
    Long trialStart;
    Long trialEnd;
    Plan plan;
    Long canceledAt;
    Long endedAt;
    Integer quantity;
    Discount discount;
    Double applicationFeePercent;
    Map<String, String> metadata;

    public Subscription update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    @Deprecated
    public Subscription update(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Subscription update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Subscription.request(APIResource.RequestMethod.POST, this.getInstanceURL(), params, Subscription.class, options);
    }

    public Subscription cancel(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.cancel(params, (RequestOptions)null);
    }

    @Deprecated
    public Subscription cancel(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.cancel(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Subscription cancel(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Subscription.request(APIResource.RequestMethod.DELETE, this.getInstanceURL(), params, Subscription.class, options);
    }

    public void deleteDiscount() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        this.deleteDiscount((RequestOptions)null);
    }

    @Deprecated
    public void deleteDiscount(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        RequestOptions result = null;
        if (apiKey != null) {
            result = RequestOptions.builder().setApiKey(apiKey).build();
        }
        this.deleteDiscount(result);
    }

    public void deleteDiscount(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Subscription.request(APIResource.RequestMethod.DELETE, String.format("%s/discount", this.getInstanceURL()), null, Discount.class, options);
    }

    public String getInstanceURL() {
        return String.format("%s/%s/subscriptions/%s", Subscription.classURL(Customer.class), this.getCustomer(), this.getId());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Long getCurrentPeriodEnd() {
        return this.currentPeriodEnd;
    }

    public void setCurrentPeriodEnd(Long currentPeriodEnd) {
        this.currentPeriodEnd = currentPeriodEnd;
    }

    public Long getCurrentPeriodStart() {
        return this.currentPeriodStart;
    }

    public void setCurrentPeriodStart(Long currentPeriodStart) {
        this.currentPeriodStart = currentPeriodStart;
    }

    public Boolean getCancelAtPeriodEnd() {
        return this.cancelAtPeriodEnd;
    }

    public void setCancelAtPeriodEnd(Boolean cancelAtPeriodEnd) {
        this.cancelAtPeriodEnd = cancelAtPeriodEnd;
    }

    public String getCustomer() {
        return this.customer;
    }

    public void setCustomer(String customer) {
        this.customer = customer;
    }

    public Long getStart() {
        return this.start;
    }

    public void setStart(Long start) {
        this.start = start;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Long getTrialStart() {
        return this.trialStart;
    }

    public void setTrialStart(Long trialStart) {
        this.trialStart = trialStart;
    }

    public Long getTrialEnd() {
        return this.trialEnd;
    }

    public void setTrialEnd(Long trialEnd) {
        this.trialEnd = trialEnd;
    }

    public Plan getPlan() {
        return this.plan;
    }

    public void setPlan(Plan plan) {
        this.plan = plan;
    }

    public Long getCanceledAt() {
        return this.canceledAt;
    }

    public void setCanceledAt(Long canceledAt) {
        this.canceledAt = canceledAt;
    }

    public Long getEndedAt() {
        return this.endedAt;
    }

    public void setEndedAt(Long endedAt) {
        this.endedAt = endedAt;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public Discount getDiscount() {
        return this.discount;
    }

    public void setDiscount(Discount discount) {
        this.discount = discount;
    }

    public Double getApplicationFeePercent() {
        return this.applicationFeePercent;
    }

    public void setApplicationFeePercent(Double applicationFeePercent) {
        this.applicationFeePercent = applicationFeePercent;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }
}

