/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.net;

import com.stripe.Stripe;

public class RequestOptions {
    private final String apiKey;
    private final String stripeVersion;
    private final String idempotencyKey;

    public static RequestOptions getDefault() {
        return new RequestOptions(Stripe.apiKey, Stripe.apiVersion, null);
    }

    private RequestOptions(String apiKey, String stripeVersion, String idempotencyKey) {
        this.apiKey = apiKey;
        this.stripeVersion = stripeVersion;
        this.idempotencyKey = idempotencyKey;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getStripeVersion() {
        return this.stripeVersion;
    }

    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestOptions that = (RequestOptions)o;
        if (this.apiKey != null ? !this.apiKey.equals(that.apiKey) : that.apiKey != null) {
            return false;
        }
        if (this.idempotencyKey != null ? !this.idempotencyKey.equals(that.idempotencyKey) : that.idempotencyKey != null) {
            return false;
        }
        return !(this.stripeVersion != null ? !this.stripeVersion.equals(that.stripeVersion) : that.stripeVersion != null);
    }

    public int hashCode() {
        int result = this.apiKey != null ? this.apiKey.hashCode() : 0;
        result = 31 * result + (this.stripeVersion != null ? this.stripeVersion.hashCode() : 0);
        result = 31 * result + (this.idempotencyKey != null ? this.idempotencyKey.hashCode() : 0);
        return result;
    }

    public static RequestOptionsBuilder builder() {
        return new RequestOptionsBuilder();
    }

    public RequestOptionsBuilder toBuilder() {
        return new RequestOptionsBuilder().setApiKey(this.apiKey).setStripeVersion(this.stripeVersion);
    }

    private static String normalizeApiKey(String apiKey) {
        if (apiKey == null) {
            return null;
        }
        String normalized = apiKey.trim();
        if (normalized.isEmpty()) {
            throw new InvalidRequestOptionsException("Empty API key specified!");
        }
        return normalized;
    }

    private static String normalizeStripeVersion(String stripeVersion) {
        if (stripeVersion == null) {
            return null;
        }
        String normalized = stripeVersion.trim();
        if (normalized.isEmpty()) {
            throw new InvalidRequestOptionsException("Empty Stripe version specified!");
        }
        return normalized;
    }

    private static String normalizeIdempotencyKey(String idempotencyKey) {
        if (idempotencyKey == null) {
            return null;
        }
        String normalized = idempotencyKey.trim();
        if (normalized.isEmpty()) {
            throw new InvalidRequestOptionsException("Empty Idempotency Key Specified!");
        }
        if (normalized.length() > 255) {
            throw new InvalidRequestOptionsException(String.format("Idempotency Key length was %d, which is larger than the 255 character maximum!", normalized.length()));
        }
        return normalized;
    }

    public static class InvalidRequestOptionsException
    extends RuntimeException {
        public InvalidRequestOptionsException(String message) {
            super(message);
        }
    }

    public static final class RequestOptionsBuilder {
        private String apiKey = Stripe.apiKey;
        private String stripeVersion = Stripe.apiVersion;
        private String idempotencyKey;

        public String getApiKey() {
            return this.apiKey;
        }

        public RequestOptionsBuilder setApiKey(String apiKey) {
            this.apiKey = RequestOptions.normalizeApiKey(apiKey);
            return this;
        }

        public RequestOptionsBuilder clearApiKey() {
            this.apiKey = null;
            return this;
        }

        public RequestOptionsBuilder setStripeVersion(String stripeVersion) {
            this.stripeVersion = RequestOptions.normalizeStripeVersion(stripeVersion);
            return this;
        }

        public RequestOptionsBuilder clearStripeVersion() {
            this.stripeVersion = null;
            return this;
        }

        public RequestOptionsBuilder setIdempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public RequestOptionsBuilder clearIdempotencyKey() {
            this.idempotencyKey = null;
            return this;
        }

        public String getIdempotencyKey() {
            return this.idempotencyKey;
        }

        public RequestOptions build() {
            return new RequestOptions(RequestOptions.normalizeApiKey(this.apiKey), RequestOptions.normalizeStripeVersion(this.stripeVersion), RequestOptions.normalizeIdempotencyKey(this.idempotencyKey));
        }
    }
}

