/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.LegalEntity;
import com.stripe.model.StripeObject;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.List;
import java.util.Map;

public class Account
extends APIResource {
    String id;
    Boolean chargesEnabled;
    Boolean detailsSubmitted;
    Boolean transfersEnabled;
    List<String> currenciesSupported;
    String email;
    String statementDescriptor;
    String defaultCurrency;
    String country;
    String timezone;
    String displayName;
    Verification verification;
    LegalEntity legalEntity;
    Keys keys;
    Map<String, String> metadata;
    String businessName;
    String businessUrl;
    String businessLogo;
    String supportPhone;
    String supportUrl;
    String supportEmail;
    Boolean managed;

    public String getId() {
        return this.id;
    }

    public Boolean getChargesEnabled() {
        return this.chargesEnabled;
    }

    public Boolean getDetailsSubmitted() {
        return this.detailsSubmitted;
    }

    public Boolean getTransfersEnabled() {
        return this.transfersEnabled;
    }

    public List<String> getCurrenciesSupported() {
        return this.currenciesSupported;
    }

    public String getEmail() {
        return this.email;
    }

    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    public String getDefaultCurrency() {
        return this.defaultCurrency;
    }

    public String getCountry() {
        return this.country;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Verification getVerification() {
        return this.verification;
    }

    public LegalEntity getLegalEntity() {
        return this.legalEntity;
    }

    public Keys getKeys() {
        return this.keys;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public String getBusinessName() {
        return this.businessName;
    }

    public String getBusinessUrl() {
        return this.businessUrl;
    }

    public String getBusinessLogo() {
        return this.businessLogo;
    }

    public String getSupportPhone() {
        return this.supportPhone;
    }

    public String getSupportUrl() {
        return this.supportUrl;
    }

    public String getSupportEmail() {
        return this.supportEmail;
    }

    public Boolean getManaged() {
        return this.managed;
    }

    public static Account create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.create(params, null);
    }

    public static Account create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.request(APIResource.RequestMethod.POST, Account.classURL(Account.class), params, Account.class, options);
    }

    public static Account retrieve() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.retrieve((RequestOptions)null);
    }

    @Deprecated
    public static Account retrieve(String apiKeyOrAccountId) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        if (null == apiKeyOrAccountId || apiKeyOrAccountId.startsWith("sk_")) {
            return Account.retrieve(RequestOptions.builder().setApiKey(apiKeyOrAccountId).build());
        }
        return Account.retrieve(apiKeyOrAccountId, null);
    }

    public static Account retrieve(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.request(APIResource.RequestMethod.GET, Account.singleClassURL(Account.class), null, Account.class, options);
    }

    public static Account retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.request(APIResource.RequestMethod.GET, Account.instanceURL(Account.class, id), null, Account.class, options);
    }

    public Account update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update(params, null);
    }

    public Account update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.request(APIResource.RequestMethod.POST, Account.instanceURL(Account.class, this.id), params, Account.class, options);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Account account = (Account)o;
        return Account.equals(this.id, account.id) && Account.equals(this.chargesEnabled, account.chargesEnabled) && Account.equals(this.detailsSubmitted, account.detailsSubmitted) && Account.equals(this.transfersEnabled, account.transfersEnabled) && Account.equals(this.currenciesSupported, account.currenciesSupported) && Account.equals(this.email, account.email) && Account.equals(this.statementDescriptor, account.statementDescriptor) && Account.equals(this.defaultCurrency, account.defaultCurrency) && Account.equals(this.country, account.country) && Account.equals(this.timezone, account.timezone) && Account.equals(this.displayName, account.displayName) && Account.equals(this.verification, account.verification) && Account.equals(this.legalEntity, account.legalEntity) && Account.equals(this.keys, account.keys) && Account.equals(this.metadata, account.metadata) && Account.equals(this.businessName, account.businessName) && Account.equals(this.businessUrl, account.businessUrl) && Account.equals(this.businessLogo, account.businessLogo) && Account.equals(this.supportPhone, account.supportPhone) && Account.equals(this.supportUrl, account.supportUrl) && Account.equals(this.supportEmail, account.supportEmail) && Account.equals(this.managed, account.managed);
    }

    public static class Keys
    extends StripeObject {
        String secret;
        String publishable;

        public String getSecret() {
            return this.secret;
        }

        public String getPublishable() {
            return this.publishable;
        }
    }

    public static class Verification
    extends StripeObject {
        List<String> fieldsNeeded;
        Long dueBy;
        Boolean contacted;

        public List<String> getFieldsNeeded() {
            return this.fieldsNeeded;
        }

        public Long getDueBy() {
            return this.dueBy;
        }

        public Boolean getContacted() {
            return this.contacted;
        }
    }
}

