/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Customer;
import com.stripe.model.DeletedAlipayAccount;
import com.stripe.model.PaymentSource;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.Map;

public class AlipayAccount
extends APIResource
implements PaymentSource {
    String id;
    String object;
    String status;
    Long created;
    String customer;
    Map<String, String> metadata;
    String username;
    String fingerprint;
    Boolean used;
    Boolean reusable;
    Integer paymentAmount;
    String paymentCurrency;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getObject() {
        return this.object;
    }

    @Override
    public void setObject(String object) {
        this.object = object;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    @Override
    public String getCustomer() {
        return this.customer;
    }

    @Override
    public void setCustomer(String customer) {
        this.customer = customer;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public Boolean getUsed() {
        return this.used;
    }

    public void setUsed(Boolean used) {
        this.used = used;
    }

    public Boolean getReusable() {
        return this.reusable;
    }

    public void setReusable(Boolean reusable) {
        this.reusable = reusable;
    }

    public Integer getPaymentAmount() {
        return this.paymentAmount;
    }

    public void setPaymentAmount(Integer paymentAmount) {
        this.paymentAmount = paymentAmount;
    }

    public String getPaymentCurrency() {
        return this.paymentCurrency;
    }

    public void setPaymentCurrency(String paymentCurrency) {
        this.paymentCurrency = paymentCurrency;
    }

    @Override
    public String getInstanceURL() {
        if (this.getCustomer() != null) {
            return String.format("%s/%s/sources/%s", AlipayAccount.classURL(Customer.class), this.getCustomer(), this.getId());
        }
        return null;
    }

    @Override
    public AlipayAccount update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    @Override
    public AlipayAccount update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return AlipayAccount.request(APIResource.RequestMethod.POST, this.getInstanceURL(), params, AlipayAccount.class, options);
    }

    @Override
    public DeletedAlipayAccount delete() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.delete(null);
    }

    @Override
    public DeletedAlipayAccount delete(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return AlipayAccount.request(APIResource.RequestMethod.DELETE, this.getInstanceURL(), null, DeletedAlipayAccount.class, options);
    }
}

