/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.stripe.model.AlipayAccount;
import com.stripe.model.BitcoinReceiver;
import com.stripe.model.Card;
import com.stripe.model.ConcretePaymentSource;
import com.stripe.model.PaymentSource;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class PaymentSourceDeserializer
implements JsonDeserializer<PaymentSource> {
    private static final String SOURCE_OBJECT_PROP = "object";
    private static Map<String, Class<?>> typeToClazz;

    public static Map<String, Class<?>> getTypeToClazz() {
        if (typeToClazz == null) {
            HashMap mapping = new HashMap();
            mapping.put("bitcoin_receiver", BitcoinReceiver.class);
            mapping.put("card", Card.class);
            mapping.put("alipay_account", AlipayAccount.class);
            PaymentSourceDeserializer.setTypeToClazz(mapping);
        }
        return typeToClazz;
    }

    public static void setTypeToClazz(Map<String, Class<?>> mapping) {
        typeToClazz = mapping;
    }

    public PaymentSource deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String sourceObject = json.getAsJsonObject().getAsJsonPrimitive(SOURCE_OBJECT_PROP).getAsString();
        Class<Object> clazz = PaymentSourceDeserializer.getTypeToClazz().get(sourceObject);
        if (clazz == null) {
            clazz = ConcretePaymentSource.class;
        }
        return (PaymentSource)context.deserialize(json, clazz);
    }
}

