/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Discount;
import com.stripe.model.InvoiceCollection;
import com.stripe.model.InvoiceLineItemCollection;
import com.stripe.model.MetadataStore;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.Map;

public class Invoice
extends APIResource
implements MetadataStore<Invoice> {
    Integer subtotal;
    Integer total;
    Integer amountDue;
    Integer startingBalance;
    Integer endingBalance;
    String id;
    Long created;
    Long nextPaymentAttempt;
    Boolean attempted;
    String charge;
    String description;
    Boolean closed;
    String customer;
    Long date;
    Boolean paid;
    Long periodStart;
    Long periodEnd;
    Discount discount;
    InvoiceLineItemCollection lines;
    Boolean livemode;
    Integer attemptCount;
    String currency;
    String subscription;
    Long applicationFee;
    Map<String, String> metadata;
    Boolean forgiven;
    String statementDescriptor;
    Integer tax;
    Double taxPercent;

    public Integer getSubtotal() {
        return this.subtotal;
    }

    public void setSubtotal(Integer subtotal) {
        this.subtotal = subtotal;
    }

    public Integer getTotal() {
        return this.total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public Integer getAmountDue() {
        return this.amountDue;
    }

    public void setAmountDue(Integer amountDue) {
        this.amountDue = amountDue;
    }

    public Integer getStartingBalance() {
        return this.startingBalance;
    }

    public void setStartingBalance(Integer startingBalance) {
        this.startingBalance = startingBalance;
    }

    public Integer getEndingBalance() {
        return this.endingBalance;
    }

    public void setEndingBalance(Integer endingBalance) {
        this.endingBalance = endingBalance;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public Long getNextPaymentAttempt() {
        return this.nextPaymentAttempt;
    }

    public void setNextPaymentAttempt(Long nextPaymentAttempt) {
        this.nextPaymentAttempt = nextPaymentAttempt;
    }

    public Boolean getAttempted() {
        return this.attempted;
    }

    public void setAttempted(Boolean attempted) {
        this.attempted = attempted;
    }

    public String getCharge() {
        return this.charge;
    }

    public void setCharge(String charge) {
        this.charge = charge;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getClosed() {
        return this.closed;
    }

    public void setClosed(Boolean closed) {
        this.closed = closed;
    }

    public String getCustomer() {
        return this.customer;
    }

    public void setCustomer(String customer) {
        this.customer = customer;
    }

    public Long getDate() {
        return this.date;
    }

    public void setDate(Long date) {
        this.date = date;
    }

    public Boolean getPaid() {
        return this.paid;
    }

    public void setPaid(Boolean paid) {
        this.paid = paid;
    }

    public Boolean getForgiven() {
        return this.forgiven;
    }

    public void setForgiven(Boolean forgiven) {
        this.forgiven = forgiven;
    }

    public Long getPeriodStart() {
        return this.periodStart;
    }

    public void setPeriodStart(Long periodStart) {
        this.periodStart = periodStart;
    }

    public Long getPeriodEnd() {
        return this.periodEnd;
    }

    public void setPeriodEnd(Long periodEnd) {
        this.periodEnd = periodEnd;
    }

    public Discount getDiscount() {
        return this.discount;
    }

    public void setDiscount(Discount discount) {
        this.discount = discount;
    }

    public InvoiceLineItemCollection getLines() {
        return this.lines;
    }

    public Boolean getLivemode() {
        return this.livemode;
    }

    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    public Integer getAttemptCount() {
        return this.attemptCount;
    }

    public void setAttemptCount(Integer attemptCount) {
        this.attemptCount = attemptCount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getSubscription() {
        return this.subscription;
    }

    public void setSubscription(String subscription) {
        this.subscription = subscription;
    }

    public Long getApplicationFee() {
        return this.applicationFee;
    }

    public void setApplicationFee(Long applicationFee) {
        this.applicationFee = applicationFee;
    }

    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    public Integer getTax() {
        return this.tax;
    }

    public void setTax(Integer tax) {
        this.tax = tax;
    }

    public Double getTaxPercent() {
        return this.taxPercent;
    }

    public void setTaxPercent(Double taxPercent) {
        this.taxPercent = taxPercent;
    }

    public static Invoice retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.retrieve(id, (RequestOptions)null);
    }

    public static Invoice create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.create(params, (RequestOptions)null);
    }

    public static InvoiceCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.all(params, (RequestOptions)null);
    }

    public static Invoice upcoming(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.upcoming(params, (RequestOptions)null);
    }

    public Invoice pay() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.pay((RequestOptions)null);
    }

    public Invoice update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    @Deprecated
    public static Invoice retrieve(String id, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.retrieve(id, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static Invoice retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.request(APIResource.RequestMethod.GET, Invoice.instanceURL(Invoice.class, id), null, Invoice.class, options);
    }

    @Deprecated
    public static Invoice create(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.create(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static Invoice create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.request(APIResource.RequestMethod.POST, Invoice.classURL(Invoice.class), params, Invoice.class, options);
    }

    @Deprecated
    public static Invoice upcoming(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.upcoming(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static Invoice upcoming(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.request(APIResource.RequestMethod.GET, String.format("%s/upcoming", Invoice.classURL(Invoice.class)), params, Invoice.class, options);
    }

    @Deprecated
    public static InvoiceCollection all(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.all(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static InvoiceCollection all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.request(APIResource.RequestMethod.GET, Invoice.classURL(Invoice.class), params, InvoiceCollection.class, options);
    }

    @Deprecated
    public Invoice update(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Invoice update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.request(APIResource.RequestMethod.POST, Invoice.instanceURL(Invoice.class, this.id), params, Invoice.class, options);
    }

    @Deprecated
    public Invoice pay(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.pay(RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Invoice pay(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.request(APIResource.RequestMethod.POST, String.format("%s/pay", Invoice.instanceURL(Invoice.class, this.getId())), null, Invoice.class, options);
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }
}

