/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.BankAccount;
import com.stripe.model.Summary;
import com.stripe.model.TransferCollection;
import com.stripe.model.TransferTransactionCollection;
import com.stripe.net.APIResource;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transfer
extends APIResource {
    String id;
    String status;
    Long date;
    Boolean livemode;
    Summary summary;
    String description;
    String statementDescriptor;
    Integer amount;
    String currency;
    List<String> otherTransfers;
    String recipient;
    BankAccount account;
    String balanceTransaction;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Boolean getLivemode() {
        return this.livemode;
    }

    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Long getDate() {
        return this.date;
    }

    public void setDate(Long date) {
        this.date = date;
    }

    public Summary getSummary() {
        return this.summary;
    }

    public void setSummary(Summary summary) {
        this.summary = summary;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    public Integer getAmount() {
        return this.amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public BankAccount getAccount() {
        return this.account;
    }

    public void setAccount(BankAccount account) {
        this.account = account;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public List<String> getOtherTransfers() {
        return this.otherTransfers;
    }

    public void setOtherTransfers(List<String> otherTransfers) {
        this.otherTransfers = otherTransfers;
    }

    public String getBalanceTransaction() {
        return this.balanceTransaction;
    }

    public void setBalanceTransaction(String balanceTransaction) {
        this.balanceTransaction = balanceTransaction;
    }

    public static Transfer create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Transfer.create(params, null);
    }

    public static Transfer retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Transfer.retrieve(id, null);
    }

    public static TransferCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Transfer.all(params, null);
    }

    public TransferTransactionCollection transactions(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.transactions(params, null);
    }

    public static Transfer create(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Transfer.request(APIResource.RequestMethod.POST, Transfer.classURL(Transfer.class), params, Transfer.class, apiKey);
    }

    public static Transfer retrieve(String id, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Transfer.request(APIResource.RequestMethod.GET, Transfer.instanceURL(Transfer.class, id), null, Transfer.class, apiKey);
    }

    public static TransferCollection all(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Transfer.request(APIResource.RequestMethod.GET, Transfer.classURL(Transfer.class), params, TransferCollection.class, apiKey);
    }

    public TransferTransactionCollection transactions(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Transfer.request(APIResource.RequestMethod.GET, String.format("%s/transactions", Transfer.instanceURL(Transfer.class, this.getId())), params, TransferTransactionCollection.class, apiKey);
    }
}

