/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Card;
import com.stripe.model.ChargeCollection;
import com.stripe.model.ChargeRefundCollection;
import com.stripe.model.Dispute;
import com.stripe.model.ExternalAccount;
import com.stripe.model.FraudDetails;
import com.stripe.model.MetadataStore;
import com.stripe.model.ShippingDetails;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.Collections;
import java.util.Map;

public class Charge
extends APIResource
implements MetadataStore<Charge> {
    Integer amount;
    Long created;
    String currency;
    String id;
    String status;
    Boolean livemode;
    Boolean paid;
    Boolean refunded;
    Boolean disputed;
    Boolean captured;
    String description;
    String failureMessage;
    String failureCode;
    Integer amountRefunded;
    String customer;
    String invoice;
    ChargeRefundCollection refunds;
    Card card;
    Dispute dispute;
    String balanceTransaction;
    Map<String, String> metadata;
    String receiptEmail;
    String receiptNumber;
    String statementDescriptor;
    @Deprecated
    String statementDescription;
    ShippingDetails shipping;
    ExternalAccount source;
    public static final String FRAUD_DETAILS = "fraud_details";
    FraudDetails fraudDetails;

    public FraudDetails getFraudDetails() {
        return this.fraudDetails;
    }

    public void setFraudDetails(FraudDetails fraudDetails) {
        this.fraudDetails = fraudDetails;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getStatus() {
        return this.status;
    }

    public Integer getAmount() {
        return this.amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Boolean getLivemode() {
        return this.livemode;
    }

    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    public Boolean getPaid() {
        return this.paid;
    }

    public void setPaid(Boolean paid) {
        this.paid = paid;
    }

    public Boolean getRefunded() {
        return this.refunded;
    }

    public void setRefunded(Boolean refunded) {
        this.refunded = refunded;
    }

    public Boolean getCaptured() {
        return this.captured;
    }

    public void setCaptured(Boolean captured) {
        this.captured = captured;
    }

    public ShippingDetails getShipping() {
        return this.shipping;
    }

    public void setShipping(ShippingDetails shipping) {
        this.shipping = shipping;
    }

    @Deprecated
    public Boolean getDisputed() {
        return this.disputed;
    }

    @Deprecated
    public void setDisputed(Boolean disputed) {
        this.disputed = disputed;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    @Deprecated
    public String getStatementDescription() {
        return this.statementDescription;
    }

    @Deprecated
    public void setStatementDescription(String statementDescription) {
        this.statementDescription = statementDescription;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public void setFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
    }

    public String getFailureCode() {
        return this.failureCode;
    }

    public void setFailureCode(String failureCode) {
        this.failureCode = failureCode;
    }

    public Integer getAmountRefunded() {
        return this.amountRefunded;
    }

    public void setAmountRefunded(Integer amountRefunded) {
        this.amountRefunded = amountRefunded;
    }

    public String getCustomer() {
        return this.customer;
    }

    public void setCustomer(String customer) {
        this.customer = customer;
    }

    public String getInvoice() {
        return this.invoice;
    }

    public void setInvoice(String invoice) {
        this.invoice = invoice;
    }

    public ChargeRefundCollection getRefunds() {
        if (this.refunds != null && this.refunds.getURL() == null) {
            this.refunds.setURL(String.format("/v1/charges/%s/refunds", this.getId()));
        }
        return this.refunds;
    }

    public Card getCard() {
        return this.card;
    }

    public void setCard(Card card) {
        this.card = card;
    }

    public Dispute getDispute() {
        return this.dispute;
    }

    public void setDispute(Dispute dispute) {
        this.dispute = dispute;
    }

    public String getBalanceTransaction() {
        return this.balanceTransaction;
    }

    public void setBalanceTransaction(String balanceTransaction) {
        this.balanceTransaction = balanceTransaction;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public String getReceiptNumber() {
        return this.receiptNumber;
    }

    public void setReceiptNumber(String receiptNumber) {
        this.receiptNumber = receiptNumber;
    }

    public String getReceiptEmail() {
        return this.receiptEmail;
    }

    public void setReceiptEmail(String receiptEmail) {
        this.receiptEmail = receiptEmail;
    }

    public ExternalAccount getSource() {
        return this.source;
    }

    public void setSource(ExternalAccount source) {
        this.source = source;
    }

    public static Charge create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.create(params, (RequestOptions)null);
    }

    public static Charge retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.retrieve(id, (RequestOptions)null);
    }

    public Charge update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public static ChargeCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.all(params, (RequestOptions)null);
    }

    public Charge refund() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.refund(null, (RequestOptions)null);
    }

    public Charge capture() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.capture(null, (RequestOptions)null);
    }

    @Deprecated
    public Dispute updateDispute(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.updateDispute(params, (RequestOptions)null);
    }

    @Deprecated
    public Dispute closeDispute() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.closeDispute((RequestOptions)null);
    }

    public Charge refund(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.refund(params, (RequestOptions)null);
    }

    public Charge capture(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.capture(params, (RequestOptions)null);
    }

    @Deprecated
    public static Charge create(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.create(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static Charge create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.request(APIResource.RequestMethod.POST, Charge.classURL(Charge.class), params, Charge.class, options);
    }

    @Deprecated
    public static Charge retrieve(String id, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.retrieve(id, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static Charge retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.request(APIResource.RequestMethod.GET, Charge.instanceURL(Charge.class, id), null, Charge.class, options);
    }

    @Deprecated
    public Charge update(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Charge update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.request(APIResource.RequestMethod.POST, Charge.instanceURL(Charge.class, this.id), params, Charge.class, options);
    }

    @Deprecated
    public static ChargeCollection all(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.all(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static ChargeCollection all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.request(APIResource.RequestMethod.GET, Charge.classURL(Charge.class), params, ChargeCollection.class, options);
    }

    @Deprecated
    public Charge refund(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.refund(RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Charge refund(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.refund(null, options);
    }

    @Deprecated
    public Charge refund(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.refund(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Charge refund(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.request(APIResource.RequestMethod.POST, String.format("%s/refund", Charge.instanceURL(Charge.class, this.getId())), params, Charge.class, options);
    }

    @Deprecated
    public Charge capture(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.capture(RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Charge capture(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.capture(null, options);
    }

    @Deprecated
    public Charge capture(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.capture(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Charge capture(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.request(APIResource.RequestMethod.POST, String.format("%s/capture", Charge.instanceURL(Charge.class, this.getId())), params, Charge.class, options);
    }

    @Deprecated
    public Dispute updateDispute(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.updateDispute(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    @Deprecated
    public Dispute updateDispute(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.request(APIResource.RequestMethod.POST, String.format("%s/dispute", Charge.instanceURL(Charge.class, this.id)), params, Dispute.class, options);
    }

    @Deprecated
    public Dispute closeDispute(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.closeDispute(RequestOptions.builder().setApiKey(apiKey).build());
    }

    @Deprecated
    public Dispute closeDispute(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.request(APIResource.RequestMethod.POST, String.format("%s/dispute/close", Charge.instanceURL(Charge.class, this.getId())), null, Dispute.class, options);
    }

    public Charge markFraudulent(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Map<String, Map<String, String>> params = Collections.singletonMap(FRAUD_DETAILS, Collections.singletonMap("user_report", "fraudulent"));
        return this.update(params, options);
    }

    public Charge markSafe(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Map<String, Map<String, String>> params = Collections.singletonMap(FRAUD_DETAILS, Collections.singletonMap("user_report", "safe"));
        return this.update(params, options);
    }
}

