/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.MetadataStore;
import com.stripe.model.PackageDimensions;
import com.stripe.model.ProductCollection;
import com.stripe.model.SKUCollection;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.List;
import java.util.Map;

public class Product
extends APIResource
implements MetadataStore<Product> {
    Long created;
    Long updated;
    String id;
    Boolean livemode;
    Boolean active;
    List<String> images;
    String name;
    Boolean shippable;
    SKUCollection skus;
    List<String> attributes;
    String caption;
    String description;
    PackageDimensions packageDimensions;
    String url;
    Map<String, String> metadata;

    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public Long getUpdated() {
        return this.updated;
    }

    public void setUpdated(Long updated) {
        this.updated = updated;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Boolean getLivemode() {
        return this.livemode;
    }

    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public List<String> getImages() {
        return this.images;
    }

    public void setImages(List<String> images) {
        this.images = images;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getShippable() {
        return this.shippable;
    }

    public void setShippable(Boolean shippable) {
        this.shippable = shippable;
    }

    public SKUCollection getSkus() {
        return this.skus;
    }

    public void setSkus(SKUCollection skus) {
        this.skus = skus;
    }

    public List<String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<String> attributes) {
        this.attributes = attributes;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PackageDimensions getPackageDimensions() {
        return this.packageDimensions;
    }

    public void setPackageDimensions(PackageDimensions packageDimensions) {
        this.packageDimensions = packageDimensions;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public static Product create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Product.create(params, null);
    }

    public static Product retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Product.retrieve(id, null);
    }

    public static ProductCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Product.all(params, null);
    }

    public Product update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public static Product create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Product.request(APIResource.RequestMethod.POST, Product.classURL(Product.class), params, Product.class, options);
    }

    public static Product retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Product.request(APIResource.RequestMethod.GET, Product.instanceURL(Product.class, id), null, Product.class, options);
    }

    public static ProductCollection all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Product.request(APIResource.RequestMethod.GET, Product.classURL(Product.class), params, ProductCollection.class, options);
    }

    public Product update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Product.request(APIResource.RequestMethod.POST, Product.instanceURL(Product.class, this.id), params, Product.class, options);
    }
}

