package com.stripe;

import java.util.HashMap;
import java.util.Map;

import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Token;
import com.stripe.net.RequestOptions;

public class StripeExample {

    public static void main(String[] args) {
        RequestOptions requestOptions = (new RequestOptions.RequestOptionsBuilder()).setApiKey("sk_test_y0SjZDHmieKxrPFJGSJ7BMcl").build();
        Map<String, Object> tokenMap = new HashMap<String, Object>();
        Map<String, Object> bankAccountMap = new HashMap<String, Object>();
        bankAccountMap.put("country", "US");
        bankAccountMap.put("routing_number", "110000000");
        bankAccountMap.put("account_number", "000123456789");
        tokenMap.put("bank_account", bankAccountMap);
        try {
            Token token = Token.create(tokenMap, requestOptions);
            System.out.println(token);
            System.out.println(token.getBankAccount());
        } catch (StripeException e) {
            e.printStackTrace();
        }
    }
}
