/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.MetadataStore;
import com.stripe.model.OrderCollection;
import com.stripe.model.OrderItem;
import com.stripe.model.ShippingDetails;
import com.stripe.model.ShippingMethod;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.List;
import java.util.Map;

public class Order
extends APIResource
implements MetadataStore<Order> {
    Long created;
    Long updated;
    String id;
    Boolean livemode;
    Integer amount;
    String currency;
    List<OrderItem> items;
    Map<String, String> metadata;
    String status;
    String charge;
    String customer;
    String email;
    String selectedShippingMethod;
    ShippingDetails shipping;
    List<ShippingMethod> shippingMethods;
    Long applicationFee;

    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public Long getUpdated() {
        return this.updated;
    }

    public void setUpdated(Long updated) {
        this.updated = updated;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Boolean getLivemode() {
        return this.livemode;
    }

    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    public Integer getAmount() {
        return this.amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public List<OrderItem> getItems() {
        return this.items;
    }

    public void setItems(List<OrderItem> items) {
        this.items = items;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getCharge() {
        return this.charge;
    }

    public void setCharge(String charge) {
        this.charge = charge;
    }

    public String getCustomer() {
        return this.customer;
    }

    public void setCustomer(String customer) {
        this.customer = customer;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getSelectedShippingMethod() {
        return this.selectedShippingMethod;
    }

    public void setSelectedShippingMethod(String selectedShippingMethod) {
        this.selectedShippingMethod = selectedShippingMethod;
    }

    public ShippingDetails getShipping() {
        return this.shipping;
    }

    public void setShipping(ShippingDetails shipping) {
        this.shipping = shipping;
    }

    public List<ShippingMethod> getShippingMethods() {
        return this.shippingMethods;
    }

    public void setShippingMethods(List<ShippingMethod> shippingMethods) {
        this.shippingMethods = shippingMethods;
    }

    public Long getApplicationFee() {
        return this.applicationFee;
    }

    public void setApplicationFee(Long applicationFee) {
        this.applicationFee = applicationFee;
    }

    public static Order create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Order.create(params, null);
    }

    public static Order retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Order.retrieve(id, null);
    }

    public static OrderCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Order.all(params, null);
    }

    public Order update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public static Order create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Order.request(APIResource.RequestMethod.POST, Order.classURL(Order.class), params, Order.class, options);
    }

    public static Order retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Order.request(APIResource.RequestMethod.GET, Order.instanceURL(Order.class, id), null, Order.class, options);
    }

    public static OrderCollection all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Order.request(APIResource.RequestMethod.GET, Order.classURL(Order.class), params, OrderCollection.class, options);
    }

    public Order update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Order.request(APIResource.RequestMethod.POST, Order.instanceURL(Order.class, this.id), params, Order.class, options);
    }

    public Order pay(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.pay(params, null);
    }

    public Order pay(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Order.request(APIResource.RequestMethod.POST, String.format("%s/pay", Order.instanceURL(Order.class, this.getId())), params, Order.class, options);
    }
}

