/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.AccountCollection;
import com.stripe.model.AccountDeclineChargeOn;
import com.stripe.model.AccountTosAcceptance;
import com.stripe.model.AccountTransferSchedule;
import com.stripe.model.DeletedAccount;
import com.stripe.model.ExternalAccountCollection;
import com.stripe.model.HasId;
import com.stripe.model.LegalEntity;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.List;
import java.util.Map;

public class Account
extends APIResource
implements HasId,
MetadataStore<Account> {
    String id;
    Boolean chargesEnabled;
    Boolean detailsSubmitted;
    Boolean transfersEnabled;
    Boolean debitNegativeBalances;
    List<String> currenciesSupported;
    String email;
    String statementDescriptor;
    String defaultCurrency;
    String country;
    String timezone;
    String displayName;
    Verification verification;
    LegalEntity legalEntity;
    Keys keys;
    Map<String, String> metadata;
    String businessName;
    String businessUrl;
    String businessLogo;
    String businessPrimaryColor;
    String supportPhone;
    String supportUrl;
    String supportEmail;
    String productDescription;
    Boolean managed;
    AccountDeclineChargeOn declineChargeOn;
    AccountTosAcceptance tosAcceptance;
    AccountTransferSchedule transferSchedule;
    ExternalAccountCollection externalAccounts;

    @Override
    public String getId() {
        return this.id;
    }

    public Boolean getChargesEnabled() {
        return this.chargesEnabled;
    }

    public Boolean getDetailsSubmitted() {
        return this.detailsSubmitted;
    }

    public Boolean getTransfersEnabled() {
        return this.transfersEnabled;
    }

    public Boolean getDebitNegativeBalances() {
        return this.debitNegativeBalances;
    }

    public void setDebitNegativeBalances(Boolean debitNegativeBalances) {
        this.debitNegativeBalances = debitNegativeBalances;
    }

    public List<String> getCurrenciesSupported() {
        return this.currenciesSupported;
    }

    public String getEmail() {
        return this.email;
    }

    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    public String getDefaultCurrency() {
        return this.defaultCurrency;
    }

    public String getCountry() {
        return this.country;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Verification getVerification() {
        return this.verification;
    }

    public LegalEntity getLegalEntity() {
        return this.legalEntity;
    }

    public Keys getKeys() {
        return this.keys;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public String getBusinessName() {
        return this.businessName;
    }

    public String getBusinessUrl() {
        return this.businessUrl;
    }

    public String getBusinessLogo() {
        return this.businessLogo;
    }

    public String getBusinessPrimaryColor() {
        return this.businessPrimaryColor;
    }

    public void setBusinessPrimaryColor(String businessPrimaryColor) {
        this.businessPrimaryColor = businessPrimaryColor;
    }

    public String getSupportPhone() {
        return this.supportPhone;
    }

    public String getSupportUrl() {
        return this.supportUrl;
    }

    public String getSupportEmail() {
        return this.supportEmail;
    }

    public String getProductDescription() {
        return this.productDescription;
    }

    public void setProductDescription(String productDescription) {
        this.productDescription = productDescription;
    }

    public Boolean getManaged() {
        return this.managed;
    }

    public AccountDeclineChargeOn getDeclineChargeOn() {
        return this.declineChargeOn;
    }

    public void setDeclineChargeOn(AccountDeclineChargeOn declineChargeOn) {
        this.declineChargeOn = declineChargeOn;
    }

    public AccountTosAcceptance getTosAcceptance() {
        return this.tosAcceptance;
    }

    public void setTosAcceptance(AccountTosAcceptance tosAcceptance) {
        this.tosAcceptance = tosAcceptance;
    }

    public AccountTransferSchedule getTransferSchedule() {
        return this.transferSchedule;
    }

    public void setTransferSchedule(AccountTransferSchedule transferSchedule) {
        this.transferSchedule = transferSchedule;
    }

    public ExternalAccountCollection getExternalAccounts() {
        return this.externalAccounts;
    }

    public static Account create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.create(params, null);
    }

    public static Account create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.request(APIResource.RequestMethod.POST, Account.classURL(Account.class), params, Account.class, options);
    }

    public static AccountCollection list(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.list(params, null);
    }

    public static AccountCollection list(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.requestCollection(Account.classURL(Account.class), params, AccountCollection.class, options);
    }

    @Deprecated
    public static AccountCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.list(params, null);
    }

    @Deprecated
    public static AccountCollection all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.list(params, options);
    }

    public static Account retrieve() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.retrieve((RequestOptions)null);
    }

    @Deprecated
    public static Account retrieve(String apiKeyOrAccountId) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        if (null == apiKeyOrAccountId || apiKeyOrAccountId.startsWith("sk_")) {
            return Account.retrieve(RequestOptions.builder().setApiKey(apiKeyOrAccountId).build());
        }
        return Account.retrieve(apiKeyOrAccountId, null);
    }

    public static Account retrieve(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.request(APIResource.RequestMethod.GET, Account.singleClassURL(Account.class), null, Account.class, options);
    }

    public static Account retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.request(APIResource.RequestMethod.GET, Account.instanceURL(Account.class, id), null, Account.class, options);
    }

    public Account update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Account update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.request(APIResource.RequestMethod.POST, Account.instanceURL(Account.class, this.id), params, Account.class, options);
    }

    public DeletedAccount delete(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.delete(params, null);
    }

    public DeletedAccount delete(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.request(APIResource.RequestMethod.DELETE, Account.instanceURL(Account.class, this.id), params, DeletedAccount.class, options);
    }

    public static class Keys
    extends StripeObject {
        String secret;
        String publishable;

        public String getSecret() {
            return this.secret;
        }

        public String getPublishable() {
            return this.publishable;
        }
    }

    public static class Verification
    extends StripeObject {
        List<String> fieldsNeeded;
        Long dueBy;
        Boolean contacted;

        public List<String> getFieldsNeeded() {
            return this.fieldsNeeded;
        }

        public Long getDueBy() {
            return this.dueBy;
        }

        public Boolean getContacted() {
            return this.contacted;
        }
    }
}

