/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.Stripe;
import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.BalanceTransactionCollection;
import com.stripe.model.Fee;
import com.stripe.model.HasId;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.List;
import java.util.Map;

public class BalanceTransaction
extends APIResource
implements HasId {
    String id;
    String source;
    Integer amount;
    String currency;
    Integer net;
    String type;
    Long created;
    Long availableOn;
    String status;
    Integer fee;
    List<Fee> feeDetails;
    String description;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Integer getAmount() {
        return this.amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Integer getNet() {
        return this.net;
    }

    public void setNet(Integer net) {
        this.net = net;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public Long getAvailableOn() {
        return this.availableOn;
    }

    public void setAvailableOn(Long availableOn) {
        this.availableOn = availableOn;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Integer getFee() {
        return this.fee;
    }

    public void setFee(Integer fee) {
        this.fee = fee;
    }

    public List<Fee> getFeeDetails() {
        return this.feeDetails;
    }

    public void setFeeDetails(List<Fee> feeDetails) {
        this.feeDetails = feeDetails;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static BalanceTransaction retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BalanceTransaction.retrieve(id, (RequestOptions)null);
    }

    @Deprecated
    public static BalanceTransaction retrieve(String id, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String url = String.format("%s/%s/%s", Stripe.getApiBase(), "v1/balance/history", id);
        return BalanceTransaction.retrieve(id, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static BalanceTransaction retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String url = String.format("%s/%s/%s", Stripe.getApiBase(), "v1/balance/history", id);
        return BalanceTransaction.request(APIResource.RequestMethod.GET, url, null, BalanceTransaction.class, options);
    }

    public static BalanceTransactionCollection list(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BalanceTransaction.list(params, null);
    }

    public static BalanceTransactionCollection list(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String url = String.format("%s/%s", Stripe.getApiBase(), "v1/balance/history");
        return BalanceTransaction.requestCollection(url, params, BalanceTransactionCollection.class, options);
    }

    @Deprecated
    public static BalanceTransactionCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BalanceTransaction.list(params, null);
    }

    @Deprecated
    public static BalanceTransactionCollection all(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BalanceTransaction.list(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    @Deprecated
    public static BalanceTransactionCollection all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BalanceTransaction.list(params, options);
    }
}

