/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Account;
import com.stripe.model.Customer;
import com.stripe.model.DeletedExternalAccount;
import com.stripe.model.HasId;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.Map;

public class ExternalAccount
extends APIResource
implements HasId {
    String id;
    String object;
    String customer;
    String account;

    @Override
    public String getId() {
        return this.id;
    }

    public String getObject() {
        return this.object;
    }

    public String getCustomer() {
        return this.customer;
    }

    public void setCustomer(String customer) {
        this.customer = customer;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getInstanceURL() {
        if (this.getCustomer() != null) {
            return String.format("%s/%s/sources/%s", ExternalAccount.classURL(Customer.class), this.getCustomer(), this.getId());
        }
        if (this.getAccount() != null) {
            return String.format("%s/%s/external_accounts/%s", ExternalAccount.classURL(Account.class), this.getAccount(), this.getId());
        }
        return null;
    }

    public ExternalAccount verify(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.verify(params, null);
    }

    public ExternalAccount verify(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        if (this.getCustomer() != null) {
            return ExternalAccount.request(APIResource.RequestMethod.POST, String.format("%s/verify", this.getInstanceURL()), params, ExternalAccount.class, options);
        }
        throw new InvalidRequestException("Only customer bank accounts can be verified in this manner.", null, null, null, null);
    }

    public ExternalAccount update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update(params, null);
    }

    public ExternalAccount update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return ExternalAccount.request(APIResource.RequestMethod.POST, this.getInstanceURL(), params, ExternalAccount.class, options);
    }

    public DeletedExternalAccount delete() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.delete(null);
    }

    public DeletedExternalAccount delete(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return ExternalAccount.request(APIResource.RequestMethod.DELETE, this.getInstanceURL(), null, DeletedExternalAccount.class, options);
    }
}

