/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.Stripe;
import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.ExternalAccount;
import com.stripe.model.StripeCollectionAPIResource;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.Map;

public class ExternalAccountCollection
extends StripeCollectionAPIResource<ExternalAccount> {
    public ExternalAccountCollection list(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.list(params, null);
    }

    public ExternalAccountCollection list(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String url = String.format("%s%s", Stripe.getApiBase(), this.getURL());
        return ExternalAccountCollection.requestCollection(url, params, ExternalAccountCollection.class, options);
    }

    @Deprecated
    public ExternalAccountCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.list(params, null);
    }

    @Deprecated
    public ExternalAccountCollection all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.list(params, options);
    }

    public ExternalAccount retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.retrieve(id, null);
    }

    public ExternalAccount retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String url = String.format("%s%s/%s", Stripe.getApiBase(), this.getURL(), id);
        return ExternalAccountCollection.request(APIResource.RequestMethod.GET, url, null, ExternalAccount.class, options);
    }

    public ExternalAccount create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.create(params, null);
    }

    public ExternalAccount create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String url = String.format("%s%s", Stripe.getApiBase(), this.getURL());
        return ExternalAccountCollection.request(APIResource.RequestMethod.POST, url, params, ExternalAccount.class, options);
    }
}

