/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.Transfer;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.Map;

public class Reversal
extends APIResource
implements MetadataStore<Transfer>,
HasId {
    Integer amount;
    String currency;
    Long created;
    String balanceTransaction;
    String id;
    String transfer;
    Map<String, String> metadata;

    public Reversal update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    @Deprecated
    public Reversal update(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Reversal update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Reversal.request(APIResource.RequestMethod.POST, this.getInstanceURL(), params, Reversal.class, options);
    }

    public String getInstanceURL() {
        if (this.transfer != null) {
            return String.format("%s/%s/reversals/%s", Reversal.classURL(Transfer.class), this.transfer, this.getId());
        }
        return null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Integer getAmount() {
        return this.amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public String getBalanceTransaction() {
        return this.balanceTransaction;
    }

    public void setBalanceTransaction(String balanceTransaction) {
        this.balanceTransaction = balanceTransaction;
    }

    public String getTransfer() {
        return this.transfer;
    }

    public void setTransfer(String transfer) {
        this.transfer = transfer;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }
}

