/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.ApplicationFeeCollection;
import com.stripe.model.FeeRefund;
import com.stripe.net.APIResource;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationFee
extends APIResource {
    Integer amount;
    Long created;
    String currency;
    String id;
    Boolean livemode;
    Boolean refunded;
    Integer amountRefunded;
    String user;
    String application;
    String charge;
    List<FeeRefund> refunds;
    String balanceTransaction;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getAmount() {
        return this.amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Boolean getLivemode() {
        return this.livemode;
    }

    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    public Boolean getRefunded() {
        return this.refunded;
    }

    public void setRefunded(Boolean refunded) {
        this.refunded = refunded;
    }

    public Integer getAmountRefunded() {
        return this.amountRefunded;
    }

    public void setAmountRefunded(Integer amountRefunded) {
        this.amountRefunded = amountRefunded;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getCharge() {
        return this.charge;
    }

    public void setCharge(String charge) {
        this.charge = charge;
    }

    public List<FeeRefund> getRefunds() {
        return this.refunds;
    }

    public void setRefunds(List<FeeRefund> refunds) {
        this.refunds = refunds;
    }

    public String getBalanceTransaction() {
        return this.balanceTransaction;
    }

    public void setBalanceTransaction(String balanceTransaction) {
        this.balanceTransaction = balanceTransaction;
    }

    public static ApplicationFee retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return ApplicationFee.retrieve(id, null);
    }

    public static ApplicationFeeCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return ApplicationFee.all(params, null);
    }

    public ApplicationFee refund() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.refund(null, null);
    }

    public ApplicationFee refund(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.refund(params, null);
    }

    public static ApplicationFee retrieve(String id, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String url = String.format("%s/%s/%s", "https://api.stripe.com", "v1/application_fees", id);
        return ApplicationFee.request(APIResource.RequestMethod.GET, url, null, ApplicationFee.class, apiKey);
    }

    public static ApplicationFeeCollection all(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String url = String.format("%s/%s", "https://api.stripe.com", "v1/application_fees");
        return ApplicationFee.request(APIResource.RequestMethod.GET, url, params, ApplicationFeeCollection.class, apiKey);
    }

    public ApplicationFee refund(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.refund(null, apiKey);
    }

    public ApplicationFee refund(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String url = String.format("%s/%s/%s", "https://api.stripe.com", "v1/application_fees", this.id);
        return ApplicationFee.request(APIResource.RequestMethod.POST, url, params, ApplicationFee.class, apiKey);
    }
}

