/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Discount;
import com.stripe.model.InvoiceCollection;
import com.stripe.model.InvoiceLineItemCollection;
import com.stripe.net.APIResource;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invoice
extends APIResource {
    Integer subtotal;
    Integer total;
    Integer amountDue;
    Integer startingBalance;
    Integer endingBalance;
    String id;
    Long created;
    Long nextPaymentAttempt;
    Boolean attempted;
    String charge;
    Boolean closed;
    String customer;
    Long date;
    Boolean paid;
    Long periodStart;
    Long periodEnd;
    Discount discount;
    InvoiceLineItemCollection lines;
    Boolean livemode;
    Integer attemptCount;
    String currency;
    String subscription;

    public Integer getSubtotal() {
        return this.subtotal;
    }

    public void setSubtotal(Integer subtotal) {
        this.subtotal = subtotal;
    }

    public Integer getTotal() {
        return this.total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public Integer getAmountDue() {
        return this.amountDue;
    }

    public void setAmountDue(Integer amountDue) {
        this.amountDue = amountDue;
    }

    public Integer getStartingBalance() {
        return this.startingBalance;
    }

    public void setStartingBalance(Integer startingBalance) {
        this.startingBalance = startingBalance;
    }

    public Integer getEndingBalance() {
        return this.endingBalance;
    }

    public void setEndingBalance(Integer endingBalance) {
        this.endingBalance = endingBalance;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public Long getNextPaymentAttempt() {
        return this.nextPaymentAttempt;
    }

    public void setNextPaymentAttempt(Long nextPaymentAttempt) {
        this.nextPaymentAttempt = nextPaymentAttempt;
    }

    public Boolean getAttempted() {
        return this.attempted;
    }

    public void setAttempted(Boolean attempted) {
        this.attempted = attempted;
    }

    public String getCharge() {
        return this.charge;
    }

    public void setCharge(String charge) {
        this.charge = charge;
    }

    public Boolean getClosed() {
        return this.closed;
    }

    public void setClosed(Boolean closed) {
        this.closed = closed;
    }

    public String getCustomer() {
        return this.customer;
    }

    public void setCustomer(String customer) {
        this.customer = customer;
    }

    public Long getDate() {
        return this.date;
    }

    public void setDate(Long date) {
        this.date = date;
    }

    public Boolean getPaid() {
        return this.paid;
    }

    public void setPaid(Boolean paid) {
        this.paid = paid;
    }

    public Long getPeriodStart() {
        return this.periodStart;
    }

    public void setPeriodStart(Long periodStart) {
        this.periodStart = periodStart;
    }

    public Long getPeriodEnd() {
        return this.periodEnd;
    }

    public void setPeriodEnd(Long periodEnd) {
        this.periodEnd = periodEnd;
    }

    public Discount getDiscount() {
        return this.discount;
    }

    public void setDiscount(Discount discount) {
        this.discount = discount;
    }

    public InvoiceLineItemCollection getLines() {
        return this.lines;
    }

    public Boolean getLivemode() {
        return this.livemode;
    }

    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    public Integer getAttemptCount() {
        return this.attemptCount;
    }

    public void setAttemptCount(Integer attemptCount) {
        this.attemptCount = attemptCount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getSubscription() {
        return this.subscription;
    }

    public void setSubscription(String subscription) {
        this.subscription = subscription;
    }

    public static Invoice retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.retrieve(id, null);
    }

    public static Invoice create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.create(params, null);
    }

    public static InvoiceCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.all(params, null);
    }

    public static Invoice upcoming(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.upcoming(params, null);
    }

    public Invoice pay() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.pay(null);
    }

    public Invoice update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update(params, null);
    }

    public static Invoice retrieve(String id, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.request(APIResource.RequestMethod.GET, Invoice.instanceURL(Invoice.class, id), null, Invoice.class, apiKey);
    }

    public static Invoice create(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.request(APIResource.RequestMethod.POST, Invoice.classURL(Invoice.class), params, Invoice.class, apiKey);
    }

    public static Invoice upcoming(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.request(APIResource.RequestMethod.GET, String.format("%s/upcoming", Invoice.classURL(Invoice.class)), params, Invoice.class, apiKey);
    }

    public static InvoiceCollection all(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.request(APIResource.RequestMethod.GET, Invoice.classURL(Invoice.class), params, InvoiceCollection.class, apiKey);
    }

    public Invoice update(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.request(APIResource.RequestMethod.POST, Invoice.instanceURL(Invoice.class, this.id), params, Invoice.class, apiKey);
    }

    public Invoice pay(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.request(APIResource.RequestMethod.POST, String.format("%s/pay", Invoice.instanceURL(Invoice.class, this.getId())), null, Invoice.class, apiKey);
    }
}

