/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Customer;
import com.stripe.model.Discount;
import com.stripe.model.Plan;
import com.stripe.net.APIResource;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Subscription
extends APIResource {
    String id;
    Long currentPeriodEnd;
    Long currentPeriodStart;
    Boolean cancelAtPeriodEnd;
    String customer;
    Long start;
    String status;
    Long trialStart;
    Long trialEnd;
    Plan plan;
    Long canceledAt;
    Long endedAt;
    Integer quantity;
    String discount;

    public Subscription update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update(params, null);
    }

    public Subscription update(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Subscription.request(APIResource.RequestMethod.POST, this.getInstanceURL(), params, Subscription.class, apiKey);
    }

    public Subscription cancel(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.cancel(null);
    }

    public Subscription cancel(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Subscription.request(APIResource.RequestMethod.DELETE, this.getInstanceURL(), params, Subscription.class, apiKey);
    }

    public void deleteDiscount() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        this.deleteDiscount(null);
    }

    public void deleteDiscount(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Subscription.request(APIResource.RequestMethod.DELETE, String.format("%s/discount", this.getInstanceURL()), null, Discount.class, apiKey);
    }

    public String getInstanceURL() {
        return String.format("%s/%s/subscriptions/%s", Subscription.classURL(Customer.class), this.getCustomer(), this.getId());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Long getCurrentPeriodEnd() {
        return this.currentPeriodEnd;
    }

    public void setCurrentPeriodEnd(Long currentPeriodEnd) {
        this.currentPeriodEnd = currentPeriodEnd;
    }

    public Long getCurrentPeriodStart() {
        return this.currentPeriodStart;
    }

    public void setCurrentPeriodStart(Long currentPeriodStart) {
        this.currentPeriodStart = currentPeriodStart;
    }

    public Boolean getCancelAtPeriodEnd() {
        return this.cancelAtPeriodEnd;
    }

    public void setCancelAtPeriodEnd(Boolean cancelAtPeriodEnd) {
        this.cancelAtPeriodEnd = cancelAtPeriodEnd;
    }

    public String getCustomer() {
        return this.customer;
    }

    public void setCustomer(String customer) {
        this.customer = customer;
    }

    public Long getStart() {
        return this.start;
    }

    public void setStart(Long start) {
        this.start = start;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Long getTrialStart() {
        return this.trialStart;
    }

    public void setTrialStart(Long trialStart) {
        this.trialStart = trialStart;
    }

    public Long getTrialEnd() {
        return this.trialEnd;
    }

    public void setTrialEnd(Long trialEnd) {
        this.trialEnd = trialEnd;
    }

    public Plan getPlan() {
        return this.plan;
    }

    public void setPlan(Plan plan) {
        this.plan = plan;
    }

    public Long getCanceledAt() {
        return this.canceledAt;
    }

    public void setCanceledAt(Long canceledAt) {
        this.canceledAt = canceledAt;
    }

    public Long getEndedAt() {
        return this.endedAt;
    }

    public void setEndedAt(Long endedAt) {
        this.endedAt = endedAt;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public String getDiscount() {
        return this.discount;
    }

    public void setDiscount(String discount) {
        this.discount = discount;
    }
}

