/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.Stripe;
import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Subscription;
import com.stripe.net.APIResource;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomerSubscriptionCollection
extends APIResource {
    List<Subscription> data;
    Integer count;
    String url;

    public List<Subscription> getData() {
        return this.data;
    }

    public String getURL() {
        return this.url;
    }

    public Integer getCount() {
        return this.count;
    }

    public CustomerSubscriptionCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.all(params, null);
    }

    public CustomerSubscriptionCollection all(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String url = String.format("%s%s", Stripe.getApiBase(), this.getURL());
        return CustomerSubscriptionCollection.request(APIResource.RequestMethod.GET, url, params, CustomerSubscriptionCollection.class, apiKey);
    }

    public Subscription retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.retrieve(id, null);
    }

    public Subscription retrieve(String id, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String url = String.format("%s%s/%s", Stripe.getApiBase(), this.getURL(), id);
        return CustomerSubscriptionCollection.request(APIResource.RequestMethod.GET, url, null, Subscription.class, apiKey);
    }

    public CustomerSubscriptionCollection create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.create(params, null);
    }

    public CustomerSubscriptionCollection create(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String url = String.format("%s%s", Stripe.getApiBase(), this.getURL());
        return CustomerSubscriptionCollection.request(APIResource.RequestMethod.POST, url, params, CustomerSubscriptionCollection.class, apiKey);
    }
}

