/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.DeletedInvoiceItem;
import com.stripe.model.InvoiceItemCollection;
import com.stripe.model.MetadataStore;
import com.stripe.net.APIResource;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvoiceItem
extends APIResource
implements MetadataStore<InvoiceItem> {
    Integer amount;
    String id;
    String currency;
    String description;
    Long date;
    Boolean livemode;
    String customer;
    String invoice;
    Map<String, String> metadata;
    String subscription;

    public Integer getAmount() {
        return this.amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getDate() {
        return this.date;
    }

    public void setDate(Long date) {
        this.date = date;
    }

    public Boolean getLivemode() {
        return this.livemode;
    }

    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    public String getCustomer() {
        return this.customer;
    }

    public void setCustomer(String customer) {
        this.customer = customer;
    }

    public String getInvoice() {
        return this.invoice;
    }

    public void setInvoice(String invoice) {
        this.invoice = invoice;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public String getSubscription() {
        return this.subscription;
    }

    public void setSubscription(String subscription) {
        this.subscription = subscription;
    }

    public static InvoiceItem create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InvoiceItem.create(params, null);
    }

    public static InvoiceItem retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InvoiceItem.retrieve(id, null);
    }

    public static InvoiceItemCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InvoiceItem.all(params, null);
    }

    public InvoiceItem update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (String)null);
    }

    public DeletedInvoiceItem delete() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.delete(null);
    }

    public static InvoiceItem create(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InvoiceItem.request(APIResource.RequestMethod.POST, InvoiceItem.classURL(InvoiceItem.class), params, InvoiceItem.class, apiKey);
    }

    public static InvoiceItem retrieve(String id, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InvoiceItem.request(APIResource.RequestMethod.GET, InvoiceItem.instanceURL(InvoiceItem.class, id), null, InvoiceItem.class, apiKey);
    }

    public static InvoiceItemCollection all(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InvoiceItem.request(APIResource.RequestMethod.GET, InvoiceItem.classURL(InvoiceItem.class), params, InvoiceItemCollection.class, apiKey);
    }

    public InvoiceItem update(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InvoiceItem.request(APIResource.RequestMethod.POST, InvoiceItem.instanceURL(InvoiceItem.class, this.id), params, InvoiceItem.class, apiKey);
    }

    public DeletedInvoiceItem delete(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InvoiceItem.request(APIResource.RequestMethod.DELETE, InvoiceItem.instanceURL(InvoiceItem.class, this.id), null, DeletedInvoiceItem.class, apiKey);
    }
}

