/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.issuing;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.ExpandableField;
import com.stripe.model.File;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.model.issuing.DisputeCollection;
import com.stripe.model.issuing.Transaction;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.issuing.DisputeCreateParams;
import com.stripe.param.issuing.DisputeListParams;
import com.stripe.param.issuing.DisputeRetrieveParams;
import com.stripe.param.issuing.DisputeUpdateParams;
import java.util.Map;
import lombok.Generated;

public class Dispute
extends ApiResource
implements HasId,
MetadataStore<Dispute> {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="disputed_transaction")
    ExpandableField<Transaction> disputedTransaction;
    @SerializedName(value="evidence")
    Evidence evidence;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="reason")
    String reason;
    @SerializedName(value="status")
    String status;

    public String getDisputedTransaction() {
        return this.disputedTransaction != null ? this.disputedTransaction.getId() : null;
    }

    public void setDisputedTransaction(String id) {
        this.disputedTransaction = ApiResource.setExpandableFieldId(id, this.disputedTransaction);
    }

    public Transaction getDisputedTransactionObject() {
        return this.disputedTransaction != null ? this.disputedTransaction.getExpanded() : null;
    }

    public void setDisputedTransactionObject(Transaction expandableObject) {
        this.disputedTransaction = new ExpandableField<Transaction>(expandableObject.getId(), expandableObject);
    }

    public static DisputeCollection list(Map<String, Object> params) throws StripeException {
        return Dispute.list(params, (RequestOptions)null);
    }

    public static DisputeCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/disputes");
        return Dispute.requestCollection(url, params, DisputeCollection.class, options);
    }

    public static DisputeCollection list(DisputeListParams params) throws StripeException {
        return Dispute.list(params, (RequestOptions)null);
    }

    public static DisputeCollection list(DisputeListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/disputes");
        return Dispute.requestCollection(url, params, DisputeCollection.class, options);
    }

    public static Dispute create(Map<String, Object> params) throws StripeException {
        return Dispute.create(params, (RequestOptions)null);
    }

    public static Dispute create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/disputes");
        return Dispute.request(ApiResource.RequestMethod.POST, url, params, Dispute.class, options);
    }

    public static Dispute create(DisputeCreateParams params) throws StripeException {
        return Dispute.create(params, (RequestOptions)null);
    }

    public static Dispute create(DisputeCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/disputes");
        return Dispute.request(ApiResource.RequestMethod.POST, url, params, Dispute.class, options);
    }

    public Dispute update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Dispute update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/disputes/%s", ApiResource.urlEncodeId(this.getId())));
        return Dispute.request(ApiResource.RequestMethod.POST, url, params, Dispute.class, options);
    }

    public Dispute update(DisputeUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Dispute update(DisputeUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/disputes/%s", ApiResource.urlEncodeId(this.getId())));
        return Dispute.request(ApiResource.RequestMethod.POST, url, params, Dispute.class, options);
    }

    public static Dispute retrieve(String dispute) throws StripeException {
        return Dispute.retrieve(dispute, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Dispute retrieve(String dispute, RequestOptions options) throws StripeException {
        return Dispute.retrieve(dispute, (Map<String, Object>)null, options);
    }

    public static Dispute retrieve(String dispute, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/disputes/%s", ApiResource.urlEncodeId(dispute)));
        return Dispute.request(ApiResource.RequestMethod.GET, url, params, Dispute.class, options);
    }

    public static Dispute retrieve(String dispute, DisputeRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/disputes/%s", ApiResource.urlEncodeId(dispute)));
        return Dispute.request(ApiResource.RequestMethod.GET, url, params, Dispute.class, options);
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public Evidence getEvidence() {
        return this.evidence;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getReason() {
        return this.reason;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setEvidence(Evidence evidence) {
        this.evidence = evidence;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setReason(String reason) {
        this.reason = reason;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Dispute)) {
            return false;
        }
        Dispute other = (Dispute)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$disputedTransaction = this.getDisputedTransaction();
        String other$disputedTransaction = other.getDisputedTransaction();
        if (this$disputedTransaction == null ? other$disputedTransaction != null : !this$disputedTransaction.equals(other$disputedTransaction)) {
            return false;
        }
        Evidence this$evidence = this.getEvidence();
        Evidence other$evidence = other.getEvidence();
        if (this$evidence == null ? other$evidence != null : !((Object)this$evidence).equals(other$evidence)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !this$status.equals(other$status));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Dispute;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $disputedTransaction = this.getDisputedTransaction();
        result = result * 59 + ($disputedTransaction == null ? 43 : $disputedTransaction.hashCode());
        Evidence $evidence = this.getEvidence();
        result = result * 59 + ($evidence == null ? 43 : ((Object)$evidence).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class EvidenceOther
    extends StripeObject {
        @SerializedName(value="dispute_explanation")
        String disputeExplanation;
        @SerializedName(value="uncategorized_file")
        ExpandableField<File> uncategorizedFile;

        public String getUncategorizedFile() {
            return this.uncategorizedFile != null ? this.uncategorizedFile.getId() : null;
        }

        public void setUncategorizedFile(String id) {
            this.uncategorizedFile = ApiResource.setExpandableFieldId(id, this.uncategorizedFile);
        }

        public File getUncategorizedFileObject() {
            return this.uncategorizedFile != null ? this.uncategorizedFile.getExpanded() : null;
        }

        public void setUncategorizedFileObject(File expandableObject) {
            this.uncategorizedFile = new ExpandableField<File>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public String getDisputeExplanation() {
            return this.disputeExplanation;
        }

        @Generated
        public void setDisputeExplanation(String disputeExplanation) {
            this.disputeExplanation = disputeExplanation;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EvidenceOther)) {
                return false;
            }
            EvidenceOther other = (EvidenceOther)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$disputeExplanation = this.getDisputeExplanation();
            String other$disputeExplanation = other.getDisputeExplanation();
            if (this$disputeExplanation == null ? other$disputeExplanation != null : !this$disputeExplanation.equals(other$disputeExplanation)) {
                return false;
            }
            String this$uncategorizedFile = this.getUncategorizedFile();
            String other$uncategorizedFile = other.getUncategorizedFile();
            return !(this$uncategorizedFile == null ? other$uncategorizedFile != null : !this$uncategorizedFile.equals(other$uncategorizedFile));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof EvidenceOther;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $disputeExplanation = this.getDisputeExplanation();
            result = result * 59 + ($disputeExplanation == null ? 43 : $disputeExplanation.hashCode());
            String $uncategorizedFile = this.getUncategorizedFile();
            result = result * 59 + ($uncategorizedFile == null ? 43 : $uncategorizedFile.hashCode());
            return result;
        }
    }

    public static class EvidenceFraudulent
    extends StripeObject {
        @SerializedName(value="dispute_explanation")
        String disputeExplanation;
        @SerializedName(value="uncategorized_file")
        ExpandableField<File> uncategorizedFile;

        public String getUncategorizedFile() {
            return this.uncategorizedFile != null ? this.uncategorizedFile.getId() : null;
        }

        public void setUncategorizedFile(String id) {
            this.uncategorizedFile = ApiResource.setExpandableFieldId(id, this.uncategorizedFile);
        }

        public File getUncategorizedFileObject() {
            return this.uncategorizedFile != null ? this.uncategorizedFile.getExpanded() : null;
        }

        public void setUncategorizedFileObject(File expandableObject) {
            this.uncategorizedFile = new ExpandableField<File>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public String getDisputeExplanation() {
            return this.disputeExplanation;
        }

        @Generated
        public void setDisputeExplanation(String disputeExplanation) {
            this.disputeExplanation = disputeExplanation;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EvidenceFraudulent)) {
                return false;
            }
            EvidenceFraudulent other = (EvidenceFraudulent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$disputeExplanation = this.getDisputeExplanation();
            String other$disputeExplanation = other.getDisputeExplanation();
            if (this$disputeExplanation == null ? other$disputeExplanation != null : !this$disputeExplanation.equals(other$disputeExplanation)) {
                return false;
            }
            String this$uncategorizedFile = this.getUncategorizedFile();
            String other$uncategorizedFile = other.getUncategorizedFile();
            return !(this$uncategorizedFile == null ? other$uncategorizedFile != null : !this$uncategorizedFile.equals(other$uncategorizedFile));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof EvidenceFraudulent;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $disputeExplanation = this.getDisputeExplanation();
            result = result * 59 + ($disputeExplanation == null ? 43 : $disputeExplanation.hashCode());
            String $uncategorizedFile = this.getUncategorizedFile();
            result = result * 59 + ($uncategorizedFile == null ? 43 : $uncategorizedFile.hashCode());
            return result;
        }
    }

    public static class Evidence
    extends StripeObject {
        @SerializedName(value="fraudulent")
        EvidenceFraudulent fraudulent;
        @SerializedName(value="other")
        EvidenceOther other;

        @Generated
        public EvidenceFraudulent getFraudulent() {
            return this.fraudulent;
        }

        @Generated
        public EvidenceOther getOther() {
            return this.other;
        }

        @Generated
        public void setFraudulent(EvidenceFraudulent fraudulent) {
            this.fraudulent = fraudulent;
        }

        @Generated
        public void setOther(EvidenceOther other) {
            this.other = other;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Evidence)) {
                return false;
            }
            Evidence other = (Evidence)o;
            if (!other.canEqual(this)) {
                return false;
            }
            EvidenceFraudulent this$fraudulent = this.getFraudulent();
            EvidenceFraudulent other$fraudulent = other.getFraudulent();
            if (this$fraudulent == null ? other$fraudulent != null : !((Object)this$fraudulent).equals(other$fraudulent)) {
                return false;
            }
            EvidenceOther this$other = this.getOther();
            EvidenceOther other$other = other.getOther();
            return !(this$other == null ? other$other != null : !((Object)this$other).equals(other$other));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Evidence;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            EvidenceFraudulent $fraudulent = this.getFraudulent();
            result = result * 59 + ($fraudulent == null ? 43 : ((Object)$fraudulent).hashCode());
            EvidenceOther $other = this.getOther();
            result = result * 59 + ($other == null ? 43 : ((Object)$other).hashCode());
            return result;
        }
    }
}

