/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Customer;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.Invoice;
import com.stripe.model.InvoiceItemCollection;
import com.stripe.model.InvoiceLineItemPeriod;
import com.stripe.model.MetadataStore;
import com.stripe.model.Plan;
import com.stripe.model.Subscription;
import com.stripe.model.TaxRate;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.InvoiceItemCreateParams;
import com.stripe.param.InvoiceItemListParams;
import com.stripe.param.InvoiceItemRetrieveParams;
import com.stripe.param.InvoiceItemUpdateParams;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class InvoiceItem
extends ApiResource
implements HasId,
MetadataStore<InvoiceItem> {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="customer")
    ExpandableField<Customer> customer;
    @SerializedName(value="date")
    Long date;
    @SerializedName(value="deleted")
    Boolean deleted;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="discountable")
    Boolean discountable;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="invoice")
    ExpandableField<Invoice> invoice;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="period")
    InvoiceLineItemPeriod period;
    @SerializedName(value="plan")
    Plan plan;
    @SerializedName(value="proration")
    Boolean proration;
    @SerializedName(value="quantity")
    Long quantity;
    @SerializedName(value="subscription")
    ExpandableField<Subscription> subscription;
    @SerializedName(value="subscription_item")
    String subscriptionItem;
    @SerializedName(value="tax_rates")
    List<TaxRate> taxRates;
    @SerializedName(value="unit_amount")
    Long unitAmount;

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String id) {
        this.customer = ApiResource.setExpandableFieldId(id, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer expandableObject) {
        this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
    }

    public String getInvoice() {
        return this.invoice != null ? this.invoice.getId() : null;
    }

    public void setInvoice(String id) {
        this.invoice = ApiResource.setExpandableFieldId(id, this.invoice);
    }

    public Invoice getInvoiceObject() {
        return this.invoice != null ? this.invoice.getExpanded() : null;
    }

    public void setInvoiceObject(Invoice expandableObject) {
        this.invoice = new ExpandableField<Invoice>(expandableObject.getId(), expandableObject);
    }

    public String getSubscription() {
        return this.subscription != null ? this.subscription.getId() : null;
    }

    public void setSubscription(String id) {
        this.subscription = ApiResource.setExpandableFieldId(id, this.subscription);
    }

    public Subscription getSubscriptionObject() {
        return this.subscription != null ? this.subscription.getExpanded() : null;
    }

    public void setSubscriptionObject(Subscription expandableObject) {
        this.subscription = new ExpandableField<Subscription>(expandableObject.getId(), expandableObject);
    }

    public static InvoiceItemCollection list(Map<String, Object> params) throws StripeException {
        return InvoiceItem.list(params, (RequestOptions)null);
    }

    public static InvoiceItemCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/invoiceitems");
        return InvoiceItem.requestCollection(url, params, InvoiceItemCollection.class, options);
    }

    public static InvoiceItemCollection list(InvoiceItemListParams params) throws StripeException {
        return InvoiceItem.list(params, (RequestOptions)null);
    }

    public static InvoiceItemCollection list(InvoiceItemListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/invoiceitems");
        return InvoiceItem.requestCollection(url, params, InvoiceItemCollection.class, options);
    }

    public static InvoiceItem create(Map<String, Object> params) throws StripeException {
        return InvoiceItem.create(params, (RequestOptions)null);
    }

    public static InvoiceItem create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/invoiceitems");
        return InvoiceItem.request(ApiResource.RequestMethod.POST, url, params, InvoiceItem.class, options);
    }

    public static InvoiceItem create(InvoiceItemCreateParams params) throws StripeException {
        return InvoiceItem.create(params, (RequestOptions)null);
    }

    public static InvoiceItem create(InvoiceItemCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/invoiceitems");
        return InvoiceItem.request(ApiResource.RequestMethod.POST, url, params, InvoiceItem.class, options);
    }

    public static InvoiceItem retrieve(String invoiceitem) throws StripeException {
        return InvoiceItem.retrieve(invoiceitem, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static InvoiceItem retrieve(String invoiceitem, RequestOptions options) throws StripeException {
        return InvoiceItem.retrieve(invoiceitem, (Map<String, Object>)null, options);
    }

    public static InvoiceItem retrieve(String invoiceitem, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/invoiceitems/%s", ApiResource.urlEncodeId(invoiceitem)));
        return InvoiceItem.request(ApiResource.RequestMethod.GET, url, params, InvoiceItem.class, options);
    }

    public static InvoiceItem retrieve(String invoiceitem, InvoiceItemRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/invoiceitems/%s", ApiResource.urlEncodeId(invoiceitem)));
        return InvoiceItem.request(ApiResource.RequestMethod.GET, url, params, InvoiceItem.class, options);
    }

    public InvoiceItem update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public InvoiceItem update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/invoiceitems/%s", ApiResource.urlEncodeId(this.getId())));
        return InvoiceItem.request(ApiResource.RequestMethod.POST, url, params, InvoiceItem.class, options);
    }

    public InvoiceItem update(InvoiceItemUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public InvoiceItem update(InvoiceItemUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/invoiceitems/%s", ApiResource.urlEncodeId(this.getId())));
        return InvoiceItem.request(ApiResource.RequestMethod.POST, url, params, InvoiceItem.class, options);
    }

    public InvoiceItem delete() throws StripeException {
        return this.delete(null, null);
    }

    public InvoiceItem delete(RequestOptions options) throws StripeException {
        return this.delete(null, options);
    }

    public InvoiceItem delete(Map<String, Object> params) throws StripeException {
        return this.delete(params, null);
    }

    public InvoiceItem delete(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/invoiceitems/%s", ApiResource.urlEncodeId(this.getId())));
        return InvoiceItem.request(ApiResource.RequestMethod.DELETE, url, params, InvoiceItem.class, options);
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public Long getDate() {
        return this.date;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Boolean getDiscountable() {
        return this.discountable;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public InvoiceLineItemPeriod getPeriod() {
        return this.period;
    }

    @Generated
    public Plan getPlan() {
        return this.plan;
    }

    @Generated
    public Boolean getProration() {
        return this.proration;
    }

    @Generated
    public Long getQuantity() {
        return this.quantity;
    }

    @Generated
    public String getSubscriptionItem() {
        return this.subscriptionItem;
    }

    @Generated
    public List<TaxRate> getTaxRates() {
        return this.taxRates;
    }

    @Generated
    public Long getUnitAmount() {
        return this.unitAmount;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setDate(Long date) {
        this.date = date;
    }

    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setDiscountable(Boolean discountable) {
        this.discountable = discountable;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPeriod(InvoiceLineItemPeriod period) {
        this.period = period;
    }

    @Generated
    public void setPlan(Plan plan) {
        this.plan = plan;
    }

    @Generated
    public void setProration(Boolean proration) {
        this.proration = proration;
    }

    @Generated
    public void setQuantity(Long quantity) {
        this.quantity = quantity;
    }

    @Generated
    public void setSubscriptionItem(String subscriptionItem) {
        this.subscriptionItem = subscriptionItem;
    }

    @Generated
    public void setTaxRates(List<TaxRate> taxRates) {
        this.taxRates = taxRates;
    }

    @Generated
    public void setUnitAmount(Long unitAmount) {
        this.unitAmount = unitAmount;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InvoiceItem)) {
            return false;
        }
        InvoiceItem other = (InvoiceItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        Long this$date = this.getDate();
        Long other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Boolean this$discountable = this.getDiscountable();
        Boolean other$discountable = other.getDiscountable();
        if (this$discountable == null ? other$discountable != null : !((Object)this$discountable).equals(other$discountable)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$invoice = this.getInvoice();
        String other$invoice = other.getInvoice();
        if (this$invoice == null ? other$invoice != null : !this$invoice.equals(other$invoice)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        InvoiceLineItemPeriod this$period = this.getPeriod();
        InvoiceLineItemPeriod other$period = other.getPeriod();
        if (this$period == null ? other$period != null : !((Object)this$period).equals(other$period)) {
            return false;
        }
        Plan this$plan = this.getPlan();
        Plan other$plan = other.getPlan();
        if (this$plan == null ? other$plan != null : !((Object)this$plan).equals(other$plan)) {
            return false;
        }
        Boolean this$proration = this.getProration();
        Boolean other$proration = other.getProration();
        if (this$proration == null ? other$proration != null : !((Object)this$proration).equals(other$proration)) {
            return false;
        }
        Long this$quantity = this.getQuantity();
        Long other$quantity = other.getQuantity();
        if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
            return false;
        }
        String this$subscription = this.getSubscription();
        String other$subscription = other.getSubscription();
        if (this$subscription == null ? other$subscription != null : !this$subscription.equals(other$subscription)) {
            return false;
        }
        String this$subscriptionItem = this.getSubscriptionItem();
        String other$subscriptionItem = other.getSubscriptionItem();
        if (this$subscriptionItem == null ? other$subscriptionItem != null : !this$subscriptionItem.equals(other$subscriptionItem)) {
            return false;
        }
        List<TaxRate> this$taxRates = this.getTaxRates();
        List<TaxRate> other$taxRates = other.getTaxRates();
        if (this$taxRates == null ? other$taxRates != null : !((Object)this$taxRates).equals(other$taxRates)) {
            return false;
        }
        Long this$unitAmount = this.getUnitAmount();
        Long other$unitAmount = other.getUnitAmount();
        return !(this$unitAmount == null ? other$unitAmount != null : !((Object)this$unitAmount).equals(other$unitAmount));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InvoiceItem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        Long $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Boolean $discountable = this.getDiscountable();
        result = result * 59 + ($discountable == null ? 43 : ((Object)$discountable).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $invoice = this.getInvoice();
        result = result * 59 + ($invoice == null ? 43 : $invoice.hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        InvoiceLineItemPeriod $period = this.getPeriod();
        result = result * 59 + ($period == null ? 43 : ((Object)$period).hashCode());
        Plan $plan = this.getPlan();
        result = result * 59 + ($plan == null ? 43 : ((Object)$plan).hashCode());
        Boolean $proration = this.getProration();
        result = result * 59 + ($proration == null ? 43 : ((Object)$proration).hashCode());
        Long $quantity = this.getQuantity();
        result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
        String $subscription = this.getSubscription();
        result = result * 59 + ($subscription == null ? 43 : $subscription.hashCode());
        String $subscriptionItem = this.getSubscriptionItem();
        result = result * 59 + ($subscriptionItem == null ? 43 : $subscriptionItem.hashCode());
        List<TaxRate> $taxRates = this.getTaxRates();
        result = result * 59 + ($taxRates == null ? 43 : ((Object)$taxRates).hashCode());
        Long $unitAmount = this.getUnitAmount();
        result = result * 59 + ($unitAmount == null ? 43 : ((Object)$unitAmount).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }
}

