/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import com.stripe.param.common.EmptyParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PaymentIntentUpdateParams
extends ApiRequestParams {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="application_fee_amount")
    Object applicationFeeAmount;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="customer")
    String customer;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="_stripe_java_extra_param_key")
    Map<String, Object> extraParams;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="payment_method")
    String paymentMethod;
    @SerializedName(value="payment_method_types")
    List<String> paymentMethodTypes;
    @SerializedName(value="receipt_email")
    String receiptEmail;
    @SerializedName(value="save_payment_method")
    Boolean savePaymentMethod;
    @SerializedName(value="shipping")
    Object shipping;
    @SerializedName(value="source")
    String source;
    @SerializedName(value="statement_descriptor")
    String statementDescriptor;
    @SerializedName(value="transfer_group")
    String transferGroup;

    private PaymentIntentUpdateParams(Long amount, Object applicationFeeAmount, String currency, String customer, String description, List<String> expand, Map<String, Object> extraParams, Map<String, String> metadata, String paymentMethod, List<String> paymentMethodTypes, String receiptEmail, Boolean savePaymentMethod, Object shipping, String source, String statementDescriptor, String transferGroup) {
        this.amount = amount;
        this.applicationFeeAmount = applicationFeeAmount;
        this.currency = currency;
        this.customer = customer;
        this.description = description;
        this.expand = expand;
        this.extraParams = extraParams;
        this.metadata = metadata;
        this.paymentMethod = paymentMethod;
        this.paymentMethodTypes = paymentMethodTypes;
        this.receiptEmail = receiptEmail;
        this.savePaymentMethod = savePaymentMethod;
        this.shipping = shipping;
        this.source = source;
        this.statementDescriptor = statementDescriptor;
        this.transferGroup = transferGroup;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Shipping {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="carrier")
        String carrier;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="phone")
        String phone;
        @SerializedName(value="tracking_number")
        String trackingNumber;

        private Shipping(Address address, String carrier, Map<String, Object> extraParams, String name, String phone, String trackingNumber) {
            this.address = address;
            this.carrier = carrier;
            this.extraParams = extraParams;
            this.name = name;
            this.phone = phone;
            this.trackingNumber = trackingNumber;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Address {
            @SerializedName(value="city")
            String city;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="line1")
            String line1;
            @SerializedName(value="line2")
            String line2;
            @SerializedName(value="postal_code")
            String postalCode;
            @SerializedName(value="state")
            String state;

            private Address(String city, String country, Map<String, Object> extraParams, String line1, String line2, String postalCode, String state) {
                this.city = city;
                this.country = country;
                this.extraParams = extraParams;
                this.line1 = line1;
                this.line2 = line2;
                this.postalCode = postalCode;
                this.state = state;
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder {
                private String city;
                private String country;
                private Map<String, Object> extraParams;
                private String line1;
                private String line2;
                private String postalCode;
                private String state;

                public Address build() {
                    return new Address(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
                }

                public Builder setCity(String city) {
                    this.city = city;
                    return this;
                }

                public Builder setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setLine1(String line1) {
                    this.line1 = line1;
                    return this;
                }

                public Builder setLine2(String line2) {
                    this.line2 = line2;
                    return this;
                }

                public Builder setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                    return this;
                }

                public Builder setState(String state) {
                    this.state = state;
                    return this;
                }
            }
        }

        public static class Builder {
            private Address address;
            private String carrier;
            private Map<String, Object> extraParams;
            private String name;
            private String phone;
            private String trackingNumber;

            public Shipping build() {
                return new Shipping(this.address, this.carrier, this.extraParams, this.name, this.phone, this.trackingNumber);
            }

            public Builder setAddress(Address address) {
                this.address = address;
                return this;
            }

            public Builder setCarrier(String carrier) {
                this.carrier = carrier;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setName(String name) {
                this.name = name;
                return this;
            }

            public Builder setPhone(String phone) {
                this.phone = phone;
                return this;
            }

            public Builder setTrackingNumber(String trackingNumber) {
                this.trackingNumber = trackingNumber;
                return this;
            }
        }
    }

    public static class Builder {
        private Long amount;
        private Object applicationFeeAmount;
        private String currency;
        private String customer;
        private String description;
        private List<String> expand;
        private Map<String, Object> extraParams;
        private Map<String, String> metadata;
        private String paymentMethod;
        private List<String> paymentMethodTypes;
        private String receiptEmail;
        private Boolean savePaymentMethod;
        private Object shipping;
        private String source;
        private String statementDescriptor;
        private String transferGroup;

        public PaymentIntentUpdateParams build() {
            return new PaymentIntentUpdateParams(this.amount, this.applicationFeeAmount, this.currency, this.customer, this.description, this.expand, this.extraParams, this.metadata, this.paymentMethod, this.paymentMethodTypes, this.receiptEmail, this.savePaymentMethod, this.shipping, this.source, this.statementDescriptor, this.transferGroup);
        }

        public Builder setAmount(Long amount) {
            this.amount = amount;
            return this;
        }

        public Builder setApplicationFeeAmount(EmptyParam applicationFeeAmount) {
            this.applicationFeeAmount = applicationFeeAmount;
            return this;
        }

        public Builder setApplicationFeeAmount(Long applicationFeeAmount) {
            this.applicationFeeAmount = applicationFeeAmount;
            return this;
        }

        public Builder setCurrency(String currency) {
            this.currency = currency;
            return this;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.put(key, value);
            return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.putAll(map);
            return this;
        }

        public Builder putMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder putAllMetadata(Map<String, String> map) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.putAll(map);
            return this;
        }

        public Builder setPaymentMethod(String paymentMethod) {
            this.paymentMethod = paymentMethod;
            return this;
        }

        public Builder addPaymentMethodType(String element) {
            if (this.paymentMethodTypes == null) {
                this.paymentMethodTypes = new ArrayList<String>();
            }
            this.paymentMethodTypes.add(element);
            return this;
        }

        public Builder addAllPaymentMethodType(List<String> elements) {
            if (this.paymentMethodTypes == null) {
                this.paymentMethodTypes = new ArrayList<String>();
            }
            this.paymentMethodTypes.addAll(elements);
            return this;
        }

        public Builder setReceiptEmail(String receiptEmail) {
            this.receiptEmail = receiptEmail;
            return this;
        }

        public Builder setSavePaymentMethod(Boolean savePaymentMethod) {
            this.savePaymentMethod = savePaymentMethod;
            return this;
        }

        public Builder setShipping(Shipping shipping) {
            this.shipping = shipping;
            return this;
        }

        public Builder setShipping(EmptyParam shipping) {
            this.shipping = shipping;
            return this;
        }

        public Builder setSource(String source) {
            this.source = source;
            return this;
        }

        public Builder setStatementDescriptor(String statementDescriptor) {
            this.statementDescriptor = statementDescriptor;
            return this;
        }

        public Builder setTransferGroup(String transferGroup) {
            this.transferGroup = transferGroup;
            return this;
        }
    }
}

