/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AccountPersonsParams
extends ApiRequestParams {
    @SerializedName(value="ending_before")
    String endingBefore;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="_stripe_java_extra_param_key")
    Map<String, Object> extraParams;
    @SerializedName(value="limit")
    Long limit;
    @SerializedName(value="relationship")
    Relationship relationship;
    @SerializedName(value="starting_after")
    String startingAfter;

    private AccountPersonsParams(String endingBefore, List<String> expand, Map<String, Object> extraParams, Long limit, Relationship relationship, String startingAfter) {
        this.endingBefore = endingBefore;
        this.expand = expand;
        this.extraParams = extraParams;
        this.limit = limit;
        this.relationship = relationship;
        this.startingAfter = startingAfter;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Relationship {
        @SerializedName(value="account_opener")
        Boolean accountOpener;
        @SerializedName(value="director")
        Boolean director;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="owner")
        Boolean owner;

        private Relationship(Boolean accountOpener, Boolean director, Map<String, Object> extraParams, Boolean owner) {
            this.accountOpener = accountOpener;
            this.director = director;
            this.extraParams = extraParams;
            this.owner = owner;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private Boolean accountOpener;
            private Boolean director;
            private Map<String, Object> extraParams;
            private Boolean owner;

            public Relationship build() {
                return new Relationship(this.accountOpener, this.director, this.extraParams, this.owner);
            }

            public Builder setAccountOpener(Boolean accountOpener) {
                this.accountOpener = accountOpener;
                return this;
            }

            public Builder setDirector(Boolean director) {
                this.director = director;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setOwner(Boolean owner) {
                this.owner = owner;
                return this;
            }
        }
    }

    public static class Builder {
        private String endingBefore;
        private List<String> expand;
        private Map<String, Object> extraParams;
        private Long limit;
        private Relationship relationship;
        private String startingAfter;

        public AccountPersonsParams build() {
            return new AccountPersonsParams(this.endingBefore, this.expand, this.extraParams, this.limit, this.relationship, this.startingAfter);
        }

        public Builder setEndingBefore(String endingBefore) {
            this.endingBefore = endingBefore;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.put(key, value);
            return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.putAll(map);
            return this;
        }

        public Builder setLimit(Long limit) {
            this.limit = limit;
            return this;
        }

        public Builder setRelationship(Relationship relationship) {
            this.relationship = relationship;
            return this;
        }

        public Builder setStartingAfter(String startingAfter) {
            this.startingAfter = startingAfter;
            return this;
        }
    }
}

