/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PaymentMethodAttachParams
extends ApiRequestParams {
    @SerializedName(value="customer")
    String customer;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="_stripe_java_extra_param_key")
    Map<String, Object> extraParams;

    private PaymentMethodAttachParams(String customer, List<String> expand, Map<String, Object> extraParams) {
        this.customer = customer;
        this.expand = expand;
        this.extraParams = extraParams;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String customer;
        private List<String> expand;
        private Map<String, Object> extraParams;

        public PaymentMethodAttachParams build() {
            return new PaymentMethodAttachParams(this.customer, this.expand, this.extraParams);
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.put(key, value);
            return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.putAll(map);
            return this;
        }
    }
}

