/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InvoicePayParams
extends ApiRequestParams {
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="_stripe_java_extra_param_key")
    Map<String, Object> extraParams;
    @SerializedName(value="forgive")
    Boolean forgive;
    @SerializedName(value="off_session")
    Boolean offSession;
    @SerializedName(value="paid_out_of_band")
    Boolean paidOutOfBand;
    @SerializedName(value="payment_method")
    String paymentMethod;
    @SerializedName(value="source")
    String source;

    private InvoicePayParams(List<String> expand, Map<String, Object> extraParams, Boolean forgive, Boolean offSession, Boolean paidOutOfBand, String paymentMethod, String source) {
        this.expand = expand;
        this.extraParams = extraParams;
        this.forgive = forgive;
        this.offSession = offSession;
        this.paidOutOfBand = paidOutOfBand;
        this.paymentMethod = paymentMethod;
        this.source = source;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<String> expand;
        private Map<String, Object> extraParams;
        private Boolean forgive;
        private Boolean offSession;
        private Boolean paidOutOfBand;
        private String paymentMethod;
        private String source;

        public InvoicePayParams build() {
            return new InvoicePayParams(this.expand, this.extraParams, this.forgive, this.offSession, this.paidOutOfBand, this.paymentMethod, this.source);
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.put(key, value);
            return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.putAll(map);
            return this;
        }

        public Builder setForgive(Boolean forgive) {
            this.forgive = forgive;
            return this;
        }

        public Builder setOffSession(Boolean offSession) {
            this.offSession = offSession;
            return this;
        }

        public Builder setPaidOutOfBand(Boolean paidOutOfBand) {
            this.paidOutOfBand = paidOutOfBand;
            return this;
        }

        public Builder setPaymentMethod(String paymentMethod) {
            this.paymentMethod = paymentMethod;
            return this;
        }

        public Builder setSource(String source) {
            this.source = source;
            return this;
        }
    }
}

