// Generated by delombok at Wed Aug 14 11:06:48 PDT 2019
// Generated by com.stripe.generator.entity.SdkBuilder
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.SubscriptionCancelParams;
import com.stripe.param.SubscriptionCreateParams;
import com.stripe.param.SubscriptionListParams;
import com.stripe.param.SubscriptionRetrieveParams;
import com.stripe.param.SubscriptionUpdateParams;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public class Subscription extends ApiResource implements HasId, MetadataStore<Subscription> {
  /**
   * A non-negative decimal between 0 and 100, with at most two decimal places. This represents the
   * percentage of the subscription invoice subtotal that will be transferred to the application
   * owner's Stripe account.
   */
  @SerializedName("application_fee_percent")
  BigDecimal applicationFeePercent;
  /**
   * This field has been renamed to `collection_method` and will be removed in a future API version.
   */
  @SerializedName("billing")
  String billing;
  /**
   * Determines the date of the first full invoice, and, for plans with `month` or `year` intervals,
   * the day of the month for subsequent invoices.
   */
  @SerializedName("billing_cycle_anchor")
  Long billingCycleAnchor;
  /**
   * Define thresholds at which an invoice will be sent, and the subscription advanced to a new
   * billing period.
   */
  @SerializedName("billing_thresholds")
  BillingThresholds billingThresholds;
  /**
   * A date in the future at which the subscription will automatically get canceled.
   */
  @SerializedName("cancel_at")
  Long cancelAt;
  /**
   * If the subscription has been canceled with the `at_period_end` flag set to `true`,
   * `cancel_at_period_end` on the subscription will be true. You can use this attribute to
   * determine whether a subscription that has a status of active is scheduled to be canceled at the
   * end of the current period.
   */
  @SerializedName("cancel_at_period_end")
  Boolean cancelAtPeriodEnd;
  /**
   * If the subscription has been canceled, the date of that cancellation. If the subscription was
   * canceled with `cancel_at_period_end`, `canceled_at` will still reflect the date of the initial
   * cancellation request, not the end of the subscription period when the subscription is
   * automatically moved to a canceled state.
   */
  @SerializedName("canceled_at")
  Long canceledAt;
  /**
   * Either `charge_automatically`, or `send_invoice`. When charging automatically, Stripe will
   * attempt to pay this subscription at the end of the cycle using the default source attached to
   * the customer. When sending an invoice, Stripe will email your customer an invoice with payment
   * instructions.
   */
  @SerializedName("collection_method")
  String collectionMethod;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * End of the current period that the subscription has been invoiced for. At the end of this
   * period, a new invoice will be created.
   */
  @SerializedName("current_period_end")
  Long currentPeriodEnd;
  /**
   * Start of the current period that the subscription has been invoiced for.
   */
  @SerializedName("current_period_start")
  Long currentPeriodStart;
  /**
   * ID of the customer who owns the subscription.
   */
  @SerializedName("customer")
  ExpandableField<Customer> customer;
  /**
   * Number of days a customer has to pay invoices generated by this subscription. This value will
   * be `null` for subscriptions where `collection_method=charge_automatically`.
   */
  @SerializedName("days_until_due")
  Long daysUntilDue;
  /**
   * ID of the default payment method for the subscription. It must belong to the customer
   * associated with the subscription. If not set, invoices will use the default payment method in
   * the customer's invoice settings.
   */
  @SerializedName("default_payment_method")
  ExpandableField<PaymentMethod> defaultPaymentMethod;
  /**
   * ID of the default payment source for the subscription. It must belong to the customer
   * associated with the subscription and be in a chargeable state. If not set, defaults to the
   * customer's default source.
   */
  @SerializedName("default_source")
  ExpandableField<PaymentSource> defaultSource;
  /**
   * The tax rates that will apply to any subscription item that does not have `tax_rates` set.
   * Invoices created will have their `default_tax_rates` populated from the subscription.
   */
  @SerializedName("default_tax_rates")
  List<TaxRate> defaultTaxRates;
  /**
   * Describes the current discount applied to this subscription, if there is one. When billing, a
   * discount applied to a subscription overrides a discount applied on a customer-wide basis.
   */
  @SerializedName("discount")
  Discount discount;
  /**
   * If the subscription has ended, the date the subscription ended.
   */
  @SerializedName("ended_at")
  Long endedAt;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * List of subscription items, each with an attached plan.
   */
  @SerializedName("items")
  SubscriptionItemCollection items;
  /**
   * The most recent invoice this subscription has generated.
   */
  @SerializedName("latest_invoice")
  ExpandableField<Invoice> latestInvoice;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object
   * exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  @SerializedName("object")
  String object;
  /**
   * You can use this [SetupIntent](https://stripe.com/docs/api/setup_intents) to collect user
   * authentication when creating a subscription without immediate payment or updating a
   * subscription's payment method, allowing you to optimize for off-session payments. Learn more in
   * the [SCA Migration
   * Guide](https://stripe.com/docs/billing/migration/strong-customer-authentication#scenario-2).
   */
  @SerializedName("pending_setup_intent")
  ExpandableField<SetupIntent> pendingSetupIntent;
  /**
   * Hash describing the plan the customer is subscribed to. Only set if the subscription contains a
   * single plan.
   */
  @SerializedName("plan")
  Plan plan;
  /**
   * The quantity of the plan to which the customer is subscribed. For example, if your plan is
   * $10/user/month, and your customer has 5 users, you could pass 5 as the quantity to have the
   * customer charged $50 (5 x $10) monthly. Only set if the subscription contains a single plan.
   */
  @SerializedName("quantity")
  Long quantity;
  /**
   * Date of the last substantial change to this subscription. For example, a change to the items
   * array, or a change of status, will reset this timestamp.
   */
  @SerializedName("start")
  Long start;
  /**
   * Date when the subscription was first created. The date might differ from the `created` date due
   * to backdating.
   */
  @SerializedName("start_date")
  Long startDate;
  /**
   * Possible values are `incomplete`, `incomplete_expired`, `trialing`, `active`, `past_due`,
   * `canceled`, or `unpaid`.
   *
   * <p>For `collection_method=charge_automatically` a subscription moves into `incomplete` if the
   * initial payment attempt fails. A subscription in this state can only have metadata and
   * default_source updated. Once the first invoice is paid, the subscription moves into an `active`
   * state. If the first invoice is not paid within 23 hours, the subscription transitions to
   * `incomplete_expired`. This is a terminal state, the open invoice will be voided and no further
   * invoices will be generated.
   *
   * <p>A subscription that is currently in a trial period is `trialing` and moves to `active` when
   * the trial period is over.
   *
   * <p>If subscription `collection_method=charge_automatically` it becomes `past_due` when payment
   * to renew it fails and `canceled` or `unpaid` (depending on your subscriptions settings) when
   * Stripe has exhausted all payment retry attempts.
   *
   * <p>If subscription `collection_method=send_invoice` it becomes `past_due` when its invoice is
   * not paid by the due date, and `canceled` or `unpaid` if it is still not paid by an additional
   * deadline after that. Note that when a subscription has a status of `unpaid`, no subsequent
   * invoices will be attempted (invoices will be created, but then immediately automatically
   * closed). After receiving updated payment information from a customer, you may choose to reopen
   * and pay their closed invoices.
   */
  @SerializedName("status")
  String status;
  /**
   * If provided, each invoice created by this subscription will apply the tax rate, increasing the
   * amount billed to the customer.
   */
  @SerializedName("tax_percent")
  BigDecimal taxPercent;
  /**
   * If specified, the funds from the subscription's invoices will be transferred to the destination
   * and the ID of the resulting transfers will be found on the resulting charges.
   */
  @SerializedName("transfer_data")
  Invoice.TransferData transferData;
  /**
   * If the subscription has a trial, the end of that trial.
   */
  @SerializedName("trial_end")
  Long trialEnd;
  /**
   * If the subscription has a trial, the beginning of that trial.
   */
  @SerializedName("trial_start")
  Long trialStart;

  /**
   * Get id of expandable `customer` object.
   */
  public String getCustomer() {
    return (this.customer != null) ? this.customer.getId() : null;
  }

  public void setCustomer(String id) {
    this.customer = ApiResource.setExpandableFieldId(id, this.customer);
  }

  /**
   * Get expanded `customer`.
   */
  public Customer getCustomerObject() {
    return (this.customer != null) ? this.customer.getExpanded() : null;
  }

  public void setCustomerObject(Customer expandableObject) {
    this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get id of expandable `defaultPaymentMethod` object.
   */
  public String getDefaultPaymentMethod() {
    return (this.defaultPaymentMethod != null) ? this.defaultPaymentMethod.getId() : null;
  }

  public void setDefaultPaymentMethod(String id) {
    this.defaultPaymentMethod = ApiResource.setExpandableFieldId(id, this.defaultPaymentMethod);
  }

  /**
   * Get expanded `defaultPaymentMethod`.
   */
  public PaymentMethod getDefaultPaymentMethodObject() {
    return (this.defaultPaymentMethod != null) ? this.defaultPaymentMethod.getExpanded() : null;
  }

  public void setDefaultPaymentMethodObject(PaymentMethod expandableObject) {
    this.defaultPaymentMethod = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get id of expandable `defaultSource` object.
   */
  public String getDefaultSource() {
    return (this.defaultSource != null) ? this.defaultSource.getId() : null;
  }

  public void setDefaultSource(String id) {
    this.defaultSource = ApiResource.setExpandableFieldId(id, this.defaultSource);
  }

  /**
   * Get expanded `defaultSource`.
   */
  public PaymentSource getDefaultSourceObject() {
    return (this.defaultSource != null) ? this.defaultSource.getExpanded() : null;
  }

  public void setDefaultSourceObject(PaymentSource expandableObject) {
    this.defaultSource = new ExpandableField<PaymentSource>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get id of expandable `latestInvoice` object.
   */
  public String getLatestInvoice() {
    return (this.latestInvoice != null) ? this.latestInvoice.getId() : null;
  }

  public void setLatestInvoice(String id) {
    this.latestInvoice = ApiResource.setExpandableFieldId(id, this.latestInvoice);
  }

  /**
   * Get expanded `latestInvoice`.
   */
  public Invoice getLatestInvoiceObject() {
    return (this.latestInvoice != null) ? this.latestInvoice.getExpanded() : null;
  }

  public void setLatestInvoiceObject(Invoice expandableObject) {
    this.latestInvoice = new ExpandableField<Invoice>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get id of expandable `pendingSetupIntent` object.
   */
  public String getPendingSetupIntent() {
    return (this.pendingSetupIntent != null) ? this.pendingSetupIntent.getId() : null;
  }

  public void setPendingSetupIntent(String id) {
    this.pendingSetupIntent = ApiResource.setExpandableFieldId(id, this.pendingSetupIntent);
  }

  /**
   * Get expanded `pendingSetupIntent`.
   */
  public SetupIntent getPendingSetupIntentObject() {
    return (this.pendingSetupIntent != null) ? this.pendingSetupIntent.getExpanded() : null;
  }

  public void setPendingSetupIntentObject(SetupIntent expandableObject) {
    this.pendingSetupIntent = new ExpandableField<SetupIntent>(expandableObject.getId(), expandableObject);
  }

  /**
   * By default, returns a list of subscriptions that have not been canceled. In order to list
   * canceled subscriptions, specify <code>status=canceled</code>.
   */
  public static SubscriptionCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * By default, returns a list of subscriptions that have not been canceled. In order to list
   * canceled subscriptions, specify <code>status=canceled</code>.
   */
  public static SubscriptionCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/subscriptions");
    return requestCollection(url, params, SubscriptionCollection.class, options);
  }

  /**
   * By default, returns a list of subscriptions that have not been canceled. In order to list
   * canceled subscriptions, specify <code>status=canceled</code>.
   */
  public static SubscriptionCollection list(SubscriptionListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * By default, returns a list of subscriptions that have not been canceled. In order to list
   * canceled subscriptions, specify <code>status=canceled</code>.
   */
  public static SubscriptionCollection list(SubscriptionListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/subscriptions");
    return requestCollection(url, params, SubscriptionCollection.class, options);
  }

  /**
   * Creates a new subscription on an existing customer.
   */
  public static Subscription create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a new subscription on an existing customer.
   */
  public static Subscription create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/subscriptions");
    return request(ApiResource.RequestMethod.POST, url, params, Subscription.class, options);
  }

  /**
   * Creates a new subscription on an existing customer.
   */
  public static Subscription create(SubscriptionCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a new subscription on an existing customer.
   */
  public static Subscription create(SubscriptionCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/subscriptions");
    return request(ApiResource.RequestMethod.POST, url, params, Subscription.class, options);
  }

  /**
   * Updates an existing subscription on a customer to match the specified parameters. When changing
   * plans or quantities, we will optionally prorate the price we charge next month to make up for
   * any price changes. To preview how the proration will be calculated, use the <a
   * href="#upcoming_invoice">upcoming invoice</a> endpoint.
   */
  @Override
  public Subscription update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates an existing subscription on a customer to match the specified parameters. When changing
   * plans or quantities, we will optionally prorate the price we charge next month to make up for
   * any price changes. To preview how the proration will be calculated, use the <a
   * href="#upcoming_invoice">upcoming invoice</a> endpoint.
   */
  @Override
  public Subscription update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscriptions/%s", ApiResource.urlEncodeId(this.getId())));
    return request(ApiResource.RequestMethod.POST, url, params, Subscription.class, options);
  }

  /**
   * Updates an existing subscription on a customer to match the specified parameters. When changing
   * plans or quantities, we will optionally prorate the price we charge next month to make up for
   * any price changes. To preview how the proration will be calculated, use the <a
   * href="#upcoming_invoice">upcoming invoice</a> endpoint.
   */
  public Subscription update(SubscriptionUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates an existing subscription on a customer to match the specified parameters. When changing
   * plans or quantities, we will optionally prorate the price we charge next month to make up for
   * any price changes. To preview how the proration will be calculated, use the <a
   * href="#upcoming_invoice">upcoming invoice</a> endpoint.
   */
  public Subscription update(SubscriptionUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscriptions/%s", ApiResource.urlEncodeId(this.getId())));
    return request(ApiResource.RequestMethod.POST, url, params, Subscription.class, options);
  }

  /**
   * Retrieves the subscription with the given ID.
   */
  public static Subscription retrieve(String subscriptionExposedId) throws StripeException {
    return retrieve(subscriptionExposedId, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the subscription with the given ID.
   */
  public static Subscription retrieve(String subscriptionExposedId, RequestOptions options) throws StripeException {
    return retrieve(subscriptionExposedId, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the subscription with the given ID.
   */
  public static Subscription retrieve(String subscriptionExposedId, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscriptions/%s", ApiResource.urlEncodeId(subscriptionExposedId)));
    return request(ApiResource.RequestMethod.GET, url, params, Subscription.class, options);
  }

  /**
   * Retrieves the subscription with the given ID.
   */
  public static Subscription retrieve(String subscriptionExposedId, SubscriptionRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscriptions/%s", ApiResource.urlEncodeId(subscriptionExposedId)));
    return request(ApiResource.RequestMethod.GET, url, params, Subscription.class, options);
  }

  /**
   * Cancels a customer’s subscription immediately. The customer will not be charged again for the
   * subscription.
   *
   * <p>Note, however, that any pending invoice items that you’ve created will still be charged for
   * at the end of the period, unless manually <a href="#delete_invoiceitem">deleted</a>. If you’ve
   * set the subscription to cancel at the end of the period, any pending prorations will also be
   * left in place and collected at the end of the period. But if the subscription is set to cancel
   * immediately, pending prorations will be removed.
   *
   * <p>By default, upon subscription cancellation, Stripe will stop automatic collection of all
   * finalized invoices for the customer. This is intended to prevent unexpected payment attempts
   * after the customer has canceled a subscription. However, you can resume automatic collection of
   * the invoices manually after subscription cancellation to have us proceed. Or, you could check
   * for unpaid invoices before allowing the customer to cancel the subscription at all.
   */
  public Subscription cancel() throws StripeException {
    return cancel((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Cancels a customer’s subscription immediately. The customer will not be charged again for the
   * subscription.
   *
   * <p>Note, however, that any pending invoice items that you’ve created will still be charged for
   * at the end of the period, unless manually <a href="#delete_invoiceitem">deleted</a>. If you’ve
   * set the subscription to cancel at the end of the period, any pending prorations will also be
   * left in place and collected at the end of the period. But if the subscription is set to cancel
   * immediately, pending prorations will be removed.
   *
   * <p>By default, upon subscription cancellation, Stripe will stop automatic collection of all
   * finalized invoices for the customer. This is intended to prevent unexpected payment attempts
   * after the customer has canceled a subscription. However, you can resume automatic collection of
   * the invoices manually after subscription cancellation to have us proceed. Or, you could check
   * for unpaid invoices before allowing the customer to cancel the subscription at all.
   */
  public Subscription cancel(Map<String, Object> params) throws StripeException {
    return cancel(params, (RequestOptions) null);
  }

  /**
   * Cancels a customer’s subscription immediately. The customer will not be charged again for the
   * subscription.
   *
   * <p>Note, however, that any pending invoice items that you’ve created will still be charged for
   * at the end of the period, unless manually <a href="#delete_invoiceitem">deleted</a>. If you’ve
   * set the subscription to cancel at the end of the period, any pending prorations will also be
   * left in place and collected at the end of the period. But if the subscription is set to cancel
   * immediately, pending prorations will be removed.
   *
   * <p>By default, upon subscription cancellation, Stripe will stop automatic collection of all
   * finalized invoices for the customer. This is intended to prevent unexpected payment attempts
   * after the customer has canceled a subscription. However, you can resume automatic collection of
   * the invoices manually after subscription cancellation to have us proceed. Or, you could check
   * for unpaid invoices before allowing the customer to cancel the subscription at all.
   */
  public Subscription cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscriptions/%s", ApiResource.urlEncodeId(this.getId())));
    return request(ApiResource.RequestMethod.DELETE, url, params, Subscription.class, options);
  }

  /**
   * Cancels a customer’s subscription immediately. The customer will not be charged again for the
   * subscription.
   *
   * <p>Note, however, that any pending invoice items that you’ve created will still be charged for
   * at the end of the period, unless manually <a href="#delete_invoiceitem">deleted</a>. If you’ve
   * set the subscription to cancel at the end of the period, any pending prorations will also be
   * left in place and collected at the end of the period. But if the subscription is set to cancel
   * immediately, pending prorations will be removed.
   *
   * <p>By default, upon subscription cancellation, Stripe will stop automatic collection of all
   * finalized invoices for the customer. This is intended to prevent unexpected payment attempts
   * after the customer has canceled a subscription. However, you can resume automatic collection of
   * the invoices manually after subscription cancellation to have us proceed. Or, you could check
   * for unpaid invoices before allowing the customer to cancel the subscription at all.
   */
  public Subscription cancel(SubscriptionCancelParams params) throws StripeException {
    return cancel(params, (RequestOptions) null);
  }

  /**
   * Cancels a customer’s subscription immediately. The customer will not be charged again for the
   * subscription.
   *
   * <p>Note, however, that any pending invoice items that you’ve created will still be charged for
   * at the end of the period, unless manually <a href="#delete_invoiceitem">deleted</a>. If you’ve
   * set the subscription to cancel at the end of the period, any pending prorations will also be
   * left in place and collected at the end of the period. But if the subscription is set to cancel
   * immediately, pending prorations will be removed.
   *
   * <p>By default, upon subscription cancellation, Stripe will stop automatic collection of all
   * finalized invoices for the customer. This is intended to prevent unexpected payment attempts
   * after the customer has canceled a subscription. However, you can resume automatic collection of
   * the invoices manually after subscription cancellation to have us proceed. Or, you could check
   * for unpaid invoices before allowing the customer to cancel the subscription at all.
   */
  public Subscription cancel(SubscriptionCancelParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscriptions/%s", ApiResource.urlEncodeId(this.getId())));
    return request(ApiResource.RequestMethod.DELETE, url, params, Subscription.class, options);
  }

  /**
   * Removes the currently applied discount on a subscription.
   */
  public Discount deleteDiscount() throws StripeException {
    return deleteDiscount((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Removes the currently applied discount on a subscription.
   */
  public Discount deleteDiscount(Map<String, Object> params) throws StripeException {
    return deleteDiscount(params, (RequestOptions) null);
  }

  /**
   * Removes the currently applied discount on a subscription.
   */
  public Discount deleteDiscount(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscriptions/%s/discount", ApiResource.urlEncodeId(this.getId())));
    return request(ApiResource.RequestMethod.DELETE, url, params, Discount.class, options);
  }


  public static class BillingThresholds extends StripeObject {
    /** Monetary threshold that triggers the subscription to create an invoice. */
    @SerializedName("amount_gte")
    Long amountGte;
    /**
     * Indicates if the `billing_cycle_anchor` should be reset when a threshold is reached. If true,
     * `billing_cycle_anchor` will be updated to the date/time the threshold was last reached;
     * otherwise, the value will remain unchanged. This value may not be `true` if the subscription
     * contains items with plans that have `aggregate_usage=last_ever`.
     */
    @SerializedName("reset_billing_cycle_anchor")
    Boolean resetBillingCycleAnchor;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmountGte() {
      return this.amountGte;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getResetBillingCycleAnchor() {
      return this.resetBillingCycleAnchor;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmountGte(final Long amountGte) {
      this.amountGte = amountGte;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setResetBillingCycleAnchor(final Boolean resetBillingCycleAnchor) {
      this.resetBillingCycleAnchor = resetBillingCycleAnchor;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Subscription.BillingThresholds)) return false;
      final Subscription.BillingThresholds other = (Subscription.BillingThresholds) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$amountGte = this.getAmountGte();
      final java.lang.Object other$amountGte = other.getAmountGte();
      if (this$amountGte == null ? other$amountGte != null : !this$amountGte.equals(other$amountGte)) return false;
      final java.lang.Object this$resetBillingCycleAnchor = this.getResetBillingCycleAnchor();
      final java.lang.Object other$resetBillingCycleAnchor = other.getResetBillingCycleAnchor();
      if (this$resetBillingCycleAnchor == null ? other$resetBillingCycleAnchor != null : !this$resetBillingCycleAnchor.equals(other$resetBillingCycleAnchor)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Subscription.BillingThresholds;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $amountGte = this.getAmountGte();
      result = result * PRIME + ($amountGte == null ? 43 : $amountGte.hashCode());
      final java.lang.Object $resetBillingCycleAnchor = this.getResetBillingCycleAnchor();
      result = result * PRIME + ($resetBillingCycleAnchor == null ? 43 : $resetBillingCycleAnchor.hashCode());
      return result;
    }
  }

  /**
   * A non-negative decimal between 0 and 100, with at most two decimal places. This represents the
   * percentage of the subscription invoice subtotal that will be transferred to the application
   * owner's Stripe account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getApplicationFeePercent() {
    return this.applicationFeePercent;
  }

  /**
   * This field has been renamed to `collection_method` and will be removed in a future API version.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getBilling() {
    return this.billing;
  }

  /**
   * Determines the date of the first full invoice, and, for plans with `month` or `year` intervals,
   * the day of the month for subsequent invoices.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getBillingCycleAnchor() {
    return this.billingCycleAnchor;
  }

  /**
   * Define thresholds at which an invoice will be sent, and the subscription advanced to a new
   * billing period.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BillingThresholds getBillingThresholds() {
    return this.billingThresholds;
  }

  /**
   * A date in the future at which the subscription will automatically get canceled.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCancelAt() {
    return this.cancelAt;
  }

  /**
   * If the subscription has been canceled with the `at_period_end` flag set to `true`,
   * `cancel_at_period_end` on the subscription will be true. You can use this attribute to
   * determine whether a subscription that has a status of active is scheduled to be canceled at the
   * end of the current period.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getCancelAtPeriodEnd() {
    return this.cancelAtPeriodEnd;
  }

  /**
   * If the subscription has been canceled, the date of that cancellation. If the subscription was
   * canceled with `cancel_at_period_end`, `canceled_at` will still reflect the date of the initial
   * cancellation request, not the end of the subscription period when the subscription is
   * automatically moved to a canceled state.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCanceledAt() {
    return this.canceledAt;
  }

  /**
   * Either `charge_automatically`, or `send_invoice`. When charging automatically, Stripe will
   * attempt to pay this subscription at the end of the cycle using the default source attached to
   * the customer. When sending an invoice, Stripe will email your customer an invoice with payment
   * instructions.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCollectionMethod() {
    return this.collectionMethod;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * End of the current period that the subscription has been invoiced for. At the end of this
   * period, a new invoice will be created.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCurrentPeriodEnd() {
    return this.currentPeriodEnd;
  }

  /**
   * Start of the current period that the subscription has been invoiced for.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCurrentPeriodStart() {
    return this.currentPeriodStart;
  }

  /**
   * Number of days a customer has to pay invoices generated by this subscription. This value will
   * be `null` for subscriptions where `collection_method=charge_automatically`.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getDaysUntilDue() {
    return this.daysUntilDue;
  }

  /**
   * The tax rates that will apply to any subscription item that does not have `tax_rates` set.
   * Invoices created will have their `default_tax_rates` populated from the subscription.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<TaxRate> getDefaultTaxRates() {
    return this.defaultTaxRates;
  }

  /**
   * Describes the current discount applied to this subscription, if there is one. When billing, a
   * discount applied to a subscription overrides a discount applied on a customer-wide basis.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Discount getDiscount() {
    return this.discount;
  }

  /**
   * If the subscription has ended, the date the subscription ended.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getEndedAt() {
    return this.endedAt;
  }

  /**
   * List of subscription items, each with an attached plan.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public SubscriptionItemCollection getItems() {
    return this.items;
  }

  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object
   * exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * Hash describing the plan the customer is subscribed to. Only set if the subscription contains a
   * single plan.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Plan getPlan() {
    return this.plan;
  }

  /**
   * The quantity of the plan to which the customer is subscribed. For example, if your plan is
   * $10/user/month, and your customer has 5 users, you could pass 5 as the quantity to have the
   * customer charged $50 (5 x $10) monthly. Only set if the subscription contains a single plan.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getQuantity() {
    return this.quantity;
  }

  /**
   * Date of the last substantial change to this subscription. For example, a change to the items
   * array, or a change of status, will reset this timestamp.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getStart() {
    return this.start;
  }

  /**
   * Date when the subscription was first created. The date might differ from the `created` date due
   * to backdating.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getStartDate() {
    return this.startDate;
  }

  /**
   * Possible values are `incomplete`, `incomplete_expired`, `trialing`, `active`, `past_due`,
   * `canceled`, or `unpaid`.
   *
   * <p>For `collection_method=charge_automatically` a subscription moves into `incomplete` if the
   * initial payment attempt fails. A subscription in this state can only have metadata and
   * default_source updated. Once the first invoice is paid, the subscription moves into an `active`
   * state. If the first invoice is not paid within 23 hours, the subscription transitions to
   * `incomplete_expired`. This is a terminal state, the open invoice will be voided and no further
   * invoices will be generated.
   *
   * <p>A subscription that is currently in a trial period is `trialing` and moves to `active` when
   * the trial period is over.
   *
   * <p>If subscription `collection_method=charge_automatically` it becomes `past_due` when payment
   * to renew it fails and `canceled` or `unpaid` (depending on your subscriptions settings) when
   * Stripe has exhausted all payment retry attempts.
   *
   * <p>If subscription `collection_method=send_invoice` it becomes `past_due` when its invoice is
   * not paid by the due date, and `canceled` or `unpaid` if it is still not paid by an additional
   * deadline after that. Note that when a subscription has a status of `unpaid`, no subsequent
   * invoices will be attempted (invoices will be created, but then immediately automatically
   * closed). After receiving updated payment information from a customer, you may choose to reopen
   * and pay their closed invoices.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  /**
   * If provided, each invoice created by this subscription will apply the tax rate, increasing the
   * amount billed to the customer.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTaxPercent() {
    return this.taxPercent;
  }

  /**
   * If specified, the funds from the subscription's invoices will be transferred to the destination
   * and the ID of the resulting transfers will be found on the resulting charges.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Invoice.TransferData getTransferData() {
    return this.transferData;
  }

  /**
   * If the subscription has a trial, the end of that trial.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getTrialEnd() {
    return this.trialEnd;
  }

  /**
   * If the subscription has a trial, the beginning of that trial.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getTrialStart() {
    return this.trialStart;
  }

  /**
   * A non-negative decimal between 0 and 100, with at most two decimal places. This represents the
   * percentage of the subscription invoice subtotal that will be transferred to the application
   * owner's Stripe account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setApplicationFeePercent(final BigDecimal applicationFeePercent) {
    this.applicationFeePercent = applicationFeePercent;
  }

  /**
   * This field has been renamed to `collection_method` and will be removed in a future API version.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBilling(final String billing) {
    this.billing = billing;
  }

  /**
   * Determines the date of the first full invoice, and, for plans with `month` or `year` intervals,
   * the day of the month for subsequent invoices.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBillingCycleAnchor(final Long billingCycleAnchor) {
    this.billingCycleAnchor = billingCycleAnchor;
  }

  /**
   * Define thresholds at which an invoice will be sent, and the subscription advanced to a new
   * billing period.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBillingThresholds(final BillingThresholds billingThresholds) {
    this.billingThresholds = billingThresholds;
  }

  /**
   * A date in the future at which the subscription will automatically get canceled.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCancelAt(final Long cancelAt) {
    this.cancelAt = cancelAt;
  }

  /**
   * If the subscription has been canceled with the `at_period_end` flag set to `true`,
   * `cancel_at_period_end` on the subscription will be true. You can use this attribute to
   * determine whether a subscription that has a status of active is scheduled to be canceled at the
   * end of the current period.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCancelAtPeriodEnd(final Boolean cancelAtPeriodEnd) {
    this.cancelAtPeriodEnd = cancelAtPeriodEnd;
  }

  /**
   * If the subscription has been canceled, the date of that cancellation. If the subscription was
   * canceled with `cancel_at_period_end`, `canceled_at` will still reflect the date of the initial
   * cancellation request, not the end of the subscription period when the subscription is
   * automatically moved to a canceled state.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCanceledAt(final Long canceledAt) {
    this.canceledAt = canceledAt;
  }

  /**
   * Either `charge_automatically`, or `send_invoice`. When charging automatically, Stripe will
   * attempt to pay this subscription at the end of the cycle using the default source attached to
   * the customer. When sending an invoice, Stripe will email your customer an invoice with payment
   * instructions.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCollectionMethod(final String collectionMethod) {
    this.collectionMethod = collectionMethod;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * End of the current period that the subscription has been invoiced for. At the end of this
   * period, a new invoice will be created.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrentPeriodEnd(final Long currentPeriodEnd) {
    this.currentPeriodEnd = currentPeriodEnd;
  }

  /**
   * Start of the current period that the subscription has been invoiced for.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrentPeriodStart(final Long currentPeriodStart) {
    this.currentPeriodStart = currentPeriodStart;
  }

  /**
   * Number of days a customer has to pay invoices generated by this subscription. This value will
   * be `null` for subscriptions where `collection_method=charge_automatically`.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDaysUntilDue(final Long daysUntilDue) {
    this.daysUntilDue = daysUntilDue;
  }

  /**
   * The tax rates that will apply to any subscription item that does not have `tax_rates` set.
   * Invoices created will have their `default_tax_rates` populated from the subscription.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDefaultTaxRates(final List<TaxRate> defaultTaxRates) {
    this.defaultTaxRates = defaultTaxRates;
  }

  /**
   * Describes the current discount applied to this subscription, if there is one. When billing, a
   * discount applied to a subscription overrides a discount applied on a customer-wide basis.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDiscount(final Discount discount) {
    this.discount = discount;
  }

  /**
   * If the subscription has ended, the date the subscription ended.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEndedAt(final Long endedAt) {
    this.endedAt = endedAt;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * List of subscription items, each with an attached plan.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setItems(final SubscriptionItemCollection items) {
    this.items = items;
  }

  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object
   * exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * Hash describing the plan the customer is subscribed to. Only set if the subscription contains a
   * single plan.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPlan(final Plan plan) {
    this.plan = plan;
  }

  /**
   * The quantity of the plan to which the customer is subscribed. For example, if your plan is
   * $10/user/month, and your customer has 5 users, you could pass 5 as the quantity to have the
   * customer charged $50 (5 x $10) monthly. Only set if the subscription contains a single plan.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setQuantity(final Long quantity) {
    this.quantity = quantity;
  }

  /**
   * Date of the last substantial change to this subscription. For example, a change to the items
   * array, or a change of status, will reset this timestamp.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStart(final Long start) {
    this.start = start;
  }

  /**
   * Date when the subscription was first created. The date might differ from the `created` date due
   * to backdating.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStartDate(final Long startDate) {
    this.startDate = startDate;
  }

  /**
   * Possible values are `incomplete`, `incomplete_expired`, `trialing`, `active`, `past_due`,
   * `canceled`, or `unpaid`.
   *
   * <p>For `collection_method=charge_automatically` a subscription moves into `incomplete` if the
   * initial payment attempt fails. A subscription in this state can only have metadata and
   * default_source updated. Once the first invoice is paid, the subscription moves into an `active`
   * state. If the first invoice is not paid within 23 hours, the subscription transitions to
   * `incomplete_expired`. This is a terminal state, the open invoice will be voided and no further
   * invoices will be generated.
   *
   * <p>A subscription that is currently in a trial period is `trialing` and moves to `active` when
   * the trial period is over.
   *
   * <p>If subscription `collection_method=charge_automatically` it becomes `past_due` when payment
   * to renew it fails and `canceled` or `unpaid` (depending on your subscriptions settings) when
   * Stripe has exhausted all payment retry attempts.
   *
   * <p>If subscription `collection_method=send_invoice` it becomes `past_due` when its invoice is
   * not paid by the due date, and `canceled` or `unpaid` if it is still not paid by an additional
   * deadline after that. Note that when a subscription has a status of `unpaid`, no subsequent
   * invoices will be attempted (invoices will be created, but then immediately automatically
   * closed). After receiving updated payment information from a customer, you may choose to reopen
   * and pay their closed invoices.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  /**
   * If provided, each invoice created by this subscription will apply the tax rate, increasing the
   * amount billed to the customer.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTaxPercent(final BigDecimal taxPercent) {
    this.taxPercent = taxPercent;
  }

  /**
   * If specified, the funds from the subscription's invoices will be transferred to the destination
   * and the ID of the resulting transfers will be found on the resulting charges.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTransferData(final Invoice.TransferData transferData) {
    this.transferData = transferData;
  }

  /**
   * If the subscription has a trial, the end of that trial.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTrialEnd(final Long trialEnd) {
    this.trialEnd = trialEnd;
  }

  /**
   * If the subscription has a trial, the beginning of that trial.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTrialStart(final Long trialStart) {
    this.trialStart = trialStart;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Subscription)) return false;
    final Subscription other = (Subscription) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$applicationFeePercent = this.getApplicationFeePercent();
    final java.lang.Object other$applicationFeePercent = other.getApplicationFeePercent();
    if (this$applicationFeePercent == null ? other$applicationFeePercent != null : !this$applicationFeePercent.equals(other$applicationFeePercent)) return false;
    final java.lang.Object this$billing = this.getBilling();
    final java.lang.Object other$billing = other.getBilling();
    if (this$billing == null ? other$billing != null : !this$billing.equals(other$billing)) return false;
    final java.lang.Object this$billingCycleAnchor = this.getBillingCycleAnchor();
    final java.lang.Object other$billingCycleAnchor = other.getBillingCycleAnchor();
    if (this$billingCycleAnchor == null ? other$billingCycleAnchor != null : !this$billingCycleAnchor.equals(other$billingCycleAnchor)) return false;
    final java.lang.Object this$billingThresholds = this.getBillingThresholds();
    final java.lang.Object other$billingThresholds = other.getBillingThresholds();
    if (this$billingThresholds == null ? other$billingThresholds != null : !this$billingThresholds.equals(other$billingThresholds)) return false;
    final java.lang.Object this$cancelAt = this.getCancelAt();
    final java.lang.Object other$cancelAt = other.getCancelAt();
    if (this$cancelAt == null ? other$cancelAt != null : !this$cancelAt.equals(other$cancelAt)) return false;
    final java.lang.Object this$cancelAtPeriodEnd = this.getCancelAtPeriodEnd();
    final java.lang.Object other$cancelAtPeriodEnd = other.getCancelAtPeriodEnd();
    if (this$cancelAtPeriodEnd == null ? other$cancelAtPeriodEnd != null : !this$cancelAtPeriodEnd.equals(other$cancelAtPeriodEnd)) return false;
    final java.lang.Object this$canceledAt = this.getCanceledAt();
    final java.lang.Object other$canceledAt = other.getCanceledAt();
    if (this$canceledAt == null ? other$canceledAt != null : !this$canceledAt.equals(other$canceledAt)) return false;
    final java.lang.Object this$collectionMethod = this.getCollectionMethod();
    final java.lang.Object other$collectionMethod = other.getCollectionMethod();
    if (this$collectionMethod == null ? other$collectionMethod != null : !this$collectionMethod.equals(other$collectionMethod)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$currentPeriodEnd = this.getCurrentPeriodEnd();
    final java.lang.Object other$currentPeriodEnd = other.getCurrentPeriodEnd();
    if (this$currentPeriodEnd == null ? other$currentPeriodEnd != null : !this$currentPeriodEnd.equals(other$currentPeriodEnd)) return false;
    final java.lang.Object this$currentPeriodStart = this.getCurrentPeriodStart();
    final java.lang.Object other$currentPeriodStart = other.getCurrentPeriodStart();
    if (this$currentPeriodStart == null ? other$currentPeriodStart != null : !this$currentPeriodStart.equals(other$currentPeriodStart)) return false;
    final java.lang.Object this$customer = this.getCustomer();
    final java.lang.Object other$customer = other.getCustomer();
    if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) return false;
    final java.lang.Object this$daysUntilDue = this.getDaysUntilDue();
    final java.lang.Object other$daysUntilDue = other.getDaysUntilDue();
    if (this$daysUntilDue == null ? other$daysUntilDue != null : !this$daysUntilDue.equals(other$daysUntilDue)) return false;
    final java.lang.Object this$defaultPaymentMethod = this.getDefaultPaymentMethod();
    final java.lang.Object other$defaultPaymentMethod = other.getDefaultPaymentMethod();
    if (this$defaultPaymentMethod == null ? other$defaultPaymentMethod != null : !this$defaultPaymentMethod.equals(other$defaultPaymentMethod)) return false;
    final java.lang.Object this$defaultSource = this.getDefaultSource();
    final java.lang.Object other$defaultSource = other.getDefaultSource();
    if (this$defaultSource == null ? other$defaultSource != null : !this$defaultSource.equals(other$defaultSource)) return false;
    final java.lang.Object this$defaultTaxRates = this.getDefaultTaxRates();
    final java.lang.Object other$defaultTaxRates = other.getDefaultTaxRates();
    if (this$defaultTaxRates == null ? other$defaultTaxRates != null : !this$defaultTaxRates.equals(other$defaultTaxRates)) return false;
    final java.lang.Object this$discount = this.getDiscount();
    final java.lang.Object other$discount = other.getDiscount();
    if (this$discount == null ? other$discount != null : !this$discount.equals(other$discount)) return false;
    final java.lang.Object this$endedAt = this.getEndedAt();
    final java.lang.Object other$endedAt = other.getEndedAt();
    if (this$endedAt == null ? other$endedAt != null : !this$endedAt.equals(other$endedAt)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$items = this.getItems();
    final java.lang.Object other$items = other.getItems();
    if (this$items == null ? other$items != null : !this$items.equals(other$items)) return false;
    final java.lang.Object this$latestInvoice = this.getLatestInvoice();
    final java.lang.Object other$latestInvoice = other.getLatestInvoice();
    if (this$latestInvoice == null ? other$latestInvoice != null : !this$latestInvoice.equals(other$latestInvoice)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$pendingSetupIntent = this.getPendingSetupIntent();
    final java.lang.Object other$pendingSetupIntent = other.getPendingSetupIntent();
    if (this$pendingSetupIntent == null ? other$pendingSetupIntent != null : !this$pendingSetupIntent.equals(other$pendingSetupIntent)) return false;
    final java.lang.Object this$plan = this.getPlan();
    final java.lang.Object other$plan = other.getPlan();
    if (this$plan == null ? other$plan != null : !this$plan.equals(other$plan)) return false;
    final java.lang.Object this$quantity = this.getQuantity();
    final java.lang.Object other$quantity = other.getQuantity();
    if (this$quantity == null ? other$quantity != null : !this$quantity.equals(other$quantity)) return false;
    final java.lang.Object this$start = this.getStart();
    final java.lang.Object other$start = other.getStart();
    if (this$start == null ? other$start != null : !this$start.equals(other$start)) return false;
    final java.lang.Object this$startDate = this.getStartDate();
    final java.lang.Object other$startDate = other.getStartDate();
    if (this$startDate == null ? other$startDate != null : !this$startDate.equals(other$startDate)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$taxPercent = this.getTaxPercent();
    final java.lang.Object other$taxPercent = other.getTaxPercent();
    if (this$taxPercent == null ? other$taxPercent != null : !this$taxPercent.equals(other$taxPercent)) return false;
    final java.lang.Object this$transferData = this.getTransferData();
    final java.lang.Object other$transferData = other.getTransferData();
    if (this$transferData == null ? other$transferData != null : !this$transferData.equals(other$transferData)) return false;
    final java.lang.Object this$trialEnd = this.getTrialEnd();
    final java.lang.Object other$trialEnd = other.getTrialEnd();
    if (this$trialEnd == null ? other$trialEnd != null : !this$trialEnd.equals(other$trialEnd)) return false;
    final java.lang.Object this$trialStart = this.getTrialStart();
    final java.lang.Object other$trialStart = other.getTrialStart();
    if (this$trialStart == null ? other$trialStart != null : !this$trialStart.equals(other$trialStart)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Subscription;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $applicationFeePercent = this.getApplicationFeePercent();
    result = result * PRIME + ($applicationFeePercent == null ? 43 : $applicationFeePercent.hashCode());
    final java.lang.Object $billing = this.getBilling();
    result = result * PRIME + ($billing == null ? 43 : $billing.hashCode());
    final java.lang.Object $billingCycleAnchor = this.getBillingCycleAnchor();
    result = result * PRIME + ($billingCycleAnchor == null ? 43 : $billingCycleAnchor.hashCode());
    final java.lang.Object $billingThresholds = this.getBillingThresholds();
    result = result * PRIME + ($billingThresholds == null ? 43 : $billingThresholds.hashCode());
    final java.lang.Object $cancelAt = this.getCancelAt();
    result = result * PRIME + ($cancelAt == null ? 43 : $cancelAt.hashCode());
    final java.lang.Object $cancelAtPeriodEnd = this.getCancelAtPeriodEnd();
    result = result * PRIME + ($cancelAtPeriodEnd == null ? 43 : $cancelAtPeriodEnd.hashCode());
    final java.lang.Object $canceledAt = this.getCanceledAt();
    result = result * PRIME + ($canceledAt == null ? 43 : $canceledAt.hashCode());
    final java.lang.Object $collectionMethod = this.getCollectionMethod();
    result = result * PRIME + ($collectionMethod == null ? 43 : $collectionMethod.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $currentPeriodEnd = this.getCurrentPeriodEnd();
    result = result * PRIME + ($currentPeriodEnd == null ? 43 : $currentPeriodEnd.hashCode());
    final java.lang.Object $currentPeriodStart = this.getCurrentPeriodStart();
    result = result * PRIME + ($currentPeriodStart == null ? 43 : $currentPeriodStart.hashCode());
    final java.lang.Object $customer = this.getCustomer();
    result = result * PRIME + ($customer == null ? 43 : $customer.hashCode());
    final java.lang.Object $daysUntilDue = this.getDaysUntilDue();
    result = result * PRIME + ($daysUntilDue == null ? 43 : $daysUntilDue.hashCode());
    final java.lang.Object $defaultPaymentMethod = this.getDefaultPaymentMethod();
    result = result * PRIME + ($defaultPaymentMethod == null ? 43 : $defaultPaymentMethod.hashCode());
    final java.lang.Object $defaultSource = this.getDefaultSource();
    result = result * PRIME + ($defaultSource == null ? 43 : $defaultSource.hashCode());
    final java.lang.Object $defaultTaxRates = this.getDefaultTaxRates();
    result = result * PRIME + ($defaultTaxRates == null ? 43 : $defaultTaxRates.hashCode());
    final java.lang.Object $discount = this.getDiscount();
    result = result * PRIME + ($discount == null ? 43 : $discount.hashCode());
    final java.lang.Object $endedAt = this.getEndedAt();
    result = result * PRIME + ($endedAt == null ? 43 : $endedAt.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $items = this.getItems();
    result = result * PRIME + ($items == null ? 43 : $items.hashCode());
    final java.lang.Object $latestInvoice = this.getLatestInvoice();
    result = result * PRIME + ($latestInvoice == null ? 43 : $latestInvoice.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $pendingSetupIntent = this.getPendingSetupIntent();
    result = result * PRIME + ($pendingSetupIntent == null ? 43 : $pendingSetupIntent.hashCode());
    final java.lang.Object $plan = this.getPlan();
    result = result * PRIME + ($plan == null ? 43 : $plan.hashCode());
    final java.lang.Object $quantity = this.getQuantity();
    result = result * PRIME + ($quantity == null ? 43 : $quantity.hashCode());
    final java.lang.Object $start = this.getStart();
    result = result * PRIME + ($start == null ? 43 : $start.hashCode());
    final java.lang.Object $startDate = this.getStartDate();
    result = result * PRIME + ($startDate == null ? 43 : $startDate.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $taxPercent = this.getTaxPercent();
    result = result * PRIME + ($taxPercent == null ? 43 : $taxPercent.hashCode());
    final java.lang.Object $transferData = this.getTransferData();
    result = result * PRIME + ($transferData == null ? 43 : $transferData.hashCode());
    final java.lang.Object $trialEnd = this.getTrialEnd();
    result = result * PRIME + ($trialEnd == null ? 43 : $trialEnd.hashCode());
    final java.lang.Object $trialStart = this.getTrialStart();
    result = result * PRIME + ($trialStart == null ? 43 : $trialStart.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
