// Generated by delombok at Mon Jun 24 11:22:20 PDT 2019
// Generated by com.stripe.generator.entity.SdkBuilder
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.PaymentMethodAttachParams;
import com.stripe.param.PaymentMethodCreateParams;
import com.stripe.param.PaymentMethodDetachParams;
import com.stripe.param.PaymentMethodListParams;
import com.stripe.param.PaymentMethodRetrieveParams;
import com.stripe.param.PaymentMethodUpdateParams;
import java.util.Map;

public class PaymentMethod extends ApiResource implements HasId, MetadataStore<PaymentMethod> {
  @SerializedName("billing_details")
  BillingDetails billingDetails;
  @SerializedName("card")
  Card card;
  @SerializedName("card_present")
  CardPresent cardPresent;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * The ID of the Customer to which this PaymentMethod is saved. This will not be set when the
   * PaymentMethod has not been saved to a Customer.
   */
  @SerializedName("customer")
  ExpandableField<Customer> customer;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object
   * exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  @SerializedName("object")
  String object;
  /**
   * The type of the PaymentMethod. An additional hash is included on the PaymentMethod with a name
   * matching this value. It contains additional information specific to the PaymentMethod type.
   */
  @SerializedName("type")
  String type;

  /**
   * Get id of expandable `customer` object.
   */
  public String getCustomer() {
    return (this.customer != null) ? this.customer.getId() : null;
  }

  public void setCustomer(String id) {
    this.customer = ApiResource.setExpandableFieldId(id, this.customer);
  }

  /**
   * Get expanded `customer`.
   */
  public Customer getCustomerObject() {
    return (this.customer != null) ? this.customer.getExpanded() : null;
  }

  public void setCustomerObject(Customer expandableObject) {
    this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
  }

  /**
   * Creates a PaymentMethod object. Read the <a
   * href="/docs/stripe-js/reference#stripe-create-payment-method">Stripe.js reference</a> to learn
   * how to create PaymentMethods via Stripe.js.
   */
  public static PaymentMethod create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a PaymentMethod object. Read the <a
   * href="/docs/stripe-js/reference#stripe-create-payment-method">Stripe.js reference</a> to learn
   * how to create PaymentMethods via Stripe.js.
   */
  public static PaymentMethod create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_methods");
    return request(ApiResource.RequestMethod.POST, url, params, PaymentMethod.class, options);
  }

  /**
   * Creates a PaymentMethod object. Read the <a
   * href="/docs/stripe-js/reference#stripe-create-payment-method">Stripe.js reference</a> to learn
   * how to create PaymentMethods via Stripe.js.
   */
  public static PaymentMethod create(PaymentMethodCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a PaymentMethod object. Read the <a
   * href="/docs/stripe-js/reference#stripe-create-payment-method">Stripe.js reference</a> to learn
   * how to create PaymentMethods via Stripe.js.
   */
  public static PaymentMethod create(PaymentMethodCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_methods");
    return request(ApiResource.RequestMethod.POST, url, params, PaymentMethod.class, options);
  }

  /**
   * Retrieves a PaymentMethod object.
   */
  public static PaymentMethod retrieve(String paymentMethod) throws StripeException {
    return retrieve(paymentMethod, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves a PaymentMethod object.
   */
  public static PaymentMethod retrieve(String paymentMethod, RequestOptions options) throws StripeException {
    return retrieve(paymentMethod, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves a PaymentMethod object.
   */
  public static PaymentMethod retrieve(String paymentMethod, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_methods/%s", ApiResource.urlEncodeId(paymentMethod)));
    return request(ApiResource.RequestMethod.GET, url, params, PaymentMethod.class, options);
  }

  /**
   * Retrieves a PaymentMethod object.
   */
  public static PaymentMethod retrieve(String paymentMethod, PaymentMethodRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_methods/%s", ApiResource.urlEncodeId(paymentMethod)));
    return request(ApiResource.RequestMethod.GET, url, params, PaymentMethod.class, options);
  }

  /**
   * Updates a PaymentMethod object. A PaymentMethod must be attached a customer to be updated.
   */
  @Override
  public PaymentMethod update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates a PaymentMethod object. A PaymentMethod must be attached a customer to be updated.
   */
  @Override
  public PaymentMethod update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_methods/%s", ApiResource.urlEncodeId(this.getId())));
    return request(ApiResource.RequestMethod.POST, url, params, PaymentMethod.class, options);
  }

  /**
   * Updates a PaymentMethod object. A PaymentMethod must be attached a customer to be updated.
   */
  public PaymentMethod update(PaymentMethodUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates a PaymentMethod object. A PaymentMethod must be attached a customer to be updated.
   */
  public PaymentMethod update(PaymentMethodUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_methods/%s", ApiResource.urlEncodeId(this.getId())));
    return request(ApiResource.RequestMethod.POST, url, params, PaymentMethod.class, options);
  }

  /**
   * Returns a list of PaymentMethods for a given Customer.
   */
  public static PaymentMethodCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of PaymentMethods for a given Customer.
   */
  public static PaymentMethodCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_methods");
    return requestCollection(url, params, PaymentMethodCollection.class, options);
  }

  /**
   * Returns a list of PaymentMethods for a given Customer.
   */
  public static PaymentMethodCollection list(PaymentMethodListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of PaymentMethods for a given Customer.
   */
  public static PaymentMethodCollection list(PaymentMethodListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_methods");
    return requestCollection(url, params, PaymentMethodCollection.class, options);
  }

  /**
   * Attaches a PaymentMethod object to a Customer.
   *
   * <p>To use this PaymentMethod as the default for invoice or subscription payments, set <a
   * href="/docs/api/customers/update#update_customer-invoice_settings-default_payment_method">
   * <code>invoice_settings.default_payment_method</code></a>, on the Customer to the
   * PaymentMethod’s ID.
   */
  public PaymentMethod attach(Map<String, Object> params) throws StripeException {
    return attach(params, (RequestOptions) null);
  }

  /**
   * Attaches a PaymentMethod object to a Customer.
   *
   * <p>To use this PaymentMethod as the default for invoice or subscription payments, set <a
   * href="/docs/api/customers/update#update_customer-invoice_settings-default_payment_method">
   * <code>invoice_settings.default_payment_method</code></a>, on the Customer to the
   * PaymentMethod’s ID.
   */
  public PaymentMethod attach(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_methods/%s/attach", ApiResource.urlEncodeId(this.getId())));
    return request(ApiResource.RequestMethod.POST, url, params, PaymentMethod.class, options);
  }

  /**
   * Attaches a PaymentMethod object to a Customer.
   *
   * <p>To use this PaymentMethod as the default for invoice or subscription payments, set <a
   * href="/docs/api/customers/update#update_customer-invoice_settings-default_payment_method">
   * <code>invoice_settings.default_payment_method</code></a>, on the Customer to the
   * PaymentMethod’s ID.
   */
  public PaymentMethod attach(PaymentMethodAttachParams params) throws StripeException {
    return attach(params, (RequestOptions) null);
  }

  /**
   * Attaches a PaymentMethod object to a Customer.
   *
   * <p>To use this PaymentMethod as the default for invoice or subscription payments, set <a
   * href="/docs/api/customers/update#update_customer-invoice_settings-default_payment_method">
   * <code>invoice_settings.default_payment_method</code></a>, on the Customer to the
   * PaymentMethod’s ID.
   */
  public PaymentMethod attach(PaymentMethodAttachParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_methods/%s/attach", ApiResource.urlEncodeId(this.getId())));
    return request(ApiResource.RequestMethod.POST, url, params, PaymentMethod.class, options);
  }

  /**
   * Detaches a PaymentMethod object from a Customer.
   */
  public PaymentMethod detach() throws StripeException {
    return detach((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Detaches a PaymentMethod object from a Customer.
   */
  public PaymentMethod detach(RequestOptions options) throws StripeException {
    return detach((Map<String, Object>) null, options);
  }

  /**
   * Detaches a PaymentMethod object from a Customer.
   */
  public PaymentMethod detach(Map<String, Object> params) throws StripeException {
    return detach(params, (RequestOptions) null);
  }

  /**
   * Detaches a PaymentMethod object from a Customer.
   */
  public PaymentMethod detach(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_methods/%s/detach", ApiResource.urlEncodeId(this.getId())));
    return request(ApiResource.RequestMethod.POST, url, params, PaymentMethod.class, options);
  }

  /**
   * Detaches a PaymentMethod object from a Customer.
   */
  public PaymentMethod detach(PaymentMethodDetachParams params) throws StripeException {
    return detach(params, (RequestOptions) null);
  }

  /**
   * Detaches a PaymentMethod object from a Customer.
   */
  public PaymentMethod detach(PaymentMethodDetachParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_methods/%s/detach", ApiResource.urlEncodeId(this.getId())));
    return request(ApiResource.RequestMethod.POST, url, params, PaymentMethod.class, options);
  }


  public static class BillingDetails extends StripeObject {
    /**
     * Billing address.
     */
    @SerializedName("address")
    Address address;
    /**
     * Email address.
     */
    @SerializedName("email")
    String email;
    /**
     * Full name.
     */
    @SerializedName("name")
    String name;
    /**
     * Billing phone number (including extension).
     */
    @SerializedName("phone")
    String phone;

    /**
     * Billing address.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Address getAddress() {
      return this.address;
    }

    /**
     * Email address.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getEmail() {
      return this.email;
    }

    /**
     * Full name.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
      return this.name;
    }

    /**
     * Billing phone number (including extension).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPhone() {
      return this.phone;
    }

    /**
     * Billing address.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAddress(final Address address) {
      this.address = address;
    }

    /**
     * Email address.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setEmail(final String email) {
      this.email = email;
    }

    /**
     * Full name.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setName(final String name) {
      this.name = name;
    }

    /**
     * Billing phone number (including extension).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPhone(final String phone) {
      this.phone = phone;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentMethod.BillingDetails)) return false;
      final PaymentMethod.BillingDetails other = (PaymentMethod.BillingDetails) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$address = this.getAddress();
      final java.lang.Object other$address = other.getAddress();
      if (this$address == null ? other$address != null : !this$address.equals(other$address)) return false;
      final java.lang.Object this$email = this.getEmail();
      final java.lang.Object other$email = other.getEmail();
      if (this$email == null ? other$email != null : !this$email.equals(other$email)) return false;
      final java.lang.Object this$name = this.getName();
      final java.lang.Object other$name = other.getName();
      if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
      final java.lang.Object this$phone = this.getPhone();
      final java.lang.Object other$phone = other.getPhone();
      if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentMethod.BillingDetails;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $address = this.getAddress();
      result = result * PRIME + ($address == null ? 43 : $address.hashCode());
      final java.lang.Object $email = this.getEmail();
      result = result * PRIME + ($email == null ? 43 : $email.hashCode());
      final java.lang.Object $name = this.getName();
      result = result * PRIME + ($name == null ? 43 : $name.hashCode());
      final java.lang.Object $phone = this.getPhone();
      result = result * PRIME + ($phone == null ? 43 : $phone.hashCode());
      return result;
    }
  }


  public static class Card extends StripeObject {
    /**
     * Card brand. Can be `amex`, `diners`, `discover`, `jcb`, `mastercard`, `unionpay`, `visa`, or
     * `unknown`.
     */
    @SerializedName("brand")
    String brand;
    /**
     * Checks on Card address and CVC if provided.
     */
    @SerializedName("checks")
    Checks checks;
    /**
     * Two-letter ISO code representing the country of the card. You could use this attribute to get
     * a sense of the international breakdown of cards you've collected.
     */
    @SerializedName("country")
    String country;
    /**
     * Card description. (Only for internal use only and not typically available in standard API
     * requests.)
     */
    @SerializedName("description")
    String description;
    /**
     * Two-digit number representing the card's expiration month.
     */
    @SerializedName("exp_month")
    Long expMonth;
    /**
     * Four-digit number representing the card's expiration year.
     */
    @SerializedName("exp_year")
    Long expYear;
    /**
     * Uniquely identifies this particular card number. You can use this attribute to check whether
     * two customers who've signed up with you are using the same card number, for example.
     */
    @SerializedName("fingerprint")
    String fingerprint;
    /**
     * Card funding type. Can be `credit`, `debit`, `prepaid`, or `unknown`.
     */
    @SerializedName("funding")
    String funding;
    /**
     * Issuer identification number of the card. (Only for internal use only and not typically
     * available in standard API requests.)
     */
    @SerializedName("iin")
    String iin;
    /**
     * Issuer bank name of the card. (Only for internal use only and not typically available in
     * standard API requests.)
     */
    @SerializedName("issuer")
    String issuer;
    /**
     * The last four digits of the card.
     */
    @SerializedName("last4")
    String last4;
    /**
     * Contains details on how this Card maybe be used for 3D Secure authentication.
     */
    @SerializedName("three_d_secure_usage")
    ThreeDSecureUsage threeDSecureUsage;
    /**
     * If this Card is part of a card wallet, this contains the details of the card wallet.
     */
    @SerializedName("wallet")
    Wallet wallet;


    public static class Checks extends StripeObject {
      /**
       * If a address line1 was provided, results of the check, one of 'pass', 'failed',
       * 'unavailable' or 'unchecked'.
       */
      @SerializedName("address_line1_check")
      String addressLine1Check;
      /**
       * If a address postal code was provided, results of the check, one of 'pass', 'failed',
       * 'unavailable' or 'unchecked'.
       */
      @SerializedName("address_postal_code_check")
      String addressPostalCodeCheck;
      /**
       * If a CVC was provided, results of the check, one of 'pass', 'failed', 'unavailable' or
       * 'unchecked'.
       */
      @SerializedName("cvc_check")
      String cvcCheck;

      /**
       * If a address line1 was provided, results of the check, one of 'pass', 'failed',
       * 'unavailable' or 'unchecked'.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getAddressLine1Check() {
        return this.addressLine1Check;
      }

      /**
       * If a address postal code was provided, results of the check, one of 'pass', 'failed',
       * 'unavailable' or 'unchecked'.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getAddressPostalCodeCheck() {
        return this.addressPostalCodeCheck;
      }

      /**
       * If a CVC was provided, results of the check, one of 'pass', 'failed', 'unavailable' or
       * 'unchecked'.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCvcCheck() {
        return this.cvcCheck;
      }

      /**
       * If a address line1 was provided, results of the check, one of 'pass', 'failed',
       * 'unavailable' or 'unchecked'.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setAddressLine1Check(final String addressLine1Check) {
        this.addressLine1Check = addressLine1Check;
      }

      /**
       * If a address postal code was provided, results of the check, one of 'pass', 'failed',
       * 'unavailable' or 'unchecked'.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setAddressPostalCodeCheck(final String addressPostalCodeCheck) {
        this.addressPostalCodeCheck = addressPostalCodeCheck;
      }

      /**
       * If a CVC was provided, results of the check, one of 'pass', 'failed', 'unavailable' or
       * 'unchecked'.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCvcCheck(final String cvcCheck) {
        this.cvcCheck = cvcCheck;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentMethod.Card.Checks)) return false;
        final PaymentMethod.Card.Checks other = (PaymentMethod.Card.Checks) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$addressLine1Check = this.getAddressLine1Check();
        final java.lang.Object other$addressLine1Check = other.getAddressLine1Check();
        if (this$addressLine1Check == null ? other$addressLine1Check != null : !this$addressLine1Check.equals(other$addressLine1Check)) return false;
        final java.lang.Object this$addressPostalCodeCheck = this.getAddressPostalCodeCheck();
        final java.lang.Object other$addressPostalCodeCheck = other.getAddressPostalCodeCheck();
        if (this$addressPostalCodeCheck == null ? other$addressPostalCodeCheck != null : !this$addressPostalCodeCheck.equals(other$addressPostalCodeCheck)) return false;
        final java.lang.Object this$cvcCheck = this.getCvcCheck();
        final java.lang.Object other$cvcCheck = other.getCvcCheck();
        if (this$cvcCheck == null ? other$cvcCheck != null : !this$cvcCheck.equals(other$cvcCheck)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentMethod.Card.Checks;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $addressLine1Check = this.getAddressLine1Check();
        result = result * PRIME + ($addressLine1Check == null ? 43 : $addressLine1Check.hashCode());
        final java.lang.Object $addressPostalCodeCheck = this.getAddressPostalCodeCheck();
        result = result * PRIME + ($addressPostalCodeCheck == null ? 43 : $addressPostalCodeCheck.hashCode());
        final java.lang.Object $cvcCheck = this.getCvcCheck();
        result = result * PRIME + ($cvcCheck == null ? 43 : $cvcCheck.hashCode());
        return result;
      }
    }


    public static class ThreeDSecureUsage extends StripeObject {
      /**
       * Whether 3D Secure is supported on this card.
       */
      @SerializedName("supported")
      Boolean supported;

      /**
       * Whether 3D Secure is supported on this card.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Boolean getSupported() {
        return this.supported;
      }

      /**
       * Whether 3D Secure is supported on this card.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSupported(final Boolean supported) {
        this.supported = supported;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentMethod.Card.ThreeDSecureUsage)) return false;
        final PaymentMethod.Card.ThreeDSecureUsage other = (PaymentMethod.Card.ThreeDSecureUsage) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$supported = this.getSupported();
        final java.lang.Object other$supported = other.getSupported();
        if (this$supported == null ? other$supported != null : !this$supported.equals(other$supported)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentMethod.Card.ThreeDSecureUsage;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $supported = this.getSupported();
        result = result * PRIME + ($supported == null ? 43 : $supported.hashCode());
        return result;
      }
    }


    public static class Wallet extends StripeObject {
      @SerializedName("amex_express_checkout")
      AmexExpressCheckout amexExpressCheckout;
      @SerializedName("apple_pay")
      ApplePay applePay;
      /** (For tokenized numbers only.) The last four digits of the device account number. */
      @SerializedName("dynamic_last4")
      String dynamicLast4;
      @SerializedName("google_pay")
      GooglePay googlePay;
      @SerializedName("masterpass")
      Masterpass masterpass;
      @SerializedName("samsung_pay")
      SamsungPay samsungPay;
      /**
       * The type of the card wallet, one of `amex_express_checkout`, `apple_pay`, `google_pay`,
       * `masterpass`, `samsung_pay`, or `visa_checkout`. An additional hash is included on the
       * Wallet subhash with a name matching this value. It contains additional information specific
       * to the card wallet type.
       */
      @SerializedName("type")
      String type;
      @SerializedName("visa_checkout")
      VisaCheckout visaCheckout;


      public static class AmexExpressCheckout extends StripeObject {
        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof PaymentMethod.Card.Wallet.AmexExpressCheckout)) return false;
          final PaymentMethod.Card.Wallet.AmexExpressCheckout other = (PaymentMethod.Card.Wallet.AmexExpressCheckout) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof PaymentMethod.Card.Wallet.AmexExpressCheckout;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int result = 1;
          return result;
        }
      }


      public static class ApplePay extends StripeObject {
        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof PaymentMethod.Card.Wallet.ApplePay)) return false;
          final PaymentMethod.Card.Wallet.ApplePay other = (PaymentMethod.Card.Wallet.ApplePay) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof PaymentMethod.Card.Wallet.ApplePay;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int result = 1;
          return result;
        }
      }


      public static class GooglePay extends StripeObject {
        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof PaymentMethod.Card.Wallet.GooglePay)) return false;
          final PaymentMethod.Card.Wallet.GooglePay other = (PaymentMethod.Card.Wallet.GooglePay) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof PaymentMethod.Card.Wallet.GooglePay;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int result = 1;
          return result;
        }
      }


      public static class Masterpass extends StripeObject {
        /**
         * Owner's verified billing address. Values are verified or provided by the wallet directly
         * (if supported) at the time of authorization or settlement. They cannot be set or mutated.
         */
        @SerializedName("billing_address")
        Address billingAddress;
        /**
         * Owner's verified email. Values are verified or provided by the wallet directly (if
         * supported) at the time of authorization or settlement. They cannot be set or mutated.
         */
        @SerializedName("email")
        String email;
        /**
         * Owner's verified full name. Values are verified or provided by the wallet directly (if
         * supported) at the time of authorization or settlement. They cannot be set or mutated.
         */
        @SerializedName("name")
        String name;
        /**
         * Owner's verified shipping address. Values are verified or provided by the wallet directly
         * (if supported) at the time of authorization or settlement. They cannot be set or mutated.
         */
        @SerializedName("shipping_address")
        Address shippingAddress;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Address getBillingAddress() {
          return this.billingAddress;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getEmail() {
          return this.email;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getName() {
          return this.name;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Address getShippingAddress() {
          return this.shippingAddress;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setBillingAddress(final Address billingAddress) {
          this.billingAddress = billingAddress;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setEmail(final String email) {
          this.email = email;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setName(final String name) {
          this.name = name;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setShippingAddress(final Address shippingAddress) {
          this.shippingAddress = shippingAddress;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof PaymentMethod.Card.Wallet.Masterpass)) return false;
          final PaymentMethod.Card.Wallet.Masterpass other = (PaymentMethod.Card.Wallet.Masterpass) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$billingAddress = this.getBillingAddress();
          final java.lang.Object other$billingAddress = other.getBillingAddress();
          if (this$billingAddress == null ? other$billingAddress != null : !this$billingAddress.equals(other$billingAddress)) return false;
          final java.lang.Object this$email = this.getEmail();
          final java.lang.Object other$email = other.getEmail();
          if (this$email == null ? other$email != null : !this$email.equals(other$email)) return false;
          final java.lang.Object this$name = this.getName();
          final java.lang.Object other$name = other.getName();
          if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
          final java.lang.Object this$shippingAddress = this.getShippingAddress();
          final java.lang.Object other$shippingAddress = other.getShippingAddress();
          if (this$shippingAddress == null ? other$shippingAddress != null : !this$shippingAddress.equals(other$shippingAddress)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof PaymentMethod.Card.Wallet.Masterpass;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $billingAddress = this.getBillingAddress();
          result = result * PRIME + ($billingAddress == null ? 43 : $billingAddress.hashCode());
          final java.lang.Object $email = this.getEmail();
          result = result * PRIME + ($email == null ? 43 : $email.hashCode());
          final java.lang.Object $name = this.getName();
          result = result * PRIME + ($name == null ? 43 : $name.hashCode());
          final java.lang.Object $shippingAddress = this.getShippingAddress();
          result = result * PRIME + ($shippingAddress == null ? 43 : $shippingAddress.hashCode());
          return result;
        }
      }


      public static class SamsungPay extends StripeObject {
        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof PaymentMethod.Card.Wallet.SamsungPay)) return false;
          final PaymentMethod.Card.Wallet.SamsungPay other = (PaymentMethod.Card.Wallet.SamsungPay) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof PaymentMethod.Card.Wallet.SamsungPay;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int result = 1;
          return result;
        }
      }


      public static class VisaCheckout extends StripeObject {
        /**
         * Owner's verified billing address. Values are verified or provided by the wallet directly
         * (if supported) at the time of authorization or settlement. They cannot be set or mutated.
         */
        @SerializedName("billing_address")
        Address billingAddress;
        /**
         * Owner's verified email. Values are verified or provided by the wallet directly (if
         * supported) at the time of authorization or settlement. They cannot be set or mutated.
         */
        @SerializedName("email")
        String email;
        /**
         * Owner's verified full name. Values are verified or provided by the wallet directly (if
         * supported) at the time of authorization or settlement. They cannot be set or mutated.
         */
        @SerializedName("name")
        String name;
        @SerializedName("shipping_address")
        Address shippingAddress;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Address getBillingAddress() {
          return this.billingAddress;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getEmail() {
          return this.email;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getName() {
          return this.name;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Address getShippingAddress() {
          return this.shippingAddress;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setBillingAddress(final Address billingAddress) {
          this.billingAddress = billingAddress;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setEmail(final String email) {
          this.email = email;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setName(final String name) {
          this.name = name;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setShippingAddress(final Address shippingAddress) {
          this.shippingAddress = shippingAddress;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof PaymentMethod.Card.Wallet.VisaCheckout)) return false;
          final PaymentMethod.Card.Wallet.VisaCheckout other = (PaymentMethod.Card.Wallet.VisaCheckout) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$billingAddress = this.getBillingAddress();
          final java.lang.Object other$billingAddress = other.getBillingAddress();
          if (this$billingAddress == null ? other$billingAddress != null : !this$billingAddress.equals(other$billingAddress)) return false;
          final java.lang.Object this$email = this.getEmail();
          final java.lang.Object other$email = other.getEmail();
          if (this$email == null ? other$email != null : !this$email.equals(other$email)) return false;
          final java.lang.Object this$name = this.getName();
          final java.lang.Object other$name = other.getName();
          if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
          final java.lang.Object this$shippingAddress = this.getShippingAddress();
          final java.lang.Object other$shippingAddress = other.getShippingAddress();
          if (this$shippingAddress == null ? other$shippingAddress != null : !this$shippingAddress.equals(other$shippingAddress)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof PaymentMethod.Card.Wallet.VisaCheckout;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $billingAddress = this.getBillingAddress();
          result = result * PRIME + ($billingAddress == null ? 43 : $billingAddress.hashCode());
          final java.lang.Object $email = this.getEmail();
          result = result * PRIME + ($email == null ? 43 : $email.hashCode());
          final java.lang.Object $name = this.getName();
          result = result * PRIME + ($name == null ? 43 : $name.hashCode());
          final java.lang.Object $shippingAddress = this.getShippingAddress();
          result = result * PRIME + ($shippingAddress == null ? 43 : $shippingAddress.hashCode());
          return result;
        }
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public AmexExpressCheckout getAmexExpressCheckout() {
        return this.amexExpressCheckout;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public ApplePay getApplePay() {
        return this.applePay;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getDynamicLast4() {
        return this.dynamicLast4;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public GooglePay getGooglePay() {
        return this.googlePay;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Masterpass getMasterpass() {
        return this.masterpass;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public SamsungPay getSamsungPay() {
        return this.samsungPay;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getType() {
        return this.type;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public VisaCheckout getVisaCheckout() {
        return this.visaCheckout;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setAmexExpressCheckout(final AmexExpressCheckout amexExpressCheckout) {
        this.amexExpressCheckout = amexExpressCheckout;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setApplePay(final ApplePay applePay) {
        this.applePay = applePay;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setDynamicLast4(final String dynamicLast4) {
        this.dynamicLast4 = dynamicLast4;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setGooglePay(final GooglePay googlePay) {
        this.googlePay = googlePay;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setMasterpass(final Masterpass masterpass) {
        this.masterpass = masterpass;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSamsungPay(final SamsungPay samsungPay) {
        this.samsungPay = samsungPay;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setType(final String type) {
        this.type = type;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setVisaCheckout(final VisaCheckout visaCheckout) {
        this.visaCheckout = visaCheckout;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentMethod.Card.Wallet)) return false;
        final PaymentMethod.Card.Wallet other = (PaymentMethod.Card.Wallet) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$amexExpressCheckout = this.getAmexExpressCheckout();
        final java.lang.Object other$amexExpressCheckout = other.getAmexExpressCheckout();
        if (this$amexExpressCheckout == null ? other$amexExpressCheckout != null : !this$amexExpressCheckout.equals(other$amexExpressCheckout)) return false;
        final java.lang.Object this$applePay = this.getApplePay();
        final java.lang.Object other$applePay = other.getApplePay();
        if (this$applePay == null ? other$applePay != null : !this$applePay.equals(other$applePay)) return false;
        final java.lang.Object this$dynamicLast4 = this.getDynamicLast4();
        final java.lang.Object other$dynamicLast4 = other.getDynamicLast4();
        if (this$dynamicLast4 == null ? other$dynamicLast4 != null : !this$dynamicLast4.equals(other$dynamicLast4)) return false;
        final java.lang.Object this$googlePay = this.getGooglePay();
        final java.lang.Object other$googlePay = other.getGooglePay();
        if (this$googlePay == null ? other$googlePay != null : !this$googlePay.equals(other$googlePay)) return false;
        final java.lang.Object this$masterpass = this.getMasterpass();
        final java.lang.Object other$masterpass = other.getMasterpass();
        if (this$masterpass == null ? other$masterpass != null : !this$masterpass.equals(other$masterpass)) return false;
        final java.lang.Object this$samsungPay = this.getSamsungPay();
        final java.lang.Object other$samsungPay = other.getSamsungPay();
        if (this$samsungPay == null ? other$samsungPay != null : !this$samsungPay.equals(other$samsungPay)) return false;
        final java.lang.Object this$type = this.getType();
        final java.lang.Object other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
        final java.lang.Object this$visaCheckout = this.getVisaCheckout();
        final java.lang.Object other$visaCheckout = other.getVisaCheckout();
        if (this$visaCheckout == null ? other$visaCheckout != null : !this$visaCheckout.equals(other$visaCheckout)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentMethod.Card.Wallet;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $amexExpressCheckout = this.getAmexExpressCheckout();
        result = result * PRIME + ($amexExpressCheckout == null ? 43 : $amexExpressCheckout.hashCode());
        final java.lang.Object $applePay = this.getApplePay();
        result = result * PRIME + ($applePay == null ? 43 : $applePay.hashCode());
        final java.lang.Object $dynamicLast4 = this.getDynamicLast4();
        result = result * PRIME + ($dynamicLast4 == null ? 43 : $dynamicLast4.hashCode());
        final java.lang.Object $googlePay = this.getGooglePay();
        result = result * PRIME + ($googlePay == null ? 43 : $googlePay.hashCode());
        final java.lang.Object $masterpass = this.getMasterpass();
        result = result * PRIME + ($masterpass == null ? 43 : $masterpass.hashCode());
        final java.lang.Object $samsungPay = this.getSamsungPay();
        result = result * PRIME + ($samsungPay == null ? 43 : $samsungPay.hashCode());
        final java.lang.Object $type = this.getType();
        result = result * PRIME + ($type == null ? 43 : $type.hashCode());
        final java.lang.Object $visaCheckout = this.getVisaCheckout();
        result = result * PRIME + ($visaCheckout == null ? 43 : $visaCheckout.hashCode());
        return result;
      }
    }

    /**
     * Card brand. Can be `amex`, `diners`, `discover`, `jcb`, `mastercard`, `unionpay`, `visa`, or
     * `unknown`.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBrand() {
      return this.brand;
    }

    /**
     * Checks on Card address and CVC if provided.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Checks getChecks() {
      return this.checks;
    }

    /**
     * Two-letter ISO code representing the country of the card. You could use this attribute to get
     * a sense of the international breakdown of cards you've collected.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCountry() {
      return this.country;
    }

    /**
     * Card description. (Only for internal use only and not typically available in standard API
     * requests.)
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDescription() {
      return this.description;
    }

    /**
     * Two-digit number representing the card's expiration month.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getExpMonth() {
      return this.expMonth;
    }

    /**
     * Four-digit number representing the card's expiration year.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getExpYear() {
      return this.expYear;
    }

    /**
     * Uniquely identifies this particular card number. You can use this attribute to check whether
     * two customers who've signed up with you are using the same card number, for example.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getFingerprint() {
      return this.fingerprint;
    }

    /**
     * Card funding type. Can be `credit`, `debit`, `prepaid`, or `unknown`.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getFunding() {
      return this.funding;
    }

    /**
     * Issuer identification number of the card. (Only for internal use only and not typically
     * available in standard API requests.)
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getIin() {
      return this.iin;
    }

    /**
     * Issuer bank name of the card. (Only for internal use only and not typically available in
     * standard API requests.)
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getIssuer() {
      return this.issuer;
    }

    /**
     * The last four digits of the card.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLast4() {
      return this.last4;
    }

    /**
     * Contains details on how this Card maybe be used for 3D Secure authentication.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ThreeDSecureUsage getThreeDSecureUsage() {
      return this.threeDSecureUsage;
    }

    /**
     * If this Card is part of a card wallet, this contains the details of the card wallet.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Wallet getWallet() {
      return this.wallet;
    }

    /**
     * Card brand. Can be `amex`, `diners`, `discover`, `jcb`, `mastercard`, `unionpay`, `visa`, or
     * `unknown`.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBrand(final String brand) {
      this.brand = brand;
    }

    /**
     * Checks on Card address and CVC if provided.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setChecks(final Checks checks) {
      this.checks = checks;
    }

    /**
     * Two-letter ISO code representing the country of the card. You could use this attribute to get
     * a sense of the international breakdown of cards you've collected.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCountry(final String country) {
      this.country = country;
    }

    /**
     * Card description. (Only for internal use only and not typically available in standard API
     * requests.)
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDescription(final String description) {
      this.description = description;
    }

    /**
     * Two-digit number representing the card's expiration month.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setExpMonth(final Long expMonth) {
      this.expMonth = expMonth;
    }

    /**
     * Four-digit number representing the card's expiration year.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setExpYear(final Long expYear) {
      this.expYear = expYear;
    }

    /**
     * Uniquely identifies this particular card number. You can use this attribute to check whether
     * two customers who've signed up with you are using the same card number, for example.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFingerprint(final String fingerprint) {
      this.fingerprint = fingerprint;
    }

    /**
     * Card funding type. Can be `credit`, `debit`, `prepaid`, or `unknown`.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFunding(final String funding) {
      this.funding = funding;
    }

    /**
     * Issuer identification number of the card. (Only for internal use only and not typically
     * available in standard API requests.)
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIin(final String iin) {
      this.iin = iin;
    }

    /**
     * Issuer bank name of the card. (Only for internal use only and not typically available in
     * standard API requests.)
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIssuer(final String issuer) {
      this.issuer = issuer;
    }

    /**
     * The last four digits of the card.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLast4(final String last4) {
      this.last4 = last4;
    }

    /**
     * Contains details on how this Card maybe be used for 3D Secure authentication.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setThreeDSecureUsage(final ThreeDSecureUsage threeDSecureUsage) {
      this.threeDSecureUsage = threeDSecureUsage;
    }

    /**
     * If this Card is part of a card wallet, this contains the details of the card wallet.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setWallet(final Wallet wallet) {
      this.wallet = wallet;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentMethod.Card)) return false;
      final PaymentMethod.Card other = (PaymentMethod.Card) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$brand = this.getBrand();
      final java.lang.Object other$brand = other.getBrand();
      if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) return false;
      final java.lang.Object this$checks = this.getChecks();
      final java.lang.Object other$checks = other.getChecks();
      if (this$checks == null ? other$checks != null : !this$checks.equals(other$checks)) return false;
      final java.lang.Object this$country = this.getCountry();
      final java.lang.Object other$country = other.getCountry();
      if (this$country == null ? other$country != null : !this$country.equals(other$country)) return false;
      final java.lang.Object this$description = this.getDescription();
      final java.lang.Object other$description = other.getDescription();
      if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
      final java.lang.Object this$expMonth = this.getExpMonth();
      final java.lang.Object other$expMonth = other.getExpMonth();
      if (this$expMonth == null ? other$expMonth != null : !this$expMonth.equals(other$expMonth)) return false;
      final java.lang.Object this$expYear = this.getExpYear();
      final java.lang.Object other$expYear = other.getExpYear();
      if (this$expYear == null ? other$expYear != null : !this$expYear.equals(other$expYear)) return false;
      final java.lang.Object this$fingerprint = this.getFingerprint();
      final java.lang.Object other$fingerprint = other.getFingerprint();
      if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) return false;
      final java.lang.Object this$funding = this.getFunding();
      final java.lang.Object other$funding = other.getFunding();
      if (this$funding == null ? other$funding != null : !this$funding.equals(other$funding)) return false;
      final java.lang.Object this$iin = this.getIin();
      final java.lang.Object other$iin = other.getIin();
      if (this$iin == null ? other$iin != null : !this$iin.equals(other$iin)) return false;
      final java.lang.Object this$issuer = this.getIssuer();
      final java.lang.Object other$issuer = other.getIssuer();
      if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) return false;
      final java.lang.Object this$last4 = this.getLast4();
      final java.lang.Object other$last4 = other.getLast4();
      if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) return false;
      final java.lang.Object this$threeDSecureUsage = this.getThreeDSecureUsage();
      final java.lang.Object other$threeDSecureUsage = other.getThreeDSecureUsage();
      if (this$threeDSecureUsage == null ? other$threeDSecureUsage != null : !this$threeDSecureUsage.equals(other$threeDSecureUsage)) return false;
      final java.lang.Object this$wallet = this.getWallet();
      final java.lang.Object other$wallet = other.getWallet();
      if (this$wallet == null ? other$wallet != null : !this$wallet.equals(other$wallet)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentMethod.Card;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $brand = this.getBrand();
      result = result * PRIME + ($brand == null ? 43 : $brand.hashCode());
      final java.lang.Object $checks = this.getChecks();
      result = result * PRIME + ($checks == null ? 43 : $checks.hashCode());
      final java.lang.Object $country = this.getCountry();
      result = result * PRIME + ($country == null ? 43 : $country.hashCode());
      final java.lang.Object $description = this.getDescription();
      result = result * PRIME + ($description == null ? 43 : $description.hashCode());
      final java.lang.Object $expMonth = this.getExpMonth();
      result = result * PRIME + ($expMonth == null ? 43 : $expMonth.hashCode());
      final java.lang.Object $expYear = this.getExpYear();
      result = result * PRIME + ($expYear == null ? 43 : $expYear.hashCode());
      final java.lang.Object $fingerprint = this.getFingerprint();
      result = result * PRIME + ($fingerprint == null ? 43 : $fingerprint.hashCode());
      final java.lang.Object $funding = this.getFunding();
      result = result * PRIME + ($funding == null ? 43 : $funding.hashCode());
      final java.lang.Object $iin = this.getIin();
      result = result * PRIME + ($iin == null ? 43 : $iin.hashCode());
      final java.lang.Object $issuer = this.getIssuer();
      result = result * PRIME + ($issuer == null ? 43 : $issuer.hashCode());
      final java.lang.Object $last4 = this.getLast4();
      result = result * PRIME + ($last4 == null ? 43 : $last4.hashCode());
      final java.lang.Object $threeDSecureUsage = this.getThreeDSecureUsage();
      result = result * PRIME + ($threeDSecureUsage == null ? 43 : $threeDSecureUsage.hashCode());
      final java.lang.Object $wallet = this.getWallet();
      result = result * PRIME + ($wallet == null ? 43 : $wallet.hashCode());
      return result;
    }
  }


  /**
   * Owner's verified shipping address. Values are verified or provided by the wallet directly
   * (if supported) at the time of authorization or settlement. They cannot be set or mutated.
   */
  public static class CardPresent extends StripeObject {
    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentMethod.CardPresent)) return false;
      final PaymentMethod.CardPresent other = (PaymentMethod.CardPresent) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentMethod.CardPresent;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int result = 1;
      return result;
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BillingDetails getBillingDetails() {
    return this.billingDetails;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Card getCard() {
    return this.card;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public CardPresent getCardPresent() {
    return this.cardPresent;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object
   * exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * The type of the PaymentMethod. An additional hash is included on the PaymentMethod with a name
   * matching this value. It contains additional information specific to the PaymentMethod type.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getType() {
    return this.type;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBillingDetails(final BillingDetails billingDetails) {
    this.billingDetails = billingDetails;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCard(final Card card) {
    this.card = card;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCardPresent(final CardPresent cardPresent) {
    this.cardPresent = cardPresent;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object
   * exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * The type of the PaymentMethod. An additional hash is included on the PaymentMethod with a name
   * matching this value. It contains additional information specific to the PaymentMethod type.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setType(final String type) {
    this.type = type;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof PaymentMethod)) return false;
    final PaymentMethod other = (PaymentMethod) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$billingDetails = this.getBillingDetails();
    final java.lang.Object other$billingDetails = other.getBillingDetails();
    if (this$billingDetails == null ? other$billingDetails != null : !this$billingDetails.equals(other$billingDetails)) return false;
    final java.lang.Object this$card = this.getCard();
    final java.lang.Object other$card = other.getCard();
    if (this$card == null ? other$card != null : !this$card.equals(other$card)) return false;
    final java.lang.Object this$cardPresent = this.getCardPresent();
    final java.lang.Object other$cardPresent = other.getCardPresent();
    if (this$cardPresent == null ? other$cardPresent != null : !this$cardPresent.equals(other$cardPresent)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$customer = this.getCustomer();
    final java.lang.Object other$customer = other.getCustomer();
    if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$type = this.getType();
    final java.lang.Object other$type = other.getType();
    if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof PaymentMethod;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $billingDetails = this.getBillingDetails();
    result = result * PRIME + ($billingDetails == null ? 43 : $billingDetails.hashCode());
    final java.lang.Object $card = this.getCard();
    result = result * PRIME + ($card == null ? 43 : $card.hashCode());
    final java.lang.Object $cardPresent = this.getCardPresent();
    result = result * PRIME + ($cardPresent == null ? 43 : $cardPresent.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $customer = this.getCustomer();
    result = result * PRIME + ($customer == null ? 43 : $customer.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $type = this.getType();
    result = result * PRIME + ($type == null ? 43 : $type.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
