// Generated by delombok at Mon Jun 24 17:51:13 PDT 2019
// Generated by com.stripe.generator.entity.SdkBuilder
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.CreditNoteCreateParams;
import com.stripe.param.CreditNoteListParams;
import com.stripe.param.CreditNoteRetrieveParams;
import com.stripe.param.CreditNoteUpdateParams;
import com.stripe.param.CreditNoteVoidCreditNoteParams;
import java.util.Map;

public class CreditNote extends ApiResource implements HasId, MetadataStore<CreditNote> {
  /**
   * The integer amount in **%s** representing the total amount of the credit note.
   */
  @SerializedName("amount")
  Long amount;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in
   * lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  @SerializedName("currency")
  String currency;
  /**
   * ID of the customer.
   */
  @SerializedName("customer")
  ExpandableField<Customer> customer;
  /**
   * Customer balance transaction related to this credit note.
   */
  @SerializedName("customer_balance_transaction")
  ExpandableField<CustomerBalanceTransaction> customerBalanceTransaction;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * ID of the invoice.
   */
  @SerializedName("invoice")
  ExpandableField<Invoice> invoice;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object
   * exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * Customer-facing text that appears on the credit note PDF.
   */
  @SerializedName("memo")
  String memo;
  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * A unique number that identifies this particular credit note and appears on the PDF of the
   * credit note and its associated invoice.
   */
  @SerializedName("number")
  String number;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  @SerializedName("object")
  String object;
  /**
   * The link to download the PDF of the credit note.
   */
  @SerializedName("pdf")
  String pdf;
  /**
   * Reason for issuing this credit note, one of `duplicate`, `fraudulent`, `order_change`, or
   * `product_unsatisfactory`.
   */
  @SerializedName("reason")
  String reason;
  /**
   * Refund related to this credit note.
   */
  @SerializedName("refund")
  ExpandableField<Refund> refund;
  /**
   * Status of this credit note, one of `issued` or `void`. Learn more about [voiding credit
   * notes](https://stripe.com/docs/billing/invoices/credit-notes#voiding).
   */
  @SerializedName("status")
  String status;
  /**
   * Type of this credit note, one of `post_payment` or `pre_payment`. A `pre_payment` credit note
   * means it was issued when the invoice was open. A `post_payment` credit note means it was issued
   * when the invoice was paid.
   */
  @SerializedName("type")
  String type;

  /**
   * Get id of expandable `customer` object.
   */
  public String getCustomer() {
    return (this.customer != null) ? this.customer.getId() : null;
  }

  public void setCustomer(String id) {
    this.customer = ApiResource.setExpandableFieldId(id, this.customer);
  }

  /**
   * Get expanded `customer`.
   */
  public Customer getCustomerObject() {
    return (this.customer != null) ? this.customer.getExpanded() : null;
  }

  public void setCustomerObject(Customer expandableObject) {
    this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get id of expandable `customerBalanceTransaction` object.
   */
  public String getCustomerBalanceTransaction() {
    return (this.customerBalanceTransaction != null) ? this.customerBalanceTransaction.getId() : null;
  }

  public void setCustomerBalanceTransaction(String id) {
    this.customerBalanceTransaction = ApiResource.setExpandableFieldId(id, this.customerBalanceTransaction);
  }

  /**
   * Get expanded `customerBalanceTransaction`.
   */
  public CustomerBalanceTransaction getCustomerBalanceTransactionObject() {
    return (this.customerBalanceTransaction != null) ? this.customerBalanceTransaction.getExpanded() : null;
  }

  public void setCustomerBalanceTransactionObject(CustomerBalanceTransaction expandableObject) {
    this.customerBalanceTransaction = new ExpandableField<CustomerBalanceTransaction>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get id of expandable `invoice` object.
   */
  public String getInvoice() {
    return (this.invoice != null) ? this.invoice.getId() : null;
  }

  public void setInvoice(String id) {
    this.invoice = ApiResource.setExpandableFieldId(id, this.invoice);
  }

  /**
   * Get expanded `invoice`.
   */
  public Invoice getInvoiceObject() {
    return (this.invoice != null) ? this.invoice.getExpanded() : null;
  }

  public void setInvoiceObject(Invoice expandableObject) {
    this.invoice = new ExpandableField<Invoice>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get id of expandable `refund` object.
   */
  public String getRefund() {
    return (this.refund != null) ? this.refund.getId() : null;
  }

  public void setRefund(String id) {
    this.refund = ApiResource.setExpandableFieldId(id, this.refund);
  }

  /**
   * Get expanded `refund`.
   */
  public Refund getRefundObject() {
    return (this.refund != null) ? this.refund.getExpanded() : null;
  }

  public void setRefundObject(Refund expandableObject) {
    this.refund = new ExpandableField<Refund>(expandableObject.getId(), expandableObject);
  }

  /**
   * Issue a credit note to adjust the amount of a finalized invoice. For a <code>status=open</code>
   * invoice, a credit note reduces its <code>amount_due</code>. For a <code>status=paid</code>
   * invoice, a credit note does not affect its <code>amount_due</code>. Instead, it can result in
   * any combination of the following:
   *
   * <ul>
   *   <li>Refund: create a new refund (using <code>refund_amount</code>) or link an existing refund
   *       (using <code>refund</code>).
   *   <li>Customer balance credit: credit the customer’s balance (using <code>credit_amount</code>)
   *       which will be automatically applied to their next invoice when it’s finalized.
   *   <li>Outside of Stripe credit: any positive value from the result of <code>
   *       amount - refund_amount - credit_amount</code> is represented as an “outside of Stripe”
   *       credit.
   * </ul>
   *
   * <p>You may issue multiple credit notes for an invoice. Each credit note will increment the
   * invoice’s <code>pre_payment_credit_notes_amount</code> or <code>
   * post_payment_credit_notes_amount</code> depending on its <code>status</code> at the time of
   * credit note creation.
   */
  public static CreditNote create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Issue a credit note to adjust the amount of a finalized invoice. For a <code>status=open</code>
   * invoice, a credit note reduces its <code>amount_due</code>. For a <code>status=paid</code>
   * invoice, a credit note does not affect its <code>amount_due</code>. Instead, it can result in
   * any combination of the following:
   *
   * <ul>
   *   <li>Refund: create a new refund (using <code>refund_amount</code>) or link an existing refund
   *       (using <code>refund</code>).
   *   <li>Customer balance credit: credit the customer’s balance (using <code>credit_amount</code>)
   *       which will be automatically applied to their next invoice when it’s finalized.
   *   <li>Outside of Stripe credit: any positive value from the result of <code>
   *       amount - refund_amount - credit_amount</code> is represented as an “outside of Stripe”
   *       credit.
   * </ul>
   *
   * <p>You may issue multiple credit notes for an invoice. Each credit note will increment the
   * invoice’s <code>pre_payment_credit_notes_amount</code> or <code>
   * post_payment_credit_notes_amount</code> depending on its <code>status</code> at the time of
   * credit note creation.
   */
  public static CreditNote create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/credit_notes");
    return request(ApiResource.RequestMethod.POST, url, params, CreditNote.class, options);
  }

  /**
   * Issue a credit note to adjust the amount of a finalized invoice. For a <code>status=open</code>
   * invoice, a credit note reduces its <code>amount_due</code>. For a <code>status=paid</code>
   * invoice, a credit note does not affect its <code>amount_due</code>. Instead, it can result in
   * any combination of the following:
   *
   * <ul>
   *   <li>Refund: create a new refund (using <code>refund_amount</code>) or link an existing refund
   *       (using <code>refund</code>).
   *   <li>Customer balance credit: credit the customer’s balance (using <code>credit_amount</code>)
   *       which will be automatically applied to their next invoice when it’s finalized.
   *   <li>Outside of Stripe credit: any positive value from the result of <code>
   *       amount - refund_amount - credit_amount</code> is represented as an “outside of Stripe”
   *       credit.
   * </ul>
   *
   * <p>You may issue multiple credit notes for an invoice. Each credit note will increment the
   * invoice’s <code>pre_payment_credit_notes_amount</code> or <code>
   * post_payment_credit_notes_amount</code> depending on its <code>status</code> at the time of
   * credit note creation.
   */
  public static CreditNote create(CreditNoteCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Issue a credit note to adjust the amount of a finalized invoice. For a <code>status=open</code>
   * invoice, a credit note reduces its <code>amount_due</code>. For a <code>status=paid</code>
   * invoice, a credit note does not affect its <code>amount_due</code>. Instead, it can result in
   * any combination of the following:
   *
   * <ul>
   *   <li>Refund: create a new refund (using <code>refund_amount</code>) or link an existing refund
   *       (using <code>refund</code>).
   *   <li>Customer balance credit: credit the customer’s balance (using <code>credit_amount</code>)
   *       which will be automatically applied to their next invoice when it’s finalized.
   *   <li>Outside of Stripe credit: any positive value from the result of <code>
   *       amount - refund_amount - credit_amount</code> is represented as an “outside of Stripe”
   *       credit.
   * </ul>
   *
   * <p>You may issue multiple credit notes for an invoice. Each credit note will increment the
   * invoice’s <code>pre_payment_credit_notes_amount</code> or <code>
   * post_payment_credit_notes_amount</code> depending on its <code>status</code> at the time of
   * credit note creation.
   */
  public static CreditNote create(CreditNoteCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/credit_notes");
    return request(ApiResource.RequestMethod.POST, url, params, CreditNote.class, options);
  }

  /**
   * Retrieves the credit note object with the given identifier.
   */
  public static CreditNote retrieve(String id) throws StripeException {
    return retrieve(id, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the credit note object with the given identifier.
   */
  public static CreditNote retrieve(String id, RequestOptions options) throws StripeException {
    return retrieve(id, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the credit note object with the given identifier.
   */
  public static CreditNote retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/credit_notes/%s", ApiResource.urlEncodeId(id)));
    return request(ApiResource.RequestMethod.GET, url, params, CreditNote.class, options);
  }

  /**
   * Retrieves the credit note object with the given identifier.
   */
  public static CreditNote retrieve(String id, CreditNoteRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/credit_notes/%s", ApiResource.urlEncodeId(id)));
    return request(ApiResource.RequestMethod.GET, url, params, CreditNote.class, options);
  }

  /**
   * Returns a list of credit notes.
   */
  public static CreditNoteCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of credit notes.
   */
  public static CreditNoteCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/credit_notes");
    return requestCollection(url, params, CreditNoteCollection.class, options);
  }

  /**
   * Returns a list of credit notes.
   */
  public static CreditNoteCollection list(CreditNoteListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of credit notes.
   */
  public static CreditNoteCollection list(CreditNoteListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/credit_notes");
    return requestCollection(url, params, CreditNoteCollection.class, options);
  }

  /**
   * Updates an existing credit note.
   */
  @Override
  public CreditNote update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates an existing credit note.
   */
  @Override
  public CreditNote update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/credit_notes/%s", ApiResource.urlEncodeId(this.getId())));
    return request(ApiResource.RequestMethod.POST, url, params, CreditNote.class, options);
  }

  /**
   * Updates an existing credit note.
   */
  public CreditNote update(CreditNoteUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates an existing credit note.
   */
  public CreditNote update(CreditNoteUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/credit_notes/%s", ApiResource.urlEncodeId(this.getId())));
    return request(ApiResource.RequestMethod.POST, url, params, CreditNote.class, options);
  }

  /**
   * Marks a credit note as void. Learn more about <a
   * href="/docs/billing/invoices/credit-notes#voiding">voiding credit notes</a>.
   */
  public CreditNote voidCreditNote() throws StripeException {
    return voidCreditNote((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Marks a credit note as void. Learn more about <a
   * href="/docs/billing/invoices/credit-notes#voiding">voiding credit notes</a>.
   */
  public CreditNote voidCreditNote(RequestOptions options) throws StripeException {
    return voidCreditNote((Map<String, Object>) null, options);
  }

  /**
   * Marks a credit note as void. Learn more about <a
   * href="/docs/billing/invoices/credit-notes#voiding">voiding credit notes</a>.
   */
  public CreditNote voidCreditNote(Map<String, Object> params) throws StripeException {
    return voidCreditNote(params, (RequestOptions) null);
  }

  /**
   * Marks a credit note as void. Learn more about <a
   * href="/docs/billing/invoices/credit-notes#voiding">voiding credit notes</a>.
   */
  public CreditNote voidCreditNote(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/credit_notes/%s/void", ApiResource.urlEncodeId(this.getId())));
    return request(ApiResource.RequestMethod.POST, url, params, CreditNote.class, options);
  }

  /**
   * Marks a credit note as void. Learn more about <a
   * href="/docs/billing/invoices/credit-notes#voiding">voiding credit notes</a>.
   */
  public CreditNote voidCreditNote(CreditNoteVoidCreditNoteParams params) throws StripeException {
    return voidCreditNote(params, (RequestOptions) null);
  }

  /**
   * Marks a credit note as void. Learn more about <a
   * href="/docs/billing/invoices/credit-notes#voiding">voiding credit notes</a>.
   */
  public CreditNote voidCreditNote(CreditNoteVoidCreditNoteParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/credit_notes/%s/void", ApiResource.urlEncodeId(this.getId())));
    return request(ApiResource.RequestMethod.POST, url, params, CreditNote.class, options);
  }

  /**
   * The integer amount in **%s** representing the total amount of the credit note.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmount() {
    return this.amount;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in
   * lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object
   * exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * Customer-facing text that appears on the credit note PDF.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getMemo() {
    return this.memo;
  }

  /**
   * A unique number that identifies this particular credit note and appears on the PDF of the
   * credit note and its associated invoice.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getNumber() {
    return this.number;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * The link to download the PDF of the credit note.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getPdf() {
    return this.pdf;
  }

  /**
   * Reason for issuing this credit note, one of `duplicate`, `fraudulent`, `order_change`, or
   * `product_unsatisfactory`.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getReason() {
    return this.reason;
  }

  /**
   * Status of this credit note, one of `issued` or `void`. Learn more about [voiding credit
   * notes](https://stripe.com/docs/billing/invoices/credit-notes#voiding).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  /**
   * Type of this credit note, one of `post_payment` or `pre_payment`. A `pre_payment` credit note
   * means it was issued when the invoice was open. A `post_payment` credit note means it was issued
   * when the invoice was paid.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getType() {
    return this.type;
  }

  /**
   * The integer amount in **%s** representing the total amount of the credit note.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmount(final Long amount) {
    this.amount = amount;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in
   * lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object
   * exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * Customer-facing text that appears on the credit note PDF.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMemo(final String memo) {
    this.memo = memo;
  }

  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * A unique number that identifies this particular credit note and appears on the PDF of the
   * credit note and its associated invoice.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNumber(final String number) {
    this.number = number;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * The link to download the PDF of the credit note.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPdf(final String pdf) {
    this.pdf = pdf;
  }

  /**
   * Reason for issuing this credit note, one of `duplicate`, `fraudulent`, `order_change`, or
   * `product_unsatisfactory`.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReason(final String reason) {
    this.reason = reason;
  }

  /**
   * Status of this credit note, one of `issued` or `void`. Learn more about [voiding credit
   * notes](https://stripe.com/docs/billing/invoices/credit-notes#voiding).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  /**
   * Type of this credit note, one of `post_payment` or `pre_payment`. A `pre_payment` credit note
   * means it was issued when the invoice was open. A `post_payment` credit note means it was issued
   * when the invoice was paid.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setType(final String type) {
    this.type = type;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof CreditNote)) return false;
    final CreditNote other = (CreditNote) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$amount = this.getAmount();
    final java.lang.Object other$amount = other.getAmount();
    if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$customer = this.getCustomer();
    final java.lang.Object other$customer = other.getCustomer();
    if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) return false;
    final java.lang.Object this$customerBalanceTransaction = this.getCustomerBalanceTransaction();
    final java.lang.Object other$customerBalanceTransaction = other.getCustomerBalanceTransaction();
    if (this$customerBalanceTransaction == null ? other$customerBalanceTransaction != null : !this$customerBalanceTransaction.equals(other$customerBalanceTransaction)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$invoice = this.getInvoice();
    final java.lang.Object other$invoice = other.getInvoice();
    if (this$invoice == null ? other$invoice != null : !this$invoice.equals(other$invoice)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$memo = this.getMemo();
    final java.lang.Object other$memo = other.getMemo();
    if (this$memo == null ? other$memo != null : !this$memo.equals(other$memo)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$number = this.getNumber();
    final java.lang.Object other$number = other.getNumber();
    if (this$number == null ? other$number != null : !this$number.equals(other$number)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$pdf = this.getPdf();
    final java.lang.Object other$pdf = other.getPdf();
    if (this$pdf == null ? other$pdf != null : !this$pdf.equals(other$pdf)) return false;
    final java.lang.Object this$reason = this.getReason();
    final java.lang.Object other$reason = other.getReason();
    if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) return false;
    final java.lang.Object this$refund = this.getRefund();
    final java.lang.Object other$refund = other.getRefund();
    if (this$refund == null ? other$refund != null : !this$refund.equals(other$refund)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$type = this.getType();
    final java.lang.Object other$type = other.getType();
    if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof CreditNote;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $amount = this.getAmount();
    result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $customer = this.getCustomer();
    result = result * PRIME + ($customer == null ? 43 : $customer.hashCode());
    final java.lang.Object $customerBalanceTransaction = this.getCustomerBalanceTransaction();
    result = result * PRIME + ($customerBalanceTransaction == null ? 43 : $customerBalanceTransaction.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $invoice = this.getInvoice();
    result = result * PRIME + ($invoice == null ? 43 : $invoice.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $memo = this.getMemo();
    result = result * PRIME + ($memo == null ? 43 : $memo.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $number = this.getNumber();
    result = result * PRIME + ($number == null ? 43 : $number.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $pdf = this.getPdf();
    result = result * PRIME + ($pdf == null ? 43 : $pdf.hashCode());
    final java.lang.Object $reason = this.getReason();
    result = result * PRIME + ($reason == null ? 43 : $reason.hashCode());
    final java.lang.Object $refund = this.getRefund();
    result = result * PRIME + ($refund == null ? 43 : $refund.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $type = this.getType();
    result = result * PRIME + ($type == null ? 43 : $type.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
