// Generated by delombok at Tue Jul 09 11:45:29 PDT 2019
// Generated by com.stripe.generator.entity.SdkBuilder
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.CustomerBalanceTransactionsParams;
import com.stripe.param.CustomerCreateParams;
import com.stripe.param.CustomerListParams;
import com.stripe.param.CustomerRetrieveParams;
import com.stripe.param.CustomerUpdateParams;
import java.util.List;
import java.util.Map;

public class Customer extends ApiResource implements HasId, MetadataStore<Customer> {
  /**
   * This field has been renamed to `balance` and will be removed in a future API version.
   */
  @SerializedName("account_balance")
  Long accountBalance;
  /**
   * The customer's address.
   */
  @SerializedName("address")
  Address address;
  /**
   * Current balance, if any, being stored on the customer. If negative, the customer has credit to
   * apply to their next invoice. If positive, the customer has an amount owed that will be added to
   * their next invoice. The balance does not refer to any unpaid invoices; it solely takes into
   * account amounts that have yet to be successfully applied to any invoice. This balance is only
   * taken into account as invoices are finalized.
   */
  @SerializedName("balance")
  Long balance;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Three-letter [ISO code for the currency](https://stripe.com/docs/currencies) the customer can
   * be charged in for recurring billing purposes.
   */
  @SerializedName("currency")
  String currency;
  /**
   * ID of the default payment source for the customer.
   */
  @SerializedName("default_source")
  ExpandableField<PaymentSource> defaultSource;
  /**
   * Always true for a deleted object.
   */
  @SerializedName("deleted")
  Boolean deleted;
  /**
   * When the customer's latest invoice is billed by charging automatically, delinquent is true if
   * the invoice's latest charge is failed. When the customer's latest invoice is billed by sending
   * an invoice, delinquent is true if the invoice is not paid by its due date.
   */
  @SerializedName("delinquent")
  Boolean delinquent;
  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @SerializedName("description")
  String description;
  /**
   * Describes the current discount active on the customer, if there is one.
   */
  @SerializedName("discount")
  Discount discount;
  /**
   * The customer's email address.
   */
  @SerializedName("email")
  String email;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * The prefix for the customer used to generate unique invoice numbers.
   */
  @SerializedName("invoice_prefix")
  String invoicePrefix;
  @SerializedName("invoice_settings")
  InvoiceSettings invoiceSettings;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object
   * exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * The customer's full name or business name.
   */
  @SerializedName("name")
  String name;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  @SerializedName("object")
  String object;
  /**
   * The customer's phone number.
   */
  @SerializedName("phone")
  String phone;
  /**
   * The customer's preferred locales (languages), ordered by preference.
   */
  @SerializedName("preferred_locales")
  List<String> preferredLocales;
  /**
   * Mailing and shipping address for the customer. Appears on invoices emailed to this customer.
   */
  @SerializedName("shipping")
  ShippingDetails shipping;
  /**
   * The customer's payment sources, if any.
   */
  @SerializedName("sources")
  PaymentSourceCollection sources;
  /**
   * The customer's current subscriptions, if any.
   */
  @SerializedName("subscriptions")
  SubscriptionCollection subscriptions;
  /**
   * Describes the customer's tax exemption status. One of `none`, `exempt`, or `reverse`. When set
   * to `reverse`, invoice and receipt PDFs include the text **"Reverse charge"**.
   */
  @SerializedName("tax_exempt")
  String taxExempt;
  /**
   * The customer's tax IDs.
   */
  @SerializedName("tax_ids")
  TaxIdCollection taxIds;
  /**
   * The customer's tax information. Appears on invoices emailed to this customer. This field has
   * been deprecated and will be removed in a future API version, for further information view the
   * [migration
   * guide](https://stripe.com/docs/billing/migration/taxes#moving-from-taxinfo-to-customer-tax-ids).
   */
  @SerializedName("tax_info")
  TaxInfo taxInfo;
  /**
   * Describes the status of looking up the tax ID provided in `tax_info`. This field has been
   * deprecated and will be removed in a future API version, for further information view the
   * [migration
   * guide](https://stripe.com/docs/billing/migration/taxes#moving-from-taxinfo-to-customer-tax-ids).
   */
  @SerializedName("tax_info_verification")
  TaxInfoVerification taxInfoVerification;

  /**
   * Get id of expandable `defaultSource` object.
   */
  public String getDefaultSource() {
    return (this.defaultSource != null) ? this.defaultSource.getId() : null;
  }

  public void setDefaultSource(String id) {
    this.defaultSource = ApiResource.setExpandableFieldId(id, this.defaultSource);
  }

  /**
   * Get expanded `defaultSource`.
   */
  public PaymentSource getDefaultSourceObject() {
    return (this.defaultSource != null) ? this.defaultSource.getExpanded() : null;
  }

  public void setDefaultSourceObject(PaymentSource expandableObject) {
    this.defaultSource = new ExpandableField<PaymentSource>(expandableObject.getId(), expandableObject);
  }

  /**
   * Returns a list of your customers. The customers are returned sorted by creation date, with the
   * most recent customers appearing first.
   */
  public static CustomerCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of your customers. The customers are returned sorted by creation date, with the
   * most recent customers appearing first.
   */
  public static CustomerCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/customers");
    return requestCollection(url, params, CustomerCollection.class, options);
  }

  /**
   * Returns a list of your customers. The customers are returned sorted by creation date, with the
   * most recent customers appearing first.
   */
  public static CustomerCollection list(CustomerListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of your customers. The customers are returned sorted by creation date, with the
   * most recent customers appearing first.
   */
  public static CustomerCollection list(CustomerListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/customers");
    return requestCollection(url, params, CustomerCollection.class, options);
  }

  /**
   * Creates a new customer object.
   */
  public static Customer create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a new customer object.
   */
  public static Customer create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/customers");
    return request(ApiResource.RequestMethod.POST, url, params, Customer.class, options);
  }

  /**
   * Creates a new customer object.
   */
  public static Customer create(CustomerCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a new customer object.
   */
  public static Customer create(CustomerCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/customers");
    return request(ApiResource.RequestMethod.POST, url, params, Customer.class, options);
  }

  /**
   * Retrieves the details of an existing customer. You need only supply the unique customer
   * identifier that was returned upon customer creation.
   */
  public static Customer retrieve(String customer) throws StripeException {
    return retrieve(customer, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the details of an existing customer. You need only supply the unique customer
   * identifier that was returned upon customer creation.
   */
  public static Customer retrieve(String customer, RequestOptions options) throws StripeException {
    return retrieve(customer, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the details of an existing customer. You need only supply the unique customer
   * identifier that was returned upon customer creation.
   */
  public static Customer retrieve(String customer, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s", ApiResource.urlEncodeId(customer)));
    return request(ApiResource.RequestMethod.GET, url, params, Customer.class, options);
  }

  /**
   * Retrieves the details of an existing customer. You need only supply the unique customer
   * identifier that was returned upon customer creation.
   */
  public static Customer retrieve(String customer, CustomerRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s", ApiResource.urlEncodeId(customer)));
    return request(ApiResource.RequestMethod.GET, url, params, Customer.class, options);
  }

  /**
   * Updates the specified customer by setting the values of the parameters passed. Any parameters
   * not provided will be left unchanged. For example, if you pass the <strong>source</strong>
   * parameter, that becomes the customer’s active source (e.g., a card) to be used for all charges
   * in the future. When you update a customer to a new valid card source by passing the
   * <strong>source</strong> parameter: for each of the customer’s current subscriptions, if the
   * subscription bills automatically and is in the <code>past_due</code> state, then the latest
   * open invoice for the subscription with automatic collection enabled will be retried. This retry
   * will not count as an automatic retry, and will not affect the next regularly scheduled payment
   * for the invoice. Changing the <strong>default_source</strong> for a customer will not trigger
   * this behavior.
   *
   * <p>This request accepts mostly the same arguments as the customer creation call.
   */
  @Override
  public Customer update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the specified customer by setting the values of the parameters passed. Any parameters
   * not provided will be left unchanged. For example, if you pass the <strong>source</strong>
   * parameter, that becomes the customer’s active source (e.g., a card) to be used for all charges
   * in the future. When you update a customer to a new valid card source by passing the
   * <strong>source</strong> parameter: for each of the customer’s current subscriptions, if the
   * subscription bills automatically and is in the <code>past_due</code> state, then the latest
   * open invoice for the subscription with automatic collection enabled will be retried. This retry
   * will not count as an automatic retry, and will not affect the next regularly scheduled payment
   * for the invoice. Changing the <strong>default_source</strong> for a customer will not trigger
   * this behavior.
   *
   * <p>This request accepts mostly the same arguments as the customer creation call.
   */
  @Override
  public Customer update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s", ApiResource.urlEncodeId(this.getId())));
    return request(ApiResource.RequestMethod.POST, url, params, Customer.class, options);
  }

  /**
   * Updates the specified customer by setting the values of the parameters passed. Any parameters
   * not provided will be left unchanged. For example, if you pass the <strong>source</strong>
   * parameter, that becomes the customer’s active source (e.g., a card) to be used for all charges
   * in the future. When you update a customer to a new valid card source by passing the
   * <strong>source</strong> parameter: for each of the customer’s current subscriptions, if the
   * subscription bills automatically and is in the <code>past_due</code> state, then the latest
   * open invoice for the subscription with automatic collection enabled will be retried. This retry
   * will not count as an automatic retry, and will not affect the next regularly scheduled payment
   * for the invoice. Changing the <strong>default_source</strong> for a customer will not trigger
   * this behavior.
   *
   * <p>This request accepts mostly the same arguments as the customer creation call.
   */
  public Customer update(CustomerUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the specified customer by setting the values of the parameters passed. Any parameters
   * not provided will be left unchanged. For example, if you pass the <strong>source</strong>
   * parameter, that becomes the customer’s active source (e.g., a card) to be used for all charges
   * in the future. When you update a customer to a new valid card source by passing the
   * <strong>source</strong> parameter: for each of the customer’s current subscriptions, if the
   * subscription bills automatically and is in the <code>past_due</code> state, then the latest
   * open invoice for the subscription with automatic collection enabled will be retried. This retry
   * will not count as an automatic retry, and will not affect the next regularly scheduled payment
   * for the invoice. Changing the <strong>default_source</strong> for a customer will not trigger
   * this behavior.
   *
   * <p>This request accepts mostly the same arguments as the customer creation call.
   */
  public Customer update(CustomerUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s", ApiResource.urlEncodeId(this.getId())));
    return request(ApiResource.RequestMethod.POST, url, params, Customer.class, options);
  }

  /**
   * Permanently deletes a customer. It cannot be undone. Also immediately cancels any active
   * subscriptions on the customer.
   */
  public Customer delete() throws StripeException {
    return delete((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Permanently deletes a customer. It cannot be undone. Also immediately cancels any active
   * subscriptions on the customer.
   */
  public Customer delete(RequestOptions options) throws StripeException {
    return delete((Map<String, Object>) null, options);
  }

  /**
   * Permanently deletes a customer. It cannot be undone. Also immediately cancels any active
   * subscriptions on the customer.
   */
  public Customer delete(Map<String, Object> params) throws StripeException {
    return delete(params, (RequestOptions) null);
  }

  /**
   * Permanently deletes a customer. It cannot be undone. Also immediately cancels any active
   * subscriptions on the customer.
   */
  public Customer delete(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s", ApiResource.urlEncodeId(this.getId())));
    return request(ApiResource.RequestMethod.DELETE, url, params, Customer.class, options);
  }

  /**
   * Retrieves the list of transactions that updated the customer’s <a
   * href="/docs/api/customers/object#customer_object-balance"><code>balance</code></a>.
   */
  public CustomerBalanceTransactionCollection balanceTransactions() throws StripeException {
    return balanceTransactions((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the list of transactions that updated the customer’s <a
   * href="/docs/api/customers/object#customer_object-balance"><code>balance</code></a>.
   */
  public CustomerBalanceTransactionCollection balanceTransactions(Map<String, Object> params) throws StripeException {
    return balanceTransactions(params, (RequestOptions) null);
  }

  /**
   * Retrieves the list of transactions that updated the customer’s <a
   * href="/docs/api/customers/object#customer_object-balance"><code>balance</code></a>.
   */
  public CustomerBalanceTransactionCollection balanceTransactions(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s/balance_transactions", ApiResource.urlEncodeId(this.getId())));
    return requestCollection(url, params, CustomerBalanceTransactionCollection.class, options);
  }

  /**
   * Retrieves the list of transactions that updated the customer’s <a
   * href="/docs/api/customers/object#customer_object-balance"><code>balance</code></a>.
   */
  public CustomerBalanceTransactionCollection balanceTransactions(CustomerBalanceTransactionsParams params) throws StripeException {
    return balanceTransactions(params, (RequestOptions) null);
  }

  /**
   * Retrieves the list of transactions that updated the customer’s <a
   * href="/docs/api/customers/object#customer_object-balance"><code>balance</code></a>.
   */
  public CustomerBalanceTransactionCollection balanceTransactions(CustomerBalanceTransactionsParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s/balance_transactions", ApiResource.urlEncodeId(this.getId())));
    return requestCollection(url, params, CustomerBalanceTransactionCollection.class, options);
  }

  /**
   * Removes the currently applied discount on a customer.
   */
  public Discount deleteDiscount() throws StripeException {
    return deleteDiscount((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Removes the currently applied discount on a customer.
   */
  public Discount deleteDiscount(Map<String, Object> params) throws StripeException {
    return deleteDiscount(params, (RequestOptions) null);
  }

  /**
   * Removes the currently applied discount on a customer.
   */
  public Discount deleteDiscount(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s/discount", ApiResource.urlEncodeId(this.getId())));
    return request(ApiResource.RequestMethod.DELETE, url, params, Discount.class, options);
  }


  public static class InvoiceSettings extends StripeObject {
    /**
     * Default custom fields to be displayed on invoices for this customer.
     */
    @SerializedName("custom_fields")
    List<Invoice.CustomField> customFields;
    /**
     * ID of the default payment method used for subscriptions and invoices for the customer.
     */
    @SerializedName("default_payment_method")
    ExpandableField<PaymentMethod> defaultPaymentMethod;
    /**
     * Default footer to be displayed on invoices for this customer.
     */
    @SerializedName("footer")
    String footer;

    /**
     * Get id of expandable `defaultPaymentMethod` object.
     */
    public String getDefaultPaymentMethod() {
      return (this.defaultPaymentMethod != null) ? this.defaultPaymentMethod.getId() : null;
    }

    public void setDefaultPaymentMethod(String id) {
      this.defaultPaymentMethod = ApiResource.setExpandableFieldId(id, this.defaultPaymentMethod);
    }

    /**
     * Get expanded `defaultPaymentMethod`.
     */
    public PaymentMethod getDefaultPaymentMethodObject() {
      return (this.defaultPaymentMethod != null) ? this.defaultPaymentMethod.getExpanded() : null;
    }

    public void setDefaultPaymentMethodObject(PaymentMethod expandableObject) {
      this.defaultPaymentMethod = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
    }

    /**
     * Default custom fields to be displayed on invoices for this customer.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Invoice.CustomField> getCustomFields() {
      return this.customFields;
    }

    /**
     * Default footer to be displayed on invoices for this customer.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getFooter() {
      return this.footer;
    }

    /**
     * Default custom fields to be displayed on invoices for this customer.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCustomFields(final List<Invoice.CustomField> customFields) {
      this.customFields = customFields;
    }

    /**
     * Default footer to be displayed on invoices for this customer.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFooter(final String footer) {
      this.footer = footer;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Customer.InvoiceSettings)) return false;
      final Customer.InvoiceSettings other = (Customer.InvoiceSettings) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$customFields = this.getCustomFields();
      final java.lang.Object other$customFields = other.getCustomFields();
      if (this$customFields == null ? other$customFields != null : !this$customFields.equals(other$customFields)) return false;
      final java.lang.Object this$defaultPaymentMethod = this.getDefaultPaymentMethod();
      final java.lang.Object other$defaultPaymentMethod = other.getDefaultPaymentMethod();
      if (this$defaultPaymentMethod == null ? other$defaultPaymentMethod != null : !this$defaultPaymentMethod.equals(other$defaultPaymentMethod)) return false;
      final java.lang.Object this$footer = this.getFooter();
      final java.lang.Object other$footer = other.getFooter();
      if (this$footer == null ? other$footer != null : !this$footer.equals(other$footer)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Customer.InvoiceSettings;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $customFields = this.getCustomFields();
      result = result * PRIME + ($customFields == null ? 43 : $customFields.hashCode());
      final java.lang.Object $defaultPaymentMethod = this.getDefaultPaymentMethod();
      result = result * PRIME + ($defaultPaymentMethod == null ? 43 : $defaultPaymentMethod.hashCode());
      final java.lang.Object $footer = this.getFooter();
      result = result * PRIME + ($footer == null ? 43 : $footer.hashCode());
      return result;
    }
  }


  public static class TaxInfo extends StripeObject {
    /**
     * The customer's tax ID number.
     */
    @SerializedName("tax_id")
    String taxId;
    /**
     * The type of ID number.
     */
    @SerializedName("type")
    String type;

    /**
     * The customer's tax ID number.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTaxId() {
      return this.taxId;
    }

    /**
     * The type of ID number.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    /**
     * The customer's tax ID number.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTaxId(final String taxId) {
      this.taxId = taxId;
    }

    /**
     * The type of ID number.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Customer.TaxInfo)) return false;
      final Customer.TaxInfo other = (Customer.TaxInfo) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$taxId = this.getTaxId();
      final java.lang.Object other$taxId = other.getTaxId();
      if (this$taxId == null ? other$taxId != null : !this$taxId.equals(other$taxId)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Customer.TaxInfo;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $taxId = this.getTaxId();
      result = result * PRIME + ($taxId == null ? 43 : $taxId.hashCode());
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      return result;
    }
  }


  public static class TaxInfoVerification extends StripeObject {
    /**
     * The state of verification for this customer. Possible values are `unverified`, `pending`, or
     * `verified`.
     */
    @SerializedName("status")
    String status;
    /** The official name associated with the tax ID returned from the external provider. */
    @SerializedName("verified_name")
    String verifiedName;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatus() {
      return this.status;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getVerifiedName() {
      return this.verifiedName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatus(final String status) {
      this.status = status;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setVerifiedName(final String verifiedName) {
      this.verifiedName = verifiedName;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Customer.TaxInfoVerification)) return false;
      final Customer.TaxInfoVerification other = (Customer.TaxInfoVerification) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$status = this.getStatus();
      final java.lang.Object other$status = other.getStatus();
      if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
      final java.lang.Object this$verifiedName = this.getVerifiedName();
      final java.lang.Object other$verifiedName = other.getVerifiedName();
      if (this$verifiedName == null ? other$verifiedName != null : !this$verifiedName.equals(other$verifiedName)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Customer.TaxInfoVerification;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $status = this.getStatus();
      result = result * PRIME + ($status == null ? 43 : $status.hashCode());
      final java.lang.Object $verifiedName = this.getVerifiedName();
      result = result * PRIME + ($verifiedName == null ? 43 : $verifiedName.hashCode());
      return result;
    }
  }

  /**
   * This field has been renamed to `balance` and will be removed in a future API version.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAccountBalance() {
    return this.accountBalance;
  }

  /**
   * The customer's address.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Address getAddress() {
    return this.address;
  }

  /**
   * Current balance, if any, being stored on the customer. If negative, the customer has credit to
   * apply to their next invoice. If positive, the customer has an amount owed that will be added to
   * their next invoice. The balance does not refer to any unpaid invoices; it solely takes into
   * account amounts that have yet to be successfully applied to any invoice. This balance is only
   * taken into account as invoices are finalized.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getBalance() {
    return this.balance;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Three-letter [ISO code for the currency](https://stripe.com/docs/currencies) the customer can
   * be charged in for recurring billing purposes.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  /**
   * Always true for a deleted object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getDeleted() {
    return this.deleted;
  }

  /**
   * When the customer's latest invoice is billed by charging automatically, delinquent is true if
   * the invoice's latest charge is failed. When the customer's latest invoice is billed by sending
   * an invoice, delinquent is true if the invoice is not paid by its due date.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getDelinquent() {
    return this.delinquent;
  }

  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDescription() {
    return this.description;
  }

  /**
   * Describes the current discount active on the customer, if there is one.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Discount getDiscount() {
    return this.discount;
  }

  /**
   * The customer's email address.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getEmail() {
    return this.email;
  }

  /**
   * The prefix for the customer used to generate unique invoice numbers.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getInvoicePrefix() {
    return this.invoicePrefix;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public InvoiceSettings getInvoiceSettings() {
    return this.invoiceSettings;
  }

  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object
   * exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * The customer's full name or business name.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getName() {
    return this.name;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * The customer's phone number.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getPhone() {
    return this.phone;
  }

  /**
   * The customer's preferred locales (languages), ordered by preference.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<String> getPreferredLocales() {
    return this.preferredLocales;
  }

  /**
   * Mailing and shipping address for the customer. Appears on invoices emailed to this customer.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ShippingDetails getShipping() {
    return this.shipping;
  }

  /**
   * The customer's payment sources, if any.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public PaymentSourceCollection getSources() {
    return this.sources;
  }

  /**
   * The customer's current subscriptions, if any.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public SubscriptionCollection getSubscriptions() {
    return this.subscriptions;
  }

  /**
   * Describes the customer's tax exemption status. One of `none`, `exempt`, or `reverse`. When set
   * to `reverse`, invoice and receipt PDFs include the text **"Reverse charge"**.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getTaxExempt() {
    return this.taxExempt;
  }

  /**
   * The customer's tax IDs.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public TaxIdCollection getTaxIds() {
    return this.taxIds;
  }

  /**
   * The customer's tax information. Appears on invoices emailed to this customer. This field has
   * been deprecated and will be removed in a future API version, for further information view the
   * [migration
   * guide](https://stripe.com/docs/billing/migration/taxes#moving-from-taxinfo-to-customer-tax-ids).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public TaxInfo getTaxInfo() {
    return this.taxInfo;
  }

  /**
   * Describes the status of looking up the tax ID provided in `tax_info`. This field has been
   * deprecated and will be removed in a future API version, for further information view the
   * [migration
   * guide](https://stripe.com/docs/billing/migration/taxes#moving-from-taxinfo-to-customer-tax-ids).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public TaxInfoVerification getTaxInfoVerification() {
    return this.taxInfoVerification;
  }

  /**
   * This field has been renamed to `balance` and will be removed in a future API version.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAccountBalance(final Long accountBalance) {
    this.accountBalance = accountBalance;
  }

  /**
   * The customer's address.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAddress(final Address address) {
    this.address = address;
  }

  /**
   * Current balance, if any, being stored on the customer. If negative, the customer has credit to
   * apply to their next invoice. If positive, the customer has an amount owed that will be added to
   * their next invoice. The balance does not refer to any unpaid invoices; it solely takes into
   * account amounts that have yet to be successfully applied to any invoice. This balance is only
   * taken into account as invoices are finalized.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBalance(final Long balance) {
    this.balance = balance;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Three-letter [ISO code for the currency](https://stripe.com/docs/currencies) the customer can
   * be charged in for recurring billing purposes.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  /**
   * Always true for a deleted object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeleted(final Boolean deleted) {
    this.deleted = deleted;
  }

  /**
   * When the customer's latest invoice is billed by charging automatically, delinquent is true if
   * the invoice's latest charge is failed. When the customer's latest invoice is billed by sending
   * an invoice, delinquent is true if the invoice is not paid by its due date.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDelinquent(final Boolean delinquent) {
    this.delinquent = delinquent;
  }

  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDescription(final String description) {
    this.description = description;
  }

  /**
   * Describes the current discount active on the customer, if there is one.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDiscount(final Discount discount) {
    this.discount = discount;
  }

  /**
   * The customer's email address.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEmail(final String email) {
    this.email = email;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * The prefix for the customer used to generate unique invoice numbers.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setInvoicePrefix(final String invoicePrefix) {
    this.invoicePrefix = invoicePrefix;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setInvoiceSettings(final InvoiceSettings invoiceSettings) {
    this.invoiceSettings = invoiceSettings;
  }

  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object
   * exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * The customer's full name or business name.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setName(final String name) {
    this.name = name;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * The customer's phone number.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPhone(final String phone) {
    this.phone = phone;
  }

  /**
   * The customer's preferred locales (languages), ordered by preference.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPreferredLocales(final List<String> preferredLocales) {
    this.preferredLocales = preferredLocales;
  }

  /**
   * Mailing and shipping address for the customer. Appears on invoices emailed to this customer.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setShipping(final ShippingDetails shipping) {
    this.shipping = shipping;
  }

  /**
   * The customer's payment sources, if any.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSources(final PaymentSourceCollection sources) {
    this.sources = sources;
  }

  /**
   * The customer's current subscriptions, if any.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSubscriptions(final SubscriptionCollection subscriptions) {
    this.subscriptions = subscriptions;
  }

  /**
   * Describes the customer's tax exemption status. One of `none`, `exempt`, or `reverse`. When set
   * to `reverse`, invoice and receipt PDFs include the text **"Reverse charge"**.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTaxExempt(final String taxExempt) {
    this.taxExempt = taxExempt;
  }

  /**
   * The customer's tax IDs.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTaxIds(final TaxIdCollection taxIds) {
    this.taxIds = taxIds;
  }

  /**
   * The customer's tax information. Appears on invoices emailed to this customer. This field has
   * been deprecated and will be removed in a future API version, for further information view the
   * [migration
   * guide](https://stripe.com/docs/billing/migration/taxes#moving-from-taxinfo-to-customer-tax-ids).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTaxInfo(final TaxInfo taxInfo) {
    this.taxInfo = taxInfo;
  }

  /**
   * Describes the status of looking up the tax ID provided in `tax_info`. This field has been
   * deprecated and will be removed in a future API version, for further information view the
   * [migration
   * guide](https://stripe.com/docs/billing/migration/taxes#moving-from-taxinfo-to-customer-tax-ids).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTaxInfoVerification(final TaxInfoVerification taxInfoVerification) {
    this.taxInfoVerification = taxInfoVerification;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Customer)) return false;
    final Customer other = (Customer) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$accountBalance = this.getAccountBalance();
    final java.lang.Object other$accountBalance = other.getAccountBalance();
    if (this$accountBalance == null ? other$accountBalance != null : !this$accountBalance.equals(other$accountBalance)) return false;
    final java.lang.Object this$address = this.getAddress();
    final java.lang.Object other$address = other.getAddress();
    if (this$address == null ? other$address != null : !this$address.equals(other$address)) return false;
    final java.lang.Object this$balance = this.getBalance();
    final java.lang.Object other$balance = other.getBalance();
    if (this$balance == null ? other$balance != null : !this$balance.equals(other$balance)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$defaultSource = this.getDefaultSource();
    final java.lang.Object other$defaultSource = other.getDefaultSource();
    if (this$defaultSource == null ? other$defaultSource != null : !this$defaultSource.equals(other$defaultSource)) return false;
    final java.lang.Object this$deleted = this.getDeleted();
    final java.lang.Object other$deleted = other.getDeleted();
    if (this$deleted == null ? other$deleted != null : !this$deleted.equals(other$deleted)) return false;
    final java.lang.Object this$delinquent = this.getDelinquent();
    final java.lang.Object other$delinquent = other.getDelinquent();
    if (this$delinquent == null ? other$delinquent != null : !this$delinquent.equals(other$delinquent)) return false;
    final java.lang.Object this$description = this.getDescription();
    final java.lang.Object other$description = other.getDescription();
    if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
    final java.lang.Object this$discount = this.getDiscount();
    final java.lang.Object other$discount = other.getDiscount();
    if (this$discount == null ? other$discount != null : !this$discount.equals(other$discount)) return false;
    final java.lang.Object this$email = this.getEmail();
    final java.lang.Object other$email = other.getEmail();
    if (this$email == null ? other$email != null : !this$email.equals(other$email)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$invoicePrefix = this.getInvoicePrefix();
    final java.lang.Object other$invoicePrefix = other.getInvoicePrefix();
    if (this$invoicePrefix == null ? other$invoicePrefix != null : !this$invoicePrefix.equals(other$invoicePrefix)) return false;
    final java.lang.Object this$invoiceSettings = this.getInvoiceSettings();
    final java.lang.Object other$invoiceSettings = other.getInvoiceSettings();
    if (this$invoiceSettings == null ? other$invoiceSettings != null : !this$invoiceSettings.equals(other$invoiceSettings)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$name = this.getName();
    final java.lang.Object other$name = other.getName();
    if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$phone = this.getPhone();
    final java.lang.Object other$phone = other.getPhone();
    if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) return false;
    final java.lang.Object this$preferredLocales = this.getPreferredLocales();
    final java.lang.Object other$preferredLocales = other.getPreferredLocales();
    if (this$preferredLocales == null ? other$preferredLocales != null : !this$preferredLocales.equals(other$preferredLocales)) return false;
    final java.lang.Object this$shipping = this.getShipping();
    final java.lang.Object other$shipping = other.getShipping();
    if (this$shipping == null ? other$shipping != null : !this$shipping.equals(other$shipping)) return false;
    final java.lang.Object this$sources = this.getSources();
    final java.lang.Object other$sources = other.getSources();
    if (this$sources == null ? other$sources != null : !this$sources.equals(other$sources)) return false;
    final java.lang.Object this$subscriptions = this.getSubscriptions();
    final java.lang.Object other$subscriptions = other.getSubscriptions();
    if (this$subscriptions == null ? other$subscriptions != null : !this$subscriptions.equals(other$subscriptions)) return false;
    final java.lang.Object this$taxExempt = this.getTaxExempt();
    final java.lang.Object other$taxExempt = other.getTaxExempt();
    if (this$taxExempt == null ? other$taxExempt != null : !this$taxExempt.equals(other$taxExempt)) return false;
    final java.lang.Object this$taxIds = this.getTaxIds();
    final java.lang.Object other$taxIds = other.getTaxIds();
    if (this$taxIds == null ? other$taxIds != null : !this$taxIds.equals(other$taxIds)) return false;
    final java.lang.Object this$taxInfo = this.getTaxInfo();
    final java.lang.Object other$taxInfo = other.getTaxInfo();
    if (this$taxInfo == null ? other$taxInfo != null : !this$taxInfo.equals(other$taxInfo)) return false;
    final java.lang.Object this$taxInfoVerification = this.getTaxInfoVerification();
    final java.lang.Object other$taxInfoVerification = other.getTaxInfoVerification();
    if (this$taxInfoVerification == null ? other$taxInfoVerification != null : !this$taxInfoVerification.equals(other$taxInfoVerification)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Customer;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $accountBalance = this.getAccountBalance();
    result = result * PRIME + ($accountBalance == null ? 43 : $accountBalance.hashCode());
    final java.lang.Object $address = this.getAddress();
    result = result * PRIME + ($address == null ? 43 : $address.hashCode());
    final java.lang.Object $balance = this.getBalance();
    result = result * PRIME + ($balance == null ? 43 : $balance.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $defaultSource = this.getDefaultSource();
    result = result * PRIME + ($defaultSource == null ? 43 : $defaultSource.hashCode());
    final java.lang.Object $deleted = this.getDeleted();
    result = result * PRIME + ($deleted == null ? 43 : $deleted.hashCode());
    final java.lang.Object $delinquent = this.getDelinquent();
    result = result * PRIME + ($delinquent == null ? 43 : $delinquent.hashCode());
    final java.lang.Object $description = this.getDescription();
    result = result * PRIME + ($description == null ? 43 : $description.hashCode());
    final java.lang.Object $discount = this.getDiscount();
    result = result * PRIME + ($discount == null ? 43 : $discount.hashCode());
    final java.lang.Object $email = this.getEmail();
    result = result * PRIME + ($email == null ? 43 : $email.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $invoicePrefix = this.getInvoicePrefix();
    result = result * PRIME + ($invoicePrefix == null ? 43 : $invoicePrefix.hashCode());
    final java.lang.Object $invoiceSettings = this.getInvoiceSettings();
    result = result * PRIME + ($invoiceSettings == null ? 43 : $invoiceSettings.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $name = this.getName();
    result = result * PRIME + ($name == null ? 43 : $name.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $phone = this.getPhone();
    result = result * PRIME + ($phone == null ? 43 : $phone.hashCode());
    final java.lang.Object $preferredLocales = this.getPreferredLocales();
    result = result * PRIME + ($preferredLocales == null ? 43 : $preferredLocales.hashCode());
    final java.lang.Object $shipping = this.getShipping();
    result = result * PRIME + ($shipping == null ? 43 : $shipping.hashCode());
    final java.lang.Object $sources = this.getSources();
    result = result * PRIME + ($sources == null ? 43 : $sources.hashCode());
    final java.lang.Object $subscriptions = this.getSubscriptions();
    result = result * PRIME + ($subscriptions == null ? 43 : $subscriptions.hashCode());
    final java.lang.Object $taxExempt = this.getTaxExempt();
    result = result * PRIME + ($taxExempt == null ? 43 : $taxExempt.hashCode());
    final java.lang.Object $taxIds = this.getTaxIds();
    result = result * PRIME + ($taxIds == null ? 43 : $taxIds.hashCode());
    final java.lang.Object $taxInfo = this.getTaxInfo();
    result = result * PRIME + ($taxInfo == null ? 43 : $taxInfo.hashCode());
    final java.lang.Object $taxInfoVerification = this.getTaxInfoVerification();
    result = result * PRIME + ($taxInfoVerification == null ? 43 : $taxInfoVerification.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
