/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class CreditNoteCreateParams
extends ApiRequestParams {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="credit_amount")
    Long creditAmount;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="_stripe_java_extra_param_key")
    Map<String, Object> extraParams;
    @SerializedName(value="invoice")
    String invoice;
    @SerializedName(value="memo")
    String memo;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="reason")
    Reason reason;
    @SerializedName(value="refund")
    String refund;
    @SerializedName(value="refund_amount")
    Long refundAmount;

    private CreditNoteCreateParams(Long amount, Long creditAmount, List<String> expand, Map<String, Object> extraParams, String invoice, String memo, Map<String, String> metadata, Reason reason, String refund, Long refundAmount) {
        this.amount = amount;
        this.creditAmount = creditAmount;
        this.expand = expand;
        this.extraParams = extraParams;
        this.invoice = invoice;
        this.memo = memo;
        this.metadata = metadata;
        this.reason = reason;
        this.refund = refund;
        this.refundAmount = refundAmount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Reason implements ApiRequestParams.EnumParam
    {
        DUPLICATE("duplicate"),
        FRAUDULENT("fraudulent"),
        ORDER_CHANGE("order_change"),
        PRODUCT_UNSATISFACTORY("product_unsatisfactory");

        private final String value;

        private Reason(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class Builder {
        private Long amount;
        private Long creditAmount;
        private List<String> expand;
        private Map<String, Object> extraParams;
        private String invoice;
        private String memo;
        private Map<String, String> metadata;
        private Reason reason;
        private String refund;
        private Long refundAmount;

        public CreditNoteCreateParams build() {
            return new CreditNoteCreateParams(this.amount, this.creditAmount, this.expand, this.extraParams, this.invoice, this.memo, this.metadata, this.reason, this.refund, this.refundAmount);
        }

        public Builder setAmount(Long amount) {
            this.amount = amount;
            return this;
        }

        public Builder setCreditAmount(Long creditAmount) {
            this.creditAmount = creditAmount;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.put(key, value);
            return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.putAll(map);
            return this;
        }

        public Builder setInvoice(String invoice) {
            this.invoice = invoice;
            return this;
        }

        public Builder setMemo(String memo) {
            this.memo = memo;
            return this;
        }

        public Builder putMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder putAllMetadata(Map<String, String> map) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.putAll(map);
            return this;
        }

        public Builder setReason(Reason reason) {
            this.reason = reason;
            return this;
        }

        public Builder setRefund(String refund) {
            this.refund = refund;
            return this;
        }

        public Builder setRefundAmount(Long refundAmount) {
            this.refundAmount = refundAmount;
            return this;
        }
    }
}

