/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class RefundCreateParams
extends ApiRequestParams {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="charge")
    String charge;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="_stripe_java_extra_param_key")
    Map<String, Object> extraParams;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="reason")
    Reason reason;
    @SerializedName(value="refund_application_fee")
    Boolean refundApplicationFee;
    @SerializedName(value="reverse_transfer")
    Boolean reverseTransfer;

    private RefundCreateParams(Long amount, String charge, List<String> expand, Map<String, Object> extraParams, Map<String, String> metadata, Reason reason, Boolean refundApplicationFee, Boolean reverseTransfer) {
        this.amount = amount;
        this.charge = charge;
        this.expand = expand;
        this.extraParams = extraParams;
        this.metadata = metadata;
        this.reason = reason;
        this.refundApplicationFee = refundApplicationFee;
        this.reverseTransfer = reverseTransfer;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Reason implements ApiRequestParams.EnumParam
    {
        DUPLICATE("duplicate"),
        FRAUDULENT("fraudulent"),
        REQUESTED_BY_CUSTOMER("requested_by_customer");

        private final String value;

        private Reason(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class Builder {
        private Long amount;
        private String charge;
        private List<String> expand;
        private Map<String, Object> extraParams;
        private Map<String, String> metadata;
        private Reason reason;
        private Boolean refundApplicationFee;
        private Boolean reverseTransfer;

        public RefundCreateParams build() {
            return new RefundCreateParams(this.amount, this.charge, this.expand, this.extraParams, this.metadata, this.reason, this.refundApplicationFee, this.reverseTransfer);
        }

        public Builder setAmount(Long amount) {
            this.amount = amount;
            return this;
        }

        public Builder setCharge(String charge) {
            this.charge = charge;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.put(key, value);
            return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.putAll(map);
            return this;
        }

        public Builder putMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder putAllMetadata(Map<String, String> map) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.putAll(map);
            return this;
        }

        public Builder setReason(Reason reason) {
            this.reason = reason;
            return this;
        }

        public Builder setRefundApplicationFee(Boolean refundApplicationFee) {
            this.refundApplicationFee = refundApplicationFee;
            return this;
        }

        public Builder setReverseTransfer(Boolean reverseTransfer) {
            this.reverseTransfer = reverseTransfer;
            return this;
        }
    }
}

