/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.BalanceTransactionCollection;
import com.stripe.model.BalanceTransactionSource;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.BalanceTransactionListParams;
import com.stripe.param.BalanceTransactionRetrieveParams;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class BalanceTransaction
extends ApiResource
implements HasId {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="available_on")
    Long availableOn;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="exchange_rate")
    BigDecimal exchangeRate;
    @SerializedName(value="fee")
    Long fee;
    @SerializedName(value="fee_details")
    List<Fee> feeDetails;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="net")
    Long net;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="source")
    ExpandableField<BalanceTransactionSource> source;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="type")
    String type;

    public String getSource() {
        return this.source != null ? this.source.getId() : null;
    }

    public void setSource(String id) {
        this.source = ApiResource.setExpandableFieldId(id, this.source);
    }

    public BalanceTransactionSource getSourceObject() {
        return this.source != null ? this.source.getExpanded() : null;
    }

    public void setSourceObject(BalanceTransactionSource expandableObject) {
        this.source = new ExpandableField<BalanceTransactionSource>(expandableObject.getId(), expandableObject);
    }

    public static BalanceTransactionCollection list(Map<String, Object> params) throws StripeException {
        return BalanceTransaction.list(params, (RequestOptions)null);
    }

    public static BalanceTransactionCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/balance_transactions");
        return BalanceTransaction.requestCollection(url, params, BalanceTransactionCollection.class, options);
    }

    public static BalanceTransactionCollection list(BalanceTransactionListParams params) throws StripeException {
        return BalanceTransaction.list(params, (RequestOptions)null);
    }

    public static BalanceTransactionCollection list(BalanceTransactionListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/balance_transactions");
        return BalanceTransaction.requestCollection(url, params, BalanceTransactionCollection.class, options);
    }

    public static BalanceTransaction retrieve(String id) throws StripeException {
        return BalanceTransaction.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static BalanceTransaction retrieve(String id, RequestOptions options) throws StripeException {
        return BalanceTransaction.retrieve(id, (Map<String, Object>)null, options);
    }

    public static BalanceTransaction retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/balance_transactions/%s", ApiResource.urlEncodeId(id)));
        return BalanceTransaction.request(ApiResource.RequestMethod.GET, url, params, BalanceTransaction.class, options);
    }

    public static BalanceTransaction retrieve(String id, BalanceTransactionRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/balance_transactions/%s", ApiResource.urlEncodeId(id)));
        return BalanceTransaction.request(ApiResource.RequestMethod.GET, url, params, BalanceTransaction.class, options);
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Long getAvailableOn() {
        return this.availableOn;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public BigDecimal getExchangeRate() {
        return this.exchangeRate;
    }

    @Generated
    public Long getFee() {
        return this.fee;
    }

    @Generated
    public List<Fee> getFeeDetails() {
        return this.feeDetails;
    }

    @Generated
    public Long getNet() {
        return this.net;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setAvailableOn(Long availableOn) {
        this.availableOn = availableOn;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setExchangeRate(BigDecimal exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    @Generated
    public void setFee(Long fee) {
        this.fee = fee;
    }

    @Generated
    public void setFeeDetails(List<Fee> feeDetails) {
        this.feeDetails = feeDetails;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setNet(Long net) {
        this.net = net;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BalanceTransaction)) {
            return false;
        }
        BalanceTransaction other = (BalanceTransaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$availableOn = this.getAvailableOn();
        Long other$availableOn = other.getAvailableOn();
        if (this$availableOn == null ? other$availableOn != null : !((Object)this$availableOn).equals(other$availableOn)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        BigDecimal this$exchangeRate = this.getExchangeRate();
        BigDecimal other$exchangeRate = other.getExchangeRate();
        if (this$exchangeRate == null ? other$exchangeRate != null : !((Object)this$exchangeRate).equals(other$exchangeRate)) {
            return false;
        }
        Long this$fee = this.getFee();
        Long other$fee = other.getFee();
        if (this$fee == null ? other$fee != null : !((Object)this$fee).equals(other$fee)) {
            return false;
        }
        List<Fee> this$feeDetails = this.getFeeDetails();
        List<Fee> other$feeDetails = other.getFeeDetails();
        if (this$feeDetails == null ? other$feeDetails != null : !((Object)this$feeDetails).equals(other$feeDetails)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Long this$net = this.getNet();
        Long other$net = other.getNet();
        if (this$net == null ? other$net != null : !((Object)this$net).equals(other$net)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BalanceTransaction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $availableOn = this.getAvailableOn();
        result = result * 59 + ($availableOn == null ? 43 : ((Object)$availableOn).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        BigDecimal $exchangeRate = this.getExchangeRate();
        result = result * 59 + ($exchangeRate == null ? 43 : ((Object)$exchangeRate).hashCode());
        Long $fee = this.getFee();
        result = result * 59 + ($fee == null ? 43 : ((Object)$fee).hashCode());
        List<Fee> $feeDetails = this.getFeeDetails();
        result = result * 59 + ($feeDetails == null ? 43 : ((Object)$feeDetails).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Long $net = this.getNet();
        result = result * 59 + ($net == null ? 43 : ((Object)$net).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class Fee
    extends StripeObject {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="application")
        String application;
        @SerializedName(value="currency")
        String currency;
        @SerializedName(value="description")
        String description;
        @SerializedName(value="type")
        String type;

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public String getApplication() {
            return this.application;
        }

        @Generated
        public String getCurrency() {
            return this.currency;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public void setApplication(String application) {
            this.application = application;
        }

        @Generated
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Fee)) {
                return false;
            }
            Fee other = (Fee)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            String this$application = this.getApplication();
            String other$application = other.getApplication();
            if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
                return false;
            }
            String this$currency = this.getCurrency();
            String other$currency = other.getCurrency();
            if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Fee;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            String $application = this.getApplication();
            result = result * 59 + ($application == null ? 43 : $application.hashCode());
            String $currency = this.getCurrency();
            result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }
    }
}

