/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChargeCaptureParams
extends ApiRequestParams {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="application_fee")
    Long applicationFee;
    @SerializedName(value="application_fee_amount")
    Long applicationFeeAmount;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="_stripe_java_extra_param_key")
    Map<String, Object> extraParams;
    @SerializedName(value="receipt_email")
    String receiptEmail;
    @SerializedName(value="statement_descriptor")
    String statementDescriptor;
    @SerializedName(value="statement_descriptor_suffix")
    String statementDescriptorSuffix;
    @SerializedName(value="transfer_data")
    TransferData transferData;
    @SerializedName(value="transfer_group")
    String transferGroup;

    private ChargeCaptureParams(Long amount, Long applicationFee, Long applicationFeeAmount, List<String> expand, Map<String, Object> extraParams, String receiptEmail, String statementDescriptor, String statementDescriptorSuffix, TransferData transferData, String transferGroup) {
        this.amount = amount;
        this.applicationFee = applicationFee;
        this.applicationFeeAmount = applicationFeeAmount;
        this.expand = expand;
        this.extraParams = extraParams;
        this.receiptEmail = receiptEmail;
        this.statementDescriptor = statementDescriptor;
        this.statementDescriptorSuffix = statementDescriptorSuffix;
        this.transferData = transferData;
        this.transferGroup = transferGroup;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class TransferData {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;

        private TransferData(Long amount, Map<String, Object> extraParams) {
            this.amount = amount;
            this.extraParams = extraParams;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private Long amount;
            private Map<String, Object> extraParams;

            public TransferData build() {
                return new TransferData(this.amount, this.extraParams);
            }

            public Builder setAmount(Long amount) {
                this.amount = amount;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }
        }
    }

    public static class Builder {
        private Long amount;
        private Long applicationFee;
        private Long applicationFeeAmount;
        private List<String> expand;
        private Map<String, Object> extraParams;
        private String receiptEmail;
        private String statementDescriptor;
        private String statementDescriptorSuffix;
        private TransferData transferData;
        private String transferGroup;

        public ChargeCaptureParams build() {
            return new ChargeCaptureParams(this.amount, this.applicationFee, this.applicationFeeAmount, this.expand, this.extraParams, this.receiptEmail, this.statementDescriptor, this.statementDescriptorSuffix, this.transferData, this.transferGroup);
        }

        public Builder setAmount(Long amount) {
            this.amount = amount;
            return this;
        }

        public Builder setApplicationFee(Long applicationFee) {
            this.applicationFee = applicationFee;
            return this;
        }

        public Builder setApplicationFeeAmount(Long applicationFeeAmount) {
            this.applicationFeeAmount = applicationFeeAmount;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.put(key, value);
            return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.putAll(map);
            return this;
        }

        public Builder setReceiptEmail(String receiptEmail) {
            this.receiptEmail = receiptEmail;
            return this;
        }

        public Builder setStatementDescriptor(String statementDescriptor) {
            this.statementDescriptor = statementDescriptor;
            return this;
        }

        public Builder setStatementDescriptorSuffix(String statementDescriptorSuffix) {
            this.statementDescriptorSuffix = statementDescriptorSuffix;
            return this;
        }

        public Builder setTransferData(TransferData transferData) {
            this.transferData = transferData;
            return this;
        }

        public Builder setTransferGroup(String transferGroup) {
            this.transferGroup = transferGroup;
            return this;
        }
    }
}

