/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.PlanCollection;
import com.stripe.model.Product;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.PlanCreateParams;
import com.stripe.param.PlanListParams;
import com.stripe.param.PlanRetrieveParams;
import com.stripe.param.PlanUpdateParams;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Plan
extends ApiResource
implements HasId,
MetadataStore<Plan> {
    @SerializedName(value="active")
    Boolean active;
    @SerializedName(value="aggregate_usage")
    String aggregateUsage;
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="amount_decimal")
    BigDecimal amountDecimal;
    @SerializedName(value="billing_scheme")
    String billingScheme;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="deleted")
    Boolean deleted;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="interval")
    String interval;
    @SerializedName(value="interval_count")
    Long intervalCount;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="nickname")
    String nickname;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="product")
    ExpandableField<Product> product;
    @SerializedName(value="tiers")
    List<Tier> tiers;
    @SerializedName(value="tiers_mode")
    String tiersMode;
    @SerializedName(value="transform_usage")
    TransformUsage transformUsage;
    @SerializedName(value="trial_period_days")
    Long trialPeriodDays;
    @SerializedName(value="usage_type")
    String usageType;

    public String getProduct() {
        return this.product != null ? this.product.getId() : null;
    }

    public void setProduct(String id) {
        this.product = ApiResource.setExpandableFieldId(id, this.product);
    }

    public Product getProductObject() {
        return this.product != null ? this.product.getExpanded() : null;
    }

    public void setProductObject(Product expandableObject) {
        this.product = new ExpandableField<Product>(expandableObject.getId(), expandableObject);
    }

    public static PlanCollection list(Map<String, Object> params) throws StripeException {
        return Plan.list(params, (RequestOptions)null);
    }

    public static PlanCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/plans");
        return Plan.requestCollection(url, params, PlanCollection.class, options);
    }

    public static PlanCollection list(PlanListParams params) throws StripeException {
        return Plan.list(params, (RequestOptions)null);
    }

    public static PlanCollection list(PlanListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/plans");
        return Plan.requestCollection(url, params, PlanCollection.class, options);
    }

    public static Plan create(Map<String, Object> params) throws StripeException {
        return Plan.create(params, (RequestOptions)null);
    }

    public static Plan create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/plans");
        return Plan.request(ApiResource.RequestMethod.POST, url, params, Plan.class, options);
    }

    public static Plan create(PlanCreateParams params) throws StripeException {
        return Plan.create(params, (RequestOptions)null);
    }

    public static Plan create(PlanCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/plans");
        return Plan.request(ApiResource.RequestMethod.POST, url, params, Plan.class, options);
    }

    public static Plan retrieve(String plan) throws StripeException {
        return Plan.retrieve(plan, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Plan retrieve(String plan, RequestOptions options) throws StripeException {
        return Plan.retrieve(plan, (Map<String, Object>)null, options);
    }

    public static Plan retrieve(String plan, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/plans/%s", ApiResource.urlEncodeId(plan)));
        return Plan.request(ApiResource.RequestMethod.GET, url, params, Plan.class, options);
    }

    public static Plan retrieve(String plan, PlanRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/plans/%s", ApiResource.urlEncodeId(plan)));
        return Plan.request(ApiResource.RequestMethod.GET, url, params, Plan.class, options);
    }

    public Plan update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Plan update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/plans/%s", ApiResource.urlEncodeId(this.getId())));
        return Plan.request(ApiResource.RequestMethod.POST, url, params, Plan.class, options);
    }

    public Plan update(PlanUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Plan update(PlanUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/plans/%s", ApiResource.urlEncodeId(this.getId())));
        return Plan.request(ApiResource.RequestMethod.POST, url, params, Plan.class, options);
    }

    public Plan delete() throws StripeException {
        return this.delete(null, null);
    }

    public Plan delete(RequestOptions options) throws StripeException {
        return this.delete(null, options);
    }

    public Plan delete(Map<String, Object> params) throws StripeException {
        return this.delete(params, null);
    }

    public Plan delete(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/plans/%s", ApiResource.urlEncodeId(this.getId())));
        return Plan.request(ApiResource.RequestMethod.DELETE, url, params, Plan.class, options);
    }

    @Generated
    public Boolean getActive() {
        return this.active;
    }

    @Generated
    public String getAggregateUsage() {
        return this.aggregateUsage;
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public BigDecimal getAmountDecimal() {
        return this.amountDecimal;
    }

    @Generated
    public String getBillingScheme() {
        return this.billingScheme;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Generated
    public String getInterval() {
        return this.interval;
    }

    @Generated
    public Long getIntervalCount() {
        return this.intervalCount;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getNickname() {
        return this.nickname;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public List<Tier> getTiers() {
        return this.tiers;
    }

    @Generated
    public String getTiersMode() {
        return this.tiersMode;
    }

    @Generated
    public TransformUsage getTransformUsage() {
        return this.transformUsage;
    }

    @Generated
    public Long getTrialPeriodDays() {
        return this.trialPeriodDays;
    }

    @Generated
    public String getUsageType() {
        return this.usageType;
    }

    @Generated
    public void setActive(Boolean active) {
        this.active = active;
    }

    @Generated
    public void setAggregateUsage(String aggregateUsage) {
        this.aggregateUsage = aggregateUsage;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setAmountDecimal(BigDecimal amountDecimal) {
        this.amountDecimal = amountDecimal;
    }

    @Generated
    public void setBillingScheme(String billingScheme) {
        this.billingScheme = billingScheme;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setInterval(String interval) {
        this.interval = interval;
    }

    @Generated
    public void setIntervalCount(Long intervalCount) {
        this.intervalCount = intervalCount;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setTiers(List<Tier> tiers) {
        this.tiers = tiers;
    }

    @Generated
    public void setTiersMode(String tiersMode) {
        this.tiersMode = tiersMode;
    }

    @Generated
    public void setTransformUsage(TransformUsage transformUsage) {
        this.transformUsage = transformUsage;
    }

    @Generated
    public void setTrialPeriodDays(Long trialPeriodDays) {
        this.trialPeriodDays = trialPeriodDays;
    }

    @Generated
    public void setUsageType(String usageType) {
        this.usageType = usageType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Plan)) {
            return false;
        }
        Plan other = (Plan)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        String this$aggregateUsage = this.getAggregateUsage();
        String other$aggregateUsage = other.getAggregateUsage();
        if (this$aggregateUsage == null ? other$aggregateUsage != null : !this$aggregateUsage.equals(other$aggregateUsage)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        BigDecimal this$amountDecimal = this.getAmountDecimal();
        BigDecimal other$amountDecimal = other.getAmountDecimal();
        if (this$amountDecimal == null ? other$amountDecimal != null : !((Object)this$amountDecimal).equals(other$amountDecimal)) {
            return false;
        }
        String this$billingScheme = this.getBillingScheme();
        String other$billingScheme = other.getBillingScheme();
        if (this$billingScheme == null ? other$billingScheme != null : !this$billingScheme.equals(other$billingScheme)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$interval = this.getInterval();
        String other$interval = other.getInterval();
        if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) {
            return false;
        }
        Long this$intervalCount = this.getIntervalCount();
        Long other$intervalCount = other.getIntervalCount();
        if (this$intervalCount == null ? other$intervalCount != null : !((Object)this$intervalCount).equals(other$intervalCount)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$nickname = this.getNickname();
        String other$nickname = other.getNickname();
        if (this$nickname == null ? other$nickname != null : !this$nickname.equals(other$nickname)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$product = this.getProduct();
        String other$product = other.getProduct();
        if (this$product == null ? other$product != null : !this$product.equals(other$product)) {
            return false;
        }
        List<Tier> this$tiers = this.getTiers();
        List<Tier> other$tiers = other.getTiers();
        if (this$tiers == null ? other$tiers != null : !((Object)this$tiers).equals(other$tiers)) {
            return false;
        }
        String this$tiersMode = this.getTiersMode();
        String other$tiersMode = other.getTiersMode();
        if (this$tiersMode == null ? other$tiersMode != null : !this$tiersMode.equals(other$tiersMode)) {
            return false;
        }
        TransformUsage this$transformUsage = this.getTransformUsage();
        TransformUsage other$transformUsage = other.getTransformUsage();
        if (this$transformUsage == null ? other$transformUsage != null : !((Object)this$transformUsage).equals(other$transformUsage)) {
            return false;
        }
        Long this$trialPeriodDays = this.getTrialPeriodDays();
        Long other$trialPeriodDays = other.getTrialPeriodDays();
        if (this$trialPeriodDays == null ? other$trialPeriodDays != null : !((Object)this$trialPeriodDays).equals(other$trialPeriodDays)) {
            return false;
        }
        String this$usageType = this.getUsageType();
        String other$usageType = other.getUsageType();
        return !(this$usageType == null ? other$usageType != null : !this$usageType.equals(other$usageType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Plan;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        String $aggregateUsage = this.getAggregateUsage();
        result = result * 59 + ($aggregateUsage == null ? 43 : $aggregateUsage.hashCode());
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        BigDecimal $amountDecimal = this.getAmountDecimal();
        result = result * 59 + ($amountDecimal == null ? 43 : ((Object)$amountDecimal).hashCode());
        String $billingScheme = this.getBillingScheme();
        result = result * 59 + ($billingScheme == null ? 43 : $billingScheme.hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $interval = this.getInterval();
        result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
        Long $intervalCount = this.getIntervalCount();
        result = result * 59 + ($intervalCount == null ? 43 : ((Object)$intervalCount).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $nickname = this.getNickname();
        result = result * 59 + ($nickname == null ? 43 : $nickname.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $product = this.getProduct();
        result = result * 59 + ($product == null ? 43 : $product.hashCode());
        List<Tier> $tiers = this.getTiers();
        result = result * 59 + ($tiers == null ? 43 : ((Object)$tiers).hashCode());
        String $tiersMode = this.getTiersMode();
        result = result * 59 + ($tiersMode == null ? 43 : $tiersMode.hashCode());
        TransformUsage $transformUsage = this.getTransformUsage();
        result = result * 59 + ($transformUsage == null ? 43 : ((Object)$transformUsage).hashCode());
        Long $trialPeriodDays = this.getTrialPeriodDays();
        result = result * 59 + ($trialPeriodDays == null ? 43 : ((Object)$trialPeriodDays).hashCode());
        String $usageType = this.getUsageType();
        result = result * 59 + ($usageType == null ? 43 : $usageType.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class TransformUsage
    extends StripeObject {
        @SerializedName(value="divide_by")
        Long divideBy;
        @SerializedName(value="round")
        String round;

        @Generated
        public Long getDivideBy() {
            return this.divideBy;
        }

        @Generated
        public String getRound() {
            return this.round;
        }

        @Generated
        public void setDivideBy(Long divideBy) {
            this.divideBy = divideBy;
        }

        @Generated
        public void setRound(String round) {
            this.round = round;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransformUsage)) {
                return false;
            }
            TransformUsage other = (TransformUsage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$divideBy = this.getDivideBy();
            Long other$divideBy = other.getDivideBy();
            if (this$divideBy == null ? other$divideBy != null : !((Object)this$divideBy).equals(other$divideBy)) {
                return false;
            }
            String this$round = this.getRound();
            String other$round = other.getRound();
            return !(this$round == null ? other$round != null : !this$round.equals(other$round));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TransformUsage;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $divideBy = this.getDivideBy();
            result = result * 59 + ($divideBy == null ? 43 : ((Object)$divideBy).hashCode());
            String $round = this.getRound();
            result = result * 59 + ($round == null ? 43 : $round.hashCode());
            return result;
        }
    }

    public static class Tier
    extends StripeObject {
        @SerializedName(value="flat_amount")
        Long flatAmount;
        @SerializedName(value="flat_amount_decimal")
        BigDecimal flatAmountDecimal;
        @SerializedName(value="unit_amount")
        Long unitAmount;
        @SerializedName(value="unit_amount_decimal")
        BigDecimal unitAmountDecimal;
        @SerializedName(value="up_to")
        Long upTo;

        @Generated
        public Long getFlatAmount() {
            return this.flatAmount;
        }

        @Generated
        public BigDecimal getFlatAmountDecimal() {
            return this.flatAmountDecimal;
        }

        @Generated
        public Long getUnitAmount() {
            return this.unitAmount;
        }

        @Generated
        public BigDecimal getUnitAmountDecimal() {
            return this.unitAmountDecimal;
        }

        @Generated
        public Long getUpTo() {
            return this.upTo;
        }

        @Generated
        public void setFlatAmount(Long flatAmount) {
            this.flatAmount = flatAmount;
        }

        @Generated
        public void setFlatAmountDecimal(BigDecimal flatAmountDecimal) {
            this.flatAmountDecimal = flatAmountDecimal;
        }

        @Generated
        public void setUnitAmount(Long unitAmount) {
            this.unitAmount = unitAmount;
        }

        @Generated
        public void setUnitAmountDecimal(BigDecimal unitAmountDecimal) {
            this.unitAmountDecimal = unitAmountDecimal;
        }

        @Generated
        public void setUpTo(Long upTo) {
            this.upTo = upTo;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tier)) {
                return false;
            }
            Tier other = (Tier)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$flatAmount = this.getFlatAmount();
            Long other$flatAmount = other.getFlatAmount();
            if (this$flatAmount == null ? other$flatAmount != null : !((Object)this$flatAmount).equals(other$flatAmount)) {
                return false;
            }
            BigDecimal this$flatAmountDecimal = this.getFlatAmountDecimal();
            BigDecimal other$flatAmountDecimal = other.getFlatAmountDecimal();
            if (this$flatAmountDecimal == null ? other$flatAmountDecimal != null : !((Object)this$flatAmountDecimal).equals(other$flatAmountDecimal)) {
                return false;
            }
            Long this$unitAmount = this.getUnitAmount();
            Long other$unitAmount = other.getUnitAmount();
            if (this$unitAmount == null ? other$unitAmount != null : !((Object)this$unitAmount).equals(other$unitAmount)) {
                return false;
            }
            BigDecimal this$unitAmountDecimal = this.getUnitAmountDecimal();
            BigDecimal other$unitAmountDecimal = other.getUnitAmountDecimal();
            if (this$unitAmountDecimal == null ? other$unitAmountDecimal != null : !((Object)this$unitAmountDecimal).equals(other$unitAmountDecimal)) {
                return false;
            }
            Long this$upTo = this.getUpTo();
            Long other$upTo = other.getUpTo();
            return !(this$upTo == null ? other$upTo != null : !((Object)this$upTo).equals(other$upTo));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Tier;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $flatAmount = this.getFlatAmount();
            result = result * 59 + ($flatAmount == null ? 43 : ((Object)$flatAmount).hashCode());
            BigDecimal $flatAmountDecimal = this.getFlatAmountDecimal();
            result = result * 59 + ($flatAmountDecimal == null ? 43 : ((Object)$flatAmountDecimal).hashCode());
            Long $unitAmount = this.getUnitAmount();
            result = result * 59 + ($unitAmount == null ? 43 : ((Object)$unitAmount).hashCode());
            BigDecimal $unitAmountDecimal = this.getUnitAmountDecimal();
            result = result * 59 + ($unitAmountDecimal == null ? 43 : ((Object)$unitAmountDecimal).hashCode());
            Long $upTo = this.getUpTo();
            result = result * 59 + ($upTo == null ? 43 : ((Object)$upTo).hashCode());
            return result;
        }
    }
}

