// Generated by delombok at Tue Sep 03 10:42:51 PDT 2019
// Generated by com.stripe.generator.entity.SdkBuilder
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import com.stripe.param.common.EmptyParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SubscriptionUpdateParams extends ApiRequestParams {
  /**
   * A non-negative decimal between 0 and 100, with at most two decimal places. This represents the
   * percentage of the subscription invoice subtotal that will be transferred to the application
   * owner's Stripe account. The request must be made with an OAuth key in order to set an
   * application fee percentage. For more information, see the application fees
   * [documentation](https://stripe.com/docs/connect/subscriptions#collecting-fees-on-subscriptions).
   */
  @SerializedName("application_fee_percent")
  BigDecimal applicationFeePercent;
  /**
   * This field has been renamed to `collection_method` and will be removed in a future API version.
   */
  @SerializedName("billing")
  Billing billing;
  /**
   * Either `now` or `unchanged`. Setting the value to `now` resets the subscription's billing cycle
   * anchor to the current time. For more information, see the billing cycle
   * [documentation](https://stripe.com/docs/billing/subscriptions/billing-cycle).
   */
  @SerializedName("billing_cycle_anchor")
  BillingCycleAnchor billingCycleAnchor;
  /**
   * Define thresholds at which an invoice will be sent, and the subscription advanced to a new
   * billing period. Pass an empty string to remove previously-defined thresholds.
   */
  @SerializedName("billing_thresholds")
  Object billingThresholds;
  /**
   * A timestamp at which the subscription should cancel. If set to a date before the current period
   * ends this will cause a proration if `prorate=true`.
   */
  @SerializedName("cancel_at")
  Object cancelAt;
  /**
   * Boolean indicating whether this subscription should cancel at the end of the current period.
   */
  @SerializedName("cancel_at_period_end")
  Boolean cancelAtPeriodEnd;
  /**
   * Either `charge_automatically`, or `send_invoice`. When charging automatically, Stripe will
   * attempt to pay this subscription at the end of the cycle using the default source attached to
   * the customer. When sending an invoice, Stripe will email your customer an invoice with payment
   * instructions. Defaults to `charge_automatically`.
   */
  @SerializedName("collection_method")
  CollectionMethod collectionMethod;
  /**
   * The code of the coupon to apply to this subscription. A coupon applied to a subscription will
   * only affect invoices created for that particular subscription.
   */
  @SerializedName("coupon")
  String coupon;
  /**
   * Number of days a customer has to pay invoices generated by this subscription. Valid only for
   * subscriptions where `collection_method` is set to `send_invoice`.
   */
  @SerializedName("days_until_due")
  Long daysUntilDue;
  /**
   * ID of the default payment method for the subscription. It must belong to the customer
   * associated with the subscription. If not set, invoices will use the default payment method in
   * the customer's invoice settings.
   */
  @SerializedName("default_payment_method")
  String defaultPaymentMethod;
  /**
   * ID of the default payment source for the subscription. It must belong to the customer
   * associated with the subscription and be in a chargeable state. If not set, defaults to the
   * customer's default source.
   */
  @SerializedName("default_source")
  String defaultSource;
  /**
   * The tax rates that will apply to any subscription item that does not have `tax_rates` set.
   * Invoices created will have their `default_tax_rates` populated from the subscription.
   */
  @SerializedName("default_tax_rates")
  Object defaultTaxRates;
  /**
   * Specifies which fields in the response should be expanded.
   */
  @SerializedName("expand")
  List<String> expand;
  /**
   * Map of extra parameters for custom features not available in this client library. The content
   * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
   * key/value pair is serialized as if the key is a root-level field (serialized) name in this
   * param object. Effectively, this map is flattened to its parent instance.
   */
  @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
  Map<String, Object> extraParams;
  /**
   * List of subscription items, each with an attached plan.
   */
  @SerializedName("items")
  List<Item> items;
  /**
   * A set of key-value pairs that you can attach to a subscription object. This can be useful for
   * storing additional information about the subscription in a structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * Indicates if a customer is on or off-session while an invoice payment is attempted.
   */
  @SerializedName("off_session")
  Boolean offSession;
  /**
   * Use `allow_incomplete` to create subscriptions with `status=incomplete` if its first invoice
   * cannot be paid. Creating subscriptions with this status allows you to manage scenarios where
   * additional user actions are needed to pay a subscription's invoice. For example, SCA regulation
   * may require 3DS authentication to complete payment. See the [SCA Migration
   * Guide](https://stripe.com/docs/billing/migration/strong-customer-authentication) for Billing to
   * learn more. This is the default behavior.
   *
   * <p>Use `error_if_incomplete` if you want Stripe to return an HTTP 402 status code if a
   * subscription's first invoice cannot be paid. For example, if a payment method requires 3DS
   * authentication due to SCA regulation and further user action is needed, this parameter does not
   * create a subscription and returns an error instead. This was the default behavior for API
   * versions prior to 2019-03-14. See the [changelog](https://stripe.com/docs/upgrades#2019-03-14)
   * to learn more.
   */
  @SerializedName("payment_behavior")
  PaymentBehavior paymentBehavior;
  /**
   * Boolean (defaults to `true`) telling us whether to [credit for unused
   * time](https://stripe.com/docs/subscriptions/billing-cycle#prorations) when the billing cycle
   * changes (e.g. when switching plans, resetting `billing_cycle_anchor=now`, or starting a trial),
   * or if an item's `quantity` changes. If `false`, the anchor period will be free (similar to a
   * trial) and no proration adjustments will be created.
   */
  @SerializedName("prorate")
  Boolean prorate;
  /**
   * If set, the proration will be calculated as though the subscription was updated at the given
   * time. This can be used to apply exactly the same proration that was previewed with [upcoming
   * invoice](#retrieve_customer_invoice) endpoint. It can also be used to implement custom
   * proration logic, such as prorating by day instead of by second, by providing the time that you
   * wish to use for proration calculations.
   */
  @SerializedName("proration_date")
  Long prorationDate;
  /**
   * A non-negative decimal (with at most four decimal places) between 0 and 100. This represents
   * the percentage of the subscription invoice subtotal that will be calculated and added as tax to
   * the final amount in each billing period. For example, a plan which charges $10/month with a
   * `tax_percent` of `20.0` will charge $12 per invoice. To unset a previously-set value, pass an
   * empty string. This field has been deprecated and will be removed in a future API version, for
   * further information view the [migration docs](https://stripe.com/docs/billing/migration/taxes)
   * for `tax_rates`.
   */
  @SerializedName("tax_percent")
  Object taxPercent;
  /**
   * If specified, the funds from the subscription's invoices will be transferred to the destination
   * and the ID of the resulting transfers will be found on the resulting charges. This will be
   * unset if you POST an empty value.
   */
  @SerializedName("transfer_data")
  Object transferData;
  /**
   * Unix timestamp representing the end of the trial period the customer will get before being
   * charged for the first time. This will always overwrite any trials that might apply via a
   * subscribed plan. If set, trial_end will override the default trial period of the plan the
   * customer is being subscribed to. The special value `now` can be provided to end the customer's
   * trial immediately. Can be at most two years from `billing_cycle_anchor`.
   */
  @SerializedName("trial_end")
  Object trialEnd;
  /**
   * Indicates if a plan's `trial_period_days` should be applied to the subscription. Setting
   * `trial_end` per subscription is preferred, and this defaults to `false`. Setting this flag to
   * `true` together with `trial_end` is not allowed.
   */
  @SerializedName("trial_from_plan")
  Boolean trialFromPlan;

  private SubscriptionUpdateParams(BigDecimal applicationFeePercent, Billing billing, BillingCycleAnchor billingCycleAnchor, Object billingThresholds, Object cancelAt, Boolean cancelAtPeriodEnd, CollectionMethod collectionMethod, String coupon, Long daysUntilDue, String defaultPaymentMethod, String defaultSource, Object defaultTaxRates, List<String> expand, Map<String, Object> extraParams, List<Item> items, Map<String, String> metadata, Boolean offSession, PaymentBehavior paymentBehavior, Boolean prorate, Long prorationDate, Object taxPercent, Object transferData, Object trialEnd, Boolean trialFromPlan) {
    this.applicationFeePercent = applicationFeePercent;
    this.billing = billing;
    this.billingCycleAnchor = billingCycleAnchor;
    this.billingThresholds = billingThresholds;
    this.cancelAt = cancelAt;
    this.cancelAtPeriodEnd = cancelAtPeriodEnd;
    this.collectionMethod = collectionMethod;
    this.coupon = coupon;
    this.daysUntilDue = daysUntilDue;
    this.defaultPaymentMethod = defaultPaymentMethod;
    this.defaultSource = defaultSource;
    this.defaultTaxRates = defaultTaxRates;
    this.expand = expand;
    this.extraParams = extraParams;
    this.items = items;
    this.metadata = metadata;
    this.offSession = offSession;
    this.paymentBehavior = paymentBehavior;
    this.prorate = prorate;
    this.prorationDate = prorationDate;
    this.taxPercent = taxPercent;
    this.transferData = transferData;
    this.trialEnd = trialEnd;
    this.trialFromPlan = trialFromPlan;
  }

  public static Builder builder() {
    return new com.stripe.param.SubscriptionUpdateParams.Builder();
  }


  public static class Builder {
    private BigDecimal applicationFeePercent;
    private Billing billing;
    private BillingCycleAnchor billingCycleAnchor;
    private Object billingThresholds;
    private Object cancelAt;
    private Boolean cancelAtPeriodEnd;
    private CollectionMethod collectionMethod;
    private String coupon;
    private Long daysUntilDue;
    private String defaultPaymentMethod;
    private String defaultSource;
    private Object defaultTaxRates;
    private List<String> expand;
    private Map<String, Object> extraParams;
    private List<Item> items;
    private Map<String, String> metadata;
    private Boolean offSession;
    private PaymentBehavior paymentBehavior;
    private Boolean prorate;
    private Long prorationDate;
    private Object taxPercent;
    private Object transferData;
    private Object trialEnd;
    private Boolean trialFromPlan;

    /**
     * Finalize and obtain parameter instance from this builder.
     */
    public SubscriptionUpdateParams build() {
      return new SubscriptionUpdateParams(this.applicationFeePercent, this.billing, this.billingCycleAnchor, this.billingThresholds, this.cancelAt, this.cancelAtPeriodEnd, this.collectionMethod, this.coupon, this.daysUntilDue, this.defaultPaymentMethod, this.defaultSource, this.defaultTaxRates, this.expand, this.extraParams, this.items, this.metadata, this.offSession, this.paymentBehavior, this.prorate, this.prorationDate, this.taxPercent, this.transferData, this.trialEnd, this.trialFromPlan);
    }

    /**
     * A non-negative decimal between 0 and 100, with at most two decimal places. This represents
     * the percentage of the subscription invoice subtotal that will be transferred to the
     * application owner's Stripe account. The request must be made with an OAuth key in order to
     * set an application fee percentage. For more information, see the application fees
     * [documentation](https://stripe.com/docs/connect/subscriptions#collecting-fees-on-subscriptions).
     */
    public Builder setApplicationFeePercent(BigDecimal applicationFeePercent) {
      this.applicationFeePercent = applicationFeePercent;
      return this;
    }

    /**
     * This field has been renamed to `collection_method` and will be removed in a future API
     * version.
     */
    public Builder setBilling(Billing billing) {
      this.billing = billing;
      return this;
    }

    /**
     * Either `now` or `unchanged`. Setting the value to `now` resets the subscription's billing
     * cycle anchor to the current time. For more information, see the billing cycle
     * [documentation](https://stripe.com/docs/billing/subscriptions/billing-cycle).
     */
    public Builder setBillingCycleAnchor(BillingCycleAnchor billingCycleAnchor) {
      this.billingCycleAnchor = billingCycleAnchor;
      return this;
    }

    /**
     * Define thresholds at which an invoice will be sent, and the subscription advanced to a new
     * billing period. Pass an empty string to remove previously-defined thresholds.
     */
    public Builder setBillingThresholds(BillingThresholds billingThresholds) {
      this.billingThresholds = billingThresholds;
      return this;
    }

    /**
     * Define thresholds at which an invoice will be sent, and the subscription advanced to a new
     * billing period. Pass an empty string to remove previously-defined thresholds.
     */
    public Builder setBillingThresholds(EmptyParam billingThresholds) {
      this.billingThresholds = billingThresholds;
      return this;
    }

    /**
     * A timestamp at which the subscription should cancel. If set to a date before the current
     * period ends this will cause a proration if `prorate=true`.
     */
    public Builder setCancelAt(EmptyParam cancelAt) {
      this.cancelAt = cancelAt;
      return this;
    }

    /**
     * A timestamp at which the subscription should cancel. If set to a date before the current
     * period ends this will cause a proration if `prorate=true`.
     */
    public Builder setCancelAt(Long cancelAt) {
      this.cancelAt = cancelAt;
      return this;
    }

    /**
     * Boolean indicating whether this subscription should cancel at the end of the current period.
     */
    public Builder setCancelAtPeriodEnd(Boolean cancelAtPeriodEnd) {
      this.cancelAtPeriodEnd = cancelAtPeriodEnd;
      return this;
    }

    /**
     * Either `charge_automatically`, or `send_invoice`. When charging automatically, Stripe will
     * attempt to pay this subscription at the end of the cycle using the default source attached to
     * the customer. When sending an invoice, Stripe will email your customer an invoice with
     * payment instructions. Defaults to `charge_automatically`.
     */
    public Builder setCollectionMethod(CollectionMethod collectionMethod) {
      this.collectionMethod = collectionMethod;
      return this;
    }

    /**
     * The code of the coupon to apply to this subscription. A coupon applied to a subscription will
     * only affect invoices created for that particular subscription.
     */
    public Builder setCoupon(String coupon) {
      this.coupon = coupon;
      return this;
    }

    /**
     * Number of days a customer has to pay invoices generated by this subscription. Valid only for
     * subscriptions where `collection_method` is set to `send_invoice`.
     */
    public Builder setDaysUntilDue(Long daysUntilDue) {
      this.daysUntilDue = daysUntilDue;
      return this;
    }

    /**
     * ID of the default payment method for the subscription. It must belong to the customer
     * associated with the subscription. If not set, invoices will use the default payment method in
     * the customer's invoice settings.
     */
    public Builder setDefaultPaymentMethod(String defaultPaymentMethod) {
      this.defaultPaymentMethod = defaultPaymentMethod;
      return this;
    }

    /**
     * ID of the default payment source for the subscription. It must belong to the customer
     * associated with the subscription and be in a chargeable state. If not set, defaults to the
     * customer's default source.
     */
    public Builder setDefaultSource(String defaultSource) {
      this.defaultSource = defaultSource;
      return this;
    }

    /**
     * The tax rates that will apply to any subscription item that does not have `tax_rates` set.
     * Invoices created will have their `default_tax_rates` populated from the subscription.
     */
    public Builder setDefaultTaxRates(EmptyParam defaultTaxRates) {
      this.defaultTaxRates = defaultTaxRates;
      return this;
    }

    /**
     * The tax rates that will apply to any subscription item that does not have `tax_rates` set.
     * Invoices created will have their `default_tax_rates` populated from the subscription.
     */
    public Builder setDefaultTaxRates(List<String> defaultTaxRates) {
      this.defaultTaxRates = defaultTaxRates;
      return this;
    }

    /**
     * Add an element to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * SubscriptionUpdateParams#expand} for the field documentation.
     */
    public Builder addExpand(String element) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.add(element);
      return this;
    }

    /**
     * Add all elements to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * SubscriptionUpdateParams#expand} for the field documentation.
     */
    public Builder addAllExpand(List<String> elements) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.addAll(elements);
      return this;
    }

    /**
     * Add a key/value pair to `extraParams` map. A map is initialized for the first `put/putAll`
     * call, and subsequent calls add additional key/value pairs to the original map. See {@link
     * SubscriptionUpdateParams#extraParams} for the field documentation.
     */
    public Builder putExtraParam(String key, Object value) {
      if (this.extraParams == null) {
        this.extraParams = new HashMap<>();
      }
      this.extraParams.put(key, value);
      return this;
    }

    /**
     * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
     * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
     * See {@link SubscriptionUpdateParams#extraParams} for the field documentation.
     */
    public Builder putAllExtraParam(Map<String, Object> map) {
      if (this.extraParams == null) {
        this.extraParams = new HashMap<>();
      }
      this.extraParams.putAll(map);
      return this;
    }

    /**
     * Add an element to `items` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * SubscriptionUpdateParams#items} for the field documentation.
     */
    public Builder addItem(Item element) {
      if (this.items == null) {
        this.items = new ArrayList<>();
      }
      this.items.add(element);
      return this;
    }

    /**
     * Add all elements to `items` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * SubscriptionUpdateParams#items} for the field documentation.
     */
    public Builder addAllItem(List<Item> elements) {
      if (this.items == null) {
        this.items = new ArrayList<>();
      }
      this.items.addAll(elements);
      return this;
    }

    /**
     * Add a key/value pair to `metadata` map. A map is initialized for the first `put/putAll` call,
     * and subsequent calls add additional key/value pairs to the original map. See {@link
     * SubscriptionUpdateParams#metadata} for the field documentation.
     */
    public Builder putMetadata(String key, String value) {
      if (this.metadata == null) {
        this.metadata = new HashMap<>();
      }
      this.metadata.put(key, value);
      return this;
    }

    /**
     * Add all map key/value pairs to `metadata` map. A map is initialized for the first
     * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
     * See {@link SubscriptionUpdateParams#metadata} for the field documentation.
     */
    public Builder putAllMetadata(Map<String, String> map) {
      if (this.metadata == null) {
        this.metadata = new HashMap<>();
      }
      this.metadata.putAll(map);
      return this;
    }

    /**
     * Indicates if a customer is on or off-session while an invoice payment is attempted.
     */
    public Builder setOffSession(Boolean offSession) {
      this.offSession = offSession;
      return this;
    }

    /**
     * Use `allow_incomplete` to create subscriptions with `status=incomplete` if its first invoice
     * cannot be paid. Creating subscriptions with this status allows you to manage scenarios where
     * additional user actions are needed to pay a subscription's invoice. For example, SCA
     * regulation may require 3DS authentication to complete payment. See the [SCA Migration
     * Guide](https://stripe.com/docs/billing/migration/strong-customer-authentication) for Billing
     * to learn more. This is the default behavior.
     *
     * <p>Use `error_if_incomplete` if you want Stripe to return an HTTP 402 status code if a
     * subscription's first invoice cannot be paid. For example, if a payment method requires 3DS
     * authentication due to SCA regulation and further user action is needed, this parameter does
     * not create a subscription and returns an error instead. This was the default behavior for API
     * versions prior to 2019-03-14. See the
     * [changelog](https://stripe.com/docs/upgrades#2019-03-14) to learn more.
     */
    public Builder setPaymentBehavior(PaymentBehavior paymentBehavior) {
      this.paymentBehavior = paymentBehavior;
      return this;
    }

    /**
     * Boolean (defaults to `true`) telling us whether to [credit for unused
     * time](https://stripe.com/docs/subscriptions/billing-cycle#prorations) when the billing cycle
     * changes (e.g. when switching plans, resetting `billing_cycle_anchor=now`, or starting a
     * trial), or if an item's `quantity` changes. If `false`, the anchor period will be free
     * (similar to a trial) and no proration adjustments will be created.
     */
    public Builder setProrate(Boolean prorate) {
      this.prorate = prorate;
      return this;
    }

    /**
     * If set, the proration will be calculated as though the subscription was updated at the given
     * time. This can be used to apply exactly the same proration that was previewed with [upcoming
     * invoice](#retrieve_customer_invoice) endpoint. It can also be used to implement custom
     * proration logic, such as prorating by day instead of by second, by providing the time that
     * you wish to use for proration calculations.
     */
    public Builder setProrationDate(Long prorationDate) {
      this.prorationDate = prorationDate;
      return this;
    }

    /**
     * A non-negative decimal (with at most four decimal places) between 0 and 100. This represents
     * the percentage of the subscription invoice subtotal that will be calculated and added as tax
     * to the final amount in each billing period. For example, a plan which charges $10/month with
     * a `tax_percent` of `20.0` will charge $12 per invoice. To unset a previously-set value, pass
     * an empty string. This field has been deprecated and will be removed in a future API version,
     * for further information view the [migration
     * docs](https://stripe.com/docs/billing/migration/taxes) for `tax_rates`.
     */
    public Builder setTaxPercent(EmptyParam taxPercent) {
      this.taxPercent = taxPercent;
      return this;
    }

    /**
     * A non-negative decimal (with at most four decimal places) between 0 and 100. This represents
     * the percentage of the subscription invoice subtotal that will be calculated and added as tax
     * to the final amount in each billing period. For example, a plan which charges $10/month with
     * a `tax_percent` of `20.0` will charge $12 per invoice. To unset a previously-set value, pass
     * an empty string. This field has been deprecated and will be removed in a future API version,
     * for further information view the [migration
     * docs](https://stripe.com/docs/billing/migration/taxes) for `tax_rates`.
     */
    public Builder setTaxPercent(BigDecimal taxPercent) {
      this.taxPercent = taxPercent;
      return this;
    }

    /**
     * If specified, the funds from the subscription's invoices will be transferred to the
     * destination and the ID of the resulting transfers will be found on the resulting charges.
     * This will be unset if you POST an empty value.
     */
    public Builder setTransferData(TransferData transferData) {
      this.transferData = transferData;
      return this;
    }

    /**
     * If specified, the funds from the subscription's invoices will be transferred to the
     * destination and the ID of the resulting transfers will be found on the resulting charges.
     * This will be unset if you POST an empty value.
     */
    public Builder setTransferData(EmptyParam transferData) {
      this.transferData = transferData;
      return this;
    }

    /**
     * Unix timestamp representing the end of the trial period the customer will get before being
     * charged for the first time. This will always overwrite any trials that might apply via a
     * subscribed plan. If set, trial_end will override the default trial period of the plan the
     * customer is being subscribed to. The special value `now` can be provided to end the
     * customer's trial immediately. Can be at most two years from `billing_cycle_anchor`.
     */
    public Builder setTrialEnd(TrialEnd trialEnd) {
      this.trialEnd = trialEnd;
      return this;
    }

    /**
     * Unix timestamp representing the end of the trial period the customer will get before being
     * charged for the first time. This will always overwrite any trials that might apply via a
     * subscribed plan. If set, trial_end will override the default trial period of the plan the
     * customer is being subscribed to. The special value `now` can be provided to end the
     * customer's trial immediately. Can be at most two years from `billing_cycle_anchor`.
     */
    public Builder setTrialEnd(Long trialEnd) {
      this.trialEnd = trialEnd;
      return this;
    }

    /**
     * Indicates if a plan's `trial_period_days` should be applied to the subscription. Setting
     * `trial_end` per subscription is preferred, and this defaults to `false`. Setting this flag to
     * `true` together with `trial_end` is not allowed.
     */
    public Builder setTrialFromPlan(Boolean trialFromPlan) {
      this.trialFromPlan = trialFromPlan;
      return this;
    }
  }


  public static class BillingThresholds {
    /**
     * Monetary threshold that triggers the subscription to advance to a new billing period.
     */
    @SerializedName("amount_gte")
    Long amountGte;
    /**
     * Map of extra parameters for custom features not available in this client library. The content
     * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
     * key/value pair is serialized as if the key is a root-level field (serialized) name in this
     * param object. Effectively, this map is flattened to its parent instance.
     */
    @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
    Map<String, Object> extraParams;
    /**
     * Indicates if the `billing_cycle_anchor` should be reset when a threshold is reached. If true,
     * `billing_cycle_anchor` will be updated to the date/time the threshold was last reached;
     * otherwise, the value will remain unchanged.
     */
    @SerializedName("reset_billing_cycle_anchor")
    Boolean resetBillingCycleAnchor;

    private BillingThresholds(Long amountGte, Map<String, Object> extraParams, Boolean resetBillingCycleAnchor) {
      this.amountGte = amountGte;
      this.extraParams = extraParams;
      this.resetBillingCycleAnchor = resetBillingCycleAnchor;
    }

    public static Builder builder() {
      return new com.stripe.param.SubscriptionUpdateParams.BillingThresholds.Builder();
    }


    public static class Builder {
      private Long amountGte;
      private Map<String, Object> extraParams;
      private Boolean resetBillingCycleAnchor;

      /** Finalize and obtain parameter instance from this builder. */
      public BillingThresholds build() {
        return new BillingThresholds(this.amountGte, this.extraParams, this.resetBillingCycleAnchor);
      }

      /** Monetary threshold that triggers the subscription to advance to a new billing period. */
      public Builder setAmountGte(Long amountGte) {
        this.amountGte = amountGte;
        return this;
      }

      /**
       * Add a key/value pair to `extraParams` map. A map is initialized for the first `put/putAll`
       * call, and subsequent calls add additional key/value pairs to the original map. See {@link
       * SubscriptionUpdateParams.BillingThresholds#extraParams} for the field documentation.
       */
      public Builder putExtraParam(String key, Object value) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.put(key, value);
        return this;
      }

      /**
       * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
       * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
       * See {@link SubscriptionUpdateParams.BillingThresholds#extraParams} for the field
       * documentation.
       */
      public Builder putAllExtraParam(Map<String, Object> map) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.putAll(map);
        return this;
      }

      public Builder setResetBillingCycleAnchor(Boolean resetBillingCycleAnchor) {
        this.resetBillingCycleAnchor = resetBillingCycleAnchor;
        return this;
      }
    }
  }


  /**
   * Indicates if the `billing_cycle_anchor` should be reset when a threshold is reached. If
   * true, `billing_cycle_anchor` will be updated to the date/time the threshold was last
   * reached; otherwise, the value will remain unchanged.
   */
  public static class Item {
    /**
     * Define thresholds at which an invoice will be sent, and the subscription advanced to a new
     * billing period.
     */
    @SerializedName("billing_thresholds")
    Object billingThresholds;
    /**
     * Delete all usage for a given subscription item. Allowed only when `deleted` is set to `true`
     * and the current plan's `usage_type` is `metered`.
     */
    @SerializedName("clear_usage")
    Boolean clearUsage;
    /**
     * A flag that, if set to `true`, will delete the specified item.
     */
    @SerializedName("deleted")
    Boolean deleted;
    /**
     * Map of extra parameters for custom features not available in this client library. The content
     * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
     * key/value pair is serialized as if the key is a root-level field (serialized) name in this
     * param object. Effectively, this map is flattened to its parent instance.
     */
    @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
    Map<String, Object> extraParams;
    /**
     * Subscription item to update.
     */
    @SerializedName("id")
    String id;
    /**
     * Set of key-value pairs that you can attach to an object. This can be useful for storing
     * additional information about the object in a structured format.
     */
    @SerializedName("metadata")
    Map<String, String> metadata;
    /**
     * Plan ID for this item, as a string.
     */
    @SerializedName("plan")
    String plan;
    /**
     * Quantity for this item.
     */
    @SerializedName("quantity")
    Long quantity;
    /**
     * The tax rates which apply to this `subscription_item`. When set, the `default_tax_rates` on
     * the subscription do not apply to this `subscription_item`.
     */
    @SerializedName("tax_rates")
    Object taxRates;

    private Item(Object billingThresholds, Boolean clearUsage, Boolean deleted, Map<String, Object> extraParams, String id, Map<String, String> metadata, String plan, Long quantity, Object taxRates) {
      this.billingThresholds = billingThresholds;
      this.clearUsage = clearUsage;
      this.deleted = deleted;
      this.extraParams = extraParams;
      this.id = id;
      this.metadata = metadata;
      this.plan = plan;
      this.quantity = quantity;
      this.taxRates = taxRates;
    }

    public static Builder builder() {
      return new com.stripe.param.SubscriptionUpdateParams.Item.Builder();
    }


    public static class Builder {
      private Object billingThresholds;
      private Boolean clearUsage;
      private Boolean deleted;
      private Map<String, Object> extraParams;
      private String id;
      private Map<String, String> metadata;
      private String plan;
      private Long quantity;
      private Object taxRates;

      /**
       * Finalize and obtain parameter instance from this builder.
       */
      public Item build() {
        return new Item(this.billingThresholds, this.clearUsage, this.deleted, this.extraParams, this.id, this.metadata, this.plan, this.quantity, this.taxRates);
      }

      /**
       * Define thresholds at which an invoice will be sent, and the subscription advanced to a new
       * billing period.
       */
      public Builder setBillingThresholds(BillingThresholds billingThresholds) {
        this.billingThresholds = billingThresholds;
        return this;
      }

      /**
       * Define thresholds at which an invoice will be sent, and the subscription advanced to a new
       * billing period.
       */
      public Builder setBillingThresholds(EmptyParam billingThresholds) {
        this.billingThresholds = billingThresholds;
        return this;
      }

      /**
       * Delete all usage for a given subscription item. Allowed only when `deleted` is set to
       * `true` and the current plan's `usage_type` is `metered`.
       */
      public Builder setClearUsage(Boolean clearUsage) {
        this.clearUsage = clearUsage;
        return this;
      }

      /**
       * A flag that, if set to `true`, will delete the specified item.
       */
      public Builder setDeleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
      }

      /**
       * Add a key/value pair to `extraParams` map. A map is initialized for the first `put/putAll`
       * call, and subsequent calls add additional key/value pairs to the original map. See {@link
       * SubscriptionUpdateParams.Item#extraParams} for the field documentation.
       */
      public Builder putExtraParam(String key, Object value) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.put(key, value);
        return this;
      }

      /**
       * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
       * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
       * See {@link SubscriptionUpdateParams.Item#extraParams} for the field documentation.
       */
      public Builder putAllExtraParam(Map<String, Object> map) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.putAll(map);
        return this;
      }

      /**
       * Subscription item to update.
       */
      public Builder setId(String id) {
        this.id = id;
        return this;
      }

      /**
       * Add a key/value pair to `metadata` map. A map is initialized for the first `put/putAll`
       * call, and subsequent calls add additional key/value pairs to the original map. See {@link
       * SubscriptionUpdateParams.Item#metadata} for the field documentation.
       */
      public Builder putMetadata(String key, String value) {
        if (this.metadata == null) {
          this.metadata = new HashMap<>();
        }
        this.metadata.put(key, value);
        return this;
      }

      /**
       * Add all map key/value pairs to `metadata` map. A map is initialized for the first
       * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
       * See {@link SubscriptionUpdateParams.Item#metadata} for the field documentation.
       */
      public Builder putAllMetadata(Map<String, String> map) {
        if (this.metadata == null) {
          this.metadata = new HashMap<>();
        }
        this.metadata.putAll(map);
        return this;
      }

      /**
       * Plan ID for this item, as a string.
       */
      public Builder setPlan(String plan) {
        this.plan = plan;
        return this;
      }

      /**
       * Quantity for this item.
       */
      public Builder setQuantity(Long quantity) {
        this.quantity = quantity;
        return this;
      }

      /**
       * The tax rates which apply to this `subscription_item`. When set, the `default_tax_rates` on
       * the subscription do not apply to this `subscription_item`.
       */
      public Builder setTaxRates(EmptyParam taxRates) {
        this.taxRates = taxRates;
        return this;
      }

      /**
       * The tax rates which apply to this `subscription_item`. When set, the `default_tax_rates` on
       * the subscription do not apply to this `subscription_item`.
       */
      public Builder setTaxRates(List<String> taxRates) {
        this.taxRates = taxRates;
        return this;
      }
    }


    public static class BillingThresholds {
      /**
       * Map of extra parameters for custom features not available in this client library. The
       * content in this map is not serialized under this field's {@code @SerializedName} value.
       * Instead, each key/value pair is serialized as if the key is a root-level field (serialized)
       * name in this param object. Effectively, this map is flattened to its parent instance.
       */
      @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
      Map<String, Object> extraParams;
      /** Usage threshold that triggers the subscription to advance to a new billing period. */
      @SerializedName("usage_gte")
      Long usageGte;

      private BillingThresholds(Map<String, Object> extraParams, Long usageGte) {
        this.extraParams = extraParams;
        this.usageGte = usageGte;
      }

      public static Builder builder() {
        return new com.stripe.param.SubscriptionUpdateParams.Item.BillingThresholds.Builder();
      }


      public static class Builder {
        private Map<String, Object> extraParams;
        private Long usageGte;

        /** Finalize and obtain parameter instance from this builder. */
        public BillingThresholds build() {
          return new BillingThresholds(this.extraParams, this.usageGte);
        }

        /**
         * Add a key/value pair to `extraParams` map. A map is initialized for the first
         * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
         * map. See {@link SubscriptionUpdateParams.Item.BillingThresholds#extraParams} for the
         * field documentation.
         */
        public Builder putExtraParam(String key, Object value) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.put(key, value);
          return this;
        }

        /**
         * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
         * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
         * map. See {@link SubscriptionUpdateParams.Item.BillingThresholds#extraParams} for the
         * field documentation.
         */
        public Builder putAllExtraParam(Map<String, Object> map) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.putAll(map);
          return this;
        }

        public Builder setUsageGte(Long usageGte) {
          this.usageGte = usageGte;
          return this;
        }
      }
    }
  }


  /**
   * Usage threshold that triggers the subscription to advance to a new billing period.
   */
  public static class TransferData {
    /**
     * ID of an existing, connected Stripe account.
     */
    @SerializedName("destination")
    String destination;
    /**
     * Map of extra parameters for custom features not available in this client library. The content
     * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
     * key/value pair is serialized as if the key is a root-level field (serialized) name in this
     * param object. Effectively, this map is flattened to its parent instance.
     */
    @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
    Map<String, Object> extraParams;

    private TransferData(String destination, Map<String, Object> extraParams) {
      this.destination = destination;
      this.extraParams = extraParams;
    }

    public static Builder builder() {
      return new com.stripe.param.SubscriptionUpdateParams.TransferData.Builder();
    }


    public static class Builder {
      private String destination;
      private Map<String, Object> extraParams;

      /** Finalize and obtain parameter instance from this builder. */
      public TransferData build() {
        return new TransferData(this.destination, this.extraParams);
      }

      /** ID of an existing, connected Stripe account. */
      public Builder setDestination(String destination) {
        this.destination = destination;
        return this;
      }

      /**
       * Add a key/value pair to `extraParams` map. A map is initialized for the first `put/putAll`
       * call, and subsequent calls add additional key/value pairs to the original map. See {@link
       * SubscriptionUpdateParams.TransferData#extraParams} for the field documentation.
       */
      public Builder putExtraParam(String key, Object value) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.put(key, value);
        return this;
      }

      public Builder putAllExtraParam(Map<String, Object> map) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.putAll(map);
        return this;
      }
    }
  }


  /**
   * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
   * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
   * See {@link SubscriptionUpdateParams.TransferData#extraParams} for the field documentation.
   */
  public enum Billing implements ApiRequestParams.EnumParam {
    @SerializedName("charge_automatically")
    CHARGE_AUTOMATICALLY("charge_automatically"), @SerializedName("send_invoice")
    SEND_INVOICE("send_invoice");
    private final String value;

    Billing(String value) {
      this.value = value;
    }

    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getValue() {
      return this.value;
    }
  }


  public enum BillingCycleAnchor implements ApiRequestParams.EnumParam {
    @SerializedName("now")
    NOW("now"), @SerializedName("unchanged")
    UNCHANGED("unchanged");
    private final String value;

    BillingCycleAnchor(String value) {
      this.value = value;
    }

    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getValue() {
      return this.value;
    }
  }


  public enum CollectionMethod implements ApiRequestParams.EnumParam {
    @SerializedName("charge_automatically")
    CHARGE_AUTOMATICALLY("charge_automatically"), @SerializedName("send_invoice")
    SEND_INVOICE("send_invoice");
    private final String value;

    CollectionMethod(String value) {
      this.value = value;
    }

    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getValue() {
      return this.value;
    }
  }


  public enum PaymentBehavior implements ApiRequestParams.EnumParam {
    @SerializedName("allow_incomplete")
    ALLOW_INCOMPLETE("allow_incomplete"), @SerializedName("error_if_incomplete")
    ERROR_IF_INCOMPLETE("error_if_incomplete");
    private final String value;

    PaymentBehavior(String value) {
      this.value = value;
    }

    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getValue() {
      return this.value;
    }
  }


  public enum TrialEnd implements ApiRequestParams.EnumParam {
    @SerializedName("now")
    NOW("now");
    private final String value;

    TrialEnd(String value) {
      this.value = value;
    }

    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getValue() {
      return this.value;
    }
  }
}
