/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.stripe.exception.EventDataObjectDeserializationException;
import com.stripe.model.EventDataDeserializer;
import com.stripe.model.StripeObject;
import java.util.Optional;
import lombok.Generated;

public class EventDataObjectDeserializer {
    String apiVersion;
    String eventType;
    JsonObject rawJsonObject;
    private StripeObject object;

    EventDataObjectDeserializer(String apiVersion, String eventType, JsonObject rawJsonObject) {
        this.apiVersion = apiVersion;
        this.rawJsonObject = rawJsonObject;
        this.eventType = eventType;
    }

    public Optional<StripeObject> getObject() {
        if (this.object != null) {
            return Optional.of(this.object);
        }
        if (this.deserialize()) {
            return Optional.of(this.object);
        }
        return Optional.empty();
    }

    public String getRawJson() {
        return this.rawJsonObject.toString();
    }

    private boolean deserialize() {
        if (!this.apiVersionMatch()) {
            return false;
        }
        if (this.object != null) {
            return true;
        }
        try {
            this.object = EventDataDeserializer.deserializeStripeObject(this.rawJsonObject);
            return true;
        }
        catch (JsonParseException e) {
            return false;
        }
    }

    public StripeObject deserializeUnsafe() throws EventDataObjectDeserializationException {
        try {
            return EventDataDeserializer.deserializeStripeObject(this.rawJsonObject);
        }
        catch (JsonParseException e) {
            String errorMessage = !this.apiVersionMatch() ? String.format("Current `stripe-java` integration has Stripe API version %s, but the event data object has %s. The JSON data might have schema not compatible with the current model classes; such incompatibility can be the cause of deserialization failure. If you are deserializing webhoook events, consider creating a different webhook endpoint with `api_version` at %s. See Stripe API reference for more details. If you are deserializing old events from `Event#retrieve`, consider transforming the raw JSON data object to be compatible with this current model class schemas using `deserializeUnsafeWith`. Original error message: %s", this.getIntegrationApiVersion(), this.apiVersion, this.getIntegrationApiVersion(), e.getMessage()) : String.format("Unable to deserialize event data object to respective Stripe object. Please see the raw JSON, and contact support@stripe.com for assistance. Original error message: %s", e.getMessage());
            throw new EventDataObjectDeserializationException(errorMessage, this.rawJsonObject.toString());
        }
    }

    public StripeObject deserializeUnsafeWith(CompatibilityTransformer transformer) {
        return EventDataDeserializer.deserializeStripeObject(transformer.transform(this.rawJsonObject.deepCopy(), this.apiVersion, this.eventType));
    }

    private boolean apiVersionMatch() {
        return this.getIntegrationApiVersion().equals(this.apiVersion);
    }

    String getIntegrationApiVersion() {
        return "2019-08-14";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventDataObjectDeserializer)) {
            return false;
        }
        EventDataObjectDeserializer other = (EventDataObjectDeserializer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$apiVersion = this.apiVersion;
        String other$apiVersion = other.apiVersion;
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        String this$eventType = this.eventType;
        String other$eventType = other.eventType;
        if (this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType)) {
            return false;
        }
        JsonObject this$rawJsonObject = this.rawJsonObject;
        JsonObject other$rawJsonObject = other.rawJsonObject;
        if (this$rawJsonObject == null ? other$rawJsonObject != null : !this$rawJsonObject.equals(other$rawJsonObject)) {
            return false;
        }
        Optional<StripeObject> this$object = this.getObject();
        Optional<StripeObject> other$object = other.getObject();
        return !(this$object == null ? other$object != null : !((Object)this$object).equals(other$object));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EventDataObjectDeserializer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $apiVersion = this.apiVersion;
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        String $eventType = this.eventType;
        result = result * 59 + ($eventType == null ? 43 : $eventType.hashCode());
        JsonObject $rawJsonObject = this.rawJsonObject;
        result = result * 59 + ($rawJsonObject == null ? 43 : $rawJsonObject.hashCode());
        Optional<StripeObject> $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : ((Object)$object).hashCode());
        return result;
    }

    public static interface CompatibilityTransformer {
        public JsonObject transform(JsonObject var1, String var2, String var3);
    }
}

