/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SetupIntentUpdateParams
extends ApiRequestParams {
    @SerializedName(value="customer")
    String customer;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="_stripe_java_extra_param_key")
    Map<String, Object> extraParams;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="payment_method")
    String paymentMethod;
    @SerializedName(value="payment_method_types")
    List<String> paymentMethodTypes;

    private SetupIntentUpdateParams(String customer, String description, List<String> expand, Map<String, Object> extraParams, Map<String, String> metadata, String paymentMethod, List<String> paymentMethodTypes) {
        this.customer = customer;
        this.description = description;
        this.expand = expand;
        this.extraParams = extraParams;
        this.metadata = metadata;
        this.paymentMethod = paymentMethod;
        this.paymentMethodTypes = paymentMethodTypes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String customer;
        private String description;
        private List<String> expand;
        private Map<String, Object> extraParams;
        private Map<String, String> metadata;
        private String paymentMethod;
        private List<String> paymentMethodTypes;

        public SetupIntentUpdateParams build() {
            return new SetupIntentUpdateParams(this.customer, this.description, this.expand, this.extraParams, this.metadata, this.paymentMethod, this.paymentMethodTypes);
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.put(key, value);
            return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.putAll(map);
            return this;
        }

        public Builder putMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder putAllMetadata(Map<String, String> map) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.putAll(map);
            return this;
        }

        public Builder setPaymentMethod(String paymentMethod) {
            this.paymentMethod = paymentMethod;
            return this;
        }

        public Builder addPaymentMethodType(String element) {
            if (this.paymentMethodTypes == null) {
                this.paymentMethodTypes = new ArrayList<String>();
            }
            this.paymentMethodTypes.add(element);
            return this;
        }

        public Builder addAllPaymentMethodType(List<String> elements) {
            if (this.paymentMethodTypes == null) {
                this.paymentMethodTypes = new ArrayList<String>();
            }
            this.paymentMethodTypes.addAll(elements);
            return this;
        }
    }
}

