/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PaymentMethodUpdateParams
extends ApiRequestParams {
    @SerializedName(value="billing_details")
    BillingDetails billingDetails;
    @SerializedName(value="card")
    Card card;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="_stripe_java_extra_param_key")
    Map<String, Object> extraParams;
    @SerializedName(value="metadata")
    Map<String, String> metadata;

    private PaymentMethodUpdateParams(BillingDetails billingDetails, Card card, List<String> expand, Map<String, Object> extraParams, Map<String, String> metadata) {
        this.billingDetails = billingDetails;
        this.card = card;
        this.expand = expand;
        this.extraParams = extraParams;
        this.metadata = metadata;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Card {
        @SerializedName(value="exp_month")
        Long expMonth;
        @SerializedName(value="exp_year")
        Long expYear;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;

        private Card(Long expMonth, Long expYear, Map<String, Object> extraParams) {
            this.expMonth = expMonth;
            this.expYear = expYear;
            this.extraParams = extraParams;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private Long expMonth;
            private Long expYear;
            private Map<String, Object> extraParams;

            public Card build() {
                return new Card(this.expMonth, this.expYear, this.extraParams);
            }

            public Builder setExpMonth(Long expMonth) {
                this.expMonth = expMonth;
                return this;
            }

            public Builder setExpYear(Long expYear) {
                this.expYear = expYear;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }
        }
    }

    public static class BillingDetails {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="email")
        String email;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="phone")
        String phone;

        private BillingDetails(Address address, String email, Map<String, Object> extraParams, String name, String phone) {
            this.address = address;
            this.email = email;
            this.extraParams = extraParams;
            this.name = name;
            this.phone = phone;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Address {
            @SerializedName(value="city")
            String city;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="line1")
            String line1;
            @SerializedName(value="line2")
            String line2;
            @SerializedName(value="postal_code")
            String postalCode;
            @SerializedName(value="state")
            String state;

            private Address(String city, String country, Map<String, Object> extraParams, String line1, String line2, String postalCode, String state) {
                this.city = city;
                this.country = country;
                this.extraParams = extraParams;
                this.line1 = line1;
                this.line2 = line2;
                this.postalCode = postalCode;
                this.state = state;
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder {
                private String city;
                private String country;
                private Map<String, Object> extraParams;
                private String line1;
                private String line2;
                private String postalCode;
                private String state;

                public Address build() {
                    return new Address(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
                }

                public Builder setCity(String city) {
                    this.city = city;
                    return this;
                }

                public Builder setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setLine1(String line1) {
                    this.line1 = line1;
                    return this;
                }

                public Builder setLine2(String line2) {
                    this.line2 = line2;
                    return this;
                }

                public Builder setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                    return this;
                }

                public Builder setState(String state) {
                    this.state = state;
                    return this;
                }
            }
        }

        public static class Builder {
            private Address address;
            private String email;
            private Map<String, Object> extraParams;
            private String name;
            private String phone;

            public BillingDetails build() {
                return new BillingDetails(this.address, this.email, this.extraParams, this.name, this.phone);
            }

            public Builder setAddress(Address address) {
                this.address = address;
                return this;
            }

            public Builder setEmail(String email) {
                this.email = email;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setName(String name) {
                this.name = name;
                return this;
            }

            public Builder setPhone(String phone) {
                this.phone = phone;
                return this;
            }
        }
    }

    public static class Builder {
        private BillingDetails billingDetails;
        private Card card;
        private List<String> expand;
        private Map<String, Object> extraParams;
        private Map<String, String> metadata;

        public PaymentMethodUpdateParams build() {
            return new PaymentMethodUpdateParams(this.billingDetails, this.card, this.expand, this.extraParams, this.metadata);
        }

        public Builder setBillingDetails(BillingDetails billingDetails) {
            this.billingDetails = billingDetails;
            return this;
        }

        public Builder setCard(Card card) {
            this.card = card;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.put(key, value);
            return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.putAll(map);
            return this;
        }

        public Builder putMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder putAllMetadata(Map<String, String> map) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.putAll(map);
            return this;
        }
    }
}

