// Generated by delombok at Tue Sep 10 10:44:01 PDT 2019
package com.stripe.model.terminal;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.terminal.ReaderCreateParams;
import com.stripe.param.terminal.ReaderDeleteParams;
import com.stripe.param.terminal.ReaderListParams;
import com.stripe.param.terminal.ReaderRetrieveParams;
import com.stripe.param.terminal.ReaderUpdateParams;
import java.util.Map;

public class Reader extends ApiResource implements HasId {
  /**
   * Always true for a deleted object.
   */
  @SerializedName("deleted")
  Boolean deleted;
  /**
   * The current software version of the reader.
   */
  @SerializedName("device_sw_version")
  String deviceSwVersion;
  /**
   * Type of reader, e.g., `verifone_P400` or `bbpos_chipper2x`.
   */
  @SerializedName("device_type")
  String deviceType;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * The local IP address of the reader.
   */
  @SerializedName("ip_address")
  String ipAddress;
  /**
   * Custom label given to the reader for easier identification.
   */
  @SerializedName("label")
  String label;
  /**
   * The location identifier of the reader.
   */
  @SerializedName("location")
  String location;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  @SerializedName("object")
  String object;
  /**
   * Serial number of the reader.
   */
  @SerializedName("serial_number")
  String serialNumber;
  /**
   * The networking status of the reader.
   */
  @SerializedName("status")
  String status;

  /**
   * Updates a <code>Reader</code> object by setting the values of the parameters passed. Any
   * parameters not provided will be left unchanged.
   */
  public Reader update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates a <code>Reader</code> object by setting the values of the parameters passed. Any
   * parameters not provided will be left unchanged.
   */
  public Reader update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/readers/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Reader.class, options);
  }

  /**
   * Updates a <code>Reader</code> object by setting the values of the parameters passed. Any
   * parameters not provided will be left unchanged.
   */
  public Reader update(ReaderUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates a <code>Reader</code> object by setting the values of the parameters passed. Any
   * parameters not provided will be left unchanged.
   */
  public Reader update(ReaderUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/readers/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Reader.class, options);
  }

  /**
   * Retrieves a <code>Reader</code> object.
   */
  public static Reader retrieve(String reader) throws StripeException {
    return retrieve(reader, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves a <code>Reader</code> object.
   */
  public static Reader retrieve(String reader, RequestOptions options) throws StripeException {
    return retrieve(reader, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves a <code>Reader</code> object.
   */
  public static Reader retrieve(String reader, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/readers/%s", ApiResource.urlEncodeId(reader)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Reader.class, options);
  }

  /**
   * Retrieves a <code>Reader</code> object.
   */
  public static Reader retrieve(String reader, ReaderRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/readers/%s", ApiResource.urlEncodeId(reader)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Reader.class, options);
  }

  /**
   * Creates a new <code>Reader</code> object.
   */
  public static Reader create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a new <code>Reader</code> object.
   */
  public static Reader create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/terminal/readers");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Reader.class, options);
  }

  /**
   * Creates a new <code>Reader</code> object.
   */
  public static Reader create(ReaderCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a new <code>Reader</code> object.
   */
  public static Reader create(ReaderCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/terminal/readers");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Reader.class, options);
  }

  /**
   * Returns a list of <code>Reader</code> objects.
   */
  public static ReaderCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of <code>Reader</code> objects.
   */
  public static ReaderCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/terminal/readers");
    return ApiResource.requestCollection(url, params, ReaderCollection.class, options);
  }

  /**
   * Returns a list of <code>Reader</code> objects.
   */
  public static ReaderCollection list(ReaderListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of <code>Reader</code> objects.
   */
  public static ReaderCollection list(ReaderListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/terminal/readers");
    return ApiResource.requestCollection(url, params, ReaderCollection.class, options);
  }

  /**
   * Deletes a <code>Reader</code> object.
   */
  public Reader delete() throws StripeException {
    return delete((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Deletes a <code>Reader</code> object.
   */
  public Reader delete(RequestOptions options) throws StripeException {
    return delete((Map<String, Object>) null, options);
  }

  /**
   * Deletes a <code>Reader</code> object.
   */
  public Reader delete(Map<String, Object> params) throws StripeException {
    return delete(params, (RequestOptions) null);
  }

  /**
   * Deletes a <code>Reader</code> object.
   */
  public Reader delete(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/readers/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.DELETE, url, params, Reader.class, options);
  }

  /**
   * Deletes a <code>Reader</code> object.
   */
  public Reader delete(ReaderDeleteParams params) throws StripeException {
    return delete(params, (RequestOptions) null);
  }

  /**
   * Deletes a <code>Reader</code> object.
   */
  public Reader delete(ReaderDeleteParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/readers/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.DELETE, url, params, Reader.class, options);
  }

  /**
   * Always true for a deleted object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getDeleted() {
    return this.deleted;
  }

  /**
   * The current software version of the reader.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDeviceSwVersion() {
    return this.deviceSwVersion;
  }

  /**
   * Type of reader, e.g., `verifone_P400` or `bbpos_chipper2x`.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDeviceType() {
    return this.deviceType;
  }

  /**
   * The local IP address of the reader.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getIpAddress() {
    return this.ipAddress;
  }

  /**
   * Custom label given to the reader for easier identification.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getLabel() {
    return this.label;
  }

  /**
   * The location identifier of the reader.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getLocation() {
    return this.location;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * Serial number of the reader.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSerialNumber() {
    return this.serialNumber;
  }

  /**
   * The networking status of the reader.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  /**
   * Always true for a deleted object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeleted(final Boolean deleted) {
    this.deleted = deleted;
  }

  /**
   * The current software version of the reader.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeviceSwVersion(final String deviceSwVersion) {
    this.deviceSwVersion = deviceSwVersion;
  }

  /**
   * Type of reader, e.g., `verifone_P400` or `bbpos_chipper2x`.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeviceType(final String deviceType) {
    this.deviceType = deviceType;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * The local IP address of the reader.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setIpAddress(final String ipAddress) {
    this.ipAddress = ipAddress;
  }

  /**
   * Custom label given to the reader for easier identification.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLabel(final String label) {
    this.label = label;
  }

  /**
   * The location identifier of the reader.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLocation(final String location) {
    this.location = location;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * Serial number of the reader.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSerialNumber(final String serialNumber) {
    this.serialNumber = serialNumber;
  }

  /**
   * The networking status of the reader.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Reader)) return false;
    final Reader other = (Reader) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$deleted = this.getDeleted();
    final java.lang.Object other$deleted = other.getDeleted();
    if (this$deleted == null ? other$deleted != null : !this$deleted.equals(other$deleted)) return false;
    final java.lang.Object this$deviceSwVersion = this.getDeviceSwVersion();
    final java.lang.Object other$deviceSwVersion = other.getDeviceSwVersion();
    if (this$deviceSwVersion == null ? other$deviceSwVersion != null : !this$deviceSwVersion.equals(other$deviceSwVersion)) return false;
    final java.lang.Object this$deviceType = this.getDeviceType();
    final java.lang.Object other$deviceType = other.getDeviceType();
    if (this$deviceType == null ? other$deviceType != null : !this$deviceType.equals(other$deviceType)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$ipAddress = this.getIpAddress();
    final java.lang.Object other$ipAddress = other.getIpAddress();
    if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) return false;
    final java.lang.Object this$label = this.getLabel();
    final java.lang.Object other$label = other.getLabel();
    if (this$label == null ? other$label != null : !this$label.equals(other$label)) return false;
    final java.lang.Object this$location = this.getLocation();
    final java.lang.Object other$location = other.getLocation();
    if (this$location == null ? other$location != null : !this$location.equals(other$location)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$serialNumber = this.getSerialNumber();
    final java.lang.Object other$serialNumber = other.getSerialNumber();
    if (this$serialNumber == null ? other$serialNumber != null : !this$serialNumber.equals(other$serialNumber)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Reader;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $deleted = this.getDeleted();
    result = result * PRIME + ($deleted == null ? 43 : $deleted.hashCode());
    final java.lang.Object $deviceSwVersion = this.getDeviceSwVersion();
    result = result * PRIME + ($deviceSwVersion == null ? 43 : $deviceSwVersion.hashCode());
    final java.lang.Object $deviceType = this.getDeviceType();
    result = result * PRIME + ($deviceType == null ? 43 : $deviceType.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $ipAddress = this.getIpAddress();
    result = result * PRIME + ($ipAddress == null ? 43 : $ipAddress.hashCode());
    final java.lang.Object $label = this.getLabel();
    result = result * PRIME + ($label == null ? 43 : $label.hashCode());
    final java.lang.Object $location = this.getLocation();
    result = result * PRIME + ($location == null ? 43 : $location.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $serialNumber = this.getSerialNumber();
    result = result * PRIME + ($serialNumber == null ? 43 : $serialNumber.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
