/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import com.stripe.param.common.EmptyParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class PaymentIntentConfirmParams
extends ApiRequestParams {
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="_stripe_java_extra_param_key")
    Map<String, Object> extraParams;
    @SerializedName(value="off_session")
    Object offSession;
    @SerializedName(value="payment_method")
    String paymentMethod;
    @SerializedName(value="payment_method_options")
    PaymentMethodOptions paymentMethodOptions;
    @SerializedName(value="receipt_email")
    Object receiptEmail;
    @SerializedName(value="return_url")
    String returnUrl;
    @SerializedName(value="save_payment_method")
    Boolean savePaymentMethod;
    @SerializedName(value="setup_future_usage")
    ApiRequestParams.EnumParam setupFutureUsage;
    @SerializedName(value="shipping")
    Object shipping;
    @SerializedName(value="source")
    String source;

    private PaymentIntentConfirmParams(List<String> expand, Map<String, Object> extraParams, Object offSession, String paymentMethod, PaymentMethodOptions paymentMethodOptions, Object receiptEmail, String returnUrl, Boolean savePaymentMethod, ApiRequestParams.EnumParam setupFutureUsage, Object shipping, String source) {
        this.expand = expand;
        this.extraParams = extraParams;
        this.offSession = offSession;
        this.paymentMethod = paymentMethod;
        this.paymentMethodOptions = paymentMethodOptions;
        this.receiptEmail = receiptEmail;
        this.returnUrl = returnUrl;
        this.savePaymentMethod = savePaymentMethod;
        this.setupFutureUsage = setupFutureUsage;
        this.shipping = shipping;
        this.source = source;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
    {
        OFF_SESSION("off_session"),
        ON_SESSION("on_session");

        private final String value;

        private SetupFutureUsage(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static enum OffSession implements ApiRequestParams.EnumParam
    {
        ONE_OFF("one_off"),
        RECURRING("recurring");

        private final String value;

        private OffSession(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class Shipping {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="carrier")
        String carrier;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="phone")
        String phone;
        @SerializedName(value="tracking_number")
        String trackingNumber;

        private Shipping(Address address, String carrier, Map<String, Object> extraParams, String name, String phone, String trackingNumber) {
            this.address = address;
            this.carrier = carrier;
            this.extraParams = extraParams;
            this.name = name;
            this.phone = phone;
            this.trackingNumber = trackingNumber;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Address {
            @SerializedName(value="city")
            String city;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="line1")
            String line1;
            @SerializedName(value="line2")
            String line2;
            @SerializedName(value="postal_code")
            String postalCode;
            @SerializedName(value="state")
            String state;

            private Address(String city, String country, Map<String, Object> extraParams, String line1, String line2, String postalCode, String state) {
                this.city = city;
                this.country = country;
                this.extraParams = extraParams;
                this.line1 = line1;
                this.line2 = line2;
                this.postalCode = postalCode;
                this.state = state;
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder {
                private String city;
                private String country;
                private Map<String, Object> extraParams;
                private String line1;
                private String line2;
                private String postalCode;
                private String state;

                public Address build() {
                    return new Address(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
                }

                public Builder setCity(String city) {
                    this.city = city;
                    return this;
                }

                public Builder setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setLine1(String line1) {
                    this.line1 = line1;
                    return this;
                }

                public Builder setLine2(String line2) {
                    this.line2 = line2;
                    return this;
                }

                public Builder setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                    return this;
                }

                public Builder setState(String state) {
                    this.state = state;
                    return this;
                }
            }
        }

        public static class Builder {
            private Address address;
            private String carrier;
            private Map<String, Object> extraParams;
            private String name;
            private String phone;
            private String trackingNumber;

            public Shipping build() {
                return new Shipping(this.address, this.carrier, this.extraParams, this.name, this.phone, this.trackingNumber);
            }

            public Builder setAddress(Address address) {
                this.address = address;
                return this;
            }

            public Builder setCarrier(String carrier) {
                this.carrier = carrier;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setName(String name) {
                this.name = name;
                return this;
            }

            public Builder setPhone(String phone) {
                this.phone = phone;
                return this;
            }

            public Builder setTrackingNumber(String trackingNumber) {
                this.trackingNumber = trackingNumber;
                return this;
            }
        }
    }

    public static class PaymentMethodOptions {
        @SerializedName(value="card")
        Card card;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;

        private PaymentMethodOptions(Card card, Map<String, Object> extraParams) {
            this.card = card;
            this.extraParams = extraParams;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Card {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="moto")
            Boolean moto;
            @SerializedName(value="request_three_d_secure")
            RequestThreeDSecure requestThreeDSecure;

            private Card(Map<String, Object> extraParams, Boolean moto, RequestThreeDSecure requestThreeDSecure) {
                this.extraParams = extraParams;
                this.moto = moto;
                this.requestThreeDSecure = requestThreeDSecure;
            }

            public static Builder builder() {
                return new Builder();
            }

            public static enum RequestThreeDSecure implements ApiRequestParams.EnumParam
            {
                ANY("any"),
                AUTOMATIC("automatic");

                private final String value;

                private RequestThreeDSecure(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Boolean moto;
                private RequestThreeDSecure requestThreeDSecure;

                public Card build() {
                    return new Card(this.extraParams, this.moto, this.requestThreeDSecure);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setMoto(Boolean moto) {
                    this.moto = moto;
                    return this;
                }

                public Builder setRequestThreeDSecure(RequestThreeDSecure requestThreeDSecure) {
                    this.requestThreeDSecure = requestThreeDSecure;
                    return this;
                }
            }
        }

        public static class Builder {
            private Card card;
            private Map<String, Object> extraParams;

            public PaymentMethodOptions build() {
                return new PaymentMethodOptions(this.card, this.extraParams);
            }

            public Builder setCard(Card card) {
                this.card = card;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }
        }
    }

    public static class Builder {
        private List<String> expand;
        private Map<String, Object> extraParams;
        private Object offSession;
        private String paymentMethod;
        private PaymentMethodOptions paymentMethodOptions;
        private Object receiptEmail;
        private String returnUrl;
        private Boolean savePaymentMethod;
        private ApiRequestParams.EnumParam setupFutureUsage;
        private Object shipping;
        private String source;

        public PaymentIntentConfirmParams build() {
            return new PaymentIntentConfirmParams(this.expand, this.extraParams, this.offSession, this.paymentMethod, this.paymentMethodOptions, this.receiptEmail, this.returnUrl, this.savePaymentMethod, this.setupFutureUsage, this.shipping, this.source);
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.put(key, value);
            return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.putAll(map);
            return this;
        }

        public Builder setOffSession(Boolean offSession) {
            this.offSession = offSession;
            return this;
        }

        public Builder setOffSession(OffSession offSession) {
            this.offSession = offSession;
            return this;
        }

        public Builder setPaymentMethod(String paymentMethod) {
            this.paymentMethod = paymentMethod;
            return this;
        }

        public Builder setPaymentMethodOptions(PaymentMethodOptions paymentMethodOptions) {
            this.paymentMethodOptions = paymentMethodOptions;
            return this;
        }

        public Builder setReceiptEmail(String receiptEmail) {
            this.receiptEmail = receiptEmail;
            return this;
        }

        public Builder setReceiptEmail(EmptyParam receiptEmail) {
            this.receiptEmail = receiptEmail;
            return this;
        }

        public Builder setReturnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
            return this;
        }

        public Builder setSavePaymentMethod(Boolean savePaymentMethod) {
            this.savePaymentMethod = savePaymentMethod;
            return this;
        }

        public Builder setSetupFutureUsage(EmptyParam setupFutureUsage) {
            this.setupFutureUsage = setupFutureUsage;
            return this;
        }

        public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
            this.setupFutureUsage = setupFutureUsage;
            return this;
        }

        public Builder setShipping(Shipping shipping) {
            this.shipping = shipping;
            return this;
        }

        public Builder setShipping(EmptyParam shipping) {
            this.shipping = shipping;
            return this;
        }

        public Builder setSource(String source) {
            this.source = source;
            return this;
        }
    }
}

