/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import com.stripe.param.common.EmptyParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class WebhookEndpointUpdateParams
extends ApiRequestParams {
    @SerializedName(value="disabled")
    Boolean disabled;
    @SerializedName(value="enabled_events")
    List<EnabledEvent> enabledEvents;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="_stripe_java_extra_param_key")
    Map<String, Object> extraParams;
    @SerializedName(value="url")
    Object url;

    private WebhookEndpointUpdateParams(Boolean disabled, List<EnabledEvent> enabledEvents, List<String> expand, Map<String, Object> extraParams, Object url) {
        this.disabled = disabled;
        this.enabledEvents = enabledEvents;
        this.expand = expand;
        this.extraParams = extraParams;
        this.url = url;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum EnabledEvent implements ApiRequestParams.EnumParam
    {
        ALL("*"),
        ACCOUNT__APPLICATION__AUTHORIZED("account.application.authorized"),
        ACCOUNT__APPLICATION__DEAUTHORIZED("account.application.deauthorized"),
        ACCOUNT__EXTERNAL_ACCOUNT__CREATED("account.external_account.created"),
        ACCOUNT__EXTERNAL_ACCOUNT__DELETED("account.external_account.deleted"),
        ACCOUNT__EXTERNAL_ACCOUNT__UPDATED("account.external_account.updated"),
        ACCOUNT__UPDATED("account.updated"),
        APPLICATION_FEE__CREATED("application_fee.created"),
        APPLICATION_FEE__REFUND__UPDATED("application_fee.refund.updated"),
        APPLICATION_FEE__REFUNDED("application_fee.refunded"),
        BALANCE__AVAILABLE("balance.available"),
        CAPABILITY__UPDATED("capability.updated"),
        CHARGE__CAPTURED("charge.captured"),
        CHARGE__DISPUTE__CLOSED("charge.dispute.closed"),
        CHARGE__DISPUTE__CREATED("charge.dispute.created"),
        CHARGE__DISPUTE__FUNDS_REINSTATED("charge.dispute.funds_reinstated"),
        CHARGE__DISPUTE__FUNDS_WITHDRAWN("charge.dispute.funds_withdrawn"),
        CHARGE__DISPUTE__UPDATED("charge.dispute.updated"),
        CHARGE__EXPIRED("charge.expired"),
        CHARGE__FAILED("charge.failed"),
        CHARGE__PENDING("charge.pending"),
        CHARGE__REFUND__UPDATED("charge.refund.updated"),
        CHARGE__REFUNDED("charge.refunded"),
        CHARGE__SUCCEEDED("charge.succeeded"),
        CHARGE__UPDATED("charge.updated"),
        CHECKOUT__SESSION__COMPLETED("checkout.session.completed"),
        COUPON__CREATED("coupon.created"),
        COUPON__DELETED("coupon.deleted"),
        COUPON__UPDATED("coupon.updated"),
        CREDIT_NOTE__CREATED("credit_note.created"),
        CREDIT_NOTE__UPDATED("credit_note.updated"),
        CREDIT_NOTE__VOIDED("credit_note.voided"),
        CUSTOMER__CREATED("customer.created"),
        CUSTOMER__DELETED("customer.deleted"),
        CUSTOMER__DISCOUNT__CREATED("customer.discount.created"),
        CUSTOMER__DISCOUNT__DELETED("customer.discount.deleted"),
        CUSTOMER__DISCOUNT__UPDATED("customer.discount.updated"),
        CUSTOMER__SOURCE__CREATED("customer.source.created"),
        CUSTOMER__SOURCE__DELETED("customer.source.deleted"),
        CUSTOMER__SOURCE__EXPIRING("customer.source.expiring"),
        CUSTOMER__SOURCE__UPDATED("customer.source.updated"),
        CUSTOMER__SUBSCRIPTION__CREATED("customer.subscription.created"),
        CUSTOMER__SUBSCRIPTION__DELETED("customer.subscription.deleted"),
        CUSTOMER__SUBSCRIPTION__TRIAL_WILL_END("customer.subscription.trial_will_end"),
        CUSTOMER__SUBSCRIPTION__UPDATED("customer.subscription.updated"),
        CUSTOMER__TAX_ID__CREATED("customer.tax_id.created"),
        CUSTOMER__TAX_ID__DELETED("customer.tax_id.deleted"),
        CUSTOMER__TAX_ID__UPDATED("customer.tax_id.updated"),
        CUSTOMER__UPDATED("customer.updated"),
        FILE__CREATED("file.created"),
        INVOICE__CREATED("invoice.created"),
        INVOICE__DELETED("invoice.deleted"),
        INVOICE__FINALIZED("invoice.finalized"),
        INVOICE__MARKED_UNCOLLECTIBLE("invoice.marked_uncollectible"),
        INVOICE__PAYMENT_ACTION_REQUIRED("invoice.payment_action_required"),
        INVOICE__PAYMENT_FAILED("invoice.payment_failed"),
        INVOICE__PAYMENT_SUCCEEDED("invoice.payment_succeeded"),
        INVOICE__SENT("invoice.sent"),
        INVOICE__UPCOMING("invoice.upcoming"),
        INVOICE__UPDATED("invoice.updated"),
        INVOICE__VOIDED("invoice.voided"),
        INVOICEITEM__CREATED("invoiceitem.created"),
        INVOICEITEM__DELETED("invoiceitem.deleted"),
        INVOICEITEM__UPDATED("invoiceitem.updated"),
        ISSUING_AUTHORIZATION__CREATED("issuing_authorization.created"),
        ISSUING_AUTHORIZATION__REQUEST("issuing_authorization.request"),
        ISSUING_AUTHORIZATION__UPDATED("issuing_authorization.updated"),
        ISSUING_CARD__CREATED("issuing_card.created"),
        ISSUING_CARD__UPDATED("issuing_card.updated"),
        ISSUING_CARDHOLDER__CREATED("issuing_cardholder.created"),
        ISSUING_CARDHOLDER__UPDATED("issuing_cardholder.updated"),
        ISSUING_DISPUTE__CREATED("issuing_dispute.created"),
        ISSUING_DISPUTE__UPDATED("issuing_dispute.updated"),
        ISSUING_SETTLEMENT__CREATED("issuing_settlement.created"),
        ISSUING_SETTLEMENT__UPDATED("issuing_settlement.updated"),
        ISSUING_TRANSACTION__CREATED("issuing_transaction.created"),
        ISSUING_TRANSACTION__UPDATED("issuing_transaction.updated"),
        ORDER__CREATED("order.created"),
        ORDER__PAYMENT_FAILED("order.payment_failed"),
        ORDER__PAYMENT_SUCCEEDED("order.payment_succeeded"),
        ORDER__UPDATED("order.updated"),
        ORDER_RETURN__CREATED("order_return.created"),
        PAYMENT_INTENT__AMOUNT_CAPTURABLE_UPDATED("payment_intent.amount_capturable_updated"),
        PAYMENT_INTENT__CANCELED("payment_intent.canceled"),
        PAYMENT_INTENT__CREATED("payment_intent.created"),
        PAYMENT_INTENT__PAYMENT_FAILED("payment_intent.payment_failed"),
        PAYMENT_INTENT__SUCCEEDED("payment_intent.succeeded"),
        PAYMENT_METHOD__ATTACHED("payment_method.attached"),
        PAYMENT_METHOD__CARD_AUTOMATICALLY_UPDATED("payment_method.card_automatically_updated"),
        PAYMENT_METHOD__DETACHED("payment_method.detached"),
        PAYMENT_METHOD__UPDATED("payment_method.updated"),
        PAYOUT__CANCELED("payout.canceled"),
        PAYOUT__CREATED("payout.created"),
        PAYOUT__FAILED("payout.failed"),
        PAYOUT__PAID("payout.paid"),
        PAYOUT__UPDATED("payout.updated"),
        PERSON__CREATED("person.created"),
        PERSON__DELETED("person.deleted"),
        PERSON__UPDATED("person.updated"),
        PLAN__CREATED("plan.created"),
        PLAN__DELETED("plan.deleted"),
        PLAN__UPDATED("plan.updated"),
        PRODUCT__CREATED("product.created"),
        PRODUCT__DELETED("product.deleted"),
        PRODUCT__UPDATED("product.updated"),
        RADAR__EARLY_FRAUD_WARNING__CREATED("radar.early_fraud_warning.created"),
        RADAR__EARLY_FRAUD_WARNING__UPDATED("radar.early_fraud_warning.updated"),
        RECIPIENT__CREATED("recipient.created"),
        RECIPIENT__DELETED("recipient.deleted"),
        RECIPIENT__UPDATED("recipient.updated"),
        REPORTING__REPORT_RUN__FAILED("reporting.report_run.failed"),
        REPORTING__REPORT_RUN__SUCCEEDED("reporting.report_run.succeeded"),
        REPORTING__REPORT_TYPE__UPDATED("reporting.report_type.updated"),
        REVIEW__CLOSED("review.closed"),
        REVIEW__OPENED("review.opened"),
        SETUP_INTENT__CANCELED("setup_intent.canceled"),
        SETUP_INTENT__CREATED("setup_intent.created"),
        SETUP_INTENT__SETUP_FAILED("setup_intent.setup_failed"),
        SETUP_INTENT__SUCCEEDED("setup_intent.succeeded"),
        SIGMA__SCHEDULED_QUERY_RUN__CREATED("sigma.scheduled_query_run.created"),
        SKU__CREATED("sku.created"),
        SKU__DELETED("sku.deleted"),
        SKU__UPDATED("sku.updated"),
        SOURCE__CANCELED("source.canceled"),
        SOURCE__CHARGEABLE("source.chargeable"),
        SOURCE__FAILED("source.failed"),
        SOURCE__MANDATE_NOTIFICATION("source.mandate_notification"),
        SOURCE__REFUND_ATTRIBUTES_REQUIRED("source.refund_attributes_required"),
        SOURCE__TRANSACTION__CREATED("source.transaction.created"),
        SOURCE__TRANSACTION__UPDATED("source.transaction.updated"),
        SUBSCRIPTION_SCHEDULE__ABORTED("subscription_schedule.aborted"),
        SUBSCRIPTION_SCHEDULE__CANCELED("subscription_schedule.canceled"),
        SUBSCRIPTION_SCHEDULE__COMPLETED("subscription_schedule.completed"),
        SUBSCRIPTION_SCHEDULE__CREATED("subscription_schedule.created"),
        SUBSCRIPTION_SCHEDULE__EXPIRING("subscription_schedule.expiring"),
        SUBSCRIPTION_SCHEDULE__RELEASED("subscription_schedule.released"),
        SUBSCRIPTION_SCHEDULE__UPDATED("subscription_schedule.updated"),
        TAX_RATE__CREATED("tax_rate.created"),
        TAX_RATE__UPDATED("tax_rate.updated"),
        TOPUP__CANCELED("topup.canceled"),
        TOPUP__CREATED("topup.created"),
        TOPUP__FAILED("topup.failed"),
        TOPUP__REVERSED("topup.reversed"),
        TOPUP__SUCCEEDED("topup.succeeded"),
        TRANSFER__CREATED("transfer.created"),
        TRANSFER__FAILED("transfer.failed"),
        TRANSFER__PAID("transfer.paid"),
        TRANSFER__REVERSED("transfer.reversed"),
        TRANSFER__UPDATED("transfer.updated");

        private final String value;

        private EnabledEvent(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class Builder {
        private Boolean disabled;
        private List<EnabledEvent> enabledEvents;
        private List<String> expand;
        private Map<String, Object> extraParams;
        private Object url;

        public WebhookEndpointUpdateParams build() {
            return new WebhookEndpointUpdateParams(this.disabled, this.enabledEvents, this.expand, this.extraParams, this.url);
        }

        public Builder setDisabled(Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public Builder addEnabledEvent(EnabledEvent element) {
            if (this.enabledEvents == null) {
                this.enabledEvents = new ArrayList<EnabledEvent>();
            }
            this.enabledEvents.add(element);
            return this;
        }

        public Builder addAllEnabledEvent(List<EnabledEvent> elements) {
            if (this.enabledEvents == null) {
                this.enabledEvents = new ArrayList<EnabledEvent>();
            }
            this.enabledEvents.addAll(elements);
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.put(key, value);
            return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.putAll(map);
            return this;
        }

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder setUrl(EmptyParam url) {
            this.url = url;
            return this;
        }
    }
}

