/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Coupon;
import com.stripe.model.Customer;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.PaymentMethod;
import com.stripe.model.PaymentSource;
import com.stripe.model.Plan;
import com.stripe.model.StripeObject;
import com.stripe.model.Subscription;
import com.stripe.model.SubscriptionItem;
import com.stripe.model.SubscriptionScheduleCollection;
import com.stripe.model.TaxRate;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.SubscriptionScheduleCancelParams;
import com.stripe.param.SubscriptionScheduleCreateParams;
import com.stripe.param.SubscriptionScheduleListParams;
import com.stripe.param.SubscriptionScheduleReleaseParams;
import com.stripe.param.SubscriptionScheduleRetrieveParams;
import com.stripe.param.SubscriptionScheduleUpdateParams;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class SubscriptionSchedule
extends ApiResource
implements HasId,
MetadataStore<SubscriptionSchedule> {
    @SerializedName(value="billing")
    String billing;
    @SerializedName(value="billing_thresholds")
    Subscription.BillingThresholds billingThresholds;
    @SerializedName(value="canceled_at")
    Long canceledAt;
    @SerializedName(value="collection_method")
    String collectionMethod;
    @SerializedName(value="completed_at")
    Long completedAt;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="current_phase")
    CurrentPhase currentPhase;
    @SerializedName(value="customer")
    ExpandableField<Customer> customer;
    @SerializedName(value="default_payment_method")
    ExpandableField<PaymentMethod> defaultPaymentMethod;
    @SerializedName(value="default_source")
    ExpandableField<PaymentSource> defaultSource;
    @SerializedName(value="end_behavior")
    String endBehavior;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="invoice_settings")
    InvoiceSettings invoiceSettings;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="phases")
    List<Phase> phases;
    @SerializedName(value="released_at")
    Long releasedAt;
    @SerializedName(value="released_subscription")
    String releasedSubscription;
    @SerializedName(value="renewal_behavior")
    String renewalBehavior;
    @SerializedName(value="renewal_interval")
    RenewalInterval renewalInterval;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="subscription")
    ExpandableField<Subscription> subscription;

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String id) {
        this.customer = ApiResource.setExpandableFieldId(id, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer expandableObject) {
        this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
    }

    public String getDefaultPaymentMethod() {
        return this.defaultPaymentMethod != null ? this.defaultPaymentMethod.getId() : null;
    }

    public void setDefaultPaymentMethod(String id) {
        this.defaultPaymentMethod = ApiResource.setExpandableFieldId(id, this.defaultPaymentMethod);
    }

    public PaymentMethod getDefaultPaymentMethodObject() {
        return this.defaultPaymentMethod != null ? this.defaultPaymentMethod.getExpanded() : null;
    }

    public void setDefaultPaymentMethodObject(PaymentMethod expandableObject) {
        this.defaultPaymentMethod = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
    }

    public String getDefaultSource() {
        return this.defaultSource != null ? this.defaultSource.getId() : null;
    }

    public void setDefaultSource(String id) {
        this.defaultSource = ApiResource.setExpandableFieldId(id, this.defaultSource);
    }

    public PaymentSource getDefaultSourceObject() {
        return this.defaultSource != null ? this.defaultSource.getExpanded() : null;
    }

    public void setDefaultSourceObject(PaymentSource expandableObject) {
        this.defaultSource = new ExpandableField<PaymentSource>(expandableObject.getId(), expandableObject);
    }

    public String getSubscription() {
        return this.subscription != null ? this.subscription.getId() : null;
    }

    public void setSubscription(String id) {
        this.subscription = ApiResource.setExpandableFieldId(id, this.subscription);
    }

    public Subscription getSubscriptionObject() {
        return this.subscription != null ? this.subscription.getExpanded() : null;
    }

    public void setSubscriptionObject(Subscription expandableObject) {
        this.subscription = new ExpandableField<Subscription>(expandableObject.getId(), expandableObject);
    }

    public static SubscriptionScheduleCollection list(Map<String, Object> params) throws StripeException {
        return SubscriptionSchedule.list(params, (RequestOptions)null);
    }

    public static SubscriptionScheduleCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/subscription_schedules");
        return ApiResource.requestCollection(url, params, SubscriptionScheduleCollection.class, options);
    }

    public static SubscriptionScheduleCollection list(SubscriptionScheduleListParams params) throws StripeException {
        return SubscriptionSchedule.list(params, (RequestOptions)null);
    }

    public static SubscriptionScheduleCollection list(SubscriptionScheduleListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/subscription_schedules");
        return ApiResource.requestCollection(url, params, SubscriptionScheduleCollection.class, options);
    }

    public static SubscriptionSchedule create(Map<String, Object> params) throws StripeException {
        return SubscriptionSchedule.create(params, (RequestOptions)null);
    }

    public static SubscriptionSchedule create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/subscription_schedules");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SubscriptionSchedule.class, options);
    }

    public static SubscriptionSchedule create(SubscriptionScheduleCreateParams params) throws StripeException {
        return SubscriptionSchedule.create(params, (RequestOptions)null);
    }

    public static SubscriptionSchedule create(SubscriptionScheduleCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/subscription_schedules");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SubscriptionSchedule.class, options);
    }

    public static SubscriptionSchedule retrieve(String schedule) throws StripeException {
        return SubscriptionSchedule.retrieve(schedule, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static SubscriptionSchedule retrieve(String schedule, RequestOptions options) throws StripeException {
        return SubscriptionSchedule.retrieve(schedule, (Map<String, Object>)null, options);
    }

    public static SubscriptionSchedule retrieve(String schedule, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_schedules/%s", ApiResource.urlEncodeId(schedule)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, SubscriptionSchedule.class, options);
    }

    public static SubscriptionSchedule retrieve(String schedule, SubscriptionScheduleRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_schedules/%s", ApiResource.urlEncodeId(schedule)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, SubscriptionSchedule.class, options);
    }

    public SubscriptionSchedule update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public SubscriptionSchedule update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_schedules/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SubscriptionSchedule.class, options);
    }

    public SubscriptionSchedule update(SubscriptionScheduleUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public SubscriptionSchedule update(SubscriptionScheduleUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_schedules/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SubscriptionSchedule.class, options);
    }

    public SubscriptionSchedule cancel() throws StripeException {
        return this.cancel((Map<String, Object>)null, (RequestOptions)null);
    }

    public SubscriptionSchedule cancel(RequestOptions options) throws StripeException {
        return this.cancel((Map<String, Object>)null, options);
    }

    public SubscriptionSchedule cancel(Map<String, Object> params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public SubscriptionSchedule cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_schedules/%s/cancel", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SubscriptionSchedule.class, options);
    }

    public SubscriptionSchedule cancel(SubscriptionScheduleCancelParams params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public SubscriptionSchedule cancel(SubscriptionScheduleCancelParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_schedules/%s/cancel", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SubscriptionSchedule.class, options);
    }

    public SubscriptionSchedule release() throws StripeException {
        return this.release((Map<String, Object>)null, (RequestOptions)null);
    }

    public SubscriptionSchedule release(RequestOptions options) throws StripeException {
        return this.release((Map<String, Object>)null, options);
    }

    public SubscriptionSchedule release(Map<String, Object> params) throws StripeException {
        return this.release(params, (RequestOptions)null);
    }

    public SubscriptionSchedule release(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_schedules/%s/release", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SubscriptionSchedule.class, options);
    }

    public SubscriptionSchedule release(SubscriptionScheduleReleaseParams params) throws StripeException {
        return this.release(params, (RequestOptions)null);
    }

    public SubscriptionSchedule release(SubscriptionScheduleReleaseParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_schedules/%s/release", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SubscriptionSchedule.class, options);
    }

    @Generated
    public String getBilling() {
        return this.billing;
    }

    @Generated
    public Subscription.BillingThresholds getBillingThresholds() {
        return this.billingThresholds;
    }

    @Generated
    public Long getCanceledAt() {
        return this.canceledAt;
    }

    @Generated
    public String getCollectionMethod() {
        return this.collectionMethod;
    }

    @Generated
    public Long getCompletedAt() {
        return this.completedAt;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public CurrentPhase getCurrentPhase() {
        return this.currentPhase;
    }

    @Generated
    public String getEndBehavior() {
        return this.endBehavior;
    }

    @Generated
    public InvoiceSettings getInvoiceSettings() {
        return this.invoiceSettings;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public List<Phase> getPhases() {
        return this.phases;
    }

    @Generated
    public Long getReleasedAt() {
        return this.releasedAt;
    }

    @Generated
    public String getReleasedSubscription() {
        return this.releasedSubscription;
    }

    @Generated
    public String getRenewalBehavior() {
        return this.renewalBehavior;
    }

    @Generated
    public RenewalInterval getRenewalInterval() {
        return this.renewalInterval;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public void setBilling(String billing) {
        this.billing = billing;
    }

    @Generated
    public void setBillingThresholds(Subscription.BillingThresholds billingThresholds) {
        this.billingThresholds = billingThresholds;
    }

    @Generated
    public void setCanceledAt(Long canceledAt) {
        this.canceledAt = canceledAt;
    }

    @Generated
    public void setCollectionMethod(String collectionMethod) {
        this.collectionMethod = collectionMethod;
    }

    @Generated
    public void setCompletedAt(Long completedAt) {
        this.completedAt = completedAt;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrentPhase(CurrentPhase currentPhase) {
        this.currentPhase = currentPhase;
    }

    @Generated
    public void setEndBehavior(String endBehavior) {
        this.endBehavior = endBehavior;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setInvoiceSettings(InvoiceSettings invoiceSettings) {
        this.invoiceSettings = invoiceSettings;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPhases(List<Phase> phases) {
        this.phases = phases;
    }

    @Generated
    public void setReleasedAt(Long releasedAt) {
        this.releasedAt = releasedAt;
    }

    @Generated
    public void setReleasedSubscription(String releasedSubscription) {
        this.releasedSubscription = releasedSubscription;
    }

    @Generated
    public void setRenewalBehavior(String renewalBehavior) {
        this.renewalBehavior = renewalBehavior;
    }

    @Generated
    public void setRenewalInterval(RenewalInterval renewalInterval) {
        this.renewalInterval = renewalInterval;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubscriptionSchedule)) {
            return false;
        }
        SubscriptionSchedule other = (SubscriptionSchedule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$billing = this.getBilling();
        String other$billing = other.getBilling();
        if (this$billing == null ? other$billing != null : !this$billing.equals(other$billing)) {
            return false;
        }
        Subscription.BillingThresholds this$billingThresholds = this.getBillingThresholds();
        Subscription.BillingThresholds other$billingThresholds = other.getBillingThresholds();
        if (this$billingThresholds == null ? other$billingThresholds != null : !((Object)this$billingThresholds).equals(other$billingThresholds)) {
            return false;
        }
        Long this$canceledAt = this.getCanceledAt();
        Long other$canceledAt = other.getCanceledAt();
        if (this$canceledAt == null ? other$canceledAt != null : !((Object)this$canceledAt).equals(other$canceledAt)) {
            return false;
        }
        String this$collectionMethod = this.getCollectionMethod();
        String other$collectionMethod = other.getCollectionMethod();
        if (this$collectionMethod == null ? other$collectionMethod != null : !this$collectionMethod.equals(other$collectionMethod)) {
            return false;
        }
        Long this$completedAt = this.getCompletedAt();
        Long other$completedAt = other.getCompletedAt();
        if (this$completedAt == null ? other$completedAt != null : !((Object)this$completedAt).equals(other$completedAt)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        CurrentPhase this$currentPhase = this.getCurrentPhase();
        CurrentPhase other$currentPhase = other.getCurrentPhase();
        if (this$currentPhase == null ? other$currentPhase != null : !((Object)this$currentPhase).equals(other$currentPhase)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        String this$defaultPaymentMethod = this.getDefaultPaymentMethod();
        String other$defaultPaymentMethod = other.getDefaultPaymentMethod();
        if (this$defaultPaymentMethod == null ? other$defaultPaymentMethod != null : !this$defaultPaymentMethod.equals(other$defaultPaymentMethod)) {
            return false;
        }
        String this$defaultSource = this.getDefaultSource();
        String other$defaultSource = other.getDefaultSource();
        if (this$defaultSource == null ? other$defaultSource != null : !this$defaultSource.equals(other$defaultSource)) {
            return false;
        }
        String this$endBehavior = this.getEndBehavior();
        String other$endBehavior = other.getEndBehavior();
        if (this$endBehavior == null ? other$endBehavior != null : !this$endBehavior.equals(other$endBehavior)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        InvoiceSettings this$invoiceSettings = this.getInvoiceSettings();
        InvoiceSettings other$invoiceSettings = other.getInvoiceSettings();
        if (this$invoiceSettings == null ? other$invoiceSettings != null : !((Object)this$invoiceSettings).equals(other$invoiceSettings)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        List<Phase> this$phases = this.getPhases();
        List<Phase> other$phases = other.getPhases();
        if (this$phases == null ? other$phases != null : !((Object)this$phases).equals(other$phases)) {
            return false;
        }
        Long this$releasedAt = this.getReleasedAt();
        Long other$releasedAt = other.getReleasedAt();
        if (this$releasedAt == null ? other$releasedAt != null : !((Object)this$releasedAt).equals(other$releasedAt)) {
            return false;
        }
        String this$releasedSubscription = this.getReleasedSubscription();
        String other$releasedSubscription = other.getReleasedSubscription();
        if (this$releasedSubscription == null ? other$releasedSubscription != null : !this$releasedSubscription.equals(other$releasedSubscription)) {
            return false;
        }
        String this$renewalBehavior = this.getRenewalBehavior();
        String other$renewalBehavior = other.getRenewalBehavior();
        if (this$renewalBehavior == null ? other$renewalBehavior != null : !this$renewalBehavior.equals(other$renewalBehavior)) {
            return false;
        }
        RenewalInterval this$renewalInterval = this.getRenewalInterval();
        RenewalInterval other$renewalInterval = other.getRenewalInterval();
        if (this$renewalInterval == null ? other$renewalInterval != null : !((Object)this$renewalInterval).equals(other$renewalInterval)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$subscription = this.getSubscription();
        String other$subscription = other.getSubscription();
        return !(this$subscription == null ? other$subscription != null : !this$subscription.equals(other$subscription));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SubscriptionSchedule;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $billing = this.getBilling();
        result = result * 59 + ($billing == null ? 43 : $billing.hashCode());
        Subscription.BillingThresholds $billingThresholds = this.getBillingThresholds();
        result = result * 59 + ($billingThresholds == null ? 43 : ((Object)$billingThresholds).hashCode());
        Long $canceledAt = this.getCanceledAt();
        result = result * 59 + ($canceledAt == null ? 43 : ((Object)$canceledAt).hashCode());
        String $collectionMethod = this.getCollectionMethod();
        result = result * 59 + ($collectionMethod == null ? 43 : $collectionMethod.hashCode());
        Long $completedAt = this.getCompletedAt();
        result = result * 59 + ($completedAt == null ? 43 : ((Object)$completedAt).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        CurrentPhase $currentPhase = this.getCurrentPhase();
        result = result * 59 + ($currentPhase == null ? 43 : ((Object)$currentPhase).hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        String $defaultPaymentMethod = this.getDefaultPaymentMethod();
        result = result * 59 + ($defaultPaymentMethod == null ? 43 : $defaultPaymentMethod.hashCode());
        String $defaultSource = this.getDefaultSource();
        result = result * 59 + ($defaultSource == null ? 43 : $defaultSource.hashCode());
        String $endBehavior = this.getEndBehavior();
        result = result * 59 + ($endBehavior == null ? 43 : $endBehavior.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        InvoiceSettings $invoiceSettings = this.getInvoiceSettings();
        result = result * 59 + ($invoiceSettings == null ? 43 : ((Object)$invoiceSettings).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        List<Phase> $phases = this.getPhases();
        result = result * 59 + ($phases == null ? 43 : ((Object)$phases).hashCode());
        Long $releasedAt = this.getReleasedAt();
        result = result * 59 + ($releasedAt == null ? 43 : ((Object)$releasedAt).hashCode());
        String $releasedSubscription = this.getReleasedSubscription();
        result = result * 59 + ($releasedSubscription == null ? 43 : $releasedSubscription.hashCode());
        String $renewalBehavior = this.getRenewalBehavior();
        result = result * 59 + ($renewalBehavior == null ? 43 : $renewalBehavior.hashCode());
        RenewalInterval $renewalInterval = this.getRenewalInterval();
        result = result * 59 + ($renewalInterval == null ? 43 : ((Object)$renewalInterval).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $subscription = this.getSubscription();
        result = result * 59 + ($subscription == null ? 43 : $subscription.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class RenewalInterval
    extends StripeObject {
        @SerializedName(value="interval")
        String interval;
        @SerializedName(value="length")
        Long length;

        @Generated
        public String getInterval() {
            return this.interval;
        }

        @Generated
        public Long getLength() {
            return this.length;
        }

        @Generated
        public void setInterval(String interval) {
            this.interval = interval;
        }

        @Generated
        public void setLength(Long length) {
            this.length = length;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RenewalInterval)) {
                return false;
            }
            RenewalInterval other = (RenewalInterval)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$interval = this.getInterval();
            String other$interval = other.getInterval();
            if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) {
                return false;
            }
            Long this$length = this.getLength();
            Long other$length = other.getLength();
            return !(this$length == null ? other$length != null : !((Object)this$length).equals(other$length));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RenewalInterval;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $interval = this.getInterval();
            result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
            Long $length = this.getLength();
            result = result * 59 + ($length == null ? 43 : ((Object)$length).hashCode());
            return result;
        }
    }

    public static class PhaseItem
    extends StripeObject {
        @SerializedName(value="billing_thresholds")
        SubscriptionItem.BillingThresholds billingThresholds;
        @SerializedName(value="plan")
        ExpandableField<Plan> plan;
        @SerializedName(value="quantity")
        Long quantity;
        @SerializedName(value="tax_rates")
        List<TaxRate> taxRates;

        public String getPlan() {
            return this.plan != null ? this.plan.getId() : null;
        }

        public void setPlan(String id) {
            this.plan = ApiResource.setExpandableFieldId(id, this.plan);
        }

        public Plan getPlanObject() {
            return this.plan != null ? this.plan.getExpanded() : null;
        }

        public void setPlanObject(Plan expandableObject) {
            this.plan = new ExpandableField<Plan>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public SubscriptionItem.BillingThresholds getBillingThresholds() {
            return this.billingThresholds;
        }

        @Generated
        public Long getQuantity() {
            return this.quantity;
        }

        @Generated
        public List<TaxRate> getTaxRates() {
            return this.taxRates;
        }

        @Generated
        public void setBillingThresholds(SubscriptionItem.BillingThresholds billingThresholds) {
            this.billingThresholds = billingThresholds;
        }

        @Generated
        public void setQuantity(Long quantity) {
            this.quantity = quantity;
        }

        @Generated
        public void setTaxRates(List<TaxRate> taxRates) {
            this.taxRates = taxRates;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PhaseItem)) {
                return false;
            }
            PhaseItem other = (PhaseItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SubscriptionItem.BillingThresholds this$billingThresholds = this.getBillingThresholds();
            SubscriptionItem.BillingThresholds other$billingThresholds = other.getBillingThresholds();
            if (this$billingThresholds == null ? other$billingThresholds != null : !((Object)this$billingThresholds).equals(other$billingThresholds)) {
                return false;
            }
            String this$plan = this.getPlan();
            String other$plan = other.getPlan();
            if (this$plan == null ? other$plan != null : !this$plan.equals(other$plan)) {
                return false;
            }
            Long this$quantity = this.getQuantity();
            Long other$quantity = other.getQuantity();
            if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
                return false;
            }
            List<TaxRate> this$taxRates = this.getTaxRates();
            List<TaxRate> other$taxRates = other.getTaxRates();
            return !(this$taxRates == null ? other$taxRates != null : !((Object)this$taxRates).equals(other$taxRates));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PhaseItem;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SubscriptionItem.BillingThresholds $billingThresholds = this.getBillingThresholds();
            result = result * 59 + ($billingThresholds == null ? 43 : ((Object)$billingThresholds).hashCode());
            String $plan = this.getPlan();
            result = result * 59 + ($plan == null ? 43 : $plan.hashCode());
            Long $quantity = this.getQuantity();
            result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
            List<TaxRate> $taxRates = this.getTaxRates();
            result = result * 59 + ($taxRates == null ? 43 : ((Object)$taxRates).hashCode());
            return result;
        }
    }

    public static class Phase
    extends StripeObject {
        @SerializedName(value="application_fee_percent")
        BigDecimal applicationFeePercent;
        @SerializedName(value="billing_thresholds")
        Subscription.BillingThresholds billingThresholds;
        @SerializedName(value="collection_method")
        String collectionMethod;
        @SerializedName(value="coupon")
        ExpandableField<Coupon> coupon;
        @SerializedName(value="default_payment_method")
        ExpandableField<PaymentMethod> defaultPaymentMethod;
        @SerializedName(value="default_tax_rates")
        List<TaxRate> defaultTaxRates;
        @SerializedName(value="end_date")
        Long endDate;
        @SerializedName(value="invoice_settings")
        InvoiceSettings invoiceSettings;
        @SerializedName(value="plans")
        List<PhaseItem> plans;
        @SerializedName(value="start_date")
        Long startDate;
        @SerializedName(value="tax_percent")
        BigDecimal taxPercent;
        @SerializedName(value="trial_end")
        Long trialEnd;

        public String getCoupon() {
            return this.coupon != null ? this.coupon.getId() : null;
        }

        public void setCoupon(String id) {
            this.coupon = ApiResource.setExpandableFieldId(id, this.coupon);
        }

        public Coupon getCouponObject() {
            return this.coupon != null ? this.coupon.getExpanded() : null;
        }

        public void setCouponObject(Coupon expandableObject) {
            this.coupon = new ExpandableField<Coupon>(expandableObject.getId(), expandableObject);
        }

        public String getDefaultPaymentMethod() {
            return this.defaultPaymentMethod != null ? this.defaultPaymentMethod.getId() : null;
        }

        public void setDefaultPaymentMethod(String id) {
            this.defaultPaymentMethod = ApiResource.setExpandableFieldId(id, this.defaultPaymentMethod);
        }

        public PaymentMethod getDefaultPaymentMethodObject() {
            return this.defaultPaymentMethod != null ? this.defaultPaymentMethod.getExpanded() : null;
        }

        public void setDefaultPaymentMethodObject(PaymentMethod expandableObject) {
            this.defaultPaymentMethod = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public BigDecimal getApplicationFeePercent() {
            return this.applicationFeePercent;
        }

        @Generated
        public Subscription.BillingThresholds getBillingThresholds() {
            return this.billingThresholds;
        }

        @Generated
        public String getCollectionMethod() {
            return this.collectionMethod;
        }

        @Generated
        public List<TaxRate> getDefaultTaxRates() {
            return this.defaultTaxRates;
        }

        @Generated
        public Long getEndDate() {
            return this.endDate;
        }

        @Generated
        public InvoiceSettings getInvoiceSettings() {
            return this.invoiceSettings;
        }

        @Generated
        public List<PhaseItem> getPlans() {
            return this.plans;
        }

        @Generated
        public Long getStartDate() {
            return this.startDate;
        }

        @Generated
        public BigDecimal getTaxPercent() {
            return this.taxPercent;
        }

        @Generated
        public Long getTrialEnd() {
            return this.trialEnd;
        }

        @Generated
        public void setApplicationFeePercent(BigDecimal applicationFeePercent) {
            this.applicationFeePercent = applicationFeePercent;
        }

        @Generated
        public void setBillingThresholds(Subscription.BillingThresholds billingThresholds) {
            this.billingThresholds = billingThresholds;
        }

        @Generated
        public void setCollectionMethod(String collectionMethod) {
            this.collectionMethod = collectionMethod;
        }

        @Generated
        public void setDefaultTaxRates(List<TaxRate> defaultTaxRates) {
            this.defaultTaxRates = defaultTaxRates;
        }

        @Generated
        public void setEndDate(Long endDate) {
            this.endDate = endDate;
        }

        @Generated
        public void setInvoiceSettings(InvoiceSettings invoiceSettings) {
            this.invoiceSettings = invoiceSettings;
        }

        @Generated
        public void setPlans(List<PhaseItem> plans) {
            this.plans = plans;
        }

        @Generated
        public void setStartDate(Long startDate) {
            this.startDate = startDate;
        }

        @Generated
        public void setTaxPercent(BigDecimal taxPercent) {
            this.taxPercent = taxPercent;
        }

        @Generated
        public void setTrialEnd(Long trialEnd) {
            this.trialEnd = trialEnd;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Phase)) {
                return false;
            }
            Phase other = (Phase)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BigDecimal this$applicationFeePercent = this.getApplicationFeePercent();
            BigDecimal other$applicationFeePercent = other.getApplicationFeePercent();
            if (this$applicationFeePercent == null ? other$applicationFeePercent != null : !((Object)this$applicationFeePercent).equals(other$applicationFeePercent)) {
                return false;
            }
            Subscription.BillingThresholds this$billingThresholds = this.getBillingThresholds();
            Subscription.BillingThresholds other$billingThresholds = other.getBillingThresholds();
            if (this$billingThresholds == null ? other$billingThresholds != null : !((Object)this$billingThresholds).equals(other$billingThresholds)) {
                return false;
            }
            String this$collectionMethod = this.getCollectionMethod();
            String other$collectionMethod = other.getCollectionMethod();
            if (this$collectionMethod == null ? other$collectionMethod != null : !this$collectionMethod.equals(other$collectionMethod)) {
                return false;
            }
            String this$coupon = this.getCoupon();
            String other$coupon = other.getCoupon();
            if (this$coupon == null ? other$coupon != null : !this$coupon.equals(other$coupon)) {
                return false;
            }
            String this$defaultPaymentMethod = this.getDefaultPaymentMethod();
            String other$defaultPaymentMethod = other.getDefaultPaymentMethod();
            if (this$defaultPaymentMethod == null ? other$defaultPaymentMethod != null : !this$defaultPaymentMethod.equals(other$defaultPaymentMethod)) {
                return false;
            }
            List<TaxRate> this$defaultTaxRates = this.getDefaultTaxRates();
            List<TaxRate> other$defaultTaxRates = other.getDefaultTaxRates();
            if (this$defaultTaxRates == null ? other$defaultTaxRates != null : !((Object)this$defaultTaxRates).equals(other$defaultTaxRates)) {
                return false;
            }
            Long this$endDate = this.getEndDate();
            Long other$endDate = other.getEndDate();
            if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
                return false;
            }
            InvoiceSettings this$invoiceSettings = this.getInvoiceSettings();
            InvoiceSettings other$invoiceSettings = other.getInvoiceSettings();
            if (this$invoiceSettings == null ? other$invoiceSettings != null : !((Object)this$invoiceSettings).equals(other$invoiceSettings)) {
                return false;
            }
            List<PhaseItem> this$plans = this.getPlans();
            List<PhaseItem> other$plans = other.getPlans();
            if (this$plans == null ? other$plans != null : !((Object)this$plans).equals(other$plans)) {
                return false;
            }
            Long this$startDate = this.getStartDate();
            Long other$startDate = other.getStartDate();
            if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
                return false;
            }
            BigDecimal this$taxPercent = this.getTaxPercent();
            BigDecimal other$taxPercent = other.getTaxPercent();
            if (this$taxPercent == null ? other$taxPercent != null : !((Object)this$taxPercent).equals(other$taxPercent)) {
                return false;
            }
            Long this$trialEnd = this.getTrialEnd();
            Long other$trialEnd = other.getTrialEnd();
            return !(this$trialEnd == null ? other$trialEnd != null : !((Object)this$trialEnd).equals(other$trialEnd));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Phase;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BigDecimal $applicationFeePercent = this.getApplicationFeePercent();
            result = result * 59 + ($applicationFeePercent == null ? 43 : ((Object)$applicationFeePercent).hashCode());
            Subscription.BillingThresholds $billingThresholds = this.getBillingThresholds();
            result = result * 59 + ($billingThresholds == null ? 43 : ((Object)$billingThresholds).hashCode());
            String $collectionMethod = this.getCollectionMethod();
            result = result * 59 + ($collectionMethod == null ? 43 : $collectionMethod.hashCode());
            String $coupon = this.getCoupon();
            result = result * 59 + ($coupon == null ? 43 : $coupon.hashCode());
            String $defaultPaymentMethod = this.getDefaultPaymentMethod();
            result = result * 59 + ($defaultPaymentMethod == null ? 43 : $defaultPaymentMethod.hashCode());
            List<TaxRate> $defaultTaxRates = this.getDefaultTaxRates();
            result = result * 59 + ($defaultTaxRates == null ? 43 : ((Object)$defaultTaxRates).hashCode());
            Long $endDate = this.getEndDate();
            result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
            InvoiceSettings $invoiceSettings = this.getInvoiceSettings();
            result = result * 59 + ($invoiceSettings == null ? 43 : ((Object)$invoiceSettings).hashCode());
            List<PhaseItem> $plans = this.getPlans();
            result = result * 59 + ($plans == null ? 43 : ((Object)$plans).hashCode());
            Long $startDate = this.getStartDate();
            result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
            BigDecimal $taxPercent = this.getTaxPercent();
            result = result * 59 + ($taxPercent == null ? 43 : ((Object)$taxPercent).hashCode());
            Long $trialEnd = this.getTrialEnd();
            result = result * 59 + ($trialEnd == null ? 43 : ((Object)$trialEnd).hashCode());
            return result;
        }
    }

    public static class InvoiceSettings
    extends StripeObject {
        @SerializedName(value="days_until_due")
        Long daysUntilDue;

        @Generated
        public Long getDaysUntilDue() {
            return this.daysUntilDue;
        }

        @Generated
        public void setDaysUntilDue(Long daysUntilDue) {
            this.daysUntilDue = daysUntilDue;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InvoiceSettings)) {
                return false;
            }
            InvoiceSettings other = (InvoiceSettings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$daysUntilDue = this.getDaysUntilDue();
            Long other$daysUntilDue = other.getDaysUntilDue();
            return !(this$daysUntilDue == null ? other$daysUntilDue != null : !((Object)this$daysUntilDue).equals(other$daysUntilDue));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof InvoiceSettings;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $daysUntilDue = this.getDaysUntilDue();
            result = result * 59 + ($daysUntilDue == null ? 43 : ((Object)$daysUntilDue).hashCode());
            return result;
        }
    }

    public static class CurrentPhase
    extends StripeObject {
        @SerializedName(value="end_date")
        Long endDate;
        @SerializedName(value="start_date")
        Long startDate;

        @Generated
        public Long getEndDate() {
            return this.endDate;
        }

        @Generated
        public Long getStartDate() {
            return this.startDate;
        }

        @Generated
        public void setEndDate(Long endDate) {
            this.endDate = endDate;
        }

        @Generated
        public void setStartDate(Long startDate) {
            this.startDate = startDate;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CurrentPhase)) {
                return false;
            }
            CurrentPhase other = (CurrentPhase)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$endDate = this.getEndDate();
            Long other$endDate = other.getEndDate();
            if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
                return false;
            }
            Long this$startDate = this.getStartDate();
            Long other$startDate = other.getStartDate();
            return !(this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CurrentPhase;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $endDate = this.getEndDate();
            result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
            Long $startDate = this.getStartDate();
            result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
            return result;
        }
    }
}

