/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param.checkout;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class SessionCreateParams
extends ApiRequestParams {
    @SerializedName(value="billing_address_collection")
    BillingAddressCollection billingAddressCollection;
    @SerializedName(value="cancel_url")
    String cancelUrl;
    @SerializedName(value="client_reference_id")
    String clientReferenceId;
    @SerializedName(value="customer")
    String customer;
    @SerializedName(value="customer_email")
    String customerEmail;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="_stripe_java_extra_param_key")
    Map<String, Object> extraParams;
    @SerializedName(value="line_items")
    List<LineItem> lineItems;
    @SerializedName(value="locale")
    Locale locale;
    @SerializedName(value="mode")
    Mode mode;
    @SerializedName(value="payment_intent_data")
    PaymentIntentData paymentIntentData;
    @SerializedName(value="payment_method_types")
    List<PaymentMethodType> paymentMethodTypes;
    @SerializedName(value="setup_intent_data")
    SetupIntentData setupIntentData;
    @SerializedName(value="submit_type")
    SubmitType submitType;
    @SerializedName(value="subscription_data")
    SubscriptionData subscriptionData;
    @SerializedName(value="success_url")
    String successUrl;

    private SessionCreateParams(BillingAddressCollection billingAddressCollection, String cancelUrl, String clientReferenceId, String customer, String customerEmail, List<String> expand, Map<String, Object> extraParams, List<LineItem> lineItems, Locale locale, Mode mode, PaymentIntentData paymentIntentData, List<PaymentMethodType> paymentMethodTypes, SetupIntentData setupIntentData, SubmitType submitType, SubscriptionData subscriptionData, String successUrl) {
        this.billingAddressCollection = billingAddressCollection;
        this.cancelUrl = cancelUrl;
        this.clientReferenceId = clientReferenceId;
        this.customer = customer;
        this.customerEmail = customerEmail;
        this.expand = expand;
        this.extraParams = extraParams;
        this.lineItems = lineItems;
        this.locale = locale;
        this.mode = mode;
        this.paymentIntentData = paymentIntentData;
        this.paymentMethodTypes = paymentMethodTypes;
        this.setupIntentData = setupIntentData;
        this.submitType = submitType;
        this.subscriptionData = subscriptionData;
        this.successUrl = successUrl;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public BillingAddressCollection getBillingAddressCollection() {
        return this.billingAddressCollection;
    }

    @Generated
    public String getCancelUrl() {
        return this.cancelUrl;
    }

    @Generated
    public String getClientReferenceId() {
        return this.clientReferenceId;
    }

    @Generated
    public String getCustomer() {
        return this.customer;
    }

    @Generated
    public String getCustomerEmail() {
        return this.customerEmail;
    }

    @Generated
    public List<String> getExpand() {
        return this.expand;
    }

    @Generated
    public Map<String, Object> getExtraParams() {
        return this.extraParams;
    }

    @Generated
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    @Generated
    public Locale getLocale() {
        return this.locale;
    }

    @Generated
    public Mode getMode() {
        return this.mode;
    }

    @Generated
    public PaymentIntentData getPaymentIntentData() {
        return this.paymentIntentData;
    }

    @Generated
    public List<PaymentMethodType> getPaymentMethodTypes() {
        return this.paymentMethodTypes;
    }

    @Generated
    public SetupIntentData getSetupIntentData() {
        return this.setupIntentData;
    }

    @Generated
    public SubmitType getSubmitType() {
        return this.submitType;
    }

    @Generated
    public SubscriptionData getSubscriptionData() {
        return this.subscriptionData;
    }

    @Generated
    public String getSuccessUrl() {
        return this.successUrl;
    }

    public static enum SubmitType implements ApiRequestParams.EnumParam
    {
        AUTO("auto"),
        BOOK("book"),
        DONATE("donate"),
        PAY("pay");

        private final String value;

        private SubmitType(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static enum PaymentMethodType implements ApiRequestParams.EnumParam
    {
        CARD("card");

        private final String value;

        private PaymentMethodType(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static enum Mode implements ApiRequestParams.EnumParam
    {
        PAYMENT("payment"),
        SETUP("setup"),
        SUBSCRIPTION("subscription");

        private final String value;

        private Mode(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static enum Locale implements ApiRequestParams.EnumParam
    {
        AUTO("auto"),
        DA("da"),
        DE("de"),
        EN("en"),
        ES("es"),
        FI("fi"),
        FR("fr"),
        IT("it"),
        JA("ja"),
        NB("nb"),
        NL("nl"),
        PL("pl"),
        PT("pt"),
        SV("sv"),
        ZH("zh");

        private final String value;

        private Locale(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static enum BillingAddressCollection implements ApiRequestParams.EnumParam
    {
        AUTO("auto"),
        REQUIRED("required");

        private final String value;

        private BillingAddressCollection(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class SubscriptionData {
        @SerializedName(value="application_fee_percent")
        BigDecimal applicationFeePercent;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="items")
        List<Item> items;
        @SerializedName(value="metadata")
        Map<String, String> metadata;
        @SerializedName(value="trial_end")
        Long trialEnd;
        @SerializedName(value="trial_from_plan")
        Boolean trialFromPlan;
        @SerializedName(value="trial_period_days")
        Long trialPeriodDays;

        private SubscriptionData(BigDecimal applicationFeePercent, Map<String, Object> extraParams, List<Item> items, Map<String, String> metadata, Long trialEnd, Boolean trialFromPlan, Long trialPeriodDays) {
            this.applicationFeePercent = applicationFeePercent;
            this.extraParams = extraParams;
            this.items = items;
            this.metadata = metadata;
            this.trialEnd = trialEnd;
            this.trialFromPlan = trialFromPlan;
            this.trialPeriodDays = trialPeriodDays;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public BigDecimal getApplicationFeePercent() {
            return this.applicationFeePercent;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public List<Item> getItems() {
            return this.items;
        }

        @Generated
        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        @Generated
        public Long getTrialEnd() {
            return this.trialEnd;
        }

        @Generated
        public Boolean getTrialFromPlan() {
            return this.trialFromPlan;
        }

        @Generated
        public Long getTrialPeriodDays() {
            return this.trialPeriodDays;
        }

        public static class Item {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="plan")
            String plan;
            @SerializedName(value="quantity")
            Long quantity;

            private Item(Map<String, Object> extraParams, String plan, Long quantity) {
                this.extraParams = extraParams;
                this.plan = plan;
                this.quantity = quantity;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getPlan() {
                return this.plan;
            }

            @Generated
            public Long getQuantity() {
                return this.quantity;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private String plan;
                private Long quantity;

                public Item build() {
                    return new Item(this.extraParams, this.plan, this.quantity);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setPlan(String plan) {
                    this.plan = plan;
                    return this;
                }

                public Builder setQuantity(Long quantity) {
                    this.quantity = quantity;
                    return this;
                }
            }
        }

        public static class Builder {
            private BigDecimal applicationFeePercent;
            private Map<String, Object> extraParams;
            private List<Item> items;
            private Map<String, String> metadata;
            private Long trialEnd;
            private Boolean trialFromPlan;
            private Long trialPeriodDays;

            public SubscriptionData build() {
                return new SubscriptionData(this.applicationFeePercent, this.extraParams, this.items, this.metadata, this.trialEnd, this.trialFromPlan, this.trialPeriodDays);
            }

            public Builder setApplicationFeePercent(BigDecimal applicationFeePercent) {
                this.applicationFeePercent = applicationFeePercent;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder addItem(Item element) {
                if (this.items == null) {
                    this.items = new ArrayList<Item>();
                }
                this.items.add(element);
                return this;
            }

            public Builder addAllItem(List<Item> elements) {
                if (this.items == null) {
                    this.items = new ArrayList<Item>();
                }
                this.items.addAll(elements);
                return this;
            }

            public Builder putMetadata(String key, String value) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.put(key, value);
                return this;
            }

            public Builder putAllMetadata(Map<String, String> map) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.putAll(map);
                return this;
            }

            public Builder setTrialEnd(Long trialEnd) {
                this.trialEnd = trialEnd;
                return this;
            }

            public Builder setTrialFromPlan(Boolean trialFromPlan) {
                this.trialFromPlan = trialFromPlan;
                return this;
            }

            public Builder setTrialPeriodDays(Long trialPeriodDays) {
                this.trialPeriodDays = trialPeriodDays;
                return this;
            }
        }
    }

    public static class SetupIntentData {
        @SerializedName(value="description")
        String description;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="metadata")
        Map<String, String> metadata;
        @SerializedName(value="on_behalf_of")
        String onBehalfOf;

        private SetupIntentData(String description, Map<String, Object> extraParams, Map<String, String> metadata, String onBehalfOf) {
            this.description = description;
            this.extraParams = extraParams;
            this.metadata = metadata;
            this.onBehalfOf = onBehalfOf;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        @Generated
        public String getOnBehalfOf() {
            return this.onBehalfOf;
        }

        public static class Builder {
            private String description;
            private Map<String, Object> extraParams;
            private Map<String, String> metadata;
            private String onBehalfOf;

            public SetupIntentData build() {
                return new SetupIntentData(this.description, this.extraParams, this.metadata, this.onBehalfOf);
            }

            public Builder setDescription(String description) {
                this.description = description;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder putMetadata(String key, String value) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.put(key, value);
                return this;
            }

            public Builder putAllMetadata(Map<String, String> map) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.putAll(map);
                return this;
            }

            public Builder setOnBehalfOf(String onBehalfOf) {
                this.onBehalfOf = onBehalfOf;
                return this;
            }
        }
    }

    public static class PaymentIntentData {
        @SerializedName(value="application_fee_amount")
        Long applicationFeeAmount;
        @SerializedName(value="capture_method")
        CaptureMethod captureMethod;
        @SerializedName(value="description")
        String description;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="metadata")
        Map<String, String> metadata;
        @SerializedName(value="on_behalf_of")
        String onBehalfOf;
        @SerializedName(value="receipt_email")
        String receiptEmail;
        @SerializedName(value="setup_future_usage")
        SetupFutureUsage setupFutureUsage;
        @SerializedName(value="shipping")
        Shipping shipping;
        @SerializedName(value="statement_descriptor")
        String statementDescriptor;
        @SerializedName(value="transfer_data")
        TransferData transferData;

        private PaymentIntentData(Long applicationFeeAmount, CaptureMethod captureMethod, String description, Map<String, Object> extraParams, Map<String, String> metadata, String onBehalfOf, String receiptEmail, SetupFutureUsage setupFutureUsage, Shipping shipping, String statementDescriptor, TransferData transferData) {
            this.applicationFeeAmount = applicationFeeAmount;
            this.captureMethod = captureMethod;
            this.description = description;
            this.extraParams = extraParams;
            this.metadata = metadata;
            this.onBehalfOf = onBehalfOf;
            this.receiptEmail = receiptEmail;
            this.setupFutureUsage = setupFutureUsage;
            this.shipping = shipping;
            this.statementDescriptor = statementDescriptor;
            this.transferData = transferData;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Long getApplicationFeeAmount() {
            return this.applicationFeeAmount;
        }

        @Generated
        public CaptureMethod getCaptureMethod() {
            return this.captureMethod;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        @Generated
        public String getOnBehalfOf() {
            return this.onBehalfOf;
        }

        @Generated
        public String getReceiptEmail() {
            return this.receiptEmail;
        }

        @Generated
        public SetupFutureUsage getSetupFutureUsage() {
            return this.setupFutureUsage;
        }

        @Generated
        public Shipping getShipping() {
            return this.shipping;
        }

        @Generated
        public String getStatementDescriptor() {
            return this.statementDescriptor;
        }

        @Generated
        public TransferData getTransferData() {
            return this.transferData;
        }

        public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
        {
            OFF_SESSION("off_session"),
            ON_SESSION("on_session");

            private final String value;

            private SetupFutureUsage(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static enum CaptureMethod implements ApiRequestParams.EnumParam
        {
            AUTOMATIC("automatic"),
            MANUAL("manual");

            private final String value;

            private CaptureMethod(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class TransferData {
            @SerializedName(value="destination")
            String destination;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private TransferData(String destination, Map<String, Object> extraParams) {
                this.destination = destination;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public String getDestination() {
                return this.destination;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private String destination;
                private Map<String, Object> extraParams;

                public TransferData build() {
                    return new TransferData(this.destination, this.extraParams);
                }

                public Builder setDestination(String destination) {
                    this.destination = destination;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Shipping {
            @SerializedName(value="address")
            Address address;
            @SerializedName(value="carrier")
            String carrier;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="name")
            String name;
            @SerializedName(value="phone")
            String phone;
            @SerializedName(value="tracking_number")
            String trackingNumber;

            private Shipping(Address address, String carrier, Map<String, Object> extraParams, String name, String phone, String trackingNumber) {
                this.address = address;
                this.carrier = carrier;
                this.extraParams = extraParams;
                this.name = name;
                this.phone = phone;
                this.trackingNumber = trackingNumber;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Address getAddress() {
                return this.address;
            }

            @Generated
            public String getCarrier() {
                return this.carrier;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public String getPhone() {
                return this.phone;
            }

            @Generated
            public String getTrackingNumber() {
                return this.trackingNumber;
            }

            public static class Address {
                @SerializedName(value="city")
                String city;
                @SerializedName(value="country")
                String country;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="line1")
                String line1;
                @SerializedName(value="line2")
                String line2;
                @SerializedName(value="postal_code")
                String postalCode;
                @SerializedName(value="state")
                String state;

                private Address(String city, String country, Map<String, Object> extraParams, String line1, String line2, String postalCode, String state) {
                    this.city = city;
                    this.country = country;
                    this.extraParams = extraParams;
                    this.line1 = line1;
                    this.line2 = line2;
                    this.postalCode = postalCode;
                    this.state = state;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getCity() {
                    return this.city;
                }

                @Generated
                public String getCountry() {
                    return this.country;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getLine1() {
                    return this.line1;
                }

                @Generated
                public String getLine2() {
                    return this.line2;
                }

                @Generated
                public String getPostalCode() {
                    return this.postalCode;
                }

                @Generated
                public String getState() {
                    return this.state;
                }

                public static class Builder {
                    private String city;
                    private String country;
                    private Map<String, Object> extraParams;
                    private String line1;
                    private String line2;
                    private String postalCode;
                    private String state;

                    public Address build() {
                        return new Address(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
                    }

                    public Builder setCity(String city) {
                        this.city = city;
                        return this;
                    }

                    public Builder setCountry(String country) {
                        this.country = country;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setLine1(String line1) {
                        this.line1 = line1;
                        return this;
                    }

                    public Builder setLine2(String line2) {
                        this.line2 = line2;
                        return this;
                    }

                    public Builder setPostalCode(String postalCode) {
                        this.postalCode = postalCode;
                        return this;
                    }

                    public Builder setState(String state) {
                        this.state = state;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Address address;
                private String carrier;
                private Map<String, Object> extraParams;
                private String name;
                private String phone;
                private String trackingNumber;

                public Shipping build() {
                    return new Shipping(this.address, this.carrier, this.extraParams, this.name, this.phone, this.trackingNumber);
                }

                public Builder setAddress(Address address) {
                    this.address = address;
                    return this;
                }

                public Builder setCarrier(String carrier) {
                    this.carrier = carrier;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setName(String name) {
                    this.name = name;
                    return this;
                }

                public Builder setPhone(String phone) {
                    this.phone = phone;
                    return this;
                }

                public Builder setTrackingNumber(String trackingNumber) {
                    this.trackingNumber = trackingNumber;
                    return this;
                }
            }
        }

        public static class Builder {
            private Long applicationFeeAmount;
            private CaptureMethod captureMethod;
            private String description;
            private Map<String, Object> extraParams;
            private Map<String, String> metadata;
            private String onBehalfOf;
            private String receiptEmail;
            private SetupFutureUsage setupFutureUsage;
            private Shipping shipping;
            private String statementDescriptor;
            private TransferData transferData;

            public PaymentIntentData build() {
                return new PaymentIntentData(this.applicationFeeAmount, this.captureMethod, this.description, this.extraParams, this.metadata, this.onBehalfOf, this.receiptEmail, this.setupFutureUsage, this.shipping, this.statementDescriptor, this.transferData);
            }

            public Builder setApplicationFeeAmount(Long applicationFeeAmount) {
                this.applicationFeeAmount = applicationFeeAmount;
                return this;
            }

            public Builder setCaptureMethod(CaptureMethod captureMethod) {
                this.captureMethod = captureMethod;
                return this;
            }

            public Builder setDescription(String description) {
                this.description = description;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder putMetadata(String key, String value) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.put(key, value);
                return this;
            }

            public Builder putAllMetadata(Map<String, String> map) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.putAll(map);
                return this;
            }

            public Builder setOnBehalfOf(String onBehalfOf) {
                this.onBehalfOf = onBehalfOf;
                return this;
            }

            public Builder setReceiptEmail(String receiptEmail) {
                this.receiptEmail = receiptEmail;
                return this;
            }

            public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
                return this;
            }

            public Builder setShipping(Shipping shipping) {
                this.shipping = shipping;
                return this;
            }

            public Builder setStatementDescriptor(String statementDescriptor) {
                this.statementDescriptor = statementDescriptor;
                return this;
            }

            public Builder setTransferData(TransferData transferData) {
                this.transferData = transferData;
                return this;
            }
        }
    }

    public static class LineItem {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="currency")
        String currency;
        @SerializedName(value="description")
        String description;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="images")
        List<String> images;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="quantity")
        Long quantity;

        private LineItem(Long amount, String currency, String description, Map<String, Object> extraParams, List<String> images, String name, Long quantity) {
            this.amount = amount;
            this.currency = currency;
            this.description = description;
            this.extraParams = extraParams;
            this.images = images;
            this.name = name;
            this.quantity = quantity;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public String getCurrency() {
            return this.currency;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public List<String> getImages() {
            return this.images;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Long getQuantity() {
            return this.quantity;
        }

        public static class Builder {
            private Long amount;
            private String currency;
            private String description;
            private Map<String, Object> extraParams;
            private List<String> images;
            private String name;
            private Long quantity;

            public LineItem build() {
                return new LineItem(this.amount, this.currency, this.description, this.extraParams, this.images, this.name, this.quantity);
            }

            public Builder setAmount(Long amount) {
                this.amount = amount;
                return this;
            }

            public Builder setCurrency(String currency) {
                this.currency = currency;
                return this;
            }

            public Builder setDescription(String description) {
                this.description = description;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder addImage(String element) {
                if (this.images == null) {
                    this.images = new ArrayList<String>();
                }
                this.images.add(element);
                return this;
            }

            public Builder addAllImage(List<String> elements) {
                if (this.images == null) {
                    this.images = new ArrayList<String>();
                }
                this.images.addAll(elements);
                return this;
            }

            public Builder setName(String name) {
                this.name = name;
                return this;
            }

            public Builder setQuantity(Long quantity) {
                this.quantity = quantity;
                return this;
            }
        }
    }

    public static class Builder {
        private BillingAddressCollection billingAddressCollection;
        private String cancelUrl;
        private String clientReferenceId;
        private String customer;
        private String customerEmail;
        private List<String> expand;
        private Map<String, Object> extraParams;
        private List<LineItem> lineItems;
        private Locale locale;
        private Mode mode;
        private PaymentIntentData paymentIntentData;
        private List<PaymentMethodType> paymentMethodTypes;
        private SetupIntentData setupIntentData;
        private SubmitType submitType;
        private SubscriptionData subscriptionData;
        private String successUrl;

        public SessionCreateParams build() {
            return new SessionCreateParams(this.billingAddressCollection, this.cancelUrl, this.clientReferenceId, this.customer, this.customerEmail, this.expand, this.extraParams, this.lineItems, this.locale, this.mode, this.paymentIntentData, this.paymentMethodTypes, this.setupIntentData, this.submitType, this.subscriptionData, this.successUrl);
        }

        public Builder setBillingAddressCollection(BillingAddressCollection billingAddressCollection) {
            this.billingAddressCollection = billingAddressCollection;
            return this;
        }

        public Builder setCancelUrl(String cancelUrl) {
            this.cancelUrl = cancelUrl;
            return this;
        }

        public Builder setClientReferenceId(String clientReferenceId) {
            this.clientReferenceId = clientReferenceId;
            return this;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setCustomerEmail(String customerEmail) {
            this.customerEmail = customerEmail;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.put(key, value);
            return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.putAll(map);
            return this;
        }

        public Builder addLineItem(LineItem element) {
            if (this.lineItems == null) {
                this.lineItems = new ArrayList<LineItem>();
            }
            this.lineItems.add(element);
            return this;
        }

        public Builder addAllLineItem(List<LineItem> elements) {
            if (this.lineItems == null) {
                this.lineItems = new ArrayList<LineItem>();
            }
            this.lineItems.addAll(elements);
            return this;
        }

        public Builder setLocale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder setMode(Mode mode) {
            this.mode = mode;
            return this;
        }

        public Builder setPaymentIntentData(PaymentIntentData paymentIntentData) {
            this.paymentIntentData = paymentIntentData;
            return this;
        }

        public Builder addPaymentMethodType(PaymentMethodType element) {
            if (this.paymentMethodTypes == null) {
                this.paymentMethodTypes = new ArrayList<PaymentMethodType>();
            }
            this.paymentMethodTypes.add(element);
            return this;
        }

        public Builder addAllPaymentMethodType(List<PaymentMethodType> elements) {
            if (this.paymentMethodTypes == null) {
                this.paymentMethodTypes = new ArrayList<PaymentMethodType>();
            }
            this.paymentMethodTypes.addAll(elements);
            return this;
        }

        public Builder setSetupIntentData(SetupIntentData setupIntentData) {
            this.setupIntentData = setupIntentData;
            return this;
        }

        public Builder setSubmitType(SubmitType submitType) {
            this.submitType = submitType;
            return this;
        }

        public Builder setSubscriptionData(SubscriptionData subscriptionData) {
            this.subscriptionData = subscriptionData;
            return this;
        }

        public Builder setSuccessUrl(String successUrl) {
            this.successUrl = successUrl;
            return this;
        }
    }
}

