// Generated by delombok at Wed Oct 30 12:50:09 PDT 2019
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.OrderCreateParams;
import com.stripe.param.OrderListParams;
import com.stripe.param.OrderPayParams;
import com.stripe.param.OrderRetrieveParams;
import com.stripe.param.OrderReturnOrderParams;
import com.stripe.param.OrderUpdateParams;
import java.util.List;
import java.util.Map;

public class Order extends ApiResource implements HasId, MetadataStore<Order> {
  /**
   * A positive integer in the smallest currency unit (that is, 100 cents for $1.00, or 1 for ¥1,
   * Japanese Yen being a zero-decimal currency) representing the total amount for the order.
   */
  @SerializedName("amount")
  Long amount;
  @SerializedName("amount_returned")
  Long amountReturned;
  /**
   * ID of the Connect Application that created the order.
   */
  @SerializedName("application")
  String application;
  @SerializedName("application_fee")
  Long applicationFee;
  /**
   * The ID of the payment used to pay for the order. Present if the order status is `paid`,
   * `fulfilled`, or `refunded`.
   */
  @SerializedName("charge")
  ExpandableField<Charge> charge;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in
   * lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  @SerializedName("currency")
  String currency;
  /**
   * The customer used for the order.
   */
  @SerializedName("customer")
  ExpandableField<Customer> customer;
  /**
   * The email address of the customer placing the order.
   */
  @SerializedName("email")
  String email;
  @SerializedName("external_coupon_code")
  String externalCouponCode;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * List of items constituting the order. An order can have up to 25 items.
   */
  @SerializedName("items")
  List<OrderItem> items;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object
   * exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  @SerializedName("object")
  String object;
  @SerializedName("returns")
  OrderReturnCollection returns;
  /**
   * The shipping method that is currently selected for this order, if any. If present, it is equal
   * to one of the `id`s of shipping methods in the `shipping_methods` array. At order creation
   * time, if there are multiple shipping methods, Stripe will automatically selected the first
   * method.
   */
  @SerializedName("selected_shipping_method")
  String selectedShippingMethod;
  /**
   * The shipping address for the order. Present if the order is for goods to be shipped.
   */
  @SerializedName("shipping")
  ShippingDetails shipping;
  /**
   * A list of supported shipping methods for this order. The desired shipping method can be
   * specified either by updating the order, or when paying it.
   */
  @SerializedName("shipping_methods")
  List<Order.ShippingMethod> shippingMethods;
  /**
   * Current order status. One of `created`, `paid`, `canceled`, `fulfilled`, or `returned`. More
   * details in the [Orders
   * Guide](https://stripe.com/docs/orders/guide#understanding-order-statuses).
   */
  @SerializedName("status")
  String status;
  /**
   * The timestamps at which the order status was updated.
   */
  @SerializedName("status_transitions")
  StatusTransitions statusTransitions;
  @SerializedName("updated")
  Long updated;
  /**
   * The user's order ID if it is different from the Stripe order ID.
   */
  @SerializedName("upstream_id")
  String upstreamId;

  /**
   * Get id of expandable `charge` object.
   */
  public String getCharge() {
    return (this.charge != null) ? this.charge.getId() : null;
  }

  public void setCharge(String id) {
    this.charge = ApiResource.setExpandableFieldId(id, this.charge);
  }

  /**
   * Get expanded `charge`.
   */
  public Charge getChargeObject() {
    return (this.charge != null) ? this.charge.getExpanded() : null;
  }

  public void setChargeObject(Charge expandableObject) {
    this.charge = new ExpandableField<Charge>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get id of expandable `customer` object.
   */
  public String getCustomer() {
    return (this.customer != null) ? this.customer.getId() : null;
  }

  public void setCustomer(String id) {
    this.customer = ApiResource.setExpandableFieldId(id, this.customer);
  }

  /**
   * Get expanded `customer`.
   */
  public Customer getCustomerObject() {
    return (this.customer != null) ? this.customer.getExpanded() : null;
  }

  public void setCustomerObject(Customer expandableObject) {
    this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
  }

  /**
   * Creates a new order object.
   */
  public static Order create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a new order object.
   */
  public static Order create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/orders");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Order.class, options);
  }

  /**
   * Creates a new order object.
   */
  public static Order create(OrderCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a new order object.
   */
  public static Order create(OrderCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/orders");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Order.class, options);
  }

  /**
   * Returns a list of your orders. The orders are returned sorted by creation date, with the most
   * recently created orders appearing first.
   */
  public static OrderCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of your orders. The orders are returned sorted by creation date, with the most
   * recently created orders appearing first.
   */
  public static OrderCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/orders");
    return ApiResource.requestCollection(url, params, OrderCollection.class, options);
  }

  /**
   * Returns a list of your orders. The orders are returned sorted by creation date, with the most
   * recently created orders appearing first.
   */
  public static OrderCollection list(OrderListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of your orders. The orders are returned sorted by creation date, with the most
   * recently created orders appearing first.
   */
  public static OrderCollection list(OrderListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/orders");
    return ApiResource.requestCollection(url, params, OrderCollection.class, options);
  }

  /**
   * Retrieves the details of an existing order. Supply the unique order ID from either an order
   * creation request or the order list, and Stripe will return the corresponding order information.
   */
  public static Order retrieve(String id) throws StripeException {
    return retrieve(id, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the details of an existing order. Supply the unique order ID from either an order
   * creation request or the order list, and Stripe will return the corresponding order information.
   */
  public static Order retrieve(String id, RequestOptions options) throws StripeException {
    return retrieve(id, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the details of an existing order. Supply the unique order ID from either an order
   * creation request or the order list, and Stripe will return the corresponding order information.
   */
  public static Order retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/orders/%s", ApiResource.urlEncodeId(id)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Order.class, options);
  }

  /**
   * Retrieves the details of an existing order. Supply the unique order ID from either an order
   * creation request or the order list, and Stripe will return the corresponding order information.
   */
  public static Order retrieve(String id, OrderRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/orders/%s", ApiResource.urlEncodeId(id)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Order.class, options);
  }

  /**
   * Updates the specific order by setting the values of the parameters passed. Any parameters not
   * provided will be left unchanged.
   */
  @Override
  public Order update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the specific order by setting the values of the parameters passed. Any parameters not
   * provided will be left unchanged.
   */
  @Override
  public Order update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/orders/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Order.class, options);
  }

  /**
   * Updates the specific order by setting the values of the parameters passed. Any parameters not
   * provided will be left unchanged.
   */
  public Order update(OrderUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the specific order by setting the values of the parameters passed. Any parameters not
   * provided will be left unchanged.
   */
  public Order update(OrderUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/orders/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Order.class, options);
  }

  /**
   * Pay an order by providing a <code>source</code> to create a payment.
   */
  public Order pay() throws StripeException {
    return pay((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Pay an order by providing a <code>source</code> to create a payment.
   */
  public Order pay(RequestOptions options) throws StripeException {
    return pay((Map<String, Object>) null, options);
  }

  /**
   * Pay an order by providing a <code>source</code> to create a payment.
   */
  public Order pay(Map<String, Object> params) throws StripeException {
    return pay(params, (RequestOptions) null);
  }

  /**
   * Pay an order by providing a <code>source</code> to create a payment.
   */
  public Order pay(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/orders/%s/pay", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Order.class, options);
  }

  /**
   * Pay an order by providing a <code>source</code> to create a payment.
   */
  public Order pay(OrderPayParams params) throws StripeException {
    return pay(params, (RequestOptions) null);
  }

  /**
   * Pay an order by providing a <code>source</code> to create a payment.
   */
  public Order pay(OrderPayParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/orders/%s/pay", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Order.class, options);
  }

  /**
   * Return all or part of an order. The order must have a status of <code>paid</code> or <code>
   * fulfilled</code> before it can be returned. Once all items have been returned, the order will
   * become <code>canceled</code> or <code>returned</code> depending on which status the order
   * started in.
   */
  public OrderReturn returnOrder() throws StripeException {
    return returnOrder((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Return all or part of an order. The order must have a status of <code>paid</code> or <code>
   * fulfilled</code> before it can be returned. Once all items have been returned, the order will
   * become <code>canceled</code> or <code>returned</code> depending on which status the order
   * started in.
   */
  public OrderReturn returnOrder(RequestOptions options) throws StripeException {
    return returnOrder((Map<String, Object>) null, options);
  }

  /**
   * Return all or part of an order. The order must have a status of <code>paid</code> or <code>
   * fulfilled</code> before it can be returned. Once all items have been returned, the order will
   * become <code>canceled</code> or <code>returned</code> depending on which status the order
   * started in.
   */
  public OrderReturn returnOrder(Map<String, Object> params) throws StripeException {
    return returnOrder(params, (RequestOptions) null);
  }

  /**
   * Return all or part of an order. The order must have a status of <code>paid</code> or <code>
   * fulfilled</code> before it can be returned. Once all items have been returned, the order will
   * become <code>canceled</code> or <code>returned</code> depending on which status the order
   * started in.
   */
  public OrderReturn returnOrder(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/orders/%s/returns", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, OrderReturn.class, options);
  }

  /**
   * Return all or part of an order. The order must have a status of <code>paid</code> or <code>
   * fulfilled</code> before it can be returned. Once all items have been returned, the order will
   * become <code>canceled</code> or <code>returned</code> depending on which status the order
   * started in.
   */
  public OrderReturn returnOrder(OrderReturnOrderParams params) throws StripeException {
    return returnOrder(params, (RequestOptions) null);
  }

  /**
   * Return all or part of an order. The order must have a status of <code>paid</code> or <code>
   * fulfilled</code> before it can be returned. Once all items have been returned, the order will
   * become <code>canceled</code> or <code>returned</code> depending on which status the order
   * started in.
   */
  public OrderReturn returnOrder(OrderReturnOrderParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/orders/%s/returns", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, OrderReturn.class, options);
  }


  public static class ShippingMethod extends StripeObject implements HasId {
    /**
     * A positive integer in the smallest currency unit (that is, 100 cents for $1.00, or 1 for ¥1,
     * Japanese Yen being a zero-decimal currency) representing the total amount for the line item.
     */
    @SerializedName("amount")
    Long amount;
    /**
     * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in
     * lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
     */
    @SerializedName("currency")
    String currency;
    /**
     * The estimated delivery date for the given shipping method. Can be either a specific date or a
     * range.
     */
    @SerializedName("delivery_estimate")
    DeliveryEstimate deliveryEstimate;
    /**
     * An arbitrary string attached to the object. Often useful for displaying to users.
     */
    @SerializedName("description")
    String description;
    /**
     * Unique identifier for the object.
     */
    @SerializedName("id")
    String id;


    public static class DeliveryEstimate extends StripeObject {
      /**
       * If `type` is `"exact"`, `date` will be the expected delivery date in the format YYYY-MM-DD.
       */
      @SerializedName("date")
      String date;
      /**
       * If `type` is `"range"`, `earliest` will be be the earliest delivery date in the format
       * YYYY-MM-DD.
       */
      @SerializedName("earliest")
      String earliest;
      /**
       * If `type` is `"range"`, `latest` will be the latest delivery date in the format YYYY-MM-DD.
       */
      @SerializedName("latest")
      String latest;
      @SerializedName("type")
      String type;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getDate() {
        return this.date;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getEarliest() {
        return this.earliest;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getLatest() {
        return this.latest;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getType() {
        return this.type;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setDate(final String date) {
        this.date = date;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setEarliest(final String earliest) {
        this.earliest = earliest;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setLatest(final String latest) {
        this.latest = latest;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setType(final String type) {
        this.type = type;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Order.ShippingMethod.DeliveryEstimate)) return false;
        final Order.ShippingMethod.DeliveryEstimate other = (Order.ShippingMethod.DeliveryEstimate) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$date = this.getDate();
        final java.lang.Object other$date = other.getDate();
        if (this$date == null ? other$date != null : !this$date.equals(other$date)) return false;
        final java.lang.Object this$earliest = this.getEarliest();
        final java.lang.Object other$earliest = other.getEarliest();
        if (this$earliest == null ? other$earliest != null : !this$earliest.equals(other$earliest)) return false;
        final java.lang.Object this$latest = this.getLatest();
        final java.lang.Object other$latest = other.getLatest();
        if (this$latest == null ? other$latest != null : !this$latest.equals(other$latest)) return false;
        final java.lang.Object this$type = this.getType();
        final java.lang.Object other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Order.ShippingMethod.DeliveryEstimate;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $date = this.getDate();
        result = result * PRIME + ($date == null ? 43 : $date.hashCode());
        final java.lang.Object $earliest = this.getEarliest();
        result = result * PRIME + ($earliest == null ? 43 : $earliest.hashCode());
        final java.lang.Object $latest = this.getLatest();
        result = result * PRIME + ($latest == null ? 43 : $latest.hashCode());
        final java.lang.Object $type = this.getType();
        result = result * PRIME + ($type == null ? 43 : $type.hashCode());
        return result;
      }
    }

    /**
     * A positive integer in the smallest currency unit (that is, 100 cents for $1.00, or 1 for ¥1,
     * Japanese Yen being a zero-decimal currency) representing the total amount for the line item.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmount() {
      return this.amount;
    }

    /**
     * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in
     * lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCurrency() {
      return this.currency;
    }

    /**
     * The estimated delivery date for the given shipping method. Can be either a specific date or a
     * range.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DeliveryEstimate getDeliveryEstimate() {
      return this.deliveryEstimate;
    }

    /**
     * An arbitrary string attached to the object. Often useful for displaying to users.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDescription() {
      return this.description;
    }

    /**
     * A positive integer in the smallest currency unit (that is, 100 cents for $1.00, or 1 for ¥1,
     * Japanese Yen being a zero-decimal currency) representing the total amount for the line item.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmount(final Long amount) {
      this.amount = amount;
    }

    /**
     * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in
     * lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCurrency(final String currency) {
      this.currency = currency;
    }

    /**
     * The estimated delivery date for the given shipping method. Can be either a specific date or a
     * range.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDeliveryEstimate(final DeliveryEstimate deliveryEstimate) {
      this.deliveryEstimate = deliveryEstimate;
    }

    /**
     * An arbitrary string attached to the object. Often useful for displaying to users.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDescription(final String description) {
      this.description = description;
    }

    /**
     * Unique identifier for the object.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setId(final String id) {
      this.id = id;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Order.ShippingMethod)) return false;
      final Order.ShippingMethod other = (Order.ShippingMethod) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$amount = this.getAmount();
      final java.lang.Object other$amount = other.getAmount();
      if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
      final java.lang.Object this$currency = this.getCurrency();
      final java.lang.Object other$currency = other.getCurrency();
      if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
      final java.lang.Object this$deliveryEstimate = this.getDeliveryEstimate();
      final java.lang.Object other$deliveryEstimate = other.getDeliveryEstimate();
      if (this$deliveryEstimate == null ? other$deliveryEstimate != null : !this$deliveryEstimate.equals(other$deliveryEstimate)) return false;
      final java.lang.Object this$description = this.getDescription();
      final java.lang.Object other$description = other.getDescription();
      if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
      final java.lang.Object this$id = this.getId();
      final java.lang.Object other$id = other.getId();
      if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Order.ShippingMethod;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $amount = this.getAmount();
      result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
      final java.lang.Object $currency = this.getCurrency();
      result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
      final java.lang.Object $deliveryEstimate = this.getDeliveryEstimate();
      result = result * PRIME + ($deliveryEstimate == null ? 43 : $deliveryEstimate.hashCode());
      final java.lang.Object $description = this.getDescription();
      result = result * PRIME + ($description == null ? 43 : $description.hashCode());
      final java.lang.Object $id = this.getId();
      result = result * PRIME + ($id == null ? 43 : $id.hashCode());
      return result;
    }

    /**
     * Unique identifier for the object.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getId() {
      return this.id;
    }
  }


  /**
   * The type of estimate. Must be either `"range"` or `"exact"`.
   */
  public static class StatusTransitions extends StripeObject {
    @SerializedName("canceled")
    Long canceled;
    @SerializedName("fulfiled")
    Long fulfiled;
    @SerializedName("paid")
    Long paid;
    @SerializedName("returned")
    Long returned;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getCanceled() {
      return this.canceled;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getFulfiled() {
      return this.fulfiled;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getPaid() {
      return this.paid;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getReturned() {
      return this.returned;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCanceled(final Long canceled) {
      this.canceled = canceled;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFulfiled(final Long fulfiled) {
      this.fulfiled = fulfiled;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPaid(final Long paid) {
      this.paid = paid;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setReturned(final Long returned) {
      this.returned = returned;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Order.StatusTransitions)) return false;
      final Order.StatusTransitions other = (Order.StatusTransitions) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$canceled = this.getCanceled();
      final java.lang.Object other$canceled = other.getCanceled();
      if (this$canceled == null ? other$canceled != null : !this$canceled.equals(other$canceled)) return false;
      final java.lang.Object this$fulfiled = this.getFulfiled();
      final java.lang.Object other$fulfiled = other.getFulfiled();
      if (this$fulfiled == null ? other$fulfiled != null : !this$fulfiled.equals(other$fulfiled)) return false;
      final java.lang.Object this$paid = this.getPaid();
      final java.lang.Object other$paid = other.getPaid();
      if (this$paid == null ? other$paid != null : !this$paid.equals(other$paid)) return false;
      final java.lang.Object this$returned = this.getReturned();
      final java.lang.Object other$returned = other.getReturned();
      if (this$returned == null ? other$returned != null : !this$returned.equals(other$returned)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Order.StatusTransitions;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $canceled = this.getCanceled();
      result = result * PRIME + ($canceled == null ? 43 : $canceled.hashCode());
      final java.lang.Object $fulfiled = this.getFulfiled();
      result = result * PRIME + ($fulfiled == null ? 43 : $fulfiled.hashCode());
      final java.lang.Object $paid = this.getPaid();
      result = result * PRIME + ($paid == null ? 43 : $paid.hashCode());
      final java.lang.Object $returned = this.getReturned();
      result = result * PRIME + ($returned == null ? 43 : $returned.hashCode());
      return result;
    }
  }

  /**
   * A positive integer in the smallest currency unit (that is, 100 cents for $1.00, or 1 for ¥1,
   * Japanese Yen being a zero-decimal currency) representing the total amount for the order.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmount() {
    return this.amount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmountReturned() {
    return this.amountReturned;
  }

  /**
   * ID of the Connect Application that created the order.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getApplication() {
    return this.application;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getApplicationFee() {
    return this.applicationFee;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in
   * lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  /**
   * The email address of the customer placing the order.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getEmail() {
    return this.email;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getExternalCouponCode() {
    return this.externalCouponCode;
  }

  /**
   * List of items constituting the order. An order can have up to 25 items.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<OrderItem> getItems() {
    return this.items;
  }

  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object
   * exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public OrderReturnCollection getReturns() {
    return this.returns;
  }

  /**
   * The shipping method that is currently selected for this order, if any. If present, it is equal
   * to one of the `id`s of shipping methods in the `shipping_methods` array. At order creation
   * time, if there are multiple shipping methods, Stripe will automatically selected the first
   * method.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSelectedShippingMethod() {
    return this.selectedShippingMethod;
  }

  /**
   * The shipping address for the order. Present if the order is for goods to be shipped.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ShippingDetails getShipping() {
    return this.shipping;
  }

  /**
   * A list of supported shipping methods for this order. The desired shipping method can be
   * specified either by updating the order, or when paying it.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<Order.ShippingMethod> getShippingMethods() {
    return this.shippingMethods;
  }

  /**
   * Current order status. One of `created`, `paid`, `canceled`, `fulfilled`, or `returned`. More
   * details in the [Orders
   * Guide](https://stripe.com/docs/orders/guide#understanding-order-statuses).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  /**
   * The timestamps at which the order status was updated.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public StatusTransitions getStatusTransitions() {
    return this.statusTransitions;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getUpdated() {
    return this.updated;
  }

  /**
   * The user's order ID if it is different from the Stripe order ID.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getUpstreamId() {
    return this.upstreamId;
  }

  /**
   * A positive integer in the smallest currency unit (that is, 100 cents for $1.00, or 1 for ¥1,
   * Japanese Yen being a zero-decimal currency) representing the total amount for the order.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmount(final Long amount) {
    this.amount = amount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmountReturned(final Long amountReturned) {
    this.amountReturned = amountReturned;
  }

  /**
   * ID of the Connect Application that created the order.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setApplication(final String application) {
    this.application = application;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setApplicationFee(final Long applicationFee) {
    this.applicationFee = applicationFee;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in
   * lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  /**
   * The email address of the customer placing the order.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEmail(final String email) {
    this.email = email;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setExternalCouponCode(final String externalCouponCode) {
    this.externalCouponCode = externalCouponCode;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * List of items constituting the order. An order can have up to 25 items.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setItems(final List<OrderItem> items) {
    this.items = items;
  }

  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object
   * exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReturns(final OrderReturnCollection returns) {
    this.returns = returns;
  }

  /**
   * The shipping method that is currently selected for this order, if any. If present, it is equal
   * to one of the `id`s of shipping methods in the `shipping_methods` array. At order creation
   * time, if there are multiple shipping methods, Stripe will automatically selected the first
   * method.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSelectedShippingMethod(final String selectedShippingMethod) {
    this.selectedShippingMethod = selectedShippingMethod;
  }

  /**
   * The shipping address for the order. Present if the order is for goods to be shipped.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setShipping(final ShippingDetails shipping) {
    this.shipping = shipping;
  }

  /**
   * A list of supported shipping methods for this order. The desired shipping method can be
   * specified either by updating the order, or when paying it.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setShippingMethods(final List<Order.ShippingMethod> shippingMethods) {
    this.shippingMethods = shippingMethods;
  }

  /**
   * Current order status. One of `created`, `paid`, `canceled`, `fulfilled`, or `returned`. More
   * details in the [Orders
   * Guide](https://stripe.com/docs/orders/guide#understanding-order-statuses).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  /**
   * The timestamps at which the order status was updated.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatusTransitions(final StatusTransitions statusTransitions) {
    this.statusTransitions = statusTransitions;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setUpdated(final Long updated) {
    this.updated = updated;
  }

  /**
   * The user's order ID if it is different from the Stripe order ID.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setUpstreamId(final String upstreamId) {
    this.upstreamId = upstreamId;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Order)) return false;
    final Order other = (Order) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$amount = this.getAmount();
    final java.lang.Object other$amount = other.getAmount();
    if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
    final java.lang.Object this$amountReturned = this.getAmountReturned();
    final java.lang.Object other$amountReturned = other.getAmountReturned();
    if (this$amountReturned == null ? other$amountReturned != null : !this$amountReturned.equals(other$amountReturned)) return false;
    final java.lang.Object this$application = this.getApplication();
    final java.lang.Object other$application = other.getApplication();
    if (this$application == null ? other$application != null : !this$application.equals(other$application)) return false;
    final java.lang.Object this$applicationFee = this.getApplicationFee();
    final java.lang.Object other$applicationFee = other.getApplicationFee();
    if (this$applicationFee == null ? other$applicationFee != null : !this$applicationFee.equals(other$applicationFee)) return false;
    final java.lang.Object this$charge = this.getCharge();
    final java.lang.Object other$charge = other.getCharge();
    if (this$charge == null ? other$charge != null : !this$charge.equals(other$charge)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$customer = this.getCustomer();
    final java.lang.Object other$customer = other.getCustomer();
    if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) return false;
    final java.lang.Object this$email = this.getEmail();
    final java.lang.Object other$email = other.getEmail();
    if (this$email == null ? other$email != null : !this$email.equals(other$email)) return false;
    final java.lang.Object this$externalCouponCode = this.getExternalCouponCode();
    final java.lang.Object other$externalCouponCode = other.getExternalCouponCode();
    if (this$externalCouponCode == null ? other$externalCouponCode != null : !this$externalCouponCode.equals(other$externalCouponCode)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$items = this.getItems();
    final java.lang.Object other$items = other.getItems();
    if (this$items == null ? other$items != null : !this$items.equals(other$items)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$returns = this.getReturns();
    final java.lang.Object other$returns = other.getReturns();
    if (this$returns == null ? other$returns != null : !this$returns.equals(other$returns)) return false;
    final java.lang.Object this$selectedShippingMethod = this.getSelectedShippingMethod();
    final java.lang.Object other$selectedShippingMethod = other.getSelectedShippingMethod();
    if (this$selectedShippingMethod == null ? other$selectedShippingMethod != null : !this$selectedShippingMethod.equals(other$selectedShippingMethod)) return false;
    final java.lang.Object this$shipping = this.getShipping();
    final java.lang.Object other$shipping = other.getShipping();
    if (this$shipping == null ? other$shipping != null : !this$shipping.equals(other$shipping)) return false;
    final java.lang.Object this$shippingMethods = this.getShippingMethods();
    final java.lang.Object other$shippingMethods = other.getShippingMethods();
    if (this$shippingMethods == null ? other$shippingMethods != null : !this$shippingMethods.equals(other$shippingMethods)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$statusTransitions = this.getStatusTransitions();
    final java.lang.Object other$statusTransitions = other.getStatusTransitions();
    if (this$statusTransitions == null ? other$statusTransitions != null : !this$statusTransitions.equals(other$statusTransitions)) return false;
    final java.lang.Object this$updated = this.getUpdated();
    final java.lang.Object other$updated = other.getUpdated();
    if (this$updated == null ? other$updated != null : !this$updated.equals(other$updated)) return false;
    final java.lang.Object this$upstreamId = this.getUpstreamId();
    final java.lang.Object other$upstreamId = other.getUpstreamId();
    if (this$upstreamId == null ? other$upstreamId != null : !this$upstreamId.equals(other$upstreamId)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Order;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $amount = this.getAmount();
    result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
    final java.lang.Object $amountReturned = this.getAmountReturned();
    result = result * PRIME + ($amountReturned == null ? 43 : $amountReturned.hashCode());
    final java.lang.Object $application = this.getApplication();
    result = result * PRIME + ($application == null ? 43 : $application.hashCode());
    final java.lang.Object $applicationFee = this.getApplicationFee();
    result = result * PRIME + ($applicationFee == null ? 43 : $applicationFee.hashCode());
    final java.lang.Object $charge = this.getCharge();
    result = result * PRIME + ($charge == null ? 43 : $charge.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $customer = this.getCustomer();
    result = result * PRIME + ($customer == null ? 43 : $customer.hashCode());
    final java.lang.Object $email = this.getEmail();
    result = result * PRIME + ($email == null ? 43 : $email.hashCode());
    final java.lang.Object $externalCouponCode = this.getExternalCouponCode();
    result = result * PRIME + ($externalCouponCode == null ? 43 : $externalCouponCode.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $items = this.getItems();
    result = result * PRIME + ($items == null ? 43 : $items.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $returns = this.getReturns();
    result = result * PRIME + ($returns == null ? 43 : $returns.hashCode());
    final java.lang.Object $selectedShippingMethod = this.getSelectedShippingMethod();
    result = result * PRIME + ($selectedShippingMethod == null ? 43 : $selectedShippingMethod.hashCode());
    final java.lang.Object $shipping = this.getShipping();
    result = result * PRIME + ($shipping == null ? 43 : $shipping.hashCode());
    final java.lang.Object $shippingMethods = this.getShippingMethods();
    result = result * PRIME + ($shippingMethods == null ? 43 : $shippingMethods.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $statusTransitions = this.getStatusTransitions();
    result = result * PRIME + ($statusTransitions == null ? 43 : $statusTransitions.hashCode());
    final java.lang.Object $updated = this.getUpdated();
    result = result * PRIME + ($updated == null ? 43 : $updated.hashCode());
    final java.lang.Object $upstreamId = this.getUpstreamId();
    result = result * PRIME + ($upstreamId == null ? 43 : $upstreamId.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
