/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.stripe.exception.StripeException;
import com.stripe.model.BankAccount;
import com.stripe.model.Card;
import com.stripe.model.ExternalAccount;
import com.stripe.net.RequestOptions;
import java.io.IOException;
import java.util.Map;
import lombok.Generated;

public class ExternalAccountTypeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (!ExternalAccount.class.isAssignableFrom(type.getRawType())) {
            return null;
        }
        String discriminator = "object";
        final TypeAdapter jsonElementAdapter = gson.getAdapter(JsonElement.class);
        final TypeAdapter externalAccountAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ExternalAccount.class));
        final TypeAdapter bankAccountAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(BankAccount.class));
        final TypeAdapter cardAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Card.class));
        TypeAdapter<ExternalAccount> resultCustomTypeAdapter = new TypeAdapter<ExternalAccount>(){

            public void write(JsonWriter out, ExternalAccount value) throws IOException {
                externalAccountAdapter.write(out, (Object)value);
            }

            public ExternalAccount read(JsonReader in) throws IOException {
                ExternalAccount objectResult;
                JsonObject object = ((JsonElement)jsonElementAdapter.read(in)).getAsJsonObject();
                String objectType = object.getAsJsonPrimitive("object").getAsString();
                if ("bank_account".equals(objectType)) {
                    objectResult = (ExternalAccount)bankAccountAdapter.fromJsonTree((JsonElement)object);
                } else if ("card".equals(objectType)) {
                    objectResult = (ExternalAccount)cardAdapter.fromJsonTree((JsonElement)object);
                } else {
                    String id = object.getAsJsonPrimitive("id").getAsString();
                    objectResult = new UnknownSubType(id, objectType, object.toString());
                }
                return objectResult;
            }
        };
        return resultCustomTypeAdapter.nullSafe();
    }

    public static class UnknownSubType
    implements ExternalAccount {
        String id;
        String object;
        String rawJson;

        private UnknownSubType(String id, String object, String rawJson) {
            this.id = id;
            this.object = object;
            this.rawJson = rawJson;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public ExternalAccount update(Map<String, Object> params, RequestOptions options) throws StripeException {
            throw new UnsupportedOperationException(String.format("Unknown subtype of ExternalAccount with id: %s, object: %s, does not implement method: update. Please contact support@stripe.com for assistance.", this.id, this.object));
        }

        @Override
        public ExternalAccount update(Map<String, Object> params) throws StripeException {
            throw new UnsupportedOperationException(String.format("Unknown subtype of ExternalAccount with id: %s, object: %s, does not implement method: update. Please contact support@stripe.com for assistance.", this.id, this.object));
        }

        @Override
        public ExternalAccount delete(Map<String, Object> params, RequestOptions options) throws StripeException {
            throw new UnsupportedOperationException(String.format("Unknown subtype of ExternalAccount with id: %s, object: %s, does not implement method: delete. Please contact support@stripe.com for assistance.", this.id, this.object));
        }

        @Override
        public ExternalAccount delete() throws StripeException {
            throw new UnsupportedOperationException(String.format("Unknown subtype of ExternalAccount with id: %s, object: %s, does not implement method: delete. Please contact support@stripe.com for assistance.", this.id, this.object));
        }

        @Override
        public ExternalAccount delete(RequestOptions options) throws StripeException {
            throw new UnsupportedOperationException(String.format("Unknown subtype of ExternalAccount with id: %s, object: %s, does not implement method: delete. Please contact support@stripe.com for assistance.", this.id, this.object));
        }

        @Override
        public ExternalAccount delete(Map<String, Object> params) throws StripeException {
            throw new UnsupportedOperationException(String.format("Unknown subtype of ExternalAccount with id: %s, object: %s, does not implement method: delete. Please contact support@stripe.com for assistance.", this.id, this.object));
        }

        @Generated
        public String getObject() {
            return this.object;
        }

        @Generated
        public String getRawJson() {
            return this.rawJson;
        }
    }
}

