/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class WebhookEndpointCreateParams
extends ApiRequestParams {
    @SerializedName(value="api_version")
    ApiVersion apiVersion;
    @SerializedName(value="connect")
    Boolean connect;
    @SerializedName(value="enabled_events")
    List<EnabledEvent> enabledEvents;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="_stripe_java_extra_param_key")
    Map<String, Object> extraParams;
    @SerializedName(value="url")
    String url;

    private WebhookEndpointCreateParams(ApiVersion apiVersion, Boolean connect, List<EnabledEvent> enabledEvents, List<String> expand, Map<String, Object> extraParams, String url) {
        this.apiVersion = apiVersion;
        this.connect = connect;
        this.enabledEvents = enabledEvents;
        this.expand = expand;
        this.extraParams = extraParams;
        this.url = url;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @Generated
    public Boolean getConnect() {
        return this.connect;
    }

    @Generated
    public List<EnabledEvent> getEnabledEvents() {
        return this.enabledEvents;
    }

    @Generated
    public List<String> getExpand() {
        return this.expand;
    }

    @Generated
    public Map<String, Object> getExtraParams() {
        return this.extraParams;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    public static enum EnabledEvent implements ApiRequestParams.EnumParam
    {
        ALL("*"),
        ACCOUNT__APPLICATION__AUTHORIZED("account.application.authorized"),
        ACCOUNT__APPLICATION__DEAUTHORIZED("account.application.deauthorized"),
        ACCOUNT__EXTERNAL_ACCOUNT__CREATED("account.external_account.created"),
        ACCOUNT__EXTERNAL_ACCOUNT__DELETED("account.external_account.deleted"),
        ACCOUNT__EXTERNAL_ACCOUNT__UPDATED("account.external_account.updated"),
        ACCOUNT__UPDATED("account.updated"),
        APPLICATION_FEE__CREATED("application_fee.created"),
        APPLICATION_FEE__REFUND__UPDATED("application_fee.refund.updated"),
        APPLICATION_FEE__REFUNDED("application_fee.refunded"),
        BALANCE__AVAILABLE("balance.available"),
        CAPABILITY__UPDATED("capability.updated"),
        CHARGE__CAPTURED("charge.captured"),
        CHARGE__DISPUTE__CLOSED("charge.dispute.closed"),
        CHARGE__DISPUTE__CREATED("charge.dispute.created"),
        CHARGE__DISPUTE__FUNDS_REINSTATED("charge.dispute.funds_reinstated"),
        CHARGE__DISPUTE__FUNDS_WITHDRAWN("charge.dispute.funds_withdrawn"),
        CHARGE__DISPUTE__UPDATED("charge.dispute.updated"),
        CHARGE__EXPIRED("charge.expired"),
        CHARGE__FAILED("charge.failed"),
        CHARGE__PENDING("charge.pending"),
        CHARGE__REFUND__UPDATED("charge.refund.updated"),
        CHARGE__REFUNDED("charge.refunded"),
        CHARGE__SUCCEEDED("charge.succeeded"),
        CHARGE__UPDATED("charge.updated"),
        CHECKOUT__SESSION__COMPLETED("checkout.session.completed"),
        COUPON__CREATED("coupon.created"),
        COUPON__DELETED("coupon.deleted"),
        COUPON__UPDATED("coupon.updated"),
        CREDIT_NOTE__CREATED("credit_note.created"),
        CREDIT_NOTE__UPDATED("credit_note.updated"),
        CREDIT_NOTE__VOIDED("credit_note.voided"),
        CUSTOMER__CREATED("customer.created"),
        CUSTOMER__DELETED("customer.deleted"),
        CUSTOMER__DISCOUNT__CREATED("customer.discount.created"),
        CUSTOMER__DISCOUNT__DELETED("customer.discount.deleted"),
        CUSTOMER__DISCOUNT__UPDATED("customer.discount.updated"),
        CUSTOMER__SOURCE__CREATED("customer.source.created"),
        CUSTOMER__SOURCE__DELETED("customer.source.deleted"),
        CUSTOMER__SOURCE__EXPIRING("customer.source.expiring"),
        CUSTOMER__SOURCE__UPDATED("customer.source.updated"),
        CUSTOMER__SUBSCRIPTION__CREATED("customer.subscription.created"),
        CUSTOMER__SUBSCRIPTION__DELETED("customer.subscription.deleted"),
        CUSTOMER__SUBSCRIPTION__TRIAL_WILL_END("customer.subscription.trial_will_end"),
        CUSTOMER__SUBSCRIPTION__UPDATED("customer.subscription.updated"),
        CUSTOMER__TAX_ID__CREATED("customer.tax_id.created"),
        CUSTOMER__TAX_ID__DELETED("customer.tax_id.deleted"),
        CUSTOMER__TAX_ID__UPDATED("customer.tax_id.updated"),
        CUSTOMER__UPDATED("customer.updated"),
        FILE__CREATED("file.created"),
        INVOICE__CREATED("invoice.created"),
        INVOICE__DELETED("invoice.deleted"),
        INVOICE__FINALIZED("invoice.finalized"),
        INVOICE__MARKED_UNCOLLECTIBLE("invoice.marked_uncollectible"),
        INVOICE__PAYMENT_ACTION_REQUIRED("invoice.payment_action_required"),
        INVOICE__PAYMENT_FAILED("invoice.payment_failed"),
        INVOICE__PAYMENT_SUCCEEDED("invoice.payment_succeeded"),
        INVOICE__SENT("invoice.sent"),
        INVOICE__UPCOMING("invoice.upcoming"),
        INVOICE__UPDATED("invoice.updated"),
        INVOICE__VOIDED("invoice.voided"),
        INVOICEITEM__CREATED("invoiceitem.created"),
        INVOICEITEM__DELETED("invoiceitem.deleted"),
        INVOICEITEM__UPDATED("invoiceitem.updated"),
        ISSUING_AUTHORIZATION__CREATED("issuing_authorization.created"),
        ISSUING_AUTHORIZATION__REQUEST("issuing_authorization.request"),
        ISSUING_AUTHORIZATION__UPDATED("issuing_authorization.updated"),
        ISSUING_CARD__CREATED("issuing_card.created"),
        ISSUING_CARD__UPDATED("issuing_card.updated"),
        ISSUING_CARDHOLDER__CREATED("issuing_cardholder.created"),
        ISSUING_CARDHOLDER__UPDATED("issuing_cardholder.updated"),
        ISSUING_DISPUTE__CREATED("issuing_dispute.created"),
        ISSUING_DISPUTE__UPDATED("issuing_dispute.updated"),
        ISSUING_SETTLEMENT__CREATED("issuing_settlement.created"),
        ISSUING_SETTLEMENT__UPDATED("issuing_settlement.updated"),
        ISSUING_TRANSACTION__CREATED("issuing_transaction.created"),
        ISSUING_TRANSACTION__UPDATED("issuing_transaction.updated"),
        MANDATE__UPDATED("mandate.updated"),
        ORDER__CREATED("order.created"),
        ORDER__PAYMENT_FAILED("order.payment_failed"),
        ORDER__PAYMENT_SUCCEEDED("order.payment_succeeded"),
        ORDER__UPDATED("order.updated"),
        ORDER_RETURN__CREATED("order_return.created"),
        PAYMENT_INTENT__AMOUNT_CAPTURABLE_UPDATED("payment_intent.amount_capturable_updated"),
        PAYMENT_INTENT__CANCELED("payment_intent.canceled"),
        PAYMENT_INTENT__CREATED("payment_intent.created"),
        PAYMENT_INTENT__PAYMENT_FAILED("payment_intent.payment_failed"),
        PAYMENT_INTENT__SUCCEEDED("payment_intent.succeeded"),
        PAYMENT_METHOD__ATTACHED("payment_method.attached"),
        PAYMENT_METHOD__CARD_AUTOMATICALLY_UPDATED("payment_method.card_automatically_updated"),
        PAYMENT_METHOD__DETACHED("payment_method.detached"),
        PAYMENT_METHOD__UPDATED("payment_method.updated"),
        PAYOUT__CANCELED("payout.canceled"),
        PAYOUT__CREATED("payout.created"),
        PAYOUT__FAILED("payout.failed"),
        PAYOUT__PAID("payout.paid"),
        PAYOUT__UPDATED("payout.updated"),
        PERSON__CREATED("person.created"),
        PERSON__DELETED("person.deleted"),
        PERSON__UPDATED("person.updated"),
        PLAN__CREATED("plan.created"),
        PLAN__DELETED("plan.deleted"),
        PLAN__UPDATED("plan.updated"),
        PRODUCT__CREATED("product.created"),
        PRODUCT__DELETED("product.deleted"),
        PRODUCT__UPDATED("product.updated"),
        RADAR__EARLY_FRAUD_WARNING__CREATED("radar.early_fraud_warning.created"),
        RADAR__EARLY_FRAUD_WARNING__UPDATED("radar.early_fraud_warning.updated"),
        RECIPIENT__CREATED("recipient.created"),
        RECIPIENT__DELETED("recipient.deleted"),
        RECIPIENT__UPDATED("recipient.updated"),
        REPORTING__REPORT_RUN__FAILED("reporting.report_run.failed"),
        REPORTING__REPORT_RUN__SUCCEEDED("reporting.report_run.succeeded"),
        REPORTING__REPORT_TYPE__UPDATED("reporting.report_type.updated"),
        REVIEW__CLOSED("review.closed"),
        REVIEW__OPENED("review.opened"),
        SETUP_INTENT__CANCELED("setup_intent.canceled"),
        SETUP_INTENT__CREATED("setup_intent.created"),
        SETUP_INTENT__SETUP_FAILED("setup_intent.setup_failed"),
        SETUP_INTENT__SUCCEEDED("setup_intent.succeeded"),
        SIGMA__SCHEDULED_QUERY_RUN__CREATED("sigma.scheduled_query_run.created"),
        SKU__CREATED("sku.created"),
        SKU__DELETED("sku.deleted"),
        SKU__UPDATED("sku.updated"),
        SOURCE__CANCELED("source.canceled"),
        SOURCE__CHARGEABLE("source.chargeable"),
        SOURCE__FAILED("source.failed"),
        SOURCE__MANDATE_NOTIFICATION("source.mandate_notification"),
        SOURCE__REFUND_ATTRIBUTES_REQUIRED("source.refund_attributes_required"),
        SOURCE__TRANSACTION__CREATED("source.transaction.created"),
        SOURCE__TRANSACTION__UPDATED("source.transaction.updated"),
        SUBSCRIPTION_SCHEDULE__ABORTED("subscription_schedule.aborted"),
        SUBSCRIPTION_SCHEDULE__CANCELED("subscription_schedule.canceled"),
        SUBSCRIPTION_SCHEDULE__COMPLETED("subscription_schedule.completed"),
        SUBSCRIPTION_SCHEDULE__CREATED("subscription_schedule.created"),
        SUBSCRIPTION_SCHEDULE__EXPIRING("subscription_schedule.expiring"),
        SUBSCRIPTION_SCHEDULE__RELEASED("subscription_schedule.released"),
        SUBSCRIPTION_SCHEDULE__UPDATED("subscription_schedule.updated"),
        TAX_RATE__CREATED("tax_rate.created"),
        TAX_RATE__UPDATED("tax_rate.updated"),
        TOPUP__CANCELED("topup.canceled"),
        TOPUP__CREATED("topup.created"),
        TOPUP__FAILED("topup.failed"),
        TOPUP__REVERSED("topup.reversed"),
        TOPUP__SUCCEEDED("topup.succeeded"),
        TRANSFER__CREATED("transfer.created"),
        TRANSFER__FAILED("transfer.failed"),
        TRANSFER__PAID("transfer.paid"),
        TRANSFER__REVERSED("transfer.reversed"),
        TRANSFER__UPDATED("transfer.updated");

        private final String value;

        private EnabledEvent(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static enum ApiVersion implements ApiRequestParams.EnumParam
    {
        VERSION_2011_01_01("2011-01-01"),
        VERSION_2011_06_21("2011-06-21"),
        VERSION_2011_06_28("2011-06-28"),
        VERSION_2011_08_01("2011-08-01"),
        VERSION_2011_09_15("2011-09-15"),
        VERSION_2011_11_17("2011-11-17"),
        VERSION_2012_02_23("2012-02-23"),
        VERSION_2012_03_25("2012-03-25"),
        VERSION_2012_06_18("2012-06-18"),
        VERSION_2012_06_28("2012-06-28"),
        VERSION_2012_07_09("2012-07-09"),
        VERSION_2012_09_24("2012-09-24"),
        VERSION_2012_10_26("2012-10-26"),
        VERSION_2012_11_07("2012-11-07"),
        VERSION_2013_02_11("2013-02-11"),
        VERSION_2013_02_13("2013-02-13"),
        VERSION_2013_07_05("2013-07-05"),
        VERSION_2013_08_12("2013-08-12"),
        VERSION_2013_08_13("2013-08-13"),
        VERSION_2013_10_29("2013-10-29"),
        VERSION_2013_12_03("2013-12-03"),
        VERSION_2014_01_31("2014-01-31"),
        VERSION_2014_03_13("2014-03-13"),
        VERSION_2014_03_28("2014-03-28"),
        VERSION_2014_05_19("2014-05-19"),
        VERSION_2014_06_13("2014-06-13"),
        VERSION_2014_06_17("2014-06-17"),
        VERSION_2014_07_22("2014-07-22"),
        VERSION_2014_07_26("2014-07-26"),
        VERSION_2014_08_04("2014-08-04"),
        VERSION_2014_08_20("2014-08-20"),
        VERSION_2014_09_08("2014-09-08"),
        VERSION_2014_10_07("2014-10-07"),
        VERSION_2014_11_05("2014-11-05"),
        VERSION_2014_11_20("2014-11-20"),
        VERSION_2014_12_08("2014-12-08"),
        VERSION_2014_12_17("2014-12-17"),
        VERSION_2014_12_22("2014-12-22"),
        VERSION_2015_01_11("2015-01-11"),
        VERSION_2015_01_26("2015-01-26"),
        VERSION_2015_02_10("2015-02-10"),
        VERSION_2015_02_16("2015-02-16"),
        VERSION_2015_02_18("2015-02-18"),
        VERSION_2015_03_24("2015-03-24"),
        VERSION_2015_04_07("2015-04-07"),
        VERSION_2015_06_15("2015-06-15"),
        VERSION_2015_07_07("2015-07-07"),
        VERSION_2015_07_13("2015-07-13"),
        VERSION_2015_07_28("2015-07-28"),
        VERSION_2015_08_07("2015-08-07"),
        VERSION_2015_08_19("2015-08-19"),
        VERSION_2015_09_03("2015-09-03"),
        VERSION_2015_09_08("2015-09-08"),
        VERSION_2015_09_23("2015-09-23"),
        VERSION_2015_10_01("2015-10-01"),
        VERSION_2015_10_12("2015-10-12"),
        VERSION_2015_10_16("2015-10-16"),
        VERSION_2016_02_03("2016-02-03"),
        VERSION_2016_02_19("2016-02-19"),
        VERSION_2016_02_22("2016-02-22"),
        VERSION_2016_02_23("2016-02-23"),
        VERSION_2016_02_29("2016-02-29"),
        VERSION_2016_03_07("2016-03-07"),
        VERSION_2016_06_15("2016-06-15"),
        VERSION_2016_07_06("2016-07-06"),
        VERSION_2016_10_19("2016-10-19"),
        VERSION_2017_01_27("2017-01-27"),
        VERSION_2017_02_14("2017-02-14"),
        VERSION_2017_04_06("2017-04-06"),
        VERSION_2017_05_25("2017-05-25"),
        VERSION_2017_06_05("2017-06-05"),
        VERSION_2017_08_15("2017-08-15"),
        VERSION_2017_12_14("2017-12-14"),
        VERSION_2018_01_23("2018-01-23"),
        VERSION_2018_02_05("2018-02-05"),
        VERSION_2018_02_06("2018-02-06"),
        VERSION_2018_02_28("2018-02-28"),
        VERSION_2018_05_21("2018-05-21"),
        VERSION_2018_07_27("2018-07-27"),
        VERSION_2018_08_23("2018-08-23"),
        VERSION_2018_09_06("2018-09-06"),
        VERSION_2018_09_24("2018-09-24"),
        VERSION_2018_10_31("2018-10-31"),
        VERSION_2018_11_08("2018-11-08"),
        VERSION_2019_02_11("2019-02-11"),
        VERSION_2019_02_19("2019-02-19"),
        VERSION_2019_03_14("2019-03-14"),
        VERSION_2019_05_16("2019-05-16"),
        VERSION_2019_08_14("2019-08-14"),
        VERSION_2019_09_09("2019-09-09"),
        VERSION_2019_10_08("2019-10-08"),
        VERSION_2019_10_17("2019-10-17"),
        VERSION_2019_11_05("2019-11-05");

        private final String value;

        private ApiVersion(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class Builder {
        private ApiVersion apiVersion;
        private Boolean connect;
        private List<EnabledEvent> enabledEvents;
        private List<String> expand;
        private Map<String, Object> extraParams;
        private String url;

        public WebhookEndpointCreateParams build() {
            return new WebhookEndpointCreateParams(this.apiVersion, this.connect, this.enabledEvents, this.expand, this.extraParams, this.url);
        }

        public Builder setApiVersion(ApiVersion apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public Builder setConnect(Boolean connect) {
            this.connect = connect;
            return this;
        }

        public Builder addEnabledEvent(EnabledEvent element) {
            if (this.enabledEvents == null) {
                this.enabledEvents = new ArrayList<EnabledEvent>();
            }
            this.enabledEvents.add(element);
            return this;
        }

        public Builder addAllEnabledEvent(List<EnabledEvent> elements) {
            if (this.enabledEvents == null) {
                this.enabledEvents = new ArrayList<EnabledEvent>();
            }
            this.enabledEvents.addAll(elements);
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.put(key, value);
            return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.putAll(map);
            return this;
        }

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }
    }
}

