/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Address;
import com.stripe.model.MetadataStore;
import com.stripe.model.PaymentSource;
import com.stripe.model.ShippingDetails;
import com.stripe.model.SourceTransactionCollection;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.SourceCreateParams;
import com.stripe.param.SourceRetrieveParams;
import com.stripe.param.SourceSourceTransactionsParams;
import com.stripe.param.SourceUpdateParams;
import com.stripe.param.SourceVerifyParams;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Source
extends ApiResource
implements MetadataStore<Source>,
PaymentSource {
    @SerializedName(value="ach_credit_transfer")
    AchCreditTransfer achCreditTransfer;
    @SerializedName(value="ach_debit")
    AchDebit achDebit;
    @SerializedName(value="acss_debit")
    AcssDebit acssDebit;
    @SerializedName(value="alipay")
    Alipay alipay;
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="au_becs_debit")
    AuBecsDebit auBecsDebit;
    @SerializedName(value="bancontact")
    Bancontact bancontact;
    @SerializedName(value="card")
    Card card;
    @SerializedName(value="card_present")
    CardPresent cardPresent;
    @SerializedName(value="client_secret")
    String clientSecret;
    @SerializedName(value="code_verification")
    CodeVerificationFlow codeVerification;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="customer")
    String customer;
    @SerializedName(value="eps")
    Eps eps;
    @SerializedName(value="flow")
    String flow;
    @SerializedName(value="giropay")
    Giropay giropay;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="ideal")
    Ideal ideal;
    @SerializedName(value="klarna")
    Klarna klarna;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="multibanco")
    Multibanco multibanco;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="owner")
    Owner owner;
    @SerializedName(value="p24")
    P24 p24;
    @SerializedName(value="receiver")
    ReceiverFlow receiver;
    @SerializedName(value="redirect")
    RedirectFlow redirect;
    @SerializedName(value="sepa_credit_transfer")
    SepaCreditTransfer sepaCreditTransfer;
    @SerializedName(value="sepa_debit")
    SepaDebit sepaDebit;
    @SerializedName(value="sofort")
    Sofort sofort;
    @SerializedName(value="source_order")
    Order sourceOrder;
    @SerializedName(value="statement_descriptor")
    String statementDescriptor;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="three_d_secure")
    ThreeDSecure threeDSecure;
    @SerializedName(value="type")
    String type;
    @SerializedName(value="usage")
    String usage;
    @SerializedName(value="wechat")
    Wechat wechat;

    public Source detach() throws StripeException {
        return this.detach(null, null);
    }

    public Source detach(Map<String, Object> params) throws StripeException {
        return this.detach(params, null);
    }

    public Source detach(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s/sources/%s", ApiResource.urlEncodeId(this.getCustomer()), ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.DELETE, url, params, Source.class, options);
    }

    public static Source retrieve(String source) throws StripeException {
        return Source.retrieve(source, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Source retrieve(String source, RequestOptions options) throws StripeException {
        return Source.retrieve(source, (Map<String, Object>)null, options);
    }

    public static Source retrieve(String source, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/sources/%s", ApiResource.urlEncodeId(source)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Source.class, options);
    }

    public static Source retrieve(String source, SourceRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/sources/%s", ApiResource.urlEncodeId(source)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Source.class, options);
    }

    public static Source create(Map<String, Object> params) throws StripeException {
        return Source.create(params, (RequestOptions)null);
    }

    public static Source create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/sources");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Source.class, options);
    }

    public static Source create(SourceCreateParams params) throws StripeException {
        return Source.create(params, (RequestOptions)null);
    }

    public static Source create(SourceCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/sources");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Source.class, options);
    }

    public Source update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Source update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/sources/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Source.class, options);
    }

    public Source update(SourceUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Source update(SourceUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/sources/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Source.class, options);
    }

    public Source verify(Map<String, Object> params) throws StripeException {
        return this.verify(params, (RequestOptions)null);
    }

    public Source verify(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/sources/%s/verify", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Source.class, options);
    }

    public Source verify(SourceVerifyParams params) throws StripeException {
        return this.verify(params, (RequestOptions)null);
    }

    public Source verify(SourceVerifyParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/sources/%s/verify", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Source.class, options);
    }

    public SourceTransactionCollection sourceTransactions() throws StripeException {
        return this.sourceTransactions((Map<String, Object>)null, (RequestOptions)null);
    }

    public SourceTransactionCollection sourceTransactions(Map<String, Object> params) throws StripeException {
        return this.sourceTransactions(params, (RequestOptions)null);
    }

    public SourceTransactionCollection sourceTransactions(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/sources/%s/source_transactions", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.requestCollection(url, params, SourceTransactionCollection.class, options);
    }

    public SourceTransactionCollection sourceTransactions(SourceSourceTransactionsParams params) throws StripeException {
        return this.sourceTransactions(params, (RequestOptions)null);
    }

    public SourceTransactionCollection sourceTransactions(SourceSourceTransactionsParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/sources/%s/source_transactions", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.requestCollection(url, params, SourceTransactionCollection.class, options);
    }

    @Generated
    public AchCreditTransfer getAchCreditTransfer() {
        return this.achCreditTransfer;
    }

    @Generated
    public AchDebit getAchDebit() {
        return this.achDebit;
    }

    @Generated
    public AcssDebit getAcssDebit() {
        return this.acssDebit;
    }

    @Generated
    public Alipay getAlipay() {
        return this.alipay;
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public AuBecsDebit getAuBecsDebit() {
        return this.auBecsDebit;
    }

    @Generated
    public Bancontact getBancontact() {
        return this.bancontact;
    }

    @Generated
    public Card getCard() {
        return this.card;
    }

    @Generated
    public CardPresent getCardPresent() {
        return this.cardPresent;
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public CodeVerificationFlow getCodeVerification() {
        return this.codeVerification;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getCustomer() {
        return this.customer;
    }

    @Generated
    public Eps getEps() {
        return this.eps;
    }

    @Generated
    public String getFlow() {
        return this.flow;
    }

    @Generated
    public Giropay getGiropay() {
        return this.giropay;
    }

    @Generated
    public Ideal getIdeal() {
        return this.ideal;
    }

    @Generated
    public Klarna getKlarna() {
        return this.klarna;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public Multibanco getMultibanco() {
        return this.multibanco;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Owner getOwner() {
        return this.owner;
    }

    @Generated
    public P24 getP24() {
        return this.p24;
    }

    @Generated
    public ReceiverFlow getReceiver() {
        return this.receiver;
    }

    @Generated
    public RedirectFlow getRedirect() {
        return this.redirect;
    }

    @Generated
    public SepaCreditTransfer getSepaCreditTransfer() {
        return this.sepaCreditTransfer;
    }

    @Generated
    public SepaDebit getSepaDebit() {
        return this.sepaDebit;
    }

    @Generated
    public Sofort getSofort() {
        return this.sofort;
    }

    @Generated
    public Order getSourceOrder() {
        return this.sourceOrder;
    }

    @Generated
    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public ThreeDSecure getThreeDSecure() {
        return this.threeDSecure;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getUsage() {
        return this.usage;
    }

    @Generated
    public Wechat getWechat() {
        return this.wechat;
    }

    @Generated
    public void setAchCreditTransfer(AchCreditTransfer achCreditTransfer) {
        this.achCreditTransfer = achCreditTransfer;
    }

    @Generated
    public void setAchDebit(AchDebit achDebit) {
        this.achDebit = achDebit;
    }

    @Generated
    public void setAcssDebit(AcssDebit acssDebit) {
        this.acssDebit = acssDebit;
    }

    @Generated
    public void setAlipay(Alipay alipay) {
        this.alipay = alipay;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setAuBecsDebit(AuBecsDebit auBecsDebit) {
        this.auBecsDebit = auBecsDebit;
    }

    @Generated
    public void setBancontact(Bancontact bancontact) {
        this.bancontact = bancontact;
    }

    @Generated
    public void setCard(Card card) {
        this.card = card;
    }

    @Generated
    public void setCardPresent(CardPresent cardPresent) {
        this.cardPresent = cardPresent;
    }

    @Generated
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Generated
    public void setCodeVerification(CodeVerificationFlow codeVerification) {
        this.codeVerification = codeVerification;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setCustomer(String customer) {
        this.customer = customer;
    }

    @Generated
    public void setEps(Eps eps) {
        this.eps = eps;
    }

    @Generated
    public void setFlow(String flow) {
        this.flow = flow;
    }

    @Generated
    public void setGiropay(Giropay giropay) {
        this.giropay = giropay;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setIdeal(Ideal ideal) {
        this.ideal = ideal;
    }

    @Generated
    public void setKlarna(Klarna klarna) {
        this.klarna = klarna;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setMultibanco(Multibanco multibanco) {
        this.multibanco = multibanco;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setOwner(Owner owner) {
        this.owner = owner;
    }

    @Generated
    public void setP24(P24 p24) {
        this.p24 = p24;
    }

    @Generated
    public void setReceiver(ReceiverFlow receiver) {
        this.receiver = receiver;
    }

    @Generated
    public void setRedirect(RedirectFlow redirect) {
        this.redirect = redirect;
    }

    @Generated
    public void setSepaCreditTransfer(SepaCreditTransfer sepaCreditTransfer) {
        this.sepaCreditTransfer = sepaCreditTransfer;
    }

    @Generated
    public void setSepaDebit(SepaDebit sepaDebit) {
        this.sepaDebit = sepaDebit;
    }

    @Generated
    public void setSofort(Sofort sofort) {
        this.sofort = sofort;
    }

    @Generated
    public void setSourceOrder(Order sourceOrder) {
        this.sourceOrder = sourceOrder;
    }

    @Generated
    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setThreeDSecure(ThreeDSecure threeDSecure) {
        this.threeDSecure = threeDSecure;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setUsage(String usage) {
        this.usage = usage;
    }

    @Generated
    public void setWechat(Wechat wechat) {
        this.wechat = wechat;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Source)) {
            return false;
        }
        Source other = (Source)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AchCreditTransfer this$achCreditTransfer = this.getAchCreditTransfer();
        AchCreditTransfer other$achCreditTransfer = other.getAchCreditTransfer();
        if (this$achCreditTransfer == null ? other$achCreditTransfer != null : !((Object)this$achCreditTransfer).equals(other$achCreditTransfer)) {
            return false;
        }
        AchDebit this$achDebit = this.getAchDebit();
        AchDebit other$achDebit = other.getAchDebit();
        if (this$achDebit == null ? other$achDebit != null : !((Object)this$achDebit).equals(other$achDebit)) {
            return false;
        }
        AcssDebit this$acssDebit = this.getAcssDebit();
        AcssDebit other$acssDebit = other.getAcssDebit();
        if (this$acssDebit == null ? other$acssDebit != null : !((Object)this$acssDebit).equals(other$acssDebit)) {
            return false;
        }
        Alipay this$alipay = this.getAlipay();
        Alipay other$alipay = other.getAlipay();
        if (this$alipay == null ? other$alipay != null : !((Object)this$alipay).equals(other$alipay)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        AuBecsDebit this$auBecsDebit = this.getAuBecsDebit();
        AuBecsDebit other$auBecsDebit = other.getAuBecsDebit();
        if (this$auBecsDebit == null ? other$auBecsDebit != null : !((Object)this$auBecsDebit).equals(other$auBecsDebit)) {
            return false;
        }
        Bancontact this$bancontact = this.getBancontact();
        Bancontact other$bancontact = other.getBancontact();
        if (this$bancontact == null ? other$bancontact != null : !((Object)this$bancontact).equals(other$bancontact)) {
            return false;
        }
        Card this$card = this.getCard();
        Card other$card = other.getCard();
        if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
            return false;
        }
        CardPresent this$cardPresent = this.getCardPresent();
        CardPresent other$cardPresent = other.getCardPresent();
        if (this$cardPresent == null ? other$cardPresent != null : !((Object)this$cardPresent).equals(other$cardPresent)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        CodeVerificationFlow this$codeVerification = this.getCodeVerification();
        CodeVerificationFlow other$codeVerification = other.getCodeVerification();
        if (this$codeVerification == null ? other$codeVerification != null : !((Object)this$codeVerification).equals(other$codeVerification)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        Eps this$eps = this.getEps();
        Eps other$eps = other.getEps();
        if (this$eps == null ? other$eps != null : !((Object)this$eps).equals(other$eps)) {
            return false;
        }
        String this$flow = this.getFlow();
        String other$flow = other.getFlow();
        if (this$flow == null ? other$flow != null : !this$flow.equals(other$flow)) {
            return false;
        }
        Giropay this$giropay = this.getGiropay();
        Giropay other$giropay = other.getGiropay();
        if (this$giropay == null ? other$giropay != null : !((Object)this$giropay).equals(other$giropay)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Ideal this$ideal = this.getIdeal();
        Ideal other$ideal = other.getIdeal();
        if (this$ideal == null ? other$ideal != null : !((Object)this$ideal).equals(other$ideal)) {
            return false;
        }
        Klarna this$klarna = this.getKlarna();
        Klarna other$klarna = other.getKlarna();
        if (this$klarna == null ? other$klarna != null : !((Object)this$klarna).equals(other$klarna)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Multibanco this$multibanco = this.getMultibanco();
        Multibanco other$multibanco = other.getMultibanco();
        if (this$multibanco == null ? other$multibanco != null : !((Object)this$multibanco).equals(other$multibanco)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Owner this$owner = this.getOwner();
        Owner other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !((Object)this$owner).equals(other$owner)) {
            return false;
        }
        P24 this$p24 = this.getP24();
        P24 other$p24 = other.getP24();
        if (this$p24 == null ? other$p24 != null : !((Object)this$p24).equals(other$p24)) {
            return false;
        }
        ReceiverFlow this$receiver = this.getReceiver();
        ReceiverFlow other$receiver = other.getReceiver();
        if (this$receiver == null ? other$receiver != null : !((Object)this$receiver).equals(other$receiver)) {
            return false;
        }
        RedirectFlow this$redirect = this.getRedirect();
        RedirectFlow other$redirect = other.getRedirect();
        if (this$redirect == null ? other$redirect != null : !((Object)this$redirect).equals(other$redirect)) {
            return false;
        }
        SepaCreditTransfer this$sepaCreditTransfer = this.getSepaCreditTransfer();
        SepaCreditTransfer other$sepaCreditTransfer = other.getSepaCreditTransfer();
        if (this$sepaCreditTransfer == null ? other$sepaCreditTransfer != null : !((Object)this$sepaCreditTransfer).equals(other$sepaCreditTransfer)) {
            return false;
        }
        SepaDebit this$sepaDebit = this.getSepaDebit();
        SepaDebit other$sepaDebit = other.getSepaDebit();
        if (this$sepaDebit == null ? other$sepaDebit != null : !((Object)this$sepaDebit).equals(other$sepaDebit)) {
            return false;
        }
        Sofort this$sofort = this.getSofort();
        Sofort other$sofort = other.getSofort();
        if (this$sofort == null ? other$sofort != null : !((Object)this$sofort).equals(other$sofort)) {
            return false;
        }
        Order this$sourceOrder = this.getSourceOrder();
        Order other$sourceOrder = other.getSourceOrder();
        if (this$sourceOrder == null ? other$sourceOrder != null : !((Object)this$sourceOrder).equals(other$sourceOrder)) {
            return false;
        }
        String this$statementDescriptor = this.getStatementDescriptor();
        String other$statementDescriptor = other.getStatementDescriptor();
        if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        ThreeDSecure this$threeDSecure = this.getThreeDSecure();
        ThreeDSecure other$threeDSecure = other.getThreeDSecure();
        if (this$threeDSecure == null ? other$threeDSecure != null : !((Object)this$threeDSecure).equals(other$threeDSecure)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$usage = this.getUsage();
        String other$usage = other.getUsage();
        if (this$usage == null ? other$usage != null : !this$usage.equals(other$usage)) {
            return false;
        }
        Wechat this$wechat = this.getWechat();
        Wechat other$wechat = other.getWechat();
        return !(this$wechat == null ? other$wechat != null : !((Object)this$wechat).equals(other$wechat));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Source;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AchCreditTransfer $achCreditTransfer = this.getAchCreditTransfer();
        result = result * 59 + ($achCreditTransfer == null ? 43 : ((Object)$achCreditTransfer).hashCode());
        AchDebit $achDebit = this.getAchDebit();
        result = result * 59 + ($achDebit == null ? 43 : ((Object)$achDebit).hashCode());
        AcssDebit $acssDebit = this.getAcssDebit();
        result = result * 59 + ($acssDebit == null ? 43 : ((Object)$acssDebit).hashCode());
        Alipay $alipay = this.getAlipay();
        result = result * 59 + ($alipay == null ? 43 : ((Object)$alipay).hashCode());
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        AuBecsDebit $auBecsDebit = this.getAuBecsDebit();
        result = result * 59 + ($auBecsDebit == null ? 43 : ((Object)$auBecsDebit).hashCode());
        Bancontact $bancontact = this.getBancontact();
        result = result * 59 + ($bancontact == null ? 43 : ((Object)$bancontact).hashCode());
        Card $card = this.getCard();
        result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
        CardPresent $cardPresent = this.getCardPresent();
        result = result * 59 + ($cardPresent == null ? 43 : ((Object)$cardPresent).hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        CodeVerificationFlow $codeVerification = this.getCodeVerification();
        result = result * 59 + ($codeVerification == null ? 43 : ((Object)$codeVerification).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        Eps $eps = this.getEps();
        result = result * 59 + ($eps == null ? 43 : ((Object)$eps).hashCode());
        String $flow = this.getFlow();
        result = result * 59 + ($flow == null ? 43 : $flow.hashCode());
        Giropay $giropay = this.getGiropay();
        result = result * 59 + ($giropay == null ? 43 : ((Object)$giropay).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Ideal $ideal = this.getIdeal();
        result = result * 59 + ($ideal == null ? 43 : ((Object)$ideal).hashCode());
        Klarna $klarna = this.getKlarna();
        result = result * 59 + ($klarna == null ? 43 : ((Object)$klarna).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Multibanco $multibanco = this.getMultibanco();
        result = result * 59 + ($multibanco == null ? 43 : ((Object)$multibanco).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Owner $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : ((Object)$owner).hashCode());
        P24 $p24 = this.getP24();
        result = result * 59 + ($p24 == null ? 43 : ((Object)$p24).hashCode());
        ReceiverFlow $receiver = this.getReceiver();
        result = result * 59 + ($receiver == null ? 43 : ((Object)$receiver).hashCode());
        RedirectFlow $redirect = this.getRedirect();
        result = result * 59 + ($redirect == null ? 43 : ((Object)$redirect).hashCode());
        SepaCreditTransfer $sepaCreditTransfer = this.getSepaCreditTransfer();
        result = result * 59 + ($sepaCreditTransfer == null ? 43 : ((Object)$sepaCreditTransfer).hashCode());
        SepaDebit $sepaDebit = this.getSepaDebit();
        result = result * 59 + ($sepaDebit == null ? 43 : ((Object)$sepaDebit).hashCode());
        Sofort $sofort = this.getSofort();
        result = result * 59 + ($sofort == null ? 43 : ((Object)$sofort).hashCode());
        Order $sourceOrder = this.getSourceOrder();
        result = result * 59 + ($sourceOrder == null ? 43 : ((Object)$sourceOrder).hashCode());
        String $statementDescriptor = this.getStatementDescriptor();
        result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        ThreeDSecure $threeDSecure = this.getThreeDSecure();
        result = result * 59 + ($threeDSecure == null ? 43 : ((Object)$threeDSecure).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : $usage.hashCode());
        Wechat $wechat = this.getWechat();
        result = result * 59 + ($wechat == null ? 43 : ((Object)$wechat).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class Wechat
    extends StripeObject {
        @SerializedName(value="prepay_id")
        String prepayId;
        @SerializedName(value="qr_code_url")
        String qrCodeUrl;
        @SerializedName(value="statement_descriptor")
        String statementDescriptor;

        @Generated
        public String getPrepayId() {
            return this.prepayId;
        }

        @Generated
        public String getQrCodeUrl() {
            return this.qrCodeUrl;
        }

        @Generated
        public String getStatementDescriptor() {
            return this.statementDescriptor;
        }

        @Generated
        public void setPrepayId(String prepayId) {
            this.prepayId = prepayId;
        }

        @Generated
        public void setQrCodeUrl(String qrCodeUrl) {
            this.qrCodeUrl = qrCodeUrl;
        }

        @Generated
        public void setStatementDescriptor(String statementDescriptor) {
            this.statementDescriptor = statementDescriptor;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Wechat)) {
                return false;
            }
            Wechat other = (Wechat)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$prepayId = this.getPrepayId();
            String other$prepayId = other.getPrepayId();
            if (this$prepayId == null ? other$prepayId != null : !this$prepayId.equals(other$prepayId)) {
                return false;
            }
            String this$qrCodeUrl = this.getQrCodeUrl();
            String other$qrCodeUrl = other.getQrCodeUrl();
            if (this$qrCodeUrl == null ? other$qrCodeUrl != null : !this$qrCodeUrl.equals(other$qrCodeUrl)) {
                return false;
            }
            String this$statementDescriptor = this.getStatementDescriptor();
            String other$statementDescriptor = other.getStatementDescriptor();
            return !(this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Wechat;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $prepayId = this.getPrepayId();
            result = result * 59 + ($prepayId == null ? 43 : $prepayId.hashCode());
            String $qrCodeUrl = this.getQrCodeUrl();
            result = result * 59 + ($qrCodeUrl == null ? 43 : $qrCodeUrl.hashCode());
            String $statementDescriptor = this.getStatementDescriptor();
            result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
            return result;
        }
    }

    public static class ThreeDSecure
    extends StripeObject {
        @SerializedName(value="address_line1_check")
        String addressLine1Check;
        @SerializedName(value="address_zip_check")
        String addressZipCheck;
        @SerializedName(value="authenticated")
        Boolean authenticated;
        @SerializedName(value="brand")
        String brand;
        @SerializedName(value="card")
        String card;
        @SerializedName(value="country")
        String country;
        @SerializedName(value="customer")
        String customer;
        @SerializedName(value="cvc_check")
        String cvcCheck;
        @SerializedName(value="description")
        String description;
        @SerializedName(value="dynamic_last4")
        String dynamicLast4;
        @SerializedName(value="exp_month")
        Long expMonth;
        @SerializedName(value="exp_year")
        Long expYear;
        @SerializedName(value="fingerprint")
        String fingerprint;
        @SerializedName(value="funding")
        String funding;
        @SerializedName(value="iin")
        String iin;
        @SerializedName(value="issuer")
        String issuer;
        @SerializedName(value="last4")
        String last4;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="three_d_secure")
        String threeDSecure;
        @SerializedName(value="tokenization_method")
        String tokenizationMethod;

        @Generated
        public String getAddressLine1Check() {
            return this.addressLine1Check;
        }

        @Generated
        public String getAddressZipCheck() {
            return this.addressZipCheck;
        }

        @Generated
        public Boolean getAuthenticated() {
            return this.authenticated;
        }

        @Generated
        public String getBrand() {
            return this.brand;
        }

        @Generated
        public String getCard() {
            return this.card;
        }

        @Generated
        public String getCountry() {
            return this.country;
        }

        @Generated
        public String getCustomer() {
            return this.customer;
        }

        @Generated
        public String getCvcCheck() {
            return this.cvcCheck;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public String getDynamicLast4() {
            return this.dynamicLast4;
        }

        @Generated
        public Long getExpMonth() {
            return this.expMonth;
        }

        @Generated
        public Long getExpYear() {
            return this.expYear;
        }

        @Generated
        public String getFingerprint() {
            return this.fingerprint;
        }

        @Generated
        public String getFunding() {
            return this.funding;
        }

        @Generated
        public String getIin() {
            return this.iin;
        }

        @Generated
        public String getIssuer() {
            return this.issuer;
        }

        @Generated
        public String getLast4() {
            return this.last4;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getThreeDSecure() {
            return this.threeDSecure;
        }

        @Generated
        public String getTokenizationMethod() {
            return this.tokenizationMethod;
        }

        @Generated
        public void setAddressLine1Check(String addressLine1Check) {
            this.addressLine1Check = addressLine1Check;
        }

        @Generated
        public void setAddressZipCheck(String addressZipCheck) {
            this.addressZipCheck = addressZipCheck;
        }

        @Generated
        public void setAuthenticated(Boolean authenticated) {
            this.authenticated = authenticated;
        }

        @Generated
        public void setBrand(String brand) {
            this.brand = brand;
        }

        @Generated
        public void setCard(String card) {
            this.card = card;
        }

        @Generated
        public void setCountry(String country) {
            this.country = country;
        }

        @Generated
        public void setCustomer(String customer) {
            this.customer = customer;
        }

        @Generated
        public void setCvcCheck(String cvcCheck) {
            this.cvcCheck = cvcCheck;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public void setDynamicLast4(String dynamicLast4) {
            this.dynamicLast4 = dynamicLast4;
        }

        @Generated
        public void setExpMonth(Long expMonth) {
            this.expMonth = expMonth;
        }

        @Generated
        public void setExpYear(Long expYear) {
            this.expYear = expYear;
        }

        @Generated
        public void setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
        }

        @Generated
        public void setFunding(String funding) {
            this.funding = funding;
        }

        @Generated
        public void setIin(String iin) {
            this.iin = iin;
        }

        @Generated
        public void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Generated
        public void setLast4(String last4) {
            this.last4 = last4;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setThreeDSecure(String threeDSecure) {
            this.threeDSecure = threeDSecure;
        }

        @Generated
        public void setTokenizationMethod(String tokenizationMethod) {
            this.tokenizationMethod = tokenizationMethod;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ThreeDSecure)) {
                return false;
            }
            ThreeDSecure other = (ThreeDSecure)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$addressLine1Check = this.getAddressLine1Check();
            String other$addressLine1Check = other.getAddressLine1Check();
            if (this$addressLine1Check == null ? other$addressLine1Check != null : !this$addressLine1Check.equals(other$addressLine1Check)) {
                return false;
            }
            String this$addressZipCheck = this.getAddressZipCheck();
            String other$addressZipCheck = other.getAddressZipCheck();
            if (this$addressZipCheck == null ? other$addressZipCheck != null : !this$addressZipCheck.equals(other$addressZipCheck)) {
                return false;
            }
            Boolean this$authenticated = this.getAuthenticated();
            Boolean other$authenticated = other.getAuthenticated();
            if (this$authenticated == null ? other$authenticated != null : !((Object)this$authenticated).equals(other$authenticated)) {
                return false;
            }
            String this$brand = this.getBrand();
            String other$brand = other.getBrand();
            if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) {
                return false;
            }
            String this$card = this.getCard();
            String other$card = other.getCard();
            if (this$card == null ? other$card != null : !this$card.equals(other$card)) {
                return false;
            }
            String this$country = this.getCountry();
            String other$country = other.getCountry();
            if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                return false;
            }
            String this$customer = this.getCustomer();
            String other$customer = other.getCustomer();
            if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
                return false;
            }
            String this$cvcCheck = this.getCvcCheck();
            String other$cvcCheck = other.getCvcCheck();
            if (this$cvcCheck == null ? other$cvcCheck != null : !this$cvcCheck.equals(other$cvcCheck)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$dynamicLast4 = this.getDynamicLast4();
            String other$dynamicLast4 = other.getDynamicLast4();
            if (this$dynamicLast4 == null ? other$dynamicLast4 != null : !this$dynamicLast4.equals(other$dynamicLast4)) {
                return false;
            }
            Long this$expMonth = this.getExpMonth();
            Long other$expMonth = other.getExpMonth();
            if (this$expMonth == null ? other$expMonth != null : !((Object)this$expMonth).equals(other$expMonth)) {
                return false;
            }
            Long this$expYear = this.getExpYear();
            Long other$expYear = other.getExpYear();
            if (this$expYear == null ? other$expYear != null : !((Object)this$expYear).equals(other$expYear)) {
                return false;
            }
            String this$fingerprint = this.getFingerprint();
            String other$fingerprint = other.getFingerprint();
            if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                return false;
            }
            String this$funding = this.getFunding();
            String other$funding = other.getFunding();
            if (this$funding == null ? other$funding != null : !this$funding.equals(other$funding)) {
                return false;
            }
            String this$iin = this.getIin();
            String other$iin = other.getIin();
            if (this$iin == null ? other$iin != null : !this$iin.equals(other$iin)) {
                return false;
            }
            String this$issuer = this.getIssuer();
            String other$issuer = other.getIssuer();
            if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) {
                return false;
            }
            String this$last4 = this.getLast4();
            String other$last4 = other.getLast4();
            if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$threeDSecure = this.getThreeDSecure();
            String other$threeDSecure = other.getThreeDSecure();
            if (this$threeDSecure == null ? other$threeDSecure != null : !this$threeDSecure.equals(other$threeDSecure)) {
                return false;
            }
            String this$tokenizationMethod = this.getTokenizationMethod();
            String other$tokenizationMethod = other.getTokenizationMethod();
            return !(this$tokenizationMethod == null ? other$tokenizationMethod != null : !this$tokenizationMethod.equals(other$tokenizationMethod));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ThreeDSecure;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $addressLine1Check = this.getAddressLine1Check();
            result = result * 59 + ($addressLine1Check == null ? 43 : $addressLine1Check.hashCode());
            String $addressZipCheck = this.getAddressZipCheck();
            result = result * 59 + ($addressZipCheck == null ? 43 : $addressZipCheck.hashCode());
            Boolean $authenticated = this.getAuthenticated();
            result = result * 59 + ($authenticated == null ? 43 : ((Object)$authenticated).hashCode());
            String $brand = this.getBrand();
            result = result * 59 + ($brand == null ? 43 : $brand.hashCode());
            String $card = this.getCard();
            result = result * 59 + ($card == null ? 43 : $card.hashCode());
            String $country = this.getCountry();
            result = result * 59 + ($country == null ? 43 : $country.hashCode());
            String $customer = this.getCustomer();
            result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
            String $cvcCheck = this.getCvcCheck();
            result = result * 59 + ($cvcCheck == null ? 43 : $cvcCheck.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $dynamicLast4 = this.getDynamicLast4();
            result = result * 59 + ($dynamicLast4 == null ? 43 : $dynamicLast4.hashCode());
            Long $expMonth = this.getExpMonth();
            result = result * 59 + ($expMonth == null ? 43 : ((Object)$expMonth).hashCode());
            Long $expYear = this.getExpYear();
            result = result * 59 + ($expYear == null ? 43 : ((Object)$expYear).hashCode());
            String $fingerprint = this.getFingerprint();
            result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
            String $funding = this.getFunding();
            result = result * 59 + ($funding == null ? 43 : $funding.hashCode());
            String $iin = this.getIin();
            result = result * 59 + ($iin == null ? 43 : $iin.hashCode());
            String $issuer = this.getIssuer();
            result = result * 59 + ($issuer == null ? 43 : $issuer.hashCode());
            String $last4 = this.getLast4();
            result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $threeDSecure = this.getThreeDSecure();
            result = result * 59 + ($threeDSecure == null ? 43 : $threeDSecure.hashCode());
            String $tokenizationMethod = this.getTokenizationMethod();
            result = result * 59 + ($tokenizationMethod == null ? 43 : $tokenizationMethod.hashCode());
            return result;
        }
    }

    public static class Sofort
    extends StripeObject {
        @SerializedName(value="bank_code")
        String bankCode;
        @SerializedName(value="bank_name")
        String bankName;
        @SerializedName(value="bic")
        String bic;
        @SerializedName(value="country")
        String country;
        @SerializedName(value="iban_last4")
        String ibanLast4;
        @SerializedName(value="preferred_language")
        String preferredLanguage;
        @SerializedName(value="statement_descriptor")
        String statementDescriptor;

        @Generated
        public String getBankCode() {
            return this.bankCode;
        }

        @Generated
        public String getBankName() {
            return this.bankName;
        }

        @Generated
        public String getBic() {
            return this.bic;
        }

        @Generated
        public String getCountry() {
            return this.country;
        }

        @Generated
        public String getIbanLast4() {
            return this.ibanLast4;
        }

        @Generated
        public String getPreferredLanguage() {
            return this.preferredLanguage;
        }

        @Generated
        public String getStatementDescriptor() {
            return this.statementDescriptor;
        }

        @Generated
        public void setBankCode(String bankCode) {
            this.bankCode = bankCode;
        }

        @Generated
        public void setBankName(String bankName) {
            this.bankName = bankName;
        }

        @Generated
        public void setBic(String bic) {
            this.bic = bic;
        }

        @Generated
        public void setCountry(String country) {
            this.country = country;
        }

        @Generated
        public void setIbanLast4(String ibanLast4) {
            this.ibanLast4 = ibanLast4;
        }

        @Generated
        public void setPreferredLanguage(String preferredLanguage) {
            this.preferredLanguage = preferredLanguage;
        }

        @Generated
        public void setStatementDescriptor(String statementDescriptor) {
            this.statementDescriptor = statementDescriptor;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Sofort)) {
                return false;
            }
            Sofort other = (Sofort)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$bankCode = this.getBankCode();
            String other$bankCode = other.getBankCode();
            if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) {
                return false;
            }
            String this$bankName = this.getBankName();
            String other$bankName = other.getBankName();
            if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                return false;
            }
            String this$bic = this.getBic();
            String other$bic = other.getBic();
            if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) {
                return false;
            }
            String this$country = this.getCountry();
            String other$country = other.getCountry();
            if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                return false;
            }
            String this$ibanLast4 = this.getIbanLast4();
            String other$ibanLast4 = other.getIbanLast4();
            if (this$ibanLast4 == null ? other$ibanLast4 != null : !this$ibanLast4.equals(other$ibanLast4)) {
                return false;
            }
            String this$preferredLanguage = this.getPreferredLanguage();
            String other$preferredLanguage = other.getPreferredLanguage();
            if (this$preferredLanguage == null ? other$preferredLanguage != null : !this$preferredLanguage.equals(other$preferredLanguage)) {
                return false;
            }
            String this$statementDescriptor = this.getStatementDescriptor();
            String other$statementDescriptor = other.getStatementDescriptor();
            return !(this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Sofort;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $bankCode = this.getBankCode();
            result = result * 59 + ($bankCode == null ? 43 : $bankCode.hashCode());
            String $bankName = this.getBankName();
            result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
            String $bic = this.getBic();
            result = result * 59 + ($bic == null ? 43 : $bic.hashCode());
            String $country = this.getCountry();
            result = result * 59 + ($country == null ? 43 : $country.hashCode());
            String $ibanLast4 = this.getIbanLast4();
            result = result * 59 + ($ibanLast4 == null ? 43 : $ibanLast4.hashCode());
            String $preferredLanguage = this.getPreferredLanguage();
            result = result * 59 + ($preferredLanguage == null ? 43 : $preferredLanguage.hashCode());
            String $statementDescriptor = this.getStatementDescriptor();
            result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
            return result;
        }
    }

    public static class SepaDebit
    extends StripeObject {
        @SerializedName(value="bank_code")
        String bankCode;
        @SerializedName(value="branch_code")
        String branchCode;
        @SerializedName(value="country")
        String country;
        @SerializedName(value="fingerprint")
        String fingerprint;
        @SerializedName(value="last4")
        String last4;
        @SerializedName(value="mandate_reference")
        String mandateReference;
        @SerializedName(value="mandate_url")
        String mandateUrl;

        @Generated
        public String getBankCode() {
            return this.bankCode;
        }

        @Generated
        public String getBranchCode() {
            return this.branchCode;
        }

        @Generated
        public String getCountry() {
            return this.country;
        }

        @Generated
        public String getFingerprint() {
            return this.fingerprint;
        }

        @Generated
        public String getLast4() {
            return this.last4;
        }

        @Generated
        public String getMandateReference() {
            return this.mandateReference;
        }

        @Generated
        public String getMandateUrl() {
            return this.mandateUrl;
        }

        @Generated
        public void setBankCode(String bankCode) {
            this.bankCode = bankCode;
        }

        @Generated
        public void setBranchCode(String branchCode) {
            this.branchCode = branchCode;
        }

        @Generated
        public void setCountry(String country) {
            this.country = country;
        }

        @Generated
        public void setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
        }

        @Generated
        public void setLast4(String last4) {
            this.last4 = last4;
        }

        @Generated
        public void setMandateReference(String mandateReference) {
            this.mandateReference = mandateReference;
        }

        @Generated
        public void setMandateUrl(String mandateUrl) {
            this.mandateUrl = mandateUrl;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SepaDebit)) {
                return false;
            }
            SepaDebit other = (SepaDebit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$bankCode = this.getBankCode();
            String other$bankCode = other.getBankCode();
            if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) {
                return false;
            }
            String this$branchCode = this.getBranchCode();
            String other$branchCode = other.getBranchCode();
            if (this$branchCode == null ? other$branchCode != null : !this$branchCode.equals(other$branchCode)) {
                return false;
            }
            String this$country = this.getCountry();
            String other$country = other.getCountry();
            if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                return false;
            }
            String this$fingerprint = this.getFingerprint();
            String other$fingerprint = other.getFingerprint();
            if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                return false;
            }
            String this$last4 = this.getLast4();
            String other$last4 = other.getLast4();
            if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                return false;
            }
            String this$mandateReference = this.getMandateReference();
            String other$mandateReference = other.getMandateReference();
            if (this$mandateReference == null ? other$mandateReference != null : !this$mandateReference.equals(other$mandateReference)) {
                return false;
            }
            String this$mandateUrl = this.getMandateUrl();
            String other$mandateUrl = other.getMandateUrl();
            return !(this$mandateUrl == null ? other$mandateUrl != null : !this$mandateUrl.equals(other$mandateUrl));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SepaDebit;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $bankCode = this.getBankCode();
            result = result * 59 + ($bankCode == null ? 43 : $bankCode.hashCode());
            String $branchCode = this.getBranchCode();
            result = result * 59 + ($branchCode == null ? 43 : $branchCode.hashCode());
            String $country = this.getCountry();
            result = result * 59 + ($country == null ? 43 : $country.hashCode());
            String $fingerprint = this.getFingerprint();
            result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
            String $last4 = this.getLast4();
            result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
            String $mandateReference = this.getMandateReference();
            result = result * 59 + ($mandateReference == null ? 43 : $mandateReference.hashCode());
            String $mandateUrl = this.getMandateUrl();
            result = result * 59 + ($mandateUrl == null ? 43 : $mandateUrl.hashCode());
            return result;
        }
    }

    public static class SepaCreditTransfer
    extends StripeObject {
        @SerializedName(value="bank_name")
        String bankName;
        @SerializedName(value="bic")
        String bic;
        @SerializedName(value="iban")
        String iban;
        @SerializedName(value="refund_account_holder_address_city")
        String refundAccountHolderAddressCity;
        @SerializedName(value="refund_account_holder_address_country")
        String refundAccountHolderAddressCountry;
        @SerializedName(value="refund_account_holder_address_line1")
        String refundAccountHolderAddressLine1;
        @SerializedName(value="refund_account_holder_address_line2")
        String refundAccountHolderAddressLine2;
        @SerializedName(value="refund_account_holder_address_postal_code")
        String refundAccountHolderAddressPostalCode;
        @SerializedName(value="refund_account_holder_address_state")
        String refundAccountHolderAddressState;
        @SerializedName(value="refund_account_holder_name")
        String refundAccountHolderName;
        @SerializedName(value="refund_iban")
        String refundIban;

        @Generated
        public String getBankName() {
            return this.bankName;
        }

        @Generated
        public String getBic() {
            return this.bic;
        }

        @Generated
        public String getIban() {
            return this.iban;
        }

        @Generated
        public String getRefundAccountHolderAddressCity() {
            return this.refundAccountHolderAddressCity;
        }

        @Generated
        public String getRefundAccountHolderAddressCountry() {
            return this.refundAccountHolderAddressCountry;
        }

        @Generated
        public String getRefundAccountHolderAddressLine1() {
            return this.refundAccountHolderAddressLine1;
        }

        @Generated
        public String getRefundAccountHolderAddressLine2() {
            return this.refundAccountHolderAddressLine2;
        }

        @Generated
        public String getRefundAccountHolderAddressPostalCode() {
            return this.refundAccountHolderAddressPostalCode;
        }

        @Generated
        public String getRefundAccountHolderAddressState() {
            return this.refundAccountHolderAddressState;
        }

        @Generated
        public String getRefundAccountHolderName() {
            return this.refundAccountHolderName;
        }

        @Generated
        public String getRefundIban() {
            return this.refundIban;
        }

        @Generated
        public void setBankName(String bankName) {
            this.bankName = bankName;
        }

        @Generated
        public void setBic(String bic) {
            this.bic = bic;
        }

        @Generated
        public void setIban(String iban) {
            this.iban = iban;
        }

        @Generated
        public void setRefundAccountHolderAddressCity(String refundAccountHolderAddressCity) {
            this.refundAccountHolderAddressCity = refundAccountHolderAddressCity;
        }

        @Generated
        public void setRefundAccountHolderAddressCountry(String refundAccountHolderAddressCountry) {
            this.refundAccountHolderAddressCountry = refundAccountHolderAddressCountry;
        }

        @Generated
        public void setRefundAccountHolderAddressLine1(String refundAccountHolderAddressLine1) {
            this.refundAccountHolderAddressLine1 = refundAccountHolderAddressLine1;
        }

        @Generated
        public void setRefundAccountHolderAddressLine2(String refundAccountHolderAddressLine2) {
            this.refundAccountHolderAddressLine2 = refundAccountHolderAddressLine2;
        }

        @Generated
        public void setRefundAccountHolderAddressPostalCode(String refundAccountHolderAddressPostalCode) {
            this.refundAccountHolderAddressPostalCode = refundAccountHolderAddressPostalCode;
        }

        @Generated
        public void setRefundAccountHolderAddressState(String refundAccountHolderAddressState) {
            this.refundAccountHolderAddressState = refundAccountHolderAddressState;
        }

        @Generated
        public void setRefundAccountHolderName(String refundAccountHolderName) {
            this.refundAccountHolderName = refundAccountHolderName;
        }

        @Generated
        public void setRefundIban(String refundIban) {
            this.refundIban = refundIban;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SepaCreditTransfer)) {
                return false;
            }
            SepaCreditTransfer other = (SepaCreditTransfer)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$bankName = this.getBankName();
            String other$bankName = other.getBankName();
            if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                return false;
            }
            String this$bic = this.getBic();
            String other$bic = other.getBic();
            if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) {
                return false;
            }
            String this$iban = this.getIban();
            String other$iban = other.getIban();
            if (this$iban == null ? other$iban != null : !this$iban.equals(other$iban)) {
                return false;
            }
            String this$refundAccountHolderAddressCity = this.getRefundAccountHolderAddressCity();
            String other$refundAccountHolderAddressCity = other.getRefundAccountHolderAddressCity();
            if (this$refundAccountHolderAddressCity == null ? other$refundAccountHolderAddressCity != null : !this$refundAccountHolderAddressCity.equals(other$refundAccountHolderAddressCity)) {
                return false;
            }
            String this$refundAccountHolderAddressCountry = this.getRefundAccountHolderAddressCountry();
            String other$refundAccountHolderAddressCountry = other.getRefundAccountHolderAddressCountry();
            if (this$refundAccountHolderAddressCountry == null ? other$refundAccountHolderAddressCountry != null : !this$refundAccountHolderAddressCountry.equals(other$refundAccountHolderAddressCountry)) {
                return false;
            }
            String this$refundAccountHolderAddressLine1 = this.getRefundAccountHolderAddressLine1();
            String other$refundAccountHolderAddressLine1 = other.getRefundAccountHolderAddressLine1();
            if (this$refundAccountHolderAddressLine1 == null ? other$refundAccountHolderAddressLine1 != null : !this$refundAccountHolderAddressLine1.equals(other$refundAccountHolderAddressLine1)) {
                return false;
            }
            String this$refundAccountHolderAddressLine2 = this.getRefundAccountHolderAddressLine2();
            String other$refundAccountHolderAddressLine2 = other.getRefundAccountHolderAddressLine2();
            if (this$refundAccountHolderAddressLine2 == null ? other$refundAccountHolderAddressLine2 != null : !this$refundAccountHolderAddressLine2.equals(other$refundAccountHolderAddressLine2)) {
                return false;
            }
            String this$refundAccountHolderAddressPostalCode = this.getRefundAccountHolderAddressPostalCode();
            String other$refundAccountHolderAddressPostalCode = other.getRefundAccountHolderAddressPostalCode();
            if (this$refundAccountHolderAddressPostalCode == null ? other$refundAccountHolderAddressPostalCode != null : !this$refundAccountHolderAddressPostalCode.equals(other$refundAccountHolderAddressPostalCode)) {
                return false;
            }
            String this$refundAccountHolderAddressState = this.getRefundAccountHolderAddressState();
            String other$refundAccountHolderAddressState = other.getRefundAccountHolderAddressState();
            if (this$refundAccountHolderAddressState == null ? other$refundAccountHolderAddressState != null : !this$refundAccountHolderAddressState.equals(other$refundAccountHolderAddressState)) {
                return false;
            }
            String this$refundAccountHolderName = this.getRefundAccountHolderName();
            String other$refundAccountHolderName = other.getRefundAccountHolderName();
            if (this$refundAccountHolderName == null ? other$refundAccountHolderName != null : !this$refundAccountHolderName.equals(other$refundAccountHolderName)) {
                return false;
            }
            String this$refundIban = this.getRefundIban();
            String other$refundIban = other.getRefundIban();
            return !(this$refundIban == null ? other$refundIban != null : !this$refundIban.equals(other$refundIban));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SepaCreditTransfer;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $bankName = this.getBankName();
            result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
            String $bic = this.getBic();
            result = result * 59 + ($bic == null ? 43 : $bic.hashCode());
            String $iban = this.getIban();
            result = result * 59 + ($iban == null ? 43 : $iban.hashCode());
            String $refundAccountHolderAddressCity = this.getRefundAccountHolderAddressCity();
            result = result * 59 + ($refundAccountHolderAddressCity == null ? 43 : $refundAccountHolderAddressCity.hashCode());
            String $refundAccountHolderAddressCountry = this.getRefundAccountHolderAddressCountry();
            result = result * 59 + ($refundAccountHolderAddressCountry == null ? 43 : $refundAccountHolderAddressCountry.hashCode());
            String $refundAccountHolderAddressLine1 = this.getRefundAccountHolderAddressLine1();
            result = result * 59 + ($refundAccountHolderAddressLine1 == null ? 43 : $refundAccountHolderAddressLine1.hashCode());
            String $refundAccountHolderAddressLine2 = this.getRefundAccountHolderAddressLine2();
            result = result * 59 + ($refundAccountHolderAddressLine2 == null ? 43 : $refundAccountHolderAddressLine2.hashCode());
            String $refundAccountHolderAddressPostalCode = this.getRefundAccountHolderAddressPostalCode();
            result = result * 59 + ($refundAccountHolderAddressPostalCode == null ? 43 : $refundAccountHolderAddressPostalCode.hashCode());
            String $refundAccountHolderAddressState = this.getRefundAccountHolderAddressState();
            result = result * 59 + ($refundAccountHolderAddressState == null ? 43 : $refundAccountHolderAddressState.hashCode());
            String $refundAccountHolderName = this.getRefundAccountHolderName();
            result = result * 59 + ($refundAccountHolderName == null ? 43 : $refundAccountHolderName.hashCode());
            String $refundIban = this.getRefundIban();
            result = result * 59 + ($refundIban == null ? 43 : $refundIban.hashCode());
            return result;
        }
    }

    public static class RedirectFlow
    extends StripeObject {
        @SerializedName(value="failure_reason")
        String failureReason;
        @SerializedName(value="return_url")
        String returnUrl;
        @SerializedName(value="status")
        String status;
        @SerializedName(value="url")
        String url;

        @Generated
        public String getFailureReason() {
            return this.failureReason;
        }

        @Generated
        public String getReturnUrl() {
            return this.returnUrl;
        }

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Generated
        public void setReturnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RedirectFlow)) {
                return false;
            }
            RedirectFlow other = (RedirectFlow)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$failureReason = this.getFailureReason();
            String other$failureReason = other.getFailureReason();
            if (this$failureReason == null ? other$failureReason != null : !this$failureReason.equals(other$failureReason)) {
                return false;
            }
            String this$returnUrl = this.getReturnUrl();
            String other$returnUrl = other.getReturnUrl();
            if (this$returnUrl == null ? other$returnUrl != null : !this$returnUrl.equals(other$returnUrl)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RedirectFlow;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $failureReason = this.getFailureReason();
            result = result * 59 + ($failureReason == null ? 43 : $failureReason.hashCode());
            String $returnUrl = this.getReturnUrl();
            result = result * 59 + ($returnUrl == null ? 43 : $returnUrl.hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }
    }

    public static class ReceiverFlow
    extends StripeObject {
        @SerializedName(value="address")
        String address;
        @SerializedName(value="amount_charged")
        Long amountCharged;
        @SerializedName(value="amount_received")
        Long amountReceived;
        @SerializedName(value="amount_returned")
        Long amountReturned;
        @SerializedName(value="refund_attributes_method")
        String refundAttributesMethod;
        @SerializedName(value="refund_attributes_status")
        String refundAttributesStatus;

        @Generated
        public String getAddress() {
            return this.address;
        }

        @Generated
        public Long getAmountCharged() {
            return this.amountCharged;
        }

        @Generated
        public Long getAmountReceived() {
            return this.amountReceived;
        }

        @Generated
        public Long getAmountReturned() {
            return this.amountReturned;
        }

        @Generated
        public String getRefundAttributesMethod() {
            return this.refundAttributesMethod;
        }

        @Generated
        public String getRefundAttributesStatus() {
            return this.refundAttributesStatus;
        }

        @Generated
        public void setAddress(String address) {
            this.address = address;
        }

        @Generated
        public void setAmountCharged(Long amountCharged) {
            this.amountCharged = amountCharged;
        }

        @Generated
        public void setAmountReceived(Long amountReceived) {
            this.amountReceived = amountReceived;
        }

        @Generated
        public void setAmountReturned(Long amountReturned) {
            this.amountReturned = amountReturned;
        }

        @Generated
        public void setRefundAttributesMethod(String refundAttributesMethod) {
            this.refundAttributesMethod = refundAttributesMethod;
        }

        @Generated
        public void setRefundAttributesStatus(String refundAttributesStatus) {
            this.refundAttributesStatus = refundAttributesStatus;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReceiverFlow)) {
                return false;
            }
            ReceiverFlow other = (ReceiverFlow)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$address = this.getAddress();
            String other$address = other.getAddress();
            if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
                return false;
            }
            Long this$amountCharged = this.getAmountCharged();
            Long other$amountCharged = other.getAmountCharged();
            if (this$amountCharged == null ? other$amountCharged != null : !((Object)this$amountCharged).equals(other$amountCharged)) {
                return false;
            }
            Long this$amountReceived = this.getAmountReceived();
            Long other$amountReceived = other.getAmountReceived();
            if (this$amountReceived == null ? other$amountReceived != null : !((Object)this$amountReceived).equals(other$amountReceived)) {
                return false;
            }
            Long this$amountReturned = this.getAmountReturned();
            Long other$amountReturned = other.getAmountReturned();
            if (this$amountReturned == null ? other$amountReturned != null : !((Object)this$amountReturned).equals(other$amountReturned)) {
                return false;
            }
            String this$refundAttributesMethod = this.getRefundAttributesMethod();
            String other$refundAttributesMethod = other.getRefundAttributesMethod();
            if (this$refundAttributesMethod == null ? other$refundAttributesMethod != null : !this$refundAttributesMethod.equals(other$refundAttributesMethod)) {
                return false;
            }
            String this$refundAttributesStatus = this.getRefundAttributesStatus();
            String other$refundAttributesStatus = other.getRefundAttributesStatus();
            return !(this$refundAttributesStatus == null ? other$refundAttributesStatus != null : !this$refundAttributesStatus.equals(other$refundAttributesStatus));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ReceiverFlow;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            Long $amountCharged = this.getAmountCharged();
            result = result * 59 + ($amountCharged == null ? 43 : ((Object)$amountCharged).hashCode());
            Long $amountReceived = this.getAmountReceived();
            result = result * 59 + ($amountReceived == null ? 43 : ((Object)$amountReceived).hashCode());
            Long $amountReturned = this.getAmountReturned();
            result = result * 59 + ($amountReturned == null ? 43 : ((Object)$amountReturned).hashCode());
            String $refundAttributesMethod = this.getRefundAttributesMethod();
            result = result * 59 + ($refundAttributesMethod == null ? 43 : $refundAttributesMethod.hashCode());
            String $refundAttributesStatus = this.getRefundAttributesStatus();
            result = result * 59 + ($refundAttributesStatus == null ? 43 : $refundAttributesStatus.hashCode());
            return result;
        }
    }

    public static class P24
    extends StripeObject {
        @SerializedName(value="reference")
        String reference;

        @Generated
        public String getReference() {
            return this.reference;
        }

        @Generated
        public void setReference(String reference) {
            this.reference = reference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof P24)) {
                return false;
            }
            P24 other = (P24)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$reference = this.getReference();
            String other$reference = other.getReference();
            return !(this$reference == null ? other$reference != null : !this$reference.equals(other$reference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof P24;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $reference = this.getReference();
            result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
            return result;
        }
    }

    public static class Owner
    extends StripeObject {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="email")
        String email;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="phone")
        String phone;
        @SerializedName(value="verified_address")
        Address verifiedAddress;
        @SerializedName(value="verified_email")
        String verifiedEmail;
        @SerializedName(value="verified_name")
        String verifiedName;
        @SerializedName(value="verified_phone")
        String verifiedPhone;

        @Generated
        public Address getAddress() {
            return this.address;
        }

        @Generated
        public String getEmail() {
            return this.email;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getPhone() {
            return this.phone;
        }

        @Generated
        public Address getVerifiedAddress() {
            return this.verifiedAddress;
        }

        @Generated
        public String getVerifiedEmail() {
            return this.verifiedEmail;
        }

        @Generated
        public String getVerifiedName() {
            return this.verifiedName;
        }

        @Generated
        public String getVerifiedPhone() {
            return this.verifiedPhone;
        }

        @Generated
        public void setAddress(Address address) {
            this.address = address;
        }

        @Generated
        public void setEmail(String email) {
            this.email = email;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setPhone(String phone) {
            this.phone = phone;
        }

        @Generated
        public void setVerifiedAddress(Address verifiedAddress) {
            this.verifiedAddress = verifiedAddress;
        }

        @Generated
        public void setVerifiedEmail(String verifiedEmail) {
            this.verifiedEmail = verifiedEmail;
        }

        @Generated
        public void setVerifiedName(String verifiedName) {
            this.verifiedName = verifiedName;
        }

        @Generated
        public void setVerifiedPhone(String verifiedPhone) {
            this.verifiedPhone = verifiedPhone;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Owner)) {
                return false;
            }
            Owner other = (Owner)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Address this$address = this.getAddress();
            Address other$address = other.getAddress();
            if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                return false;
            }
            String this$email = this.getEmail();
            String other$email = other.getEmail();
            if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$phone = this.getPhone();
            String other$phone = other.getPhone();
            if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) {
                return false;
            }
            Address this$verifiedAddress = this.getVerifiedAddress();
            Address other$verifiedAddress = other.getVerifiedAddress();
            if (this$verifiedAddress == null ? other$verifiedAddress != null : !((Object)this$verifiedAddress).equals(other$verifiedAddress)) {
                return false;
            }
            String this$verifiedEmail = this.getVerifiedEmail();
            String other$verifiedEmail = other.getVerifiedEmail();
            if (this$verifiedEmail == null ? other$verifiedEmail != null : !this$verifiedEmail.equals(other$verifiedEmail)) {
                return false;
            }
            String this$verifiedName = this.getVerifiedName();
            String other$verifiedName = other.getVerifiedName();
            if (this$verifiedName == null ? other$verifiedName != null : !this$verifiedName.equals(other$verifiedName)) {
                return false;
            }
            String this$verifiedPhone = this.getVerifiedPhone();
            String other$verifiedPhone = other.getVerifiedPhone();
            return !(this$verifiedPhone == null ? other$verifiedPhone != null : !this$verifiedPhone.equals(other$verifiedPhone));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Owner;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Address $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
            String $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $phone = this.getPhone();
            result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
            Address $verifiedAddress = this.getVerifiedAddress();
            result = result * 59 + ($verifiedAddress == null ? 43 : ((Object)$verifiedAddress).hashCode());
            String $verifiedEmail = this.getVerifiedEmail();
            result = result * 59 + ($verifiedEmail == null ? 43 : $verifiedEmail.hashCode());
            String $verifiedName = this.getVerifiedName();
            result = result * 59 + ($verifiedName == null ? 43 : $verifiedName.hashCode());
            String $verifiedPhone = this.getVerifiedPhone();
            result = result * 59 + ($verifiedPhone == null ? 43 : $verifiedPhone.hashCode());
            return result;
        }
    }

    public static class OrderItem
    extends StripeObject {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="currency")
        String currency;
        @SerializedName(value="description")
        String description;
        @SerializedName(value="quantity")
        Long quantity;
        @SerializedName(value="type")
        String type;

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public String getCurrency() {
            return this.currency;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public Long getQuantity() {
            return this.quantity;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public void setQuantity(Long quantity) {
            this.quantity = quantity;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OrderItem)) {
                return false;
            }
            OrderItem other = (OrderItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            String this$currency = this.getCurrency();
            String other$currency = other.getCurrency();
            if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            Long this$quantity = this.getQuantity();
            Long other$quantity = other.getQuantity();
            if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OrderItem;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            String $currency = this.getCurrency();
            result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            Long $quantity = this.getQuantity();
            result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }
    }

    public static class Order
    extends StripeObject {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="currency")
        String currency;
        @SerializedName(value="email")
        String email;
        @SerializedName(value="items")
        List<OrderItem> items;
        @SerializedName(value="shipping")
        ShippingDetails shipping;

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public String getCurrency() {
            return this.currency;
        }

        @Generated
        public String getEmail() {
            return this.email;
        }

        @Generated
        public List<OrderItem> getItems() {
            return this.items;
        }

        @Generated
        public ShippingDetails getShipping() {
            return this.shipping;
        }

        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        @Generated
        public void setEmail(String email) {
            this.email = email;
        }

        @Generated
        public void setItems(List<OrderItem> items) {
            this.items = items;
        }

        @Generated
        public void setShipping(ShippingDetails shipping) {
            this.shipping = shipping;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Order)) {
                return false;
            }
            Order other = (Order)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            String this$currency = this.getCurrency();
            String other$currency = other.getCurrency();
            if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                return false;
            }
            String this$email = this.getEmail();
            String other$email = other.getEmail();
            if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                return false;
            }
            List<OrderItem> this$items = this.getItems();
            List<OrderItem> other$items = other.getItems();
            if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
                return false;
            }
            ShippingDetails this$shipping = this.getShipping();
            ShippingDetails other$shipping = other.getShipping();
            return !(this$shipping == null ? other$shipping != null : !((Object)this$shipping).equals(other$shipping));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Order;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            String $currency = this.getCurrency();
            result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
            String $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            List<OrderItem> $items = this.getItems();
            result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
            ShippingDetails $shipping = this.getShipping();
            result = result * 59 + ($shipping == null ? 43 : ((Object)$shipping).hashCode());
            return result;
        }
    }

    public static class Multibanco
    extends StripeObject {
        @SerializedName(value="entity")
        String entity;
        @SerializedName(value="reference")
        String reference;
        @SerializedName(value="refund_account_holder_address_city")
        String refundAccountHolderAddressCity;
        @SerializedName(value="refund_account_holder_address_country")
        String refundAccountHolderAddressCountry;
        @SerializedName(value="refund_account_holder_address_line1")
        String refundAccountHolderAddressLine1;
        @SerializedName(value="refund_account_holder_address_line2")
        String refundAccountHolderAddressLine2;
        @SerializedName(value="refund_account_holder_address_postal_code")
        String refundAccountHolderAddressPostalCode;
        @SerializedName(value="refund_account_holder_address_state")
        String refundAccountHolderAddressState;
        @SerializedName(value="refund_account_holder_name")
        String refundAccountHolderName;
        @SerializedName(value="refund_iban")
        String refundIban;

        @Generated
        public String getEntity() {
            return this.entity;
        }

        @Generated
        public String getReference() {
            return this.reference;
        }

        @Generated
        public String getRefundAccountHolderAddressCity() {
            return this.refundAccountHolderAddressCity;
        }

        @Generated
        public String getRefundAccountHolderAddressCountry() {
            return this.refundAccountHolderAddressCountry;
        }

        @Generated
        public String getRefundAccountHolderAddressLine1() {
            return this.refundAccountHolderAddressLine1;
        }

        @Generated
        public String getRefundAccountHolderAddressLine2() {
            return this.refundAccountHolderAddressLine2;
        }

        @Generated
        public String getRefundAccountHolderAddressPostalCode() {
            return this.refundAccountHolderAddressPostalCode;
        }

        @Generated
        public String getRefundAccountHolderAddressState() {
            return this.refundAccountHolderAddressState;
        }

        @Generated
        public String getRefundAccountHolderName() {
            return this.refundAccountHolderName;
        }

        @Generated
        public String getRefundIban() {
            return this.refundIban;
        }

        @Generated
        public void setEntity(String entity) {
            this.entity = entity;
        }

        @Generated
        public void setReference(String reference) {
            this.reference = reference;
        }

        @Generated
        public void setRefundAccountHolderAddressCity(String refundAccountHolderAddressCity) {
            this.refundAccountHolderAddressCity = refundAccountHolderAddressCity;
        }

        @Generated
        public void setRefundAccountHolderAddressCountry(String refundAccountHolderAddressCountry) {
            this.refundAccountHolderAddressCountry = refundAccountHolderAddressCountry;
        }

        @Generated
        public void setRefundAccountHolderAddressLine1(String refundAccountHolderAddressLine1) {
            this.refundAccountHolderAddressLine1 = refundAccountHolderAddressLine1;
        }

        @Generated
        public void setRefundAccountHolderAddressLine2(String refundAccountHolderAddressLine2) {
            this.refundAccountHolderAddressLine2 = refundAccountHolderAddressLine2;
        }

        @Generated
        public void setRefundAccountHolderAddressPostalCode(String refundAccountHolderAddressPostalCode) {
            this.refundAccountHolderAddressPostalCode = refundAccountHolderAddressPostalCode;
        }

        @Generated
        public void setRefundAccountHolderAddressState(String refundAccountHolderAddressState) {
            this.refundAccountHolderAddressState = refundAccountHolderAddressState;
        }

        @Generated
        public void setRefundAccountHolderName(String refundAccountHolderName) {
            this.refundAccountHolderName = refundAccountHolderName;
        }

        @Generated
        public void setRefundIban(String refundIban) {
            this.refundIban = refundIban;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Multibanco)) {
                return false;
            }
            Multibanco other = (Multibanco)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$entity = this.getEntity();
            String other$entity = other.getEntity();
            if (this$entity == null ? other$entity != null : !this$entity.equals(other$entity)) {
                return false;
            }
            String this$reference = this.getReference();
            String other$reference = other.getReference();
            if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                return false;
            }
            String this$refundAccountHolderAddressCity = this.getRefundAccountHolderAddressCity();
            String other$refundAccountHolderAddressCity = other.getRefundAccountHolderAddressCity();
            if (this$refundAccountHolderAddressCity == null ? other$refundAccountHolderAddressCity != null : !this$refundAccountHolderAddressCity.equals(other$refundAccountHolderAddressCity)) {
                return false;
            }
            String this$refundAccountHolderAddressCountry = this.getRefundAccountHolderAddressCountry();
            String other$refundAccountHolderAddressCountry = other.getRefundAccountHolderAddressCountry();
            if (this$refundAccountHolderAddressCountry == null ? other$refundAccountHolderAddressCountry != null : !this$refundAccountHolderAddressCountry.equals(other$refundAccountHolderAddressCountry)) {
                return false;
            }
            String this$refundAccountHolderAddressLine1 = this.getRefundAccountHolderAddressLine1();
            String other$refundAccountHolderAddressLine1 = other.getRefundAccountHolderAddressLine1();
            if (this$refundAccountHolderAddressLine1 == null ? other$refundAccountHolderAddressLine1 != null : !this$refundAccountHolderAddressLine1.equals(other$refundAccountHolderAddressLine1)) {
                return false;
            }
            String this$refundAccountHolderAddressLine2 = this.getRefundAccountHolderAddressLine2();
            String other$refundAccountHolderAddressLine2 = other.getRefundAccountHolderAddressLine2();
            if (this$refundAccountHolderAddressLine2 == null ? other$refundAccountHolderAddressLine2 != null : !this$refundAccountHolderAddressLine2.equals(other$refundAccountHolderAddressLine2)) {
                return false;
            }
            String this$refundAccountHolderAddressPostalCode = this.getRefundAccountHolderAddressPostalCode();
            String other$refundAccountHolderAddressPostalCode = other.getRefundAccountHolderAddressPostalCode();
            if (this$refundAccountHolderAddressPostalCode == null ? other$refundAccountHolderAddressPostalCode != null : !this$refundAccountHolderAddressPostalCode.equals(other$refundAccountHolderAddressPostalCode)) {
                return false;
            }
            String this$refundAccountHolderAddressState = this.getRefundAccountHolderAddressState();
            String other$refundAccountHolderAddressState = other.getRefundAccountHolderAddressState();
            if (this$refundAccountHolderAddressState == null ? other$refundAccountHolderAddressState != null : !this$refundAccountHolderAddressState.equals(other$refundAccountHolderAddressState)) {
                return false;
            }
            String this$refundAccountHolderName = this.getRefundAccountHolderName();
            String other$refundAccountHolderName = other.getRefundAccountHolderName();
            if (this$refundAccountHolderName == null ? other$refundAccountHolderName != null : !this$refundAccountHolderName.equals(other$refundAccountHolderName)) {
                return false;
            }
            String this$refundIban = this.getRefundIban();
            String other$refundIban = other.getRefundIban();
            return !(this$refundIban == null ? other$refundIban != null : !this$refundIban.equals(other$refundIban));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Multibanco;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $entity = this.getEntity();
            result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
            String $reference = this.getReference();
            result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
            String $refundAccountHolderAddressCity = this.getRefundAccountHolderAddressCity();
            result = result * 59 + ($refundAccountHolderAddressCity == null ? 43 : $refundAccountHolderAddressCity.hashCode());
            String $refundAccountHolderAddressCountry = this.getRefundAccountHolderAddressCountry();
            result = result * 59 + ($refundAccountHolderAddressCountry == null ? 43 : $refundAccountHolderAddressCountry.hashCode());
            String $refundAccountHolderAddressLine1 = this.getRefundAccountHolderAddressLine1();
            result = result * 59 + ($refundAccountHolderAddressLine1 == null ? 43 : $refundAccountHolderAddressLine1.hashCode());
            String $refundAccountHolderAddressLine2 = this.getRefundAccountHolderAddressLine2();
            result = result * 59 + ($refundAccountHolderAddressLine2 == null ? 43 : $refundAccountHolderAddressLine2.hashCode());
            String $refundAccountHolderAddressPostalCode = this.getRefundAccountHolderAddressPostalCode();
            result = result * 59 + ($refundAccountHolderAddressPostalCode == null ? 43 : $refundAccountHolderAddressPostalCode.hashCode());
            String $refundAccountHolderAddressState = this.getRefundAccountHolderAddressState();
            result = result * 59 + ($refundAccountHolderAddressState == null ? 43 : $refundAccountHolderAddressState.hashCode());
            String $refundAccountHolderName = this.getRefundAccountHolderName();
            result = result * 59 + ($refundAccountHolderName == null ? 43 : $refundAccountHolderName.hashCode());
            String $refundIban = this.getRefundIban();
            result = result * 59 + ($refundIban == null ? 43 : $refundIban.hashCode());
            return result;
        }
    }

    public static class Klarna
    extends StripeObject {
        @SerializedName(value="background_image_url")
        String backgroundImageUrl;
        @SerializedName(value="client_token")
        String clientToken;
        @SerializedName(value="first_name")
        String firstName;
        @SerializedName(value="last_name")
        String lastName;
        @SerializedName(value="locale")
        String locale;
        @SerializedName(value="logo_url")
        String logoUrl;
        @SerializedName(value="page_title")
        String pageTitle;
        @SerializedName(value="pay_later_asset_urls_descriptive")
        String payLaterAssetUrlsDescriptive;
        @SerializedName(value="pay_later_asset_urls_standard")
        String payLaterAssetUrlsStandard;
        @SerializedName(value="pay_later_name")
        String payLaterName;
        @SerializedName(value="pay_later_redirect_url")
        String payLaterRedirectUrl;
        @SerializedName(value="pay_now_asset_urls_descriptive")
        String payNowAssetUrlsDescriptive;
        @SerializedName(value="pay_now_asset_urls_standard")
        String payNowAssetUrlsStandard;
        @SerializedName(value="pay_now_name")
        String payNowName;
        @SerializedName(value="pay_now_redirect_url")
        String payNowRedirectUrl;
        @SerializedName(value="pay_over_time_asset_urls_descriptive")
        String payOverTimeAssetUrlsDescriptive;
        @SerializedName(value="pay_over_time_asset_urls_standard")
        String payOverTimeAssetUrlsStandard;
        @SerializedName(value="pay_over_time_name")
        String payOverTimeName;
        @SerializedName(value="pay_over_time_redirect_url")
        String payOverTimeRedirectUrl;
        @SerializedName(value="payment_method_categories")
        String paymentMethodCategories;
        @SerializedName(value="purchase_country")
        String purchaseCountry;
        @SerializedName(value="purchase_type")
        String purchaseType;
        @SerializedName(value="redirect_url")
        String redirectUrl;
        @SerializedName(value="shipping_first_name")
        String shippingFirstName;
        @SerializedName(value="shipping_last_name")
        String shippingLastName;

        @Generated
        public String getBackgroundImageUrl() {
            return this.backgroundImageUrl;
        }

        @Generated
        public String getClientToken() {
            return this.clientToken;
        }

        @Generated
        public String getFirstName() {
            return this.firstName;
        }

        @Generated
        public String getLastName() {
            return this.lastName;
        }

        @Generated
        public String getLocale() {
            return this.locale;
        }

        @Generated
        public String getLogoUrl() {
            return this.logoUrl;
        }

        @Generated
        public String getPageTitle() {
            return this.pageTitle;
        }

        @Generated
        public String getPayLaterAssetUrlsDescriptive() {
            return this.payLaterAssetUrlsDescriptive;
        }

        @Generated
        public String getPayLaterAssetUrlsStandard() {
            return this.payLaterAssetUrlsStandard;
        }

        @Generated
        public String getPayLaterName() {
            return this.payLaterName;
        }

        @Generated
        public String getPayLaterRedirectUrl() {
            return this.payLaterRedirectUrl;
        }

        @Generated
        public String getPayNowAssetUrlsDescriptive() {
            return this.payNowAssetUrlsDescriptive;
        }

        @Generated
        public String getPayNowAssetUrlsStandard() {
            return this.payNowAssetUrlsStandard;
        }

        @Generated
        public String getPayNowName() {
            return this.payNowName;
        }

        @Generated
        public String getPayNowRedirectUrl() {
            return this.payNowRedirectUrl;
        }

        @Generated
        public String getPayOverTimeAssetUrlsDescriptive() {
            return this.payOverTimeAssetUrlsDescriptive;
        }

        @Generated
        public String getPayOverTimeAssetUrlsStandard() {
            return this.payOverTimeAssetUrlsStandard;
        }

        @Generated
        public String getPayOverTimeName() {
            return this.payOverTimeName;
        }

        @Generated
        public String getPayOverTimeRedirectUrl() {
            return this.payOverTimeRedirectUrl;
        }

        @Generated
        public String getPaymentMethodCategories() {
            return this.paymentMethodCategories;
        }

        @Generated
        public String getPurchaseCountry() {
            return this.purchaseCountry;
        }

        @Generated
        public String getPurchaseType() {
            return this.purchaseType;
        }

        @Generated
        public String getRedirectUrl() {
            return this.redirectUrl;
        }

        @Generated
        public String getShippingFirstName() {
            return this.shippingFirstName;
        }

        @Generated
        public String getShippingLastName() {
            return this.shippingLastName;
        }

        @Generated
        public void setBackgroundImageUrl(String backgroundImageUrl) {
            this.backgroundImageUrl = backgroundImageUrl;
        }

        @Generated
        public void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Generated
        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Generated
        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Generated
        public void setLocale(String locale) {
            this.locale = locale;
        }

        @Generated
        public void setLogoUrl(String logoUrl) {
            this.logoUrl = logoUrl;
        }

        @Generated
        public void setPageTitle(String pageTitle) {
            this.pageTitle = pageTitle;
        }

        @Generated
        public void setPayLaterAssetUrlsDescriptive(String payLaterAssetUrlsDescriptive) {
            this.payLaterAssetUrlsDescriptive = payLaterAssetUrlsDescriptive;
        }

        @Generated
        public void setPayLaterAssetUrlsStandard(String payLaterAssetUrlsStandard) {
            this.payLaterAssetUrlsStandard = payLaterAssetUrlsStandard;
        }

        @Generated
        public void setPayLaterName(String payLaterName) {
            this.payLaterName = payLaterName;
        }

        @Generated
        public void setPayLaterRedirectUrl(String payLaterRedirectUrl) {
            this.payLaterRedirectUrl = payLaterRedirectUrl;
        }

        @Generated
        public void setPayNowAssetUrlsDescriptive(String payNowAssetUrlsDescriptive) {
            this.payNowAssetUrlsDescriptive = payNowAssetUrlsDescriptive;
        }

        @Generated
        public void setPayNowAssetUrlsStandard(String payNowAssetUrlsStandard) {
            this.payNowAssetUrlsStandard = payNowAssetUrlsStandard;
        }

        @Generated
        public void setPayNowName(String payNowName) {
            this.payNowName = payNowName;
        }

        @Generated
        public void setPayNowRedirectUrl(String payNowRedirectUrl) {
            this.payNowRedirectUrl = payNowRedirectUrl;
        }

        @Generated
        public void setPayOverTimeAssetUrlsDescriptive(String payOverTimeAssetUrlsDescriptive) {
            this.payOverTimeAssetUrlsDescriptive = payOverTimeAssetUrlsDescriptive;
        }

        @Generated
        public void setPayOverTimeAssetUrlsStandard(String payOverTimeAssetUrlsStandard) {
            this.payOverTimeAssetUrlsStandard = payOverTimeAssetUrlsStandard;
        }

        @Generated
        public void setPayOverTimeName(String payOverTimeName) {
            this.payOverTimeName = payOverTimeName;
        }

        @Generated
        public void setPayOverTimeRedirectUrl(String payOverTimeRedirectUrl) {
            this.payOverTimeRedirectUrl = payOverTimeRedirectUrl;
        }

        @Generated
        public void setPaymentMethodCategories(String paymentMethodCategories) {
            this.paymentMethodCategories = paymentMethodCategories;
        }

        @Generated
        public void setPurchaseCountry(String purchaseCountry) {
            this.purchaseCountry = purchaseCountry;
        }

        @Generated
        public void setPurchaseType(String purchaseType) {
            this.purchaseType = purchaseType;
        }

        @Generated
        public void setRedirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
        }

        @Generated
        public void setShippingFirstName(String shippingFirstName) {
            this.shippingFirstName = shippingFirstName;
        }

        @Generated
        public void setShippingLastName(String shippingLastName) {
            this.shippingLastName = shippingLastName;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Klarna)) {
                return false;
            }
            Klarna other = (Klarna)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$backgroundImageUrl = this.getBackgroundImageUrl();
            String other$backgroundImageUrl = other.getBackgroundImageUrl();
            if (this$backgroundImageUrl == null ? other$backgroundImageUrl != null : !this$backgroundImageUrl.equals(other$backgroundImageUrl)) {
                return false;
            }
            String this$clientToken = this.getClientToken();
            String other$clientToken = other.getClientToken();
            if (this$clientToken == null ? other$clientToken != null : !this$clientToken.equals(other$clientToken)) {
                return false;
            }
            String this$firstName = this.getFirstName();
            String other$firstName = other.getFirstName();
            if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
                return false;
            }
            String this$lastName = this.getLastName();
            String other$lastName = other.getLastName();
            if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
                return false;
            }
            String this$locale = this.getLocale();
            String other$locale = other.getLocale();
            if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
                return false;
            }
            String this$logoUrl = this.getLogoUrl();
            String other$logoUrl = other.getLogoUrl();
            if (this$logoUrl == null ? other$logoUrl != null : !this$logoUrl.equals(other$logoUrl)) {
                return false;
            }
            String this$pageTitle = this.getPageTitle();
            String other$pageTitle = other.getPageTitle();
            if (this$pageTitle == null ? other$pageTitle != null : !this$pageTitle.equals(other$pageTitle)) {
                return false;
            }
            String this$payLaterAssetUrlsDescriptive = this.getPayLaterAssetUrlsDescriptive();
            String other$payLaterAssetUrlsDescriptive = other.getPayLaterAssetUrlsDescriptive();
            if (this$payLaterAssetUrlsDescriptive == null ? other$payLaterAssetUrlsDescriptive != null : !this$payLaterAssetUrlsDescriptive.equals(other$payLaterAssetUrlsDescriptive)) {
                return false;
            }
            String this$payLaterAssetUrlsStandard = this.getPayLaterAssetUrlsStandard();
            String other$payLaterAssetUrlsStandard = other.getPayLaterAssetUrlsStandard();
            if (this$payLaterAssetUrlsStandard == null ? other$payLaterAssetUrlsStandard != null : !this$payLaterAssetUrlsStandard.equals(other$payLaterAssetUrlsStandard)) {
                return false;
            }
            String this$payLaterName = this.getPayLaterName();
            String other$payLaterName = other.getPayLaterName();
            if (this$payLaterName == null ? other$payLaterName != null : !this$payLaterName.equals(other$payLaterName)) {
                return false;
            }
            String this$payLaterRedirectUrl = this.getPayLaterRedirectUrl();
            String other$payLaterRedirectUrl = other.getPayLaterRedirectUrl();
            if (this$payLaterRedirectUrl == null ? other$payLaterRedirectUrl != null : !this$payLaterRedirectUrl.equals(other$payLaterRedirectUrl)) {
                return false;
            }
            String this$payNowAssetUrlsDescriptive = this.getPayNowAssetUrlsDescriptive();
            String other$payNowAssetUrlsDescriptive = other.getPayNowAssetUrlsDescriptive();
            if (this$payNowAssetUrlsDescriptive == null ? other$payNowAssetUrlsDescriptive != null : !this$payNowAssetUrlsDescriptive.equals(other$payNowAssetUrlsDescriptive)) {
                return false;
            }
            String this$payNowAssetUrlsStandard = this.getPayNowAssetUrlsStandard();
            String other$payNowAssetUrlsStandard = other.getPayNowAssetUrlsStandard();
            if (this$payNowAssetUrlsStandard == null ? other$payNowAssetUrlsStandard != null : !this$payNowAssetUrlsStandard.equals(other$payNowAssetUrlsStandard)) {
                return false;
            }
            String this$payNowName = this.getPayNowName();
            String other$payNowName = other.getPayNowName();
            if (this$payNowName == null ? other$payNowName != null : !this$payNowName.equals(other$payNowName)) {
                return false;
            }
            String this$payNowRedirectUrl = this.getPayNowRedirectUrl();
            String other$payNowRedirectUrl = other.getPayNowRedirectUrl();
            if (this$payNowRedirectUrl == null ? other$payNowRedirectUrl != null : !this$payNowRedirectUrl.equals(other$payNowRedirectUrl)) {
                return false;
            }
            String this$payOverTimeAssetUrlsDescriptive = this.getPayOverTimeAssetUrlsDescriptive();
            String other$payOverTimeAssetUrlsDescriptive = other.getPayOverTimeAssetUrlsDescriptive();
            if (this$payOverTimeAssetUrlsDescriptive == null ? other$payOverTimeAssetUrlsDescriptive != null : !this$payOverTimeAssetUrlsDescriptive.equals(other$payOverTimeAssetUrlsDescriptive)) {
                return false;
            }
            String this$payOverTimeAssetUrlsStandard = this.getPayOverTimeAssetUrlsStandard();
            String other$payOverTimeAssetUrlsStandard = other.getPayOverTimeAssetUrlsStandard();
            if (this$payOverTimeAssetUrlsStandard == null ? other$payOverTimeAssetUrlsStandard != null : !this$payOverTimeAssetUrlsStandard.equals(other$payOverTimeAssetUrlsStandard)) {
                return false;
            }
            String this$payOverTimeName = this.getPayOverTimeName();
            String other$payOverTimeName = other.getPayOverTimeName();
            if (this$payOverTimeName == null ? other$payOverTimeName != null : !this$payOverTimeName.equals(other$payOverTimeName)) {
                return false;
            }
            String this$payOverTimeRedirectUrl = this.getPayOverTimeRedirectUrl();
            String other$payOverTimeRedirectUrl = other.getPayOverTimeRedirectUrl();
            if (this$payOverTimeRedirectUrl == null ? other$payOverTimeRedirectUrl != null : !this$payOverTimeRedirectUrl.equals(other$payOverTimeRedirectUrl)) {
                return false;
            }
            String this$paymentMethodCategories = this.getPaymentMethodCategories();
            String other$paymentMethodCategories = other.getPaymentMethodCategories();
            if (this$paymentMethodCategories == null ? other$paymentMethodCategories != null : !this$paymentMethodCategories.equals(other$paymentMethodCategories)) {
                return false;
            }
            String this$purchaseCountry = this.getPurchaseCountry();
            String other$purchaseCountry = other.getPurchaseCountry();
            if (this$purchaseCountry == null ? other$purchaseCountry != null : !this$purchaseCountry.equals(other$purchaseCountry)) {
                return false;
            }
            String this$purchaseType = this.getPurchaseType();
            String other$purchaseType = other.getPurchaseType();
            if (this$purchaseType == null ? other$purchaseType != null : !this$purchaseType.equals(other$purchaseType)) {
                return false;
            }
            String this$redirectUrl = this.getRedirectUrl();
            String other$redirectUrl = other.getRedirectUrl();
            if (this$redirectUrl == null ? other$redirectUrl != null : !this$redirectUrl.equals(other$redirectUrl)) {
                return false;
            }
            String this$shippingFirstName = this.getShippingFirstName();
            String other$shippingFirstName = other.getShippingFirstName();
            if (this$shippingFirstName == null ? other$shippingFirstName != null : !this$shippingFirstName.equals(other$shippingFirstName)) {
                return false;
            }
            String this$shippingLastName = this.getShippingLastName();
            String other$shippingLastName = other.getShippingLastName();
            return !(this$shippingLastName == null ? other$shippingLastName != null : !this$shippingLastName.equals(other$shippingLastName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Klarna;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $backgroundImageUrl = this.getBackgroundImageUrl();
            result = result * 59 + ($backgroundImageUrl == null ? 43 : $backgroundImageUrl.hashCode());
            String $clientToken = this.getClientToken();
            result = result * 59 + ($clientToken == null ? 43 : $clientToken.hashCode());
            String $firstName = this.getFirstName();
            result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
            String $lastName = this.getLastName();
            result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
            String $locale = this.getLocale();
            result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
            String $logoUrl = this.getLogoUrl();
            result = result * 59 + ($logoUrl == null ? 43 : $logoUrl.hashCode());
            String $pageTitle = this.getPageTitle();
            result = result * 59 + ($pageTitle == null ? 43 : $pageTitle.hashCode());
            String $payLaterAssetUrlsDescriptive = this.getPayLaterAssetUrlsDescriptive();
            result = result * 59 + ($payLaterAssetUrlsDescriptive == null ? 43 : $payLaterAssetUrlsDescriptive.hashCode());
            String $payLaterAssetUrlsStandard = this.getPayLaterAssetUrlsStandard();
            result = result * 59 + ($payLaterAssetUrlsStandard == null ? 43 : $payLaterAssetUrlsStandard.hashCode());
            String $payLaterName = this.getPayLaterName();
            result = result * 59 + ($payLaterName == null ? 43 : $payLaterName.hashCode());
            String $payLaterRedirectUrl = this.getPayLaterRedirectUrl();
            result = result * 59 + ($payLaterRedirectUrl == null ? 43 : $payLaterRedirectUrl.hashCode());
            String $payNowAssetUrlsDescriptive = this.getPayNowAssetUrlsDescriptive();
            result = result * 59 + ($payNowAssetUrlsDescriptive == null ? 43 : $payNowAssetUrlsDescriptive.hashCode());
            String $payNowAssetUrlsStandard = this.getPayNowAssetUrlsStandard();
            result = result * 59 + ($payNowAssetUrlsStandard == null ? 43 : $payNowAssetUrlsStandard.hashCode());
            String $payNowName = this.getPayNowName();
            result = result * 59 + ($payNowName == null ? 43 : $payNowName.hashCode());
            String $payNowRedirectUrl = this.getPayNowRedirectUrl();
            result = result * 59 + ($payNowRedirectUrl == null ? 43 : $payNowRedirectUrl.hashCode());
            String $payOverTimeAssetUrlsDescriptive = this.getPayOverTimeAssetUrlsDescriptive();
            result = result * 59 + ($payOverTimeAssetUrlsDescriptive == null ? 43 : $payOverTimeAssetUrlsDescriptive.hashCode());
            String $payOverTimeAssetUrlsStandard = this.getPayOverTimeAssetUrlsStandard();
            result = result * 59 + ($payOverTimeAssetUrlsStandard == null ? 43 : $payOverTimeAssetUrlsStandard.hashCode());
            String $payOverTimeName = this.getPayOverTimeName();
            result = result * 59 + ($payOverTimeName == null ? 43 : $payOverTimeName.hashCode());
            String $payOverTimeRedirectUrl = this.getPayOverTimeRedirectUrl();
            result = result * 59 + ($payOverTimeRedirectUrl == null ? 43 : $payOverTimeRedirectUrl.hashCode());
            String $paymentMethodCategories = this.getPaymentMethodCategories();
            result = result * 59 + ($paymentMethodCategories == null ? 43 : $paymentMethodCategories.hashCode());
            String $purchaseCountry = this.getPurchaseCountry();
            result = result * 59 + ($purchaseCountry == null ? 43 : $purchaseCountry.hashCode());
            String $purchaseType = this.getPurchaseType();
            result = result * 59 + ($purchaseType == null ? 43 : $purchaseType.hashCode());
            String $redirectUrl = this.getRedirectUrl();
            result = result * 59 + ($redirectUrl == null ? 43 : $redirectUrl.hashCode());
            String $shippingFirstName = this.getShippingFirstName();
            result = result * 59 + ($shippingFirstName == null ? 43 : $shippingFirstName.hashCode());
            String $shippingLastName = this.getShippingLastName();
            result = result * 59 + ($shippingLastName == null ? 43 : $shippingLastName.hashCode());
            return result;
        }
    }

    public static class Ideal
    extends StripeObject {
        @SerializedName(value="bank")
        String bank;
        @SerializedName(value="bic")
        String bic;
        @SerializedName(value="iban_last4")
        String ibanLast4;
        @SerializedName(value="statement_descriptor")
        String statementDescriptor;

        @Generated
        public String getBank() {
            return this.bank;
        }

        @Generated
        public String getBic() {
            return this.bic;
        }

        @Generated
        public String getIbanLast4() {
            return this.ibanLast4;
        }

        @Generated
        public String getStatementDescriptor() {
            return this.statementDescriptor;
        }

        @Generated
        public void setBank(String bank) {
            this.bank = bank;
        }

        @Generated
        public void setBic(String bic) {
            this.bic = bic;
        }

        @Generated
        public void setIbanLast4(String ibanLast4) {
            this.ibanLast4 = ibanLast4;
        }

        @Generated
        public void setStatementDescriptor(String statementDescriptor) {
            this.statementDescriptor = statementDescriptor;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ideal)) {
                return false;
            }
            Ideal other = (Ideal)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$bank = this.getBank();
            String other$bank = other.getBank();
            if (this$bank == null ? other$bank != null : !this$bank.equals(other$bank)) {
                return false;
            }
            String this$bic = this.getBic();
            String other$bic = other.getBic();
            if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) {
                return false;
            }
            String this$ibanLast4 = this.getIbanLast4();
            String other$ibanLast4 = other.getIbanLast4();
            if (this$ibanLast4 == null ? other$ibanLast4 != null : !this$ibanLast4.equals(other$ibanLast4)) {
                return false;
            }
            String this$statementDescriptor = this.getStatementDescriptor();
            String other$statementDescriptor = other.getStatementDescriptor();
            return !(this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Ideal;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $bank = this.getBank();
            result = result * 59 + ($bank == null ? 43 : $bank.hashCode());
            String $bic = this.getBic();
            result = result * 59 + ($bic == null ? 43 : $bic.hashCode());
            String $ibanLast4 = this.getIbanLast4();
            result = result * 59 + ($ibanLast4 == null ? 43 : $ibanLast4.hashCode());
            String $statementDescriptor = this.getStatementDescriptor();
            result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
            return result;
        }
    }

    public static class Giropay
    extends StripeObject {
        @SerializedName(value="bank_code")
        String bankCode;
        @SerializedName(value="bank_name")
        String bankName;
        @SerializedName(value="bic")
        String bic;
        @SerializedName(value="statement_descriptor")
        String statementDescriptor;

        @Generated
        public String getBankCode() {
            return this.bankCode;
        }

        @Generated
        public String getBankName() {
            return this.bankName;
        }

        @Generated
        public String getBic() {
            return this.bic;
        }

        @Generated
        public String getStatementDescriptor() {
            return this.statementDescriptor;
        }

        @Generated
        public void setBankCode(String bankCode) {
            this.bankCode = bankCode;
        }

        @Generated
        public void setBankName(String bankName) {
            this.bankName = bankName;
        }

        @Generated
        public void setBic(String bic) {
            this.bic = bic;
        }

        @Generated
        public void setStatementDescriptor(String statementDescriptor) {
            this.statementDescriptor = statementDescriptor;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Giropay)) {
                return false;
            }
            Giropay other = (Giropay)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$bankCode = this.getBankCode();
            String other$bankCode = other.getBankCode();
            if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) {
                return false;
            }
            String this$bankName = this.getBankName();
            String other$bankName = other.getBankName();
            if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                return false;
            }
            String this$bic = this.getBic();
            String other$bic = other.getBic();
            if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) {
                return false;
            }
            String this$statementDescriptor = this.getStatementDescriptor();
            String other$statementDescriptor = other.getStatementDescriptor();
            return !(this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Giropay;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $bankCode = this.getBankCode();
            result = result * 59 + ($bankCode == null ? 43 : $bankCode.hashCode());
            String $bankName = this.getBankName();
            result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
            String $bic = this.getBic();
            result = result * 59 + ($bic == null ? 43 : $bic.hashCode());
            String $statementDescriptor = this.getStatementDescriptor();
            result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
            return result;
        }
    }

    public static class Eps
    extends StripeObject {
        @SerializedName(value="reference")
        String reference;
        @SerializedName(value="statement_descriptor")
        String statementDescriptor;

        @Generated
        public String getReference() {
            return this.reference;
        }

        @Generated
        public String getStatementDescriptor() {
            return this.statementDescriptor;
        }

        @Generated
        public void setReference(String reference) {
            this.reference = reference;
        }

        @Generated
        public void setStatementDescriptor(String statementDescriptor) {
            this.statementDescriptor = statementDescriptor;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Eps)) {
                return false;
            }
            Eps other = (Eps)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$reference = this.getReference();
            String other$reference = other.getReference();
            if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                return false;
            }
            String this$statementDescriptor = this.getStatementDescriptor();
            String other$statementDescriptor = other.getStatementDescriptor();
            return !(this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Eps;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $reference = this.getReference();
            result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
            String $statementDescriptor = this.getStatementDescriptor();
            result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
            return result;
        }
    }

    public static class CodeVerificationFlow
    extends StripeObject {
        @SerializedName(value="attempts_remaining")
        Long attemptsRemaining;
        @SerializedName(value="status")
        String status;

        @Generated
        public Long getAttemptsRemaining() {
            return this.attemptsRemaining;
        }

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public void setAttemptsRemaining(Long attemptsRemaining) {
            this.attemptsRemaining = attemptsRemaining;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CodeVerificationFlow)) {
                return false;
            }
            CodeVerificationFlow other = (CodeVerificationFlow)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$attemptsRemaining = this.getAttemptsRemaining();
            Long other$attemptsRemaining = other.getAttemptsRemaining();
            if (this$attemptsRemaining == null ? other$attemptsRemaining != null : !((Object)this$attemptsRemaining).equals(other$attemptsRemaining)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            return !(this$status == null ? other$status != null : !this$status.equals(other$status));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CodeVerificationFlow;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $attemptsRemaining = this.getAttemptsRemaining();
            result = result * 59 + ($attemptsRemaining == null ? 43 : ((Object)$attemptsRemaining).hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            return result;
        }
    }

    public static class CardPresent
    extends StripeObject {
        @SerializedName(value="application_cryptogram")
        String applicationCryptogram;
        @SerializedName(value="application_preferred_name")
        String applicationPreferredName;
        @SerializedName(value="authorization_code")
        String authorizationCode;
        @SerializedName(value="authorization_response_code")
        String authorizationResponseCode;
        @SerializedName(value="brand")
        String brand;
        @SerializedName(value="country")
        String country;
        @SerializedName(value="cvm_type")
        String cvmType;
        @SerializedName(value="data_type")
        String dataType;
        @SerializedName(value="dedicated_file_name")
        String dedicatedFileName;
        @SerializedName(value="description")
        String description;
        @SerializedName(value="emv_auth_data")
        String emvAuthData;
        @SerializedName(value="evidence_customer_signature")
        String evidenceCustomerSignature;
        @SerializedName(value="evidence_transaction_certificate")
        String evidenceTransactionCertificate;
        @SerializedName(value="exp_month")
        Long expMonth;
        @SerializedName(value="exp_year")
        Long expYear;
        @SerializedName(value="fingerprint")
        String fingerprint;
        @SerializedName(value="funding")
        String funding;
        @SerializedName(value="iin")
        String iin;
        @SerializedName(value="issuer")
        String issuer;
        @SerializedName(value="last4")
        String last4;
        @SerializedName(value="pos_device_id")
        String posDeviceId;
        @SerializedName(value="pos_entry_mode")
        String posEntryMode;
        @SerializedName(value="read_method")
        String readMethod;
        @SerializedName(value="reader")
        String reader;
        @SerializedName(value="terminal_verification_results")
        String terminalVerificationResults;
        @SerializedName(value="transaction_status_information")
        String transactionStatusInformation;

        @Generated
        public String getApplicationCryptogram() {
            return this.applicationCryptogram;
        }

        @Generated
        public String getApplicationPreferredName() {
            return this.applicationPreferredName;
        }

        @Generated
        public String getAuthorizationCode() {
            return this.authorizationCode;
        }

        @Generated
        public String getAuthorizationResponseCode() {
            return this.authorizationResponseCode;
        }

        @Generated
        public String getBrand() {
            return this.brand;
        }

        @Generated
        public String getCountry() {
            return this.country;
        }

        @Generated
        public String getCvmType() {
            return this.cvmType;
        }

        @Generated
        public String getDataType() {
            return this.dataType;
        }

        @Generated
        public String getDedicatedFileName() {
            return this.dedicatedFileName;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public String getEmvAuthData() {
            return this.emvAuthData;
        }

        @Generated
        public String getEvidenceCustomerSignature() {
            return this.evidenceCustomerSignature;
        }

        @Generated
        public String getEvidenceTransactionCertificate() {
            return this.evidenceTransactionCertificate;
        }

        @Generated
        public Long getExpMonth() {
            return this.expMonth;
        }

        @Generated
        public Long getExpYear() {
            return this.expYear;
        }

        @Generated
        public String getFingerprint() {
            return this.fingerprint;
        }

        @Generated
        public String getFunding() {
            return this.funding;
        }

        @Generated
        public String getIin() {
            return this.iin;
        }

        @Generated
        public String getIssuer() {
            return this.issuer;
        }

        @Generated
        public String getLast4() {
            return this.last4;
        }

        @Generated
        public String getPosDeviceId() {
            return this.posDeviceId;
        }

        @Generated
        public String getPosEntryMode() {
            return this.posEntryMode;
        }

        @Generated
        public String getReadMethod() {
            return this.readMethod;
        }

        @Generated
        public String getReader() {
            return this.reader;
        }

        @Generated
        public String getTerminalVerificationResults() {
            return this.terminalVerificationResults;
        }

        @Generated
        public String getTransactionStatusInformation() {
            return this.transactionStatusInformation;
        }

        @Generated
        public void setApplicationCryptogram(String applicationCryptogram) {
            this.applicationCryptogram = applicationCryptogram;
        }

        @Generated
        public void setApplicationPreferredName(String applicationPreferredName) {
            this.applicationPreferredName = applicationPreferredName;
        }

        @Generated
        public void setAuthorizationCode(String authorizationCode) {
            this.authorizationCode = authorizationCode;
        }

        @Generated
        public void setAuthorizationResponseCode(String authorizationResponseCode) {
            this.authorizationResponseCode = authorizationResponseCode;
        }

        @Generated
        public void setBrand(String brand) {
            this.brand = brand;
        }

        @Generated
        public void setCountry(String country) {
            this.country = country;
        }

        @Generated
        public void setCvmType(String cvmType) {
            this.cvmType = cvmType;
        }

        @Generated
        public void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Generated
        public void setDedicatedFileName(String dedicatedFileName) {
            this.dedicatedFileName = dedicatedFileName;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public void setEmvAuthData(String emvAuthData) {
            this.emvAuthData = emvAuthData;
        }

        @Generated
        public void setEvidenceCustomerSignature(String evidenceCustomerSignature) {
            this.evidenceCustomerSignature = evidenceCustomerSignature;
        }

        @Generated
        public void setEvidenceTransactionCertificate(String evidenceTransactionCertificate) {
            this.evidenceTransactionCertificate = evidenceTransactionCertificate;
        }

        @Generated
        public void setExpMonth(Long expMonth) {
            this.expMonth = expMonth;
        }

        @Generated
        public void setExpYear(Long expYear) {
            this.expYear = expYear;
        }

        @Generated
        public void setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
        }

        @Generated
        public void setFunding(String funding) {
            this.funding = funding;
        }

        @Generated
        public void setIin(String iin) {
            this.iin = iin;
        }

        @Generated
        public void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Generated
        public void setLast4(String last4) {
            this.last4 = last4;
        }

        @Generated
        public void setPosDeviceId(String posDeviceId) {
            this.posDeviceId = posDeviceId;
        }

        @Generated
        public void setPosEntryMode(String posEntryMode) {
            this.posEntryMode = posEntryMode;
        }

        @Generated
        public void setReadMethod(String readMethod) {
            this.readMethod = readMethod;
        }

        @Generated
        public void setReader(String reader) {
            this.reader = reader;
        }

        @Generated
        public void setTerminalVerificationResults(String terminalVerificationResults) {
            this.terminalVerificationResults = terminalVerificationResults;
        }

        @Generated
        public void setTransactionStatusInformation(String transactionStatusInformation) {
            this.transactionStatusInformation = transactionStatusInformation;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CardPresent)) {
                return false;
            }
            CardPresent other = (CardPresent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$applicationCryptogram = this.getApplicationCryptogram();
            String other$applicationCryptogram = other.getApplicationCryptogram();
            if (this$applicationCryptogram == null ? other$applicationCryptogram != null : !this$applicationCryptogram.equals(other$applicationCryptogram)) {
                return false;
            }
            String this$applicationPreferredName = this.getApplicationPreferredName();
            String other$applicationPreferredName = other.getApplicationPreferredName();
            if (this$applicationPreferredName == null ? other$applicationPreferredName != null : !this$applicationPreferredName.equals(other$applicationPreferredName)) {
                return false;
            }
            String this$authorizationCode = this.getAuthorizationCode();
            String other$authorizationCode = other.getAuthorizationCode();
            if (this$authorizationCode == null ? other$authorizationCode != null : !this$authorizationCode.equals(other$authorizationCode)) {
                return false;
            }
            String this$authorizationResponseCode = this.getAuthorizationResponseCode();
            String other$authorizationResponseCode = other.getAuthorizationResponseCode();
            if (this$authorizationResponseCode == null ? other$authorizationResponseCode != null : !this$authorizationResponseCode.equals(other$authorizationResponseCode)) {
                return false;
            }
            String this$brand = this.getBrand();
            String other$brand = other.getBrand();
            if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) {
                return false;
            }
            String this$country = this.getCountry();
            String other$country = other.getCountry();
            if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                return false;
            }
            String this$cvmType = this.getCvmType();
            String other$cvmType = other.getCvmType();
            if (this$cvmType == null ? other$cvmType != null : !this$cvmType.equals(other$cvmType)) {
                return false;
            }
            String this$dataType = this.getDataType();
            String other$dataType = other.getDataType();
            if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
                return false;
            }
            String this$dedicatedFileName = this.getDedicatedFileName();
            String other$dedicatedFileName = other.getDedicatedFileName();
            if (this$dedicatedFileName == null ? other$dedicatedFileName != null : !this$dedicatedFileName.equals(other$dedicatedFileName)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$emvAuthData = this.getEmvAuthData();
            String other$emvAuthData = other.getEmvAuthData();
            if (this$emvAuthData == null ? other$emvAuthData != null : !this$emvAuthData.equals(other$emvAuthData)) {
                return false;
            }
            String this$evidenceCustomerSignature = this.getEvidenceCustomerSignature();
            String other$evidenceCustomerSignature = other.getEvidenceCustomerSignature();
            if (this$evidenceCustomerSignature == null ? other$evidenceCustomerSignature != null : !this$evidenceCustomerSignature.equals(other$evidenceCustomerSignature)) {
                return false;
            }
            String this$evidenceTransactionCertificate = this.getEvidenceTransactionCertificate();
            String other$evidenceTransactionCertificate = other.getEvidenceTransactionCertificate();
            if (this$evidenceTransactionCertificate == null ? other$evidenceTransactionCertificate != null : !this$evidenceTransactionCertificate.equals(other$evidenceTransactionCertificate)) {
                return false;
            }
            Long this$expMonth = this.getExpMonth();
            Long other$expMonth = other.getExpMonth();
            if (this$expMonth == null ? other$expMonth != null : !((Object)this$expMonth).equals(other$expMonth)) {
                return false;
            }
            Long this$expYear = this.getExpYear();
            Long other$expYear = other.getExpYear();
            if (this$expYear == null ? other$expYear != null : !((Object)this$expYear).equals(other$expYear)) {
                return false;
            }
            String this$fingerprint = this.getFingerprint();
            String other$fingerprint = other.getFingerprint();
            if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                return false;
            }
            String this$funding = this.getFunding();
            String other$funding = other.getFunding();
            if (this$funding == null ? other$funding != null : !this$funding.equals(other$funding)) {
                return false;
            }
            String this$iin = this.getIin();
            String other$iin = other.getIin();
            if (this$iin == null ? other$iin != null : !this$iin.equals(other$iin)) {
                return false;
            }
            String this$issuer = this.getIssuer();
            String other$issuer = other.getIssuer();
            if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) {
                return false;
            }
            String this$last4 = this.getLast4();
            String other$last4 = other.getLast4();
            if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                return false;
            }
            String this$posDeviceId = this.getPosDeviceId();
            String other$posDeviceId = other.getPosDeviceId();
            if (this$posDeviceId == null ? other$posDeviceId != null : !this$posDeviceId.equals(other$posDeviceId)) {
                return false;
            }
            String this$posEntryMode = this.getPosEntryMode();
            String other$posEntryMode = other.getPosEntryMode();
            if (this$posEntryMode == null ? other$posEntryMode != null : !this$posEntryMode.equals(other$posEntryMode)) {
                return false;
            }
            String this$readMethod = this.getReadMethod();
            String other$readMethod = other.getReadMethod();
            if (this$readMethod == null ? other$readMethod != null : !this$readMethod.equals(other$readMethod)) {
                return false;
            }
            String this$reader = this.getReader();
            String other$reader = other.getReader();
            if (this$reader == null ? other$reader != null : !this$reader.equals(other$reader)) {
                return false;
            }
            String this$terminalVerificationResults = this.getTerminalVerificationResults();
            String other$terminalVerificationResults = other.getTerminalVerificationResults();
            if (this$terminalVerificationResults == null ? other$terminalVerificationResults != null : !this$terminalVerificationResults.equals(other$terminalVerificationResults)) {
                return false;
            }
            String this$transactionStatusInformation = this.getTransactionStatusInformation();
            String other$transactionStatusInformation = other.getTransactionStatusInformation();
            return !(this$transactionStatusInformation == null ? other$transactionStatusInformation != null : !this$transactionStatusInformation.equals(other$transactionStatusInformation));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CardPresent;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $applicationCryptogram = this.getApplicationCryptogram();
            result = result * 59 + ($applicationCryptogram == null ? 43 : $applicationCryptogram.hashCode());
            String $applicationPreferredName = this.getApplicationPreferredName();
            result = result * 59 + ($applicationPreferredName == null ? 43 : $applicationPreferredName.hashCode());
            String $authorizationCode = this.getAuthorizationCode();
            result = result * 59 + ($authorizationCode == null ? 43 : $authorizationCode.hashCode());
            String $authorizationResponseCode = this.getAuthorizationResponseCode();
            result = result * 59 + ($authorizationResponseCode == null ? 43 : $authorizationResponseCode.hashCode());
            String $brand = this.getBrand();
            result = result * 59 + ($brand == null ? 43 : $brand.hashCode());
            String $country = this.getCountry();
            result = result * 59 + ($country == null ? 43 : $country.hashCode());
            String $cvmType = this.getCvmType();
            result = result * 59 + ($cvmType == null ? 43 : $cvmType.hashCode());
            String $dataType = this.getDataType();
            result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
            String $dedicatedFileName = this.getDedicatedFileName();
            result = result * 59 + ($dedicatedFileName == null ? 43 : $dedicatedFileName.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $emvAuthData = this.getEmvAuthData();
            result = result * 59 + ($emvAuthData == null ? 43 : $emvAuthData.hashCode());
            String $evidenceCustomerSignature = this.getEvidenceCustomerSignature();
            result = result * 59 + ($evidenceCustomerSignature == null ? 43 : $evidenceCustomerSignature.hashCode());
            String $evidenceTransactionCertificate = this.getEvidenceTransactionCertificate();
            result = result * 59 + ($evidenceTransactionCertificate == null ? 43 : $evidenceTransactionCertificate.hashCode());
            Long $expMonth = this.getExpMonth();
            result = result * 59 + ($expMonth == null ? 43 : ((Object)$expMonth).hashCode());
            Long $expYear = this.getExpYear();
            result = result * 59 + ($expYear == null ? 43 : ((Object)$expYear).hashCode());
            String $fingerprint = this.getFingerprint();
            result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
            String $funding = this.getFunding();
            result = result * 59 + ($funding == null ? 43 : $funding.hashCode());
            String $iin = this.getIin();
            result = result * 59 + ($iin == null ? 43 : $iin.hashCode());
            String $issuer = this.getIssuer();
            result = result * 59 + ($issuer == null ? 43 : $issuer.hashCode());
            String $last4 = this.getLast4();
            result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
            String $posDeviceId = this.getPosDeviceId();
            result = result * 59 + ($posDeviceId == null ? 43 : $posDeviceId.hashCode());
            String $posEntryMode = this.getPosEntryMode();
            result = result * 59 + ($posEntryMode == null ? 43 : $posEntryMode.hashCode());
            String $readMethod = this.getReadMethod();
            result = result * 59 + ($readMethod == null ? 43 : $readMethod.hashCode());
            String $reader = this.getReader();
            result = result * 59 + ($reader == null ? 43 : $reader.hashCode());
            String $terminalVerificationResults = this.getTerminalVerificationResults();
            result = result * 59 + ($terminalVerificationResults == null ? 43 : $terminalVerificationResults.hashCode());
            String $transactionStatusInformation = this.getTransactionStatusInformation();
            result = result * 59 + ($transactionStatusInformation == null ? 43 : $transactionStatusInformation.hashCode());
            return result;
        }
    }

    public static class Card
    extends StripeObject {
        @SerializedName(value="address_line1_check")
        String addressLine1Check;
        @SerializedName(value="address_zip_check")
        String addressZipCheck;
        @SerializedName(value="brand")
        String brand;
        @SerializedName(value="country")
        String country;
        @SerializedName(value="cvc_check")
        String cvcCheck;
        @SerializedName(value="description")
        String description;
        @SerializedName(value="dynamic_last4")
        String dynamicLast4;
        @SerializedName(value="exp_month")
        Long expMonth;
        @SerializedName(value="exp_year")
        Long expYear;
        @SerializedName(value="fingerprint")
        String fingerprint;
        @SerializedName(value="funding")
        String funding;
        @SerializedName(value="iin")
        String iin;
        @SerializedName(value="issuer")
        String issuer;
        @SerializedName(value="last4")
        String last4;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="three_d_secure")
        String threeDSecure;
        @SerializedName(value="tokenization_method")
        String tokenizationMethod;

        @Generated
        public String getAddressLine1Check() {
            return this.addressLine1Check;
        }

        @Generated
        public String getAddressZipCheck() {
            return this.addressZipCheck;
        }

        @Generated
        public String getBrand() {
            return this.brand;
        }

        @Generated
        public String getCountry() {
            return this.country;
        }

        @Generated
        public String getCvcCheck() {
            return this.cvcCheck;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public String getDynamicLast4() {
            return this.dynamicLast4;
        }

        @Generated
        public Long getExpMonth() {
            return this.expMonth;
        }

        @Generated
        public Long getExpYear() {
            return this.expYear;
        }

        @Generated
        public String getFingerprint() {
            return this.fingerprint;
        }

        @Generated
        public String getFunding() {
            return this.funding;
        }

        @Generated
        public String getIin() {
            return this.iin;
        }

        @Generated
        public String getIssuer() {
            return this.issuer;
        }

        @Generated
        public String getLast4() {
            return this.last4;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getThreeDSecure() {
            return this.threeDSecure;
        }

        @Generated
        public String getTokenizationMethod() {
            return this.tokenizationMethod;
        }

        @Generated
        public void setAddressLine1Check(String addressLine1Check) {
            this.addressLine1Check = addressLine1Check;
        }

        @Generated
        public void setAddressZipCheck(String addressZipCheck) {
            this.addressZipCheck = addressZipCheck;
        }

        @Generated
        public void setBrand(String brand) {
            this.brand = brand;
        }

        @Generated
        public void setCountry(String country) {
            this.country = country;
        }

        @Generated
        public void setCvcCheck(String cvcCheck) {
            this.cvcCheck = cvcCheck;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public void setDynamicLast4(String dynamicLast4) {
            this.dynamicLast4 = dynamicLast4;
        }

        @Generated
        public void setExpMonth(Long expMonth) {
            this.expMonth = expMonth;
        }

        @Generated
        public void setExpYear(Long expYear) {
            this.expYear = expYear;
        }

        @Generated
        public void setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
        }

        @Generated
        public void setFunding(String funding) {
            this.funding = funding;
        }

        @Generated
        public void setIin(String iin) {
            this.iin = iin;
        }

        @Generated
        public void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Generated
        public void setLast4(String last4) {
            this.last4 = last4;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setThreeDSecure(String threeDSecure) {
            this.threeDSecure = threeDSecure;
        }

        @Generated
        public void setTokenizationMethod(String tokenizationMethod) {
            this.tokenizationMethod = tokenizationMethod;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Card)) {
                return false;
            }
            Card other = (Card)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$addressLine1Check = this.getAddressLine1Check();
            String other$addressLine1Check = other.getAddressLine1Check();
            if (this$addressLine1Check == null ? other$addressLine1Check != null : !this$addressLine1Check.equals(other$addressLine1Check)) {
                return false;
            }
            String this$addressZipCheck = this.getAddressZipCheck();
            String other$addressZipCheck = other.getAddressZipCheck();
            if (this$addressZipCheck == null ? other$addressZipCheck != null : !this$addressZipCheck.equals(other$addressZipCheck)) {
                return false;
            }
            String this$brand = this.getBrand();
            String other$brand = other.getBrand();
            if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) {
                return false;
            }
            String this$country = this.getCountry();
            String other$country = other.getCountry();
            if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                return false;
            }
            String this$cvcCheck = this.getCvcCheck();
            String other$cvcCheck = other.getCvcCheck();
            if (this$cvcCheck == null ? other$cvcCheck != null : !this$cvcCheck.equals(other$cvcCheck)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$dynamicLast4 = this.getDynamicLast4();
            String other$dynamicLast4 = other.getDynamicLast4();
            if (this$dynamicLast4 == null ? other$dynamicLast4 != null : !this$dynamicLast4.equals(other$dynamicLast4)) {
                return false;
            }
            Long this$expMonth = this.getExpMonth();
            Long other$expMonth = other.getExpMonth();
            if (this$expMonth == null ? other$expMonth != null : !((Object)this$expMonth).equals(other$expMonth)) {
                return false;
            }
            Long this$expYear = this.getExpYear();
            Long other$expYear = other.getExpYear();
            if (this$expYear == null ? other$expYear != null : !((Object)this$expYear).equals(other$expYear)) {
                return false;
            }
            String this$fingerprint = this.getFingerprint();
            String other$fingerprint = other.getFingerprint();
            if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                return false;
            }
            String this$funding = this.getFunding();
            String other$funding = other.getFunding();
            if (this$funding == null ? other$funding != null : !this$funding.equals(other$funding)) {
                return false;
            }
            String this$iin = this.getIin();
            String other$iin = other.getIin();
            if (this$iin == null ? other$iin != null : !this$iin.equals(other$iin)) {
                return false;
            }
            String this$issuer = this.getIssuer();
            String other$issuer = other.getIssuer();
            if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) {
                return false;
            }
            String this$last4 = this.getLast4();
            String other$last4 = other.getLast4();
            if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$threeDSecure = this.getThreeDSecure();
            String other$threeDSecure = other.getThreeDSecure();
            if (this$threeDSecure == null ? other$threeDSecure != null : !this$threeDSecure.equals(other$threeDSecure)) {
                return false;
            }
            String this$tokenizationMethod = this.getTokenizationMethod();
            String other$tokenizationMethod = other.getTokenizationMethod();
            return !(this$tokenizationMethod == null ? other$tokenizationMethod != null : !this$tokenizationMethod.equals(other$tokenizationMethod));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Card;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $addressLine1Check = this.getAddressLine1Check();
            result = result * 59 + ($addressLine1Check == null ? 43 : $addressLine1Check.hashCode());
            String $addressZipCheck = this.getAddressZipCheck();
            result = result * 59 + ($addressZipCheck == null ? 43 : $addressZipCheck.hashCode());
            String $brand = this.getBrand();
            result = result * 59 + ($brand == null ? 43 : $brand.hashCode());
            String $country = this.getCountry();
            result = result * 59 + ($country == null ? 43 : $country.hashCode());
            String $cvcCheck = this.getCvcCheck();
            result = result * 59 + ($cvcCheck == null ? 43 : $cvcCheck.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $dynamicLast4 = this.getDynamicLast4();
            result = result * 59 + ($dynamicLast4 == null ? 43 : $dynamicLast4.hashCode());
            Long $expMonth = this.getExpMonth();
            result = result * 59 + ($expMonth == null ? 43 : ((Object)$expMonth).hashCode());
            Long $expYear = this.getExpYear();
            result = result * 59 + ($expYear == null ? 43 : ((Object)$expYear).hashCode());
            String $fingerprint = this.getFingerprint();
            result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
            String $funding = this.getFunding();
            result = result * 59 + ($funding == null ? 43 : $funding.hashCode());
            String $iin = this.getIin();
            result = result * 59 + ($iin == null ? 43 : $iin.hashCode());
            String $issuer = this.getIssuer();
            result = result * 59 + ($issuer == null ? 43 : $issuer.hashCode());
            String $last4 = this.getLast4();
            result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $threeDSecure = this.getThreeDSecure();
            result = result * 59 + ($threeDSecure == null ? 43 : $threeDSecure.hashCode());
            String $tokenizationMethod = this.getTokenizationMethod();
            result = result * 59 + ($tokenizationMethod == null ? 43 : $tokenizationMethod.hashCode());
            return result;
        }
    }

    public static class Bancontact
    extends StripeObject {
        @SerializedName(value="bank_code")
        String bankCode;
        @SerializedName(value="bank_name")
        String bankName;
        @SerializedName(value="bic")
        String bic;
        @SerializedName(value="iban_last4")
        String ibanLast4;
        @SerializedName(value="preferred_language")
        String preferredLanguage;
        @SerializedName(value="statement_descriptor")
        String statementDescriptor;

        @Generated
        public String getBankCode() {
            return this.bankCode;
        }

        @Generated
        public String getBankName() {
            return this.bankName;
        }

        @Generated
        public String getBic() {
            return this.bic;
        }

        @Generated
        public String getIbanLast4() {
            return this.ibanLast4;
        }

        @Generated
        public String getPreferredLanguage() {
            return this.preferredLanguage;
        }

        @Generated
        public String getStatementDescriptor() {
            return this.statementDescriptor;
        }

        @Generated
        public void setBankCode(String bankCode) {
            this.bankCode = bankCode;
        }

        @Generated
        public void setBankName(String bankName) {
            this.bankName = bankName;
        }

        @Generated
        public void setBic(String bic) {
            this.bic = bic;
        }

        @Generated
        public void setIbanLast4(String ibanLast4) {
            this.ibanLast4 = ibanLast4;
        }

        @Generated
        public void setPreferredLanguage(String preferredLanguage) {
            this.preferredLanguage = preferredLanguage;
        }

        @Generated
        public void setStatementDescriptor(String statementDescriptor) {
            this.statementDescriptor = statementDescriptor;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Bancontact)) {
                return false;
            }
            Bancontact other = (Bancontact)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$bankCode = this.getBankCode();
            String other$bankCode = other.getBankCode();
            if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) {
                return false;
            }
            String this$bankName = this.getBankName();
            String other$bankName = other.getBankName();
            if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                return false;
            }
            String this$bic = this.getBic();
            String other$bic = other.getBic();
            if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) {
                return false;
            }
            String this$ibanLast4 = this.getIbanLast4();
            String other$ibanLast4 = other.getIbanLast4();
            if (this$ibanLast4 == null ? other$ibanLast4 != null : !this$ibanLast4.equals(other$ibanLast4)) {
                return false;
            }
            String this$preferredLanguage = this.getPreferredLanguage();
            String other$preferredLanguage = other.getPreferredLanguage();
            if (this$preferredLanguage == null ? other$preferredLanguage != null : !this$preferredLanguage.equals(other$preferredLanguage)) {
                return false;
            }
            String this$statementDescriptor = this.getStatementDescriptor();
            String other$statementDescriptor = other.getStatementDescriptor();
            return !(this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Bancontact;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $bankCode = this.getBankCode();
            result = result * 59 + ($bankCode == null ? 43 : $bankCode.hashCode());
            String $bankName = this.getBankName();
            result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
            String $bic = this.getBic();
            result = result * 59 + ($bic == null ? 43 : $bic.hashCode());
            String $ibanLast4 = this.getIbanLast4();
            result = result * 59 + ($ibanLast4 == null ? 43 : $ibanLast4.hashCode());
            String $preferredLanguage = this.getPreferredLanguage();
            result = result * 59 + ($preferredLanguage == null ? 43 : $preferredLanguage.hashCode());
            String $statementDescriptor = this.getStatementDescriptor();
            result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
            return result;
        }
    }

    public static class AuBecsDebit
    extends StripeObject {
        @SerializedName(value="bsb_number")
        String bsbNumber;
        @SerializedName(value="fingerprint")
        String fingerprint;
        @SerializedName(value="last4")
        String last4;

        @Generated
        public String getBsbNumber() {
            return this.bsbNumber;
        }

        @Generated
        public String getFingerprint() {
            return this.fingerprint;
        }

        @Generated
        public String getLast4() {
            return this.last4;
        }

        @Generated
        public void setBsbNumber(String bsbNumber) {
            this.bsbNumber = bsbNumber;
        }

        @Generated
        public void setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
        }

        @Generated
        public void setLast4(String last4) {
            this.last4 = last4;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AuBecsDebit)) {
                return false;
            }
            AuBecsDebit other = (AuBecsDebit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$bsbNumber = this.getBsbNumber();
            String other$bsbNumber = other.getBsbNumber();
            if (this$bsbNumber == null ? other$bsbNumber != null : !this$bsbNumber.equals(other$bsbNumber)) {
                return false;
            }
            String this$fingerprint = this.getFingerprint();
            String other$fingerprint = other.getFingerprint();
            if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                return false;
            }
            String this$last4 = this.getLast4();
            String other$last4 = other.getLast4();
            return !(this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AuBecsDebit;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $bsbNumber = this.getBsbNumber();
            result = result * 59 + ($bsbNumber == null ? 43 : $bsbNumber.hashCode());
            String $fingerprint = this.getFingerprint();
            result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
            String $last4 = this.getLast4();
            result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
            return result;
        }
    }

    public static class Alipay
    extends StripeObject {
        @SerializedName(value="data_string")
        String dataString;
        @SerializedName(value="native_url")
        String nativeUrl;
        @SerializedName(value="statement_descriptor")
        String statementDescriptor;

        @Generated
        public String getDataString() {
            return this.dataString;
        }

        @Generated
        public String getNativeUrl() {
            return this.nativeUrl;
        }

        @Generated
        public String getStatementDescriptor() {
            return this.statementDescriptor;
        }

        @Generated
        public void setDataString(String dataString) {
            this.dataString = dataString;
        }

        @Generated
        public void setNativeUrl(String nativeUrl) {
            this.nativeUrl = nativeUrl;
        }

        @Generated
        public void setStatementDescriptor(String statementDescriptor) {
            this.statementDescriptor = statementDescriptor;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Alipay)) {
                return false;
            }
            Alipay other = (Alipay)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$dataString = this.getDataString();
            String other$dataString = other.getDataString();
            if (this$dataString == null ? other$dataString != null : !this$dataString.equals(other$dataString)) {
                return false;
            }
            String this$nativeUrl = this.getNativeUrl();
            String other$nativeUrl = other.getNativeUrl();
            if (this$nativeUrl == null ? other$nativeUrl != null : !this$nativeUrl.equals(other$nativeUrl)) {
                return false;
            }
            String this$statementDescriptor = this.getStatementDescriptor();
            String other$statementDescriptor = other.getStatementDescriptor();
            return !(this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Alipay;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $dataString = this.getDataString();
            result = result * 59 + ($dataString == null ? 43 : $dataString.hashCode());
            String $nativeUrl = this.getNativeUrl();
            result = result * 59 + ($nativeUrl == null ? 43 : $nativeUrl.hashCode());
            String $statementDescriptor = this.getStatementDescriptor();
            result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
            return result;
        }
    }

    public static class AcssDebit
    extends StripeObject {
        @SerializedName(value="bank_address_city")
        String bankAddressCity;
        @SerializedName(value="bank_address_line_1")
        String bankAddressLine1;
        @SerializedName(value="bank_address_line_2")
        String bankAddressLine2;
        @SerializedName(value="bank_address_postal_code")
        String bankAddressPostalCode;
        @SerializedName(value="bank_name")
        String bankName;
        @SerializedName(value="category")
        String category;
        @SerializedName(value="country")
        String country;
        @SerializedName(value="fingerprint")
        String fingerprint;
        @SerializedName(value="last4")
        String last4;
        @SerializedName(value="routing_number")
        String routingNumber;

        @Generated
        public String getBankAddressCity() {
            return this.bankAddressCity;
        }

        @Generated
        public String getBankAddressLine1() {
            return this.bankAddressLine1;
        }

        @Generated
        public String getBankAddressLine2() {
            return this.bankAddressLine2;
        }

        @Generated
        public String getBankAddressPostalCode() {
            return this.bankAddressPostalCode;
        }

        @Generated
        public String getBankName() {
            return this.bankName;
        }

        @Generated
        public String getCategory() {
            return this.category;
        }

        @Generated
        public String getCountry() {
            return this.country;
        }

        @Generated
        public String getFingerprint() {
            return this.fingerprint;
        }

        @Generated
        public String getLast4() {
            return this.last4;
        }

        @Generated
        public String getRoutingNumber() {
            return this.routingNumber;
        }

        @Generated
        public void setBankAddressCity(String bankAddressCity) {
            this.bankAddressCity = bankAddressCity;
        }

        @Generated
        public void setBankAddressLine1(String bankAddressLine1) {
            this.bankAddressLine1 = bankAddressLine1;
        }

        @Generated
        public void setBankAddressLine2(String bankAddressLine2) {
            this.bankAddressLine2 = bankAddressLine2;
        }

        @Generated
        public void setBankAddressPostalCode(String bankAddressPostalCode) {
            this.bankAddressPostalCode = bankAddressPostalCode;
        }

        @Generated
        public void setBankName(String bankName) {
            this.bankName = bankName;
        }

        @Generated
        public void setCategory(String category) {
            this.category = category;
        }

        @Generated
        public void setCountry(String country) {
            this.country = country;
        }

        @Generated
        public void setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
        }

        @Generated
        public void setLast4(String last4) {
            this.last4 = last4;
        }

        @Generated
        public void setRoutingNumber(String routingNumber) {
            this.routingNumber = routingNumber;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AcssDebit)) {
                return false;
            }
            AcssDebit other = (AcssDebit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$bankAddressCity = this.getBankAddressCity();
            String other$bankAddressCity = other.getBankAddressCity();
            if (this$bankAddressCity == null ? other$bankAddressCity != null : !this$bankAddressCity.equals(other$bankAddressCity)) {
                return false;
            }
            String this$bankAddressLine1 = this.getBankAddressLine1();
            String other$bankAddressLine1 = other.getBankAddressLine1();
            if (this$bankAddressLine1 == null ? other$bankAddressLine1 != null : !this$bankAddressLine1.equals(other$bankAddressLine1)) {
                return false;
            }
            String this$bankAddressLine2 = this.getBankAddressLine2();
            String other$bankAddressLine2 = other.getBankAddressLine2();
            if (this$bankAddressLine2 == null ? other$bankAddressLine2 != null : !this$bankAddressLine2.equals(other$bankAddressLine2)) {
                return false;
            }
            String this$bankAddressPostalCode = this.getBankAddressPostalCode();
            String other$bankAddressPostalCode = other.getBankAddressPostalCode();
            if (this$bankAddressPostalCode == null ? other$bankAddressPostalCode != null : !this$bankAddressPostalCode.equals(other$bankAddressPostalCode)) {
                return false;
            }
            String this$bankName = this.getBankName();
            String other$bankName = other.getBankName();
            if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                return false;
            }
            String this$category = this.getCategory();
            String other$category = other.getCategory();
            if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
                return false;
            }
            String this$country = this.getCountry();
            String other$country = other.getCountry();
            if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                return false;
            }
            String this$fingerprint = this.getFingerprint();
            String other$fingerprint = other.getFingerprint();
            if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                return false;
            }
            String this$last4 = this.getLast4();
            String other$last4 = other.getLast4();
            if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                return false;
            }
            String this$routingNumber = this.getRoutingNumber();
            String other$routingNumber = other.getRoutingNumber();
            return !(this$routingNumber == null ? other$routingNumber != null : !this$routingNumber.equals(other$routingNumber));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AcssDebit;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $bankAddressCity = this.getBankAddressCity();
            result = result * 59 + ($bankAddressCity == null ? 43 : $bankAddressCity.hashCode());
            String $bankAddressLine1 = this.getBankAddressLine1();
            result = result * 59 + ($bankAddressLine1 == null ? 43 : $bankAddressLine1.hashCode());
            String $bankAddressLine2 = this.getBankAddressLine2();
            result = result * 59 + ($bankAddressLine2 == null ? 43 : $bankAddressLine2.hashCode());
            String $bankAddressPostalCode = this.getBankAddressPostalCode();
            result = result * 59 + ($bankAddressPostalCode == null ? 43 : $bankAddressPostalCode.hashCode());
            String $bankName = this.getBankName();
            result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
            String $category = this.getCategory();
            result = result * 59 + ($category == null ? 43 : $category.hashCode());
            String $country = this.getCountry();
            result = result * 59 + ($country == null ? 43 : $country.hashCode());
            String $fingerprint = this.getFingerprint();
            result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
            String $last4 = this.getLast4();
            result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
            String $routingNumber = this.getRoutingNumber();
            result = result * 59 + ($routingNumber == null ? 43 : $routingNumber.hashCode());
            return result;
        }
    }

    public static class AchDebit
    extends StripeObject {
        @SerializedName(value="bank_name")
        String bankName;
        @SerializedName(value="country")
        String country;
        @SerializedName(value="fingerprint")
        String fingerprint;
        @SerializedName(value="last4")
        String last4;
        @SerializedName(value="routing_number")
        String routingNumber;
        @SerializedName(value="type")
        String type;

        @Generated
        public String getBankName() {
            return this.bankName;
        }

        @Generated
        public String getCountry() {
            return this.country;
        }

        @Generated
        public String getFingerprint() {
            return this.fingerprint;
        }

        @Generated
        public String getLast4() {
            return this.last4;
        }

        @Generated
        public String getRoutingNumber() {
            return this.routingNumber;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setBankName(String bankName) {
            this.bankName = bankName;
        }

        @Generated
        public void setCountry(String country) {
            this.country = country;
        }

        @Generated
        public void setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
        }

        @Generated
        public void setLast4(String last4) {
            this.last4 = last4;
        }

        @Generated
        public void setRoutingNumber(String routingNumber) {
            this.routingNumber = routingNumber;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AchDebit)) {
                return false;
            }
            AchDebit other = (AchDebit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$bankName = this.getBankName();
            String other$bankName = other.getBankName();
            if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                return false;
            }
            String this$country = this.getCountry();
            String other$country = other.getCountry();
            if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                return false;
            }
            String this$fingerprint = this.getFingerprint();
            String other$fingerprint = other.getFingerprint();
            if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                return false;
            }
            String this$last4 = this.getLast4();
            String other$last4 = other.getLast4();
            if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                return false;
            }
            String this$routingNumber = this.getRoutingNumber();
            String other$routingNumber = other.getRoutingNumber();
            if (this$routingNumber == null ? other$routingNumber != null : !this$routingNumber.equals(other$routingNumber)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AchDebit;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $bankName = this.getBankName();
            result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
            String $country = this.getCountry();
            result = result * 59 + ($country == null ? 43 : $country.hashCode());
            String $fingerprint = this.getFingerprint();
            result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
            String $last4 = this.getLast4();
            result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
            String $routingNumber = this.getRoutingNumber();
            result = result * 59 + ($routingNumber == null ? 43 : $routingNumber.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }
    }

    public static class AchCreditTransfer
    extends StripeObject {
        @SerializedName(value="account_number")
        String accountNumber;
        @SerializedName(value="bank_name")
        String bankName;
        @SerializedName(value="fingerprint")
        String fingerprint;
        @SerializedName(value="refund_account_holder_name")
        String refundAccountHolderName;
        @SerializedName(value="refund_account_holder_type")
        String refundAccountHolderType;
        @SerializedName(value="refund_routing_number")
        String refundRoutingNumber;
        @SerializedName(value="routing_number")
        String routingNumber;
        @SerializedName(value="swift_code")
        String swiftCode;

        @Generated
        public String getAccountNumber() {
            return this.accountNumber;
        }

        @Generated
        public String getBankName() {
            return this.bankName;
        }

        @Generated
        public String getFingerprint() {
            return this.fingerprint;
        }

        @Generated
        public String getRefundAccountHolderName() {
            return this.refundAccountHolderName;
        }

        @Generated
        public String getRefundAccountHolderType() {
            return this.refundAccountHolderType;
        }

        @Generated
        public String getRefundRoutingNumber() {
            return this.refundRoutingNumber;
        }

        @Generated
        public String getRoutingNumber() {
            return this.routingNumber;
        }

        @Generated
        public String getSwiftCode() {
            return this.swiftCode;
        }

        @Generated
        public void setAccountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
        }

        @Generated
        public void setBankName(String bankName) {
            this.bankName = bankName;
        }

        @Generated
        public void setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
        }

        @Generated
        public void setRefundAccountHolderName(String refundAccountHolderName) {
            this.refundAccountHolderName = refundAccountHolderName;
        }

        @Generated
        public void setRefundAccountHolderType(String refundAccountHolderType) {
            this.refundAccountHolderType = refundAccountHolderType;
        }

        @Generated
        public void setRefundRoutingNumber(String refundRoutingNumber) {
            this.refundRoutingNumber = refundRoutingNumber;
        }

        @Generated
        public void setRoutingNumber(String routingNumber) {
            this.routingNumber = routingNumber;
        }

        @Generated
        public void setSwiftCode(String swiftCode) {
            this.swiftCode = swiftCode;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AchCreditTransfer)) {
                return false;
            }
            AchCreditTransfer other = (AchCreditTransfer)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$accountNumber = this.getAccountNumber();
            String other$accountNumber = other.getAccountNumber();
            if (this$accountNumber == null ? other$accountNumber != null : !this$accountNumber.equals(other$accountNumber)) {
                return false;
            }
            String this$bankName = this.getBankName();
            String other$bankName = other.getBankName();
            if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                return false;
            }
            String this$fingerprint = this.getFingerprint();
            String other$fingerprint = other.getFingerprint();
            if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                return false;
            }
            String this$refundAccountHolderName = this.getRefundAccountHolderName();
            String other$refundAccountHolderName = other.getRefundAccountHolderName();
            if (this$refundAccountHolderName == null ? other$refundAccountHolderName != null : !this$refundAccountHolderName.equals(other$refundAccountHolderName)) {
                return false;
            }
            String this$refundAccountHolderType = this.getRefundAccountHolderType();
            String other$refundAccountHolderType = other.getRefundAccountHolderType();
            if (this$refundAccountHolderType == null ? other$refundAccountHolderType != null : !this$refundAccountHolderType.equals(other$refundAccountHolderType)) {
                return false;
            }
            String this$refundRoutingNumber = this.getRefundRoutingNumber();
            String other$refundRoutingNumber = other.getRefundRoutingNumber();
            if (this$refundRoutingNumber == null ? other$refundRoutingNumber != null : !this$refundRoutingNumber.equals(other$refundRoutingNumber)) {
                return false;
            }
            String this$routingNumber = this.getRoutingNumber();
            String other$routingNumber = other.getRoutingNumber();
            if (this$routingNumber == null ? other$routingNumber != null : !this$routingNumber.equals(other$routingNumber)) {
                return false;
            }
            String this$swiftCode = this.getSwiftCode();
            String other$swiftCode = other.getSwiftCode();
            return !(this$swiftCode == null ? other$swiftCode != null : !this$swiftCode.equals(other$swiftCode));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AchCreditTransfer;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $accountNumber = this.getAccountNumber();
            result = result * 59 + ($accountNumber == null ? 43 : $accountNumber.hashCode());
            String $bankName = this.getBankName();
            result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
            String $fingerprint = this.getFingerprint();
            result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
            String $refundAccountHolderName = this.getRefundAccountHolderName();
            result = result * 59 + ($refundAccountHolderName == null ? 43 : $refundAccountHolderName.hashCode());
            String $refundAccountHolderType = this.getRefundAccountHolderType();
            result = result * 59 + ($refundAccountHolderType == null ? 43 : $refundAccountHolderType.hashCode());
            String $refundRoutingNumber = this.getRefundRoutingNumber();
            result = result * 59 + ($refundRoutingNumber == null ? 43 : $refundRoutingNumber.hashCode());
            String $routingNumber = this.getRoutingNumber();
            result = result * 59 + ($routingNumber == null ? 43 : $routingNumber.hashCode());
            String $swiftCode = this.getSwiftCode();
            result = result * 59 + ($swiftCode == null ? 43 : $swiftCode.hashCode());
            return result;
        }
    }
}

